<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>

<?php
include 'layouts/dbconn.php';

$staff_id = $_GET['id'];

// Fetch staff details
$query = "SELECT s.*, u.full_name as created_by_name 
          FROM staff s
          LEFT JOIN users u ON s.created_by = u.user_id
          WHERE s.staff_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $staff_id);
$stmt->execute();
$result = $stmt->get_result();
$staff = $result->fetch_assoc();

if (!$staff) {
    header('Location: all_staff.php');
    exit;
}
?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'View Staff')); ?>
    <?php include 'layouts/head-css.php'; ?>
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Staff Management', 'title' => 'Staff Details')); ?>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <div class="d-flex align-items-center">
                                        <h5 class="card-title mb-0 flex-grow-1">Staff Member Details</h5>
                                        <div class="flex-shrink-0">
                                            <a href="edit_staff.php?id=<?php echo $staff_id; ?>" class="btn btn-primary">
                                                <i class="ri-pencil-fill align-bottom me-1"></i> Edit
                                            </a>
                                            <a href="all_staff.php" class="btn btn-secondary">
                                                <i class="ri-arrow-left-line align-bottom me-1"></i> Back
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <h6 class="mb-3 text-muted">Personal Information</h6>
                                            <table class="table table-borderless">
                                                <tr>
                                                    <td width="30%"><strong>Employee ID:</strong></td>
                                                    <td><?php echo $staff['employee_id']; ?></td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Full Name:</strong></td>
                                                    <td><?php echo $staff['full_name']; ?></td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Email:</strong></td>
                                                    <td><?php echo $staff['email']; ?></td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Phone:</strong></td>
                                                    <td><?php echo $staff['phone']; ?></td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Status:</strong></td>
                                                    <td>
                                                        <?php
                                                        $status_class = '';
                                                        switch($staff['status']) {
                                                            case 'active':
                                                                $status_class = 'badge bg-success';
                                                                break;
                                                            case 'inactive':
                                                                $status_class = 'badge bg-secondary';
                                                                break;
                                                            case 'suspended':
                                                                $status_class = 'badge bg-danger';
                                                                break;
                                                        }
                                                        ?>
                                                        <span class="<?php echo $status_class; ?>"><?php echo ucfirst($staff['status']); ?></span>
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <h6 class="mb-3 text-muted">Employment Information</h6>
                                            <table class="table table-borderless">
                                                <tr>
                                                    <td width="30%"><strong>Department:</strong></td>
                                                    <td><?php echo $staff['department']; ?></td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Position:</strong></td>
                                                    <td><?php echo $staff['position']; ?></td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Date Hired:</strong></td>
                                                    <td><?php echo $staff['date_hired'] ? date('d M Y', strtotime($staff['date_hired'])) : 'N/A'; ?></td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Added By:</strong></td>
                                                    <td><?php echo $staff['created_by_name']; ?></td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Created At:</strong></td>
                                                    <td><?php echo date('d M Y H:i', strtotime($staff['created_at'])); ?></td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                    
                                    <div class="row mt-4">
                                        <div class="col-12">
                                            <h6 class="mb-3 text-muted">Contact Information</h6>
                                            <table class="table table-borderless">
                                                <tr>
                                                    <td width="15%"><strong>Address:</strong></td>
                                                    <td><?php echo $staff['address'] ?: 'N/A'; ?></td>
                                                </tr>
                                                <tr>
                                                    <td><strong>City:</strong></td>
                                                    <td><?php echo $staff['city'] ?: 'N/A'; ?></td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Country:</strong></td>
                                                    <td><?php echo $staff['country'] ?: 'N/A'; ?></td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="assets/js/app.js"></script>
</body>
</html>