<?php
include 'layouts/main.php';
include 'layouts/dbconn.php';


// Get service ID from URL
$service_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($service_id == 0) {
    header('Location: all_go_home.php');
    exit();
}

// Fetch service details
$sql = "SELECT ghs.*, u_created.full_name as created_by_name, u_updated.full_name as updated_by_name
        FROM go_home_service ghs
        LEFT JOIN users u_created ON ghs.created_by = u_created.user_id
        LEFT JOIN users u_updated ON ghs.updated_by = u_updated.user_id
        WHERE ghs.service_id = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $service_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows == 0) {
    header('Location: all_go_home.php');
    exit();
}

$service = $result->fetch_assoc();
?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'View Go Home Service')); ?>
    <?php include 'layouts/head-css.php'; ?>
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Services', 'title' => 'View Go Home Service')); ?>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h4 class="card-title mb-0">Service Details</h4>
                                        <div>
                                            <a href="edit_go_home.php?id=<?php echo $service_id; ?>" class="btn btn-warning btn-sm me-2">
                                                <i class="ri-edit-box-line align-middle"></i> Edit
                                            </a>
                                            <a href="print_go_home.php?id=<?php echo $service_id; ?>" class="btn btn-info btn-sm me-2">
                                                <i class="ri-printer-line align-middle"></i> Print
                                            </a>
                                            <a href="all_go_home.php" class="btn btn-secondary btn-sm">
                                                <i class="ri-arrow-left-line align-middle"></i> Back
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="row mb-4">
                                                <div class="col-md-4">
                                                    <h5 class="fs-14 mb-1">Reference Number</h5>
                                                    <p class="text-muted"><?php echo htmlspecialchars($service['reference_number']); ?></p>
                                                </div>
                                                <div class="col-md-4">
                                                    <h5 class="fs-14 mb-1">Service Date</h5>
                                                    <p class="text-muted"><?php echo date('d M Y', strtotime($service['service_date'])); ?></p>
                                                </div>
                                                <div class="col-md-4">
                                                    <h5 class="fs-14 mb-1">Status</h5>
                                                    <p class="text-muted">
                                                        <span class="badge bg-<?php 
                                                            echo $service['status'] == 'completed' ? 'success' : 
                                                                ($service['status'] == 'in_progress' ? 'info' : 
                                                                ($service['status'] == 'cancelled' ? 'danger' : 'secondary')); 
                                                        ?>">
                                                            <?php echo ucfirst(str_replace('_', ' ', $service['status'])); ?>
                                                        </span>
                                                    </p>
                                                </div>
                                            </div>

                                            <h5 class="fs-17 fw-semibold">Client Information</h5>
                                            <div class="row mb-4">
                                                <div class="col-md-4">
                                                    <h5 class="fs-14 mb-1">Client Name</h5>
                                                    <p class="text-muted"><?php echo htmlspecialchars($service['client_name']); ?></p>
                                                </div>
                                                <div class="col-md-4">
                                                    <h5 class="fs-14 mb-1">Mother's Name</h5>
                                                    <p class="text-muted"><?php echo htmlspecialchars($service['mother_name']); ?></p>
                                                </div>
                                                <div class="col-md-4">
                                                    <h5 class="fs-14 mb-1">Date of Birth</h5>
                                                    <p class="text-muted"><?php echo date('d M Y', strtotime($service['date_of_birth'])); ?></p>
                                                </div>
                                            </div>

                                            <h5 class="fs-17 fw-semibold">Financial Details</h5>
                                            <div class="row mb-4">
                                                <div class="col-md-3">
                                                    <h5 class="fs-14 mb-1">Price</h5>
                                                    <p class="text-muted"><?php echo $service['currency'] . ' ' . number_format($service['price'], 2); ?></p>
                                                </div>
                                                <div class="col-md-3">
                                                    <h5 class="fs-14 mb-1">Office Fee</h5>
                                                    <p class="text-muted"><?php echo $service['currency'] . ' ' . number_format($service['office_fee'], 2); ?></p>
                                                </div>
                                                <div class="col-md-3">
                                                    <h5 class="fs-14 mb-1">Total Amount</h5>
                                                    <p class="text-muted fw-semibold"><?php echo $service['currency'] . ' ' . number_format($service['price'] + $service['office_fee'], 2); ?></p>
                                                </div>
                                                <div class="col-md-3">
                                                    <h5 class="fs-14 mb-1">Payment Status</h5>
                                                    <p class="text-muted">
                                                        <span class="badge bg-<?php 
                                                            echo $service['payment_status'] == 'paid' ? 'success' : 
                                                                ($service['payment_status'] == 'partial' ? 'warning' : 'danger'); 
                                                        ?>">
                                                            <?php echo ucfirst($service['payment_status']); ?>
                                                        </span>
                                                    </p>
                                                </div>
                                            </div>

                                            <h5 class="fs-17 fw-semibold">Service Details</h5>
                                            <div class="row mb-4">
                                                <div class="col-md-6">
                                                    <h5 class="fs-14 mb-1">Agent Name</h5>
                                                    <p class="text-muted"><?php echo htmlspecialchars($service['agent_name']); ?></p>
                                                </div>
                                            </div>

                                            <?php if (!empty($service['notes'])): ?>
                                            <h5 class="fs-17 fw-semibold">Notes</h5>
                                            <div class="row mb-4">
                                                <div class="col-md-12">
                                                    <p class="text-muted"><?php echo nl2br(htmlspecialchars($service['notes'])); ?></p>
                                                </div>
                                            </div>
                                            <?php endif; ?>

                                            <h5 class="fs-17 fw-semibold">System Information</h5>
                                            <div class="row">
                                                <div class="col-md-4">
                                                    <h5 class="fs-14 mb-1">Created By</h5>
                                                    <p class="text-muted"><?php echo htmlspecialchars($service['created_by_name']); ?></p>
                                                </div>
                                                <div class="col-md-4">
                                                    <h5 class="fs-14 mb-1">Created Date</h5>
                                                    <p class="text-muted"><?php echo date('d M Y H:i', strtotime($service['created_at'])); ?></p>
                                                </div>
                                                <div class="col-md-4">
                                                    <h5 class="fs-14 mb-1">Last Updated</h5>
                                                    <p class="text-muted"><?php echo date('d M Y H:i', strtotime($service['updated_at'])); ?></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
</body>
</html>