<?php
include 'layouts/session.php';
include 'layouts/dbconn.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $expense_id = $_POST['expense_id'];
    $expense_type = $_POST['expense_type'];
    $amount = $_POST['amount'];
    $currency = $_POST['currency'];
    $description = $_POST['description'];
    $expense_date = $_POST['expense_date'];
    $payment_method = $_POST['payment_method'];
    $reference_number = $_POST['reference_number'];

    try {
        $stmt = $conn->prepare("UPDATE expenses SET expense_type=?, amount=?, currency=?, description=?, expense_date=?, payment_method=?, reference_number=? WHERE expense_id=?");
        $stmt->bind_param("sdsssssi", $expense_type, $amount, $currency, $description, $expense_date, $payment_method, $reference_number, $expense_id);
        
        if ($stmt->execute()) {
            $_SESSION['success_msg'] = "Expense updated successfully";
        } else {
            $_SESSION['error_msg'] = "Error updating expense";
        }
    } catch (Exception $e) {
        $_SESSION['error_msg'] = "Error: " . $e->getMessage();
    }

    header("Location: all_expenses.php");
    exit();
}
?>