<?php
// Enable error reporting for debugging
//ini_set('display_errors', 1); 
//ini_set('log_errors', 1); 
//ini_set('error_log', 'errors.log');
//error_reporting(E_ALL);

// Include the database connection file
include('layouts/dbconn.php');

// Ensure the request is POST
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    header('Content-Type: application/json'); // Ensure the response is JSON

    // Retrieve form data
    $customer_id = $_POST['customer_id'] ?? null;
    $subject = $_POST['subject'] ?? null;
    $description = $_POST['description'] ?? null;
    $priority = $_POST['priority'] ?? 'low'; // default to low if not provided
    $status = $_POST['status'] ?? 'open'; // default to open if not provided

    // Start a transaction
    $conn->begin_transaction();

    try {
        // Get the next ticket number from your function
        $result = $conn->query("SELECT get_next_ticket_number() AS next_number");
        if (!$result) {
            throw new Exception($conn->error);
        }
        $row = $result->fetch_assoc();
        $ticket_number = $row['next_number'];

        // Prepare the SQL query
        $sql = "INSERT INTO support_tickets (ticket_number, customer_id, subject, description, priority, status) VALUES (?, ?, ?, ?, ?, ?)";

        // Prepare the statement
        $stmt = $conn->prepare($sql);
        if (!$stmt) {
            throw new Exception($conn->error);
        }

        // Bind parameters and execute the statement
        $stmt->bind_param("sissss", $ticket_number, $customer_id, $subject, $description, $priority, $status);
        if ($stmt->execute()) {
            // Commit transaction
            $conn->commit();
            echo json_encode(['status' => 'success', 'message' => 'New ticket created successfully', 'ticket_number' => $ticket_number]);
        } else {
            throw new Exception($stmt->error);
        }

        // Close statement
        $stmt->close();
    } catch (Exception $e) {
        // Rollback the transaction on error
        $conn->rollback();
        error_log("Transaction failed: " . $e->getMessage());
        echo json_encode(['status' => 'error', 'message' => 'Error: ' . $e->getMessage()]);
    }

    // Close the connection
    $conn->close();
    exit;
}
