<?php
include 'layouts/session.php';
include 'layouts/dbconn.php';
?>
<!DOCTYPE html>
<html>
<head>
    <title>Saving Staff Member</title>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body>
<?php

// Function to show SweetAlert
function show_sweet_alert($type, $title, $message, $redirect = '') {
    echo "<script>
        Swal.fire({
            icon: '" . $type . "',
            title: '" . addslashes($title) . "',
            html: '" . addslashes($message) . "',
            confirmButtonText: 'Okay'
        }).then((result) => {
            if (result.isConfirmed && '" . $redirect . "') {
                window.location.href = '" . $redirect . "';
            }
        });
    </script>";
}

// Sanitize inputs
$employee_id = trim($_POST['employee_id']);
$full_name = trim($_POST['full_name']);
$email = trim($_POST['email']);
$phone = trim($_POST['phone']);
$department = trim($_POST['department']);
$position = trim($_POST['position']);
$date_hired = trim($_POST['date_hired']);
$address = trim($_POST['address']);
$city = trim($_POST['city']);
$country = trim($_POST['country']);
$status = trim($_POST['status']);
$created_by = $_SESSION['user_id'];

// Validation
$errors = [];

if (empty($employee_id)) $errors[] = 'Employee ID is required.';
if (empty($full_name)) $errors[] = 'Full name is required.';
if (empty($email)) $errors[] = 'Email is required.';
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = 'Invalid email format.';

// Check if employee ID or email already exists
$check_query = "SELECT * FROM staff WHERE employee_id = ? OR email = ?";
$stmt = $conn->prepare($check_query);
$stmt->bind_param("ss", $employee_id, $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $errors[] = 'Employee ID or Email already exists.';
}

if (!empty($errors)) {
    show_sweet_alert('error', 'Validation Error', implode('<br>', $errors));
    echo "</body></html>";
    exit;
}

try {
    // Insert new staff member
    $query = "INSERT INTO staff (
        employee_id, full_name, email, phone, department, 
        position, date_hired, address, city, country, 
        status, created_by
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    
    $stmt = $conn->prepare($query);
    $stmt->bind_param(
        "sssssssssssi",
        $employee_id, $full_name, $email, $phone, $department,
        $position, $date_hired, $address, $city, $country,
        $status, $created_by
    );
    
    if ($stmt->execute()) {
        show_sweet_alert(
            'success',
            'Success',
            'Staff member added successfully!',
            'all_staff.php'
        );
    } else {
        throw new Exception($stmt->error);
    }
    
} catch (Exception $e) {
    show_sweet_alert(
        'error',
        'Error',
        'Error saving staff member: ' . htmlspecialchars($e->getMessage())
    );
} finally {
    if (isset($stmt)) {
        $stmt->close();
    }
    $conn->close();
}
?>
</body>
</html>