<?php include 'layouts/main.php'; ?>
<?php
session_start();
include 'layouts/dbconn.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Basic initialization
$current_month = date('m');
$current_year = date('Y');
$user_id = $_SESSION['user_id'];

// Fetch user details
$sql_user_details = "SELECT username, user_role, full_name, email FROM users WHERE user_id = $user_id";
$result_user_details = $conn->query($sql_user_details);

if ($result_user_details && $row_user_details = $result_user_details->fetch_assoc()) {
    $username = $row_user_details['username'];
    $user_role = $row_user_details['user_role'];
    $full_name = $row_user_details['full_name'];
    $email = $row_user_details['email'];
}

// Initialize variables
$totalBookings = $totalBookingsPrev = $upcomingFlights = $upcomingFlightsPrev = 0;
$totalRevenue = $totalRevenuePrev = $totalCancellations = $totalCancellationsPrev = 0;

try {
    // 1. Get Monthly Revenue Trend for Chart
    $sqlMonthlyRevenue = "
    SELECT 
        MONTH(p.payment_date) as month,
        SUM(p.amount) as revenue
    FROM payments p 
    WHERE p.payment_status = 'Completed' 
    AND YEAR(p.payment_date) = YEAR(CURDATE())
    GROUP BY MONTH(p.payment_date)
    ORDER BY MONTH(p.payment_date)";
    
    $result = $conn->query($sqlMonthlyRevenue);
    $monthlyRevenue = array_fill(1, 12, 0);
    while ($row = $result->fetch_assoc()) {
        $monthlyRevenue[$row['month']] = (float)$row['revenue'];
    }

    // 2. Revenue by Source Chart Data
    $sqlRevenueBySource = "
    SELECT 'Flight Tickets' as source, SUM(total_amount) as amount, SUM(agency_fee) as commission
    FROM ticket_details 
    WHERE status = 'Active' 
    AND MONTH(created_date) = MONTH(CURDATE())
    UNION ALL
    SELECT 'Cargo Services' as source, SUM(total_amount) as amount, SUM(total_amount - paid_amount) as commission
    FROM cargo_bookings 
    WHERE payment_status = 'paid' 
    AND MONTH(booking_date) = MONTH(CURDATE())
    UNION ALL
    SELECT 'Visa Services' as source, SUM(amount) as amount, SUM(commission) as commission
    FROM visa_applications 
    WHERE status = 'Completed' 
    AND MONTH(created_at) = MONTH(CURDATE())
    UNION ALL
    SELECT 'Passport Extensions' as source, SUM(amount_received) as amount, SUM(agency_fee) as commission
    FROM passport_extensions 
    WHERE payment_status = 'paid' 
    AND MONTH(extension_date) = MONTH(CURDATE())";
    
    $result = $conn->query($sqlRevenueBySource);
    $revenueBySource = [];
    $totalRevenueAmount = 0;
    while ($row = $result->fetch_assoc()) {
        if ($row['amount'] > 0) {
            $revenueBySource[] = $row;
            $totalRevenueAmount += $row['amount'];
        }
    }
    $totalRevenue = $totalRevenueAmount;

    // 3. Get Popular Routes
    $sqlPopularRoutes = "
    SELECT 
        CONCAT(a1.city, ' - ', a2.city) AS route,
        COUNT(*) AS bookings
    FROM bookings b
    JOIN flights f ON b.flight_id = f.flight_id
    JOIN airports a1 ON f.origin_id = a1.airport_id
    JOIN airports a2 ON f.destination_id = a2.airport_id
    WHERE b.status = 'Booked'
    AND b.booking_date >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)
    GROUP BY a1.city, a2.city
    ORDER BY bookings DESC
    LIMIT 5";
    
    $result = $conn->query($sqlPopularRoutes);
    $popularRoutes = [];
    while ($row = $result->fetch_assoc()) {
        $popularRoutes[] = $row;
    }

    // 4. Monthly Bookings Trend
    $sqlMonthlyBookings = "
    SELECT 
        MONTH(booking_date) as month,
        COUNT(*) as bookings
    FROM bookings 
    WHERE status = 'Booked' 
    AND YEAR(booking_date) = YEAR(CURDATE())
    GROUP BY MONTH(booking_date)
    ORDER BY MONTH(booking_date)";
    
    $result = $conn->query($sqlMonthlyBookings);
    $monthlyBookings = array_fill(1, 12, 0);
    while ($row = $result->fetch_assoc()) {
        $monthlyBookings[$row['month']] = (int)$row['bookings'];
    }

    // 5. Get Currency Distribution
    $sqlCurrencyDistribution = "
    SELECT 
        SUM(CASE WHEN currency = 'USD' THEN total_amount ELSE 0 END) as usd_total,
        SUM(CASE WHEN currency = 'KES' THEN total_amount ELSE 0 END) as kes_total
    FROM ticket_details 
    WHERE status = 'Active' 
    AND MONTH(created_date) = MONTH(CURDATE())";
    
    $result = $conn->query($sqlCurrencyDistribution);
    $currencyData = ['USD' => 0, 'KES' => 0];
    if ($row = $result->fetch_assoc()) {
        $currencyData['USD'] = (float)$row['usd_total'];
        $currencyData['KES'] = (float)$row['kes_total'];
    }

    // 6. Recent Current Month Metrics
    $sqlTotalBookings = "SELECT COUNT(*) AS total_bookings 
                        FROM bookings 
                        WHERE status = 'Booked' 
                        AND MONTH(booking_date) = MONTH(CURDATE()) 
                        AND YEAR(booking_date) = YEAR(CURDATE())";
    $result = $conn->query($sqlTotalBookings);
    if ($result->num_rows > 0) {
        $totalBookings = $result->fetch_assoc()['total_bookings'];
    }

    // 7. Previous Month Bookings for comparison
    $sqlTotalBookingsPrev = "SELECT COUNT(*) AS total_bookings 
                            FROM bookings 
                            WHERE status = 'Booked' 
                            AND MONTH(booking_date) = MONTH(CURDATE()) - 1 
                            AND YEAR(booking_date) = YEAR(CURDATE())";
    $result = $conn->query($sqlTotalBookingsPrev);
    if ($result->num_rows > 0) {
        $totalBookingsPrev = $result->fetch_assoc()['total_bookings'];
    }

    // Calculate percentage changes
    $bookingsChange = ($totalBookingsPrev > 0) ? 
        (($totalBookings - $totalBookingsPrev) / $totalBookingsPrev) * 100 : 0;

    // Get agency fees
    $sqlAgencyFees = "
    SELECT (
        -- Agency fees from ticket details
        SELECT COALESCE(SUM(agency_fee), 0)
        FROM ticket_details 
        WHERE status = 'Active'
        AND MONTH(created_date) = MONTH(CURDATE())
        AND YEAR(created_date) = YEAR(CURDATE())
    ) + (
        -- Agency fees from visa applications
        SELECT COALESCE(SUM(commission), 0)
        FROM visa_applications
        WHERE status = 'Completed'
        AND MONTH(created_at) = MONTH(CURDATE())
        AND YEAR(created_at) = YEAR(CURDATE())
    ) + (
        -- Agency fees from passport extensions
        SELECT COALESCE(SUM(agency_fee), 0)
        FROM passport_extensions
        WHERE payment_status = 'paid'
        AND MONTH(extension_date) = MONTH(CURDATE())
        AND YEAR(extension_date) = YEAR(CURDATE())
    ) AS total_agency_fees";

    $result = $conn->query($sqlAgencyFees);
    $totalAgencyFees = $result->fetch_assoc()['total_agency_fees'];

} catch (Exception $e) {
    error_log("Error in dashboard metrics calculation: " . $e->getMessage());
    $monthlyRevenue = array_fill(1, 12, 0);
    $currencyData = ['USD' => 0, 'KES' => 0];
    $popularRoutes = [];
    $revenueBySource = [];
    $monthlyBookings = array_fill(1, 12, 0);
}
?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'African Wings Travel & Cargo Agency')); ?>
    <?php include 'layouts/head-css.php'; ?>
    
    <!-- Chart.js CDN -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <!-- ApexCharts CDN (alternative chart library) -->
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    
    <!-- Custom Charts CSS -->
    <style>
        .chart-container {
            position: relative;
            height: 300px;
            width: 100%;
        }
        .small-chart {
            height: 200px;
        }
        .metric-card {
            transition: all 0.3s ease;
        }
        .metric-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
    </style>
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Dashboard', 'title' => 'African Wings Travel & Cargo Agency')); ?>

                    <!-- Main Metrics Cards -->
                    <div class="row">
                        <!-- Revenue Card -->
                        <div class="col-xl-4 col-md-6">
                            <div class="card card-animate metric-card">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-sm flex-shrink-0">
                                            <span class="avatar-title bg-success-subtle text-success rounded-2 fs-2">
                                                <i data-feather="dollar-sign" class="text-success"></i>
                                            </span>
                                        </div>
                                        <div class="flex-grow-1 overflow-hidden ms-3">
                                            <p class="text-uppercase fw-semibold text-muted text-truncate mb-3">Revenue Generated</p>
                                            <div class="d-flex align-items-center mb-3">
                                                <h4 class="fs-4 flex-grow-1 mb-0">$<?php echo number_format($totalRevenue, 2); ?></h4>
                                                <span class="badge bg-success-subtle text-success fs-12">
                                                    <i class="ri-arrow-up-s-line fs-13 align-middle me-1"></i>
                                                    MTD
                                                </span>
                                            </div>
                                            <p class="text-muted text-truncate mb-0">Revenue this month (All Services)</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Total Bookings Card -->
                        <div class="col-xl-4 col-md-6">
                            <div class="card card-animate metric-card">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-sm flex-shrink-0">
                                            <span class="avatar-title bg-primary-subtle text-primary rounded-2 fs-2">
                                                <i data-feather="briefcase" class="text-primary"></i>
                                            </span>
                                        </div>
                                        <div class="flex-grow-1 overflow-hidden ms-3">
                                            <p class="text-uppercase fw-semibold text-muted text-truncate mb-3">Total Bookings</p>
                                            <div class="d-flex align-items-center mb-3">
                                                <h4 class="fs-4 flex-grow-1 mb-0"><?php echo $totalBookings; ?></h4>
                                                <span class="badge <?php echo $bookingsChange >= 0 ? 'bg-success-subtle text-success' : 'bg-danger-subtle text-danger'; ?> fs-12">
                                                    <i class="ri-arrow-<?php echo $bookingsChange >= 0 ? 'up' : 'down'; ?>-s-line fs-13 align-middle me-1"></i>
                                                    <?php echo number_format(abs($bookingsChange), 1); ?>%
                                                </span>
                                            </div>
                                            <p class="text-muted text-truncate mb-0">Bookings this month</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Total Agency Fees Card -->
                        <div class="col-xl-4 col-md-6">
                            <div class="card card-animate metric-card">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-sm flex-shrink-0">
                                            <span class="avatar-title bg-warning-subtle text-warning rounded-2 fs-2">
                                                <i data-feather="percent" class="text-warning"></i>
                                            </span>
                                        </div>
                                        <div class="flex-grow-1 overflow-hidden ms-3">
                                            <p class="text-uppercase fw-semibold text-muted text-truncate mb-3">Total Agency Fees</p>
                                            <div class="d-flex align-items-center mb-3">
                                                <h4 class="fs-4 flex-grow-1 mb-0">$<?php echo number_format($totalAgencyFees, 2); ?></h4>
                                            </div>
                                            <p class="text-muted text-truncate mb-0">Commission earned this month</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Charts Row -->
                    <div class="row">
                        <!-- Monthly Revenue Trend Chart -->
                        <div class="col-xl-8">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Monthly Revenue Trend</h4>
                                </div>
                                <div class="card-body">
                                    <div class="chart-container">
                                        <canvas id="revenueChart"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Revenue by Source Pie Chart -->
                        <div class="col-xl-4">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Revenue by Source</h4>
                                </div>
                                <div class="card-body">
                                    <div class="chart-container small-chart">
                                        <canvas id="revenueBySourceChart"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Monthly Bookings and Currency Distribution -->
                    <div class="row">
                        <!-- Monthly Bookings Bar Chart -->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Monthly Bookings Trend</h4>
                                </div>
                                <div class="card-body">
                                    <div class="chart-container small-chart">
                                        <canvas id="monthlyBookingsChart"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Popular Routes -->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Popular Routes</h4>
                                </div>
                                <div class="card-body">
                                    <div class="chart-container small-chart">
                                        <canvas id="popularRoutesChart"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Tables Section -->
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Recent Ticket Bookings</h4>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="buttons-datatables" class="display table table-bordered" style="width:100%">
                                            <thead>
                                                <tr>
                                                    <th>Ticket ID</th>
                                                    <th>Ticket Ref</th>
                                                    <th>Customer Name</th>
                                                    <th>Flight Route</th>
                                                    <th>Flight Date</th>
                                                    <th>Amount</th>
                                                    <th>Agency Fee</th>
                                                    <th>Status</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                // Include the database connection file
                                                include('layouts/dbconn.php');
                                                
                                                // Fetch recent tickets
                                                $query = "SELECT 
                                                    td.ticket_id,
                                                    td.ticket_ref,
                                                    td.customer_name,
                                                    td.flight_route,
                                                    td.flight_date,
                                                    td.total_amount,
                                                    td.agency_fee,
                                                    td.status
                                                FROM ticket_details td
                                                ORDER BY td.created_date DESC
                                                LIMIT 10";
                                                
                                                $result = $conn->query($query);
                                                
                                                if ($result->num_rows > 0) {
                                                    while ($row = $result->fetch_assoc()) {
                                                        $statusClass = $row['status'] === 'Active' ? 'badge bg-success' : 
                                                                    ($row['status'] === 'Cancelled' ? 'badge bg-danger' : 'badge bg-warning');
                                                        
                                                        echo "<tr>";
                                                        echo "<td>{$row['ticket_id']}</td>";
                                                        echo "<td>{$row['ticket_ref']}</td>";
                                                        echo "<td>{$row['customer_name']}</td>";
                                                        echo "<td>{$row['flight_route']}</td>";
                                                        echo "<td>" . date('d M Y', strtotime($row['flight_date'])) . "</td>";
                                                        echo "<td>$" . number_format($row['total_amount'], 2) . "</td>";
                                                        echo "<td>$" . number_format($row['agency_fee'], 2) . "</td>";
                                                        echo "<td><span class='{$statusClass}'>{$row['status']}</span></td>";
                                                        echo '<td>
                                                                <a href="view_ticket.php?ticket_id=' . $row['ticket_id'] . '" class="btn btn-sm btn-soft-info">
                                                                    <i class="ri-eye-fill align-bottom"></i> View
                                                                </a>
                                                              </td>';
                                                        echo "</tr>";
                                                    }
                                                } else {
                                                    echo "<tr><td colspan='9'>No tickets found</td></tr>";
                                                }
                                                
                                                $conn->close();
                                                ?>
                                            </tbody>    
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php include 'layouts/footer.php'; ?>
                </div>
            </div>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="assets/js/app.js"></script>
    <script>
    // Chart.js global configuration
    Chart.defaults.font.family = "'Inter', sans-serif";
    Chart.defaults.color = '#8c90a4';

    // Monthly Revenue Chart
    const monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
    const monthlyRevenueData = <?php echo json_encode(array_values($monthlyRevenue)); ?>;
    
    new Chart(document.getElementById('revenueChart'), {
        type: 'line',
        data: {
            labels: monthNames,
            datasets: [{
                label: 'Revenue ($)',
                data: monthlyRevenueData,
                borderColor: 'rgb(75, 192, 192)',
                backgroundColor: 'rgba(75, 192, 192, 0.1)',
                borderWidth: 2,
                fill: true,
                tension: 0.3
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'top',
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return `Revenue: $${context.parsed.y.toLocaleString()}`;
                        }
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return '$' + value.toLocaleString();
                        }
                    }
                }
            }
        }
    });

    // Revenue by Source Pie Chart
    const revenueBySourceData = <?php echo json_encode($revenueBySource); ?>;
    const sources = revenueBySourceData.map(item => item.source);
    const amounts = revenueBySourceData.map(item => item.amount);
    
    new Chart(document.getElementById('revenueBySourceChart'), {
        type: 'pie',
        data: {
            labels: sources,
            datasets: [{
                data: amounts,
                backgroundColor: [
                    'rgba(255, 99, 132, 0.8)',
                    'rgba(54, 162, 235, 0.8)',
                    'rgba(255, 206, 86, 0.8)',
                    'rgba(75, 192, 192, 0.8)',
                    'rgba(153, 102, 255, 0.8)'
                ],
                borderColor: [
                    'rgba(255, 99, 132, 1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 206, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(153, 102, 255, 1)'
                ],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            const value = context.parsed;
                            const total = amounts.reduce((a, b) => a + b, 0);
                            const percentage = ((value / total) * 100).toFixed(1);
                            return `${context.label}: $${value.toLocaleString()} (${percentage}%)`;
                        }
                    }
                }
            }
        }
    });

    // Monthly Bookings Bar Chart
    const monthlyBookingsData = <?php echo json_encode(array_values($monthlyBookings)); ?>;
    
    new Chart(document.getElementById('monthlyBookingsChart'), {
        type: 'bar',
        data: {
            labels: monthNames,
            datasets: [{
                label: 'Number of Bookings',
                data: monthlyBookingsData,
                backgroundColor: 'rgba(54, 162, 235, 0.8)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return `Bookings: ${context.parsed.y}`;
                        }
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1
                    }
                }
            }
        }
    });

    // Popular Routes Bar Chart
    const popularRoutesData = <?php echo json_encode($popularRoutes); ?>;
    const routes = popularRoutesData.map(item => item.route);
    const bookings = popularRoutesData.map(item => item.bookings);
    
    new Chart(document.getElementById('popularRoutesChart'), {
        type: 'bar',
        data: {
            labels: routes,
            datasets: [{
                label: 'Number of Bookings',
                data: bookings,
                backgroundColor: 'rgba(255, 159, 64, 0.8)',
                borderColor: 'rgba(255, 159, 64, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return `Bookings: ${context.parsed.y}`;
                        }
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1
                    }
                }
            }
        }
    });

    // Initialize Feather Icons
    feather.replace();
    </script>
</body>
</html>