<?php
include 'layouts/dbconn.php';

if (isset($_GET['customer_id'])) {
    $customer_id = intval($_GET['customer_id']);
    $query = "SELECT address_id, street_address, city, state, postal_code, country FROM customer_addresses WHERE customer_id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param('i', $customer_id);
    $stmt->execute();
    $result = $stmt->get_result();

    $addresses = [];
    while ($row = $result->fetch_assoc()) {
        $addresses[] = $row;
    }

    echo json_encode($addresses);
} else {
    echo json_encode([]);
}

$conn->close();
?>
