<?php
include 'layouts/main.php';
include 'layouts/dbconn.php';


$user_id = $_SESSION['user_id'];

// Get service ID from URL
$service_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($service_id == 0) {
    header('Location: all_go_home.php');
    exit();
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $service_date = $_POST['service_date'];
        $client_name = $_POST['client_name'];
        $mother_name = $_POST['mother_name'];
        $date_of_birth = $_POST['date_of_birth'];
        $price = floatval($_POST['price']);
        $office_fee = floatval($_POST['office_fee']);
        $agent_name = $_POST['agent_name'];
        $currency = $_POST['currency'];
        $notes = $_POST['notes'] ?? '';
        $payment_status = $_POST['payment_status'];
        $status = $_POST['status'];
        
        $sql = "UPDATE go_home_service SET 
                service_date = ?, 
                client_name = ?, 
                mother_name = ?, 
                date_of_birth = ?, 
                price = ?, 
                office_fee = ?, 
                agent_name = ?, 
                currency = ?, 
                notes = ?, 
                payment_status = ?, 
                status = ?,
                updated_by = ?
                WHERE service_id = ?";
        
        $stmt = $conn->prepare($sql);
        $stmt->bind_param(
            "ssssddsssssii",
            $service_date,
            $client_name,
            $mother_name,
            $date_of_birth,
            $price,
            $office_fee,
            $agent_name,
            $currency,
            $notes,
            $payment_status,
            $status,
            $user_id,
            $service_id
        );
        
        if ($stmt->execute()) {
            $_SESSION['success_message'] = "Go Home service has been successfully updated.";
            header('Location: view_go_home.php?id=' . $service_id);
            exit();
        } else {
            $_SESSION['error_message'] = "Error updating Go Home service: " . $stmt->error;
        }
    } catch (Exception $e) {
        $_SESSION['error_message'] = "Error: " . $e->getMessage();
    }
}

// Fetch existing service details
$sql = "SELECT * FROM go_home_service WHERE service_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $service_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows == 0) {
    header('Location: all_go_home.php');
    exit();
}

$service = $result->fetch_assoc();
?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Edit Go Home Service')); ?>
    <?php include 'layouts/head-css.php'; ?>
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Services', 'title' => 'Edit Go Home Service')); ?>

                    <?php if (isset($_SESSION['error_message'])): ?>
                        <div class="alert alert-danger alert-dismissible">
                            <?php echo $_SESSION['error_message']; ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                        <?php unset($_SESSION['error_message']); ?>
                    <?php endif; ?>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Edit Go Home Service</h4>
                                </div>
                                <div class="card-body">
                                    <form action="" method="POST" class="needs-validation" novalidate>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label" for="reference_number">Reference Number</label>
                                                    <input type="text" class="form-control" id="reference_number" 
                                                           value="<?php echo htmlspecialchars($service['reference_number']); ?>" disabled>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label" for="service_date">Service Date</label>
                                                    <input type="date" class="form-control" id="service_date" name="service_date" 
                                                           value="<?php echo $service['service_date']; ?>" required>
                                                    <div class="invalid-feedback">
                                                        Please enter service date.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label" for="client_name">Client Name</label>
                                                    <input type="text" class="form-control" id="client_name" name="client_name" 
                                                           value="<?php echo htmlspecialchars($service['client_name']); ?>" required>
                                                    <div class="invalid-feedback">
                                                        Please enter client name.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label" for="mother_name">Mother's Name</label>
                                                    <input type="text" class="form-control" id="mother_name" name="mother_name" 
                                                           value="<?php echo htmlspecialchars($service['mother_name']); ?>" required>
                                                    <div class="invalid-feedback">
                                                        Please enter mother's name.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label" for="date_of_birth">Date of Birth</label>
                                                    <input type="date" class="form-control" id="date_of_birth" name="date_of_birth" 
                                                           value="<?php echo $service['date_of_birth']; ?>" required>
                                                    <div class="invalid-feedback">
                                                        Please enter date of birth.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label" for="price">Price</label>
                                                    <input type="number" class="form-control" id="price" name="price" 
                                                           value="<?php echo $service['price']; ?>" step="0.01" min="0" required>
                                                    <div class="invalid-feedback">
                                                        Please enter price.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label" for="office_fee">Office Fee</label>
                                                    <input type="number" class="form-control" id="office_fee" name="office_fee" 
                                                           value="<?php echo $service['office_fee']; ?>" step="0.01" min="0" required>
                                                    <div class="invalid-feedback">
                                                        Please enter office fee.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label" for="agent_name">Agent Name</label>
                                                    <input type="text" class="form-control" id="agent_name" name="agent_name" 
                                                           value="<?php echo htmlspecialchars($service['agent_name']); ?>" required>
                                                    <div class="invalid-feedback">
                                                        Please enter agent name.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label" for="currency">Currency</label>
                                                    <select class="form-select" id="currency" name="currency" required>
                                                        <option value="">Select currency</option>
                                                        <option value="USD" <?php echo $service['currency'] == 'USD' ? 'selected' : ''; ?>>USD</option>
                                                        <option value="KES" <?php echo $service['currency'] == 'KES' ? 'selected' : ''; ?>>KES</option>
                                                    </select>
                                                    <div class="invalid-feedback">
                                                        Please select currency.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label" for="payment_status">Payment Status</label>
                                                    <select class="form-select" id="payment_status" name="payment_status" required>
                                                        <option value="">Select payment status</option>
                                                        <option value="unpaid" <?php echo $service['payment_status'] == 'unpaid' ? 'selected' : ''; ?>>Unpaid</option>
                                                        <option value="partial" <?php echo $service['payment_status'] == 'partial' ? 'selected' : ''; ?>>Partial</option>
                                                        <option value="paid" <?php echo $service['payment_status'] == 'paid' ? 'selected' : ''; ?>>Paid</option>
                                                    </select>
                                                    <div class="invalid-feedback">
                                                        Please select payment status.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label" for="status">Service Status</label>
                                                    <select class="form-select" id="status" name="status" required>
                                                        <option value="">Select status</option>
                                                        <option value="pending" <?php echo $service['status'] == 'pending' ? 'selected' : ''; ?>>Pending</option>
                                                        <option value="in_progress" <?php echo $service['status'] == 'in_progress' ? 'selected' : ''; ?>>In Progress</option>
                                                        <option value="completed" <?php echo $service['status'] == 'completed' ? 'selected' : ''; ?>>Completed</option>
                                                        <option value="cancelled" <?php echo $service['status'] == 'cancelled' ? 'selected' : ''; ?>>Cancelled</option>
                                                    </select>
                                                    <div class="invalid-feedback">
                                                        Please select status.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-12">
                                                <div class="mb-3">
                                                    <label class="form-label" for="notes">Notes (Optional)</label>
                                                    <textarea class="form-control" id="notes" name="notes" rows="3"><?php echo htmlspecialchars($service['notes']); ?></textarea>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="mt-3">
                                            <button type="submit" class="btn btn-primary">Update</button>
                                            <a href="view_go_home.php?id=<?php echo $service_id; ?>" class="btn btn-secondary">Cancel</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>

    <script>
        // Form validation
        (function() {
            'use strict';
            window.addEventListener('load', function() {
                var forms = document.getElementsByClassName('needs-validation');
                var validation = Array.prototype.filter.call(forms, function(form) {
                    form.addEventListener('submit', function(event) {
                        if (form.checkValidity() === false) {
                            event.preventDefault();
                            event.stopPropagation();
                        }
                        form.classList.add('was-validated');
                    }, false);
                });
            }, false);
        })();
    </script>
</body>
</html>