<?php
include 'layouts/session.php';
include 'layouts/dbconn.php';
header('Content-Type: application/json');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $conn->begin_transaction();
    try {
        // Get JSON data
        $data = json_decode(file_get_contents('php://input'), true);
        
        // Validate ticket_ref
        if (!isset($data['ticket_ref']) || empty($data['ticket_ref'])) {
            throw new Exception("Invalid ticket reference");
        }
        
        $ticket_ref = $data['ticket_ref'];
        
        // Check if ticket exists and is in cancellable state
        $checkStmt = $conn->prepare("SELECT status FROM ticket_details WHERE ticket_ref = ?");
        $checkStmt->bind_param("s", $ticket_ref);
        $checkStmt->execute();
        $result = $checkStmt->get_result();
        
        if ($result->num_rows === 0) {
            throw new Exception("Ticket not found");
        }
        
        $ticket = $result->fetch_assoc();
        if ($ticket['status'] !== 'Active') {
            throw new Exception("Only active tickets can be cancelled");
        }
        
        // Update ticket status
        $updateStmt = $conn->prepare("UPDATE ticket_details 
                                    SET status = 'Cancelled', 
                                        created_by = ?,
                                        updated_date = CURRENT_TIMESTAMP 
                                    WHERE ticket_ref = ?");
        
        $userId = $_SESSION['user_id'];
        $updateStmt->bind_param("is", $userId, $ticket_ref);
        
        if (!$updateStmt->execute()) {
            throw new Exception("Failed to cancel ticket");
        }
        
        // Add audit log
        $logStmt = $conn->prepare("INSERT INTO audit_logs (user_id, action, log_details, ip_address, user_agent) 
                                  VALUES (?, 'CANCEL_TICKET', ?, ?, ?)");
        $logDetails = "Cancelled ticket reference: " . $ticket_ref;
        $logStmt->bind_param(
            "isss", 
            $userId,
            $logDetails,
            $_SERVER['REMOTE_ADDR'],
            $_SERVER['HTTP_USER_AGENT']
        );
        $logStmt->execute();
        
        $conn->commit();
        echo json_encode([
            'status' => 'success',
            'message' => 'Ticket cancelled successfully'
        ]);
    } catch (Exception $e) {
        $conn->rollback();
        echo json_encode([
            'status' => 'error',
            'message' => $e->getMessage()
        ]);
    }
}
$conn->close();
?>