<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>

<?php
include 'layouts/dbconn.php';

// Fetch all staff members
$query = "SELECT s.*, u.full_name as created_by_name 
          FROM staff s
          LEFT JOIN users u ON s.created_by = u.user_id
          ORDER BY s.created_at DESC";
$result = $conn->query($query);
?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'View All Staff')); ?>
    <?php include 'layouts/head-css.php'; ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Staff Management', 'title' => 'All Staff Members')); ?>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <div class="d-flex align-items-center">
                                        <h5 class="card-title mb-0 flex-grow-1">Staff List</h5>
                                        <div class="flex-shrink-0">
                                            <a href="add_staff.php" class="btn btn-success">
                                                <i class="ri-add-line align-bottom me-1"></i> Add Staff
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="buttons-datatables" class="display table table-bordered" style="width:100%">
                                            <thead>
                                                <tr>
                                                    <th>Employee ID</th>
                                                    <th>Full Name</th>
                                                    <th>Email</th>
                                                    <th>Phone</th>
                                                    <th>Department</th>
                                                    <th>Position</th>
                                                    <th>Date Hired</th>
                                                    <th>Status</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                if ($result->num_rows > 0) {
                                                    while ($row = $result->fetch_assoc()) {
                                                        $status_class = '';
                                                        switch($row['status']) {
                                                            case 'active':
                                                                $status_class = 'badge bg-success';
                                                                break;
                                                            case 'inactive':
                                                                $status_class = 'badge bg-secondary';
                                                                break;
                                                            case 'suspended':
                                                                $status_class = 'badge bg-danger';
                                                                break;
                                                        }
                                                        ?>
                                                        <tr>
                                                            <td><?php echo $row['employee_id']; ?></td>
                                                            <td><?php echo $row['full_name']; ?></td>
                                                            <td><?php echo $row['email']; ?></td>
                                                            <td><?php echo $row['phone']; ?></td>
                                                            <td><?php echo $row['department']; ?></td>
                                                            <td><?php echo $row['position']; ?></td>
                                                            <td><?php echo $row['date_hired'] ? date('d M Y', strtotime($row['date_hired'])) : ''; ?></td>
                                                            <td><span class="<?php echo $status_class; ?>"><?php echo ucfirst($row['status']); ?></span></td>
                                                            <td>
                                                                <div class="dropdown d-inline-block">
                                                                    <button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                                        <i class="ri-more-fill align-middle"></i>
                                                                    </button>
                                                                    <ul class="dropdown-menu dropdown-menu-end">
                                                                        <li>
                                                                            <a href="view_staff.php?id=<?php echo $row['staff_id']; ?>" class="dropdown-item">
                                                                                <i class="ri-eye-fill align-bottom me-2 text-muted"></i> View
                                                                            </a>
                                                                        </li>
                                                                        <li>
                                                                            <a href="edit_staff.php?id=<?php echo $row['staff_id']; ?>" class="dropdown-item edit-item-btn">
                                                                                <i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Edit
                                                                            </a>
                                                                        </li>
                                                                        <li>
                                                                            <a href="javascript:void(0);" onclick="confirmDelete(<?php echo $row['staff_id']; ?>)" class="dropdown-item remove-item-btn">
                                                                                <i class="ri-delete-bin-fill align-bottom me-2 text-muted"></i> Delete
                                                                            </a>
                                                                        </li>
                                                                    </ul>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    <?php
                                                    }
                                                } else {
                                                    echo "<tr><td colspan='9' class='text-center'>No staff members found</td></tr>";
                                                }
                                                ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="assets/js/pages/datatables.init.js"></script>
    <script src="assets/js/app.js"></script>

    <script>
    function confirmDelete(staffId) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = 'delete_staff.php?id=' + staffId;
            }
        })
    }
    </script>
</body>
</html>