<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>
<?php
// Include the database connection file
include 'layouts/dbconn.php';

// Fetch all flight schedules from the database
$sqlFlightSchedules = "SELECT fs.schedule_id, fs.flight_number, fs.departure_time, fs.arrival_time, 
                               fs.start_date, fs.end_date, fs.days_of_week,
                               o.city AS origin_city, d.city AS destination_city
                        FROM flight_schedules fs
                        JOIN airports o ON fs.origin_id = o.airport_id
                        JOIN airports d ON fs.destination_id = d.airport_id
                        WHERE fs.end_date >= CURDATE()
                        ORDER BY fs.start_date, fs.departure_time";
$result = $conn->query($sqlFlightSchedules);

// Initialize an array to store flight schedules
$flightSchedules = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $flightSchedules[] = $row;
    }
}

// Encode the flight schedules as JSON for use in JavaScript
$flightSchedulesJson = json_encode($flightSchedules);

// Close the database connection
$conn->close();
?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'All Flight Schedules')); ?>

    <!--datatable css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />
    <!--datatable responsive css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">

    <?php include 'layouts/head-css.php'; ?>
    
    <link href='https://cdn.jsdelivr.net/npm/fullcalendar@5.10.2/main.min.css' rel='stylesheet' />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <style>
        #calendar {
            max-width: 900px;
            margin: 40px auto;
        }
        .date-picker {
            margin-bottom: 20px;
        }
    </style>
</head>

<body>
    <!-- Begin page -->
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Manage Flights', 'title' => 'All Flight Schedules')); ?>

                    <div class="date-picker">
                        <label for="date-range">Select Date Range:</label>
                        <input type="text" id="date-range" placeholder="Select date range">
                    </div>

                    <div id='calendar'></div>
                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

            <?php include 'layouts/footer.php'; ?>
        </div>
        <!-- end main content-->
    </div>
    <!-- END layout-wrapper -->

    <?php include 'layouts/customizer.php'; ?>
    <?php include 'layouts/vendor-scripts.php'; ?>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

    <script src="assets/js/pages/datatables.init.js"></script>
    <!-- App js -->
    <script src="assets/js/app.js"></script>
    <script src='https://cdn.jsdelivr.net/npm/fullcalendar@5.10.2/main.min.js'></script>
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var calendarEl = document.getElementById('calendar');
            var flightSchedules = <?php echo $flightSchedulesJson; ?>;
            
            var events = [];
            flightSchedules.forEach(function(schedule) {
                var daysOfWeek = schedule.days_of_week.split(',').map(function(day) {
                    return ['sun', 'mon', 'tue', 'wed', 'thu', 'fri', 'sat'].indexOf(day.toLowerCase());
                });
                
                events.push({
                    title: schedule.flight_number + ': ' + schedule.origin_city + ' to ' + schedule.destination_city,
                    startTime: schedule.departure_time,
                    endTime: schedule.arrival_time,
                    startRecur: schedule.start_date,
                    endRecur: schedule.end_date,
                    daysOfWeek: daysOfWeek,
                    extendedProps: {
                        scheduleId: schedule.schedule_id
                    }
                });
            });

            var calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                events: events,
                eventClick: function(info) {
                    alert('Flight: ' + info.event.title + '\nSchedule ID: ' + info.event.extendedProps.scheduleId);
                }
            });

            calendar.render();

            // Initialize Flatpickr
            flatpickr("#date-range", {
                mode: "range",
                dateFormat: "Y-m-d",
                onChange: function(selectedDates, dateStr, instance) {
                    if (selectedDates.length === 2) {
                        var start = selectedDates[0];
                        var end = selectedDates[1];
                        calendar.gotoDate(start);
                        calendar.setOption('visibleRange', {
                            start: start,
                            end: end
                        });
                    }
                }
            });
        });
    </script>
</body>
</html>