<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>
<?php include 'layouts/dbconn.php'; ?>

<head>

    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'All Ticket Cancellations')); ?>

    <!--datatable css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />
    <!--datatable responsive css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />

    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
    
    <!-- SweetAlert2 CSS -->
    <link href="assets/libs/sweetalert2/sweetalert2.min.css" rel="stylesheet" type="text/css" />


    <?php include 'layouts/head-css.php'; ?>

</head>

<body>

    <!-- Begin page -->
    <div id="layout-wrapper">

        <?php include 'layouts/menu.php'; ?>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Ticket Management', 'title' => 'Ticket Cancellations')); ?>


                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h5 class="card-title mb-0">Cancelled Tickets</h5>
                                </div>
                                <div class="card-body">
                                    <table id="cancellations-table" class="table table-bordered dt-responsive nowrap" style="width:100%">
                                        <thead>
                                            <tr>
                                                <th>Ticket Ref</th>
                                                <th>Customer</th>
                                                <th>Airline</th>
                                                <th>Route</th>
                                                <th>Flight Date</th>
                                                <th>Ticket Cost</th>
                                                <th>Agency Fee</th>
                                                <th>Total Amount</th>
                                                <th>Currency</th>
                                                <th>Cancellation Date</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $query = "SELECT td.*, 
                                                     u.full_name as cancelled_by 
                                                     FROM ticket_details td
                                                     LEFT JOIN users u ON td.created_by = u.user_id
                                                     WHERE td.status = 'Cancelled'
                                                     ORDER BY td.updated_date DESC";
                                            
                                            $result = $conn->query($query);
                                            
                                            if (!$result) {
                                                die("Query failed: " . $conn->error);
                                            }
                                            
                                            while($row = $result->fetch_assoc()):
                                            ?>
                                            <tr>
                                                <td><?php echo htmlspecialchars($row['ticket_ref']); ?></td>
                                                <td>
                                                    <div>
                                                        <h5 class="font-size-14 mb-1">
                                                            <?php echo htmlspecialchars($row['salutation'] . ' ' . $row['customer_name']); ?>
                                                        </h5>
                                                        <?php if ($row['cancelled_by']): ?>
                                                            <p class="text-muted mb-0">Cancelled by: <?php echo htmlspecialchars($row['cancelled_by']); ?></p>
                                                        <?php endif; ?>
                                                    </div>
                                                </td>
                                                <td><?php echo htmlspecialchars($row['airline']); ?></td>
                                                <td><?php echo htmlspecialchars($row['flight_route']); ?></td>
                                                <td><?php echo date('d M Y H:i', strtotime($row['flight_date'])); ?></td>
                                                <td><?php echo htmlspecialchars($row['currency']); ?> <?php echo number_format($row['ticket_cost'], 2); ?></td>
                                                <td><?php echo htmlspecialchars($row['currency']); ?> <?php echo number_format($row['agency_fee'], 2); ?></td>
                                                <td><?php echo htmlspecialchars($row['currency']); ?> <?php echo number_format($row['total_amount'], 2); ?></td>
                                                <td>
                                                    <span class="badge 
                                                        <?php echo $row['currency'] == 'USD' ? 'bg-success' : 
                                                            ($row['currency'] == 'KES' ? 'bg-info' : 'bg-secondary'); ?>">
                                                        <?php echo htmlspecialchars($row['currency']); ?>
                                                    </span>
                                                </td>
                                                <td><?php echo date('d M Y H:i', strtotime($row['updated_date'])); ?></td>
                                                <td><span class="badge bg-danger">Cancelled</span></td>
                                                <td>
                                                    <div class="dropdown">
                                                        <button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown">
                                                            <i class="ri-more-fill align-middle"></i>
                                                        </button>
                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                            <li>
                                                                <a href="#" class="dropdown-item" onclick="viewTicket(<?php echo $row['ticket_id']; ?>)">
                                                                    <i class="ri-eye-fill align-bottom me-2 text-muted"></i> View Details
                                                                </a>
                                                            </li>
                                                            <?php if($row['status'] === 'Cancelled'): ?>
                                                            <li>
                                                                <a href="#" class="dropdown-item" onclick="reissueTicket(<?php echo $row['ticket_id']; ?>, '<?php echo htmlspecialchars($row['ticket_ref']); ?>')">
                                                                    <i class="ri-refresh-fill align-bottom me-2 text-muted"></i> Reissue
                                                                </a>
                                                            </li>
                                                            <?php endif; ?>
                                                            <li>
                                                                <a href="#" class="dropdown-item" onclick="printTicket(<?php echo $row['ticket_id']; ?>)">
                                                                    <i class="ri-printer-fill align-bottom me-2 text-muted"></i> Print
                                                                </a>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php endwhile; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

            <?php include 'layouts/footer.php'; ?>
        </div>
        <!-- end main content-->

    </div>
    <!-- END layout-wrapper -->


    <?php include 'layouts/vendor-scripts.php'; ?>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

    <!-- SweetAlert2 JS -->
    <script src="assets/libs/sweetalert2/sweetalert2.min.js"></script>

    <script src="assets/js/pages/datatables.init.js"></script>
    <!-- App js -->
    <script src="assets/js/app.js"></script>
    
    <script>
    $(document).ready(function() {
        $('#cancellations-table').DataTable({
            dom: 'Bfrtip',
            buttons: [
                {
                    extend: 'copy',
                    className: 'btn btn-sm'
                },
                {
                    extend: 'csv',
                    className: 'btn btn-sm'
                },
                {
                    extend: 'excel',
                    className: 'btn btn-sm'
                },
                {
                    extend: 'pdf',
                    className: 'btn btn-sm'
                },
                {
                    extend: 'print',
                    className: 'btn btn-sm'
                }
            ],
            order: [[9, 'desc']], // Order by cancellation date
            pageLength: 10,
            responsive: true
        });
    });
    
    function viewTicket(ticketId) {
        window.location.href = 'view_ticket.php?id=' + ticketId;
    }
    
    function reissueTicket(ticketId, ticketRef) {
        Swal.fire({
            title: 'Reissue Ticket',
            text: 'Are you sure you want to reissue ticket ' + ticketRef + '?',
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, reissue it!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                // Show loading
                Swal.fire({
                    title: 'Processing...',
                    text: 'Reissuing ticket...',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });
                
                // Redirect to reissue page
                window.location.href = 'reissue_ticket.php?id=' + ticketId;
            }
        });
    }
    
    function printTicket(ticketId) {
        Swal.fire({
            title: 'Print Ticket',
            text: 'Do you want to print this ticket?',
            icon: 'info',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, print it!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                window.open('print_ticket.php?id=' + ticketId, '_blank');
                
                Swal.fire({
                    title: 'Printing...',
                    text: 'Ticket is being prepared for printing',
                    icon: 'success',
                    timer: 1500,
                    showConfirmButton: false
                });
            }
        });
    }
    
    // Export confirmation
    $('.dt-button').click(function() {
        Swal.fire({
            title: 'Export Data',
            text: 'Your data is being exported...',
            icon: 'success',
            timer: 1500,
            showConfirmButton: false
        });
    });
    </script>
</body>

</html>