<?php
include 'layouts/session.php';
include 'layouts/main.php';
include 'layouts/dbconn.php'; // Include the database connection

// Fetch booking details
$bookingId = isset($_GET['booking_id']) ? intval($_GET['booking_id']) : 0;
$bookingCode = isset($_GET['booking_code']) ? $_GET['booking_code'] : '';

$stmt = $conn->prepare("
    SELECT
        b.*,
        c.first_name,
        c.last_name,
        f.flight_number,
        o.airport_name AS origin,
        d.airport_name AS destination,
        f.departure_time AS departure,
        f.arrival_time AS arrival,
        f.price AS base_price,
        f.price * 0.16 AS taxes_fees, -- Assuming taxes and fees are 16% of the base price
        f.price * 1.16 AS total_price_per_passenger -- Assuming total price includes base price and taxes/fees
    FROM
        bookings b
    JOIN
        customers c ON b.customer_id = c.customer_id
    JOIN
        flights f ON b.flight_id = f.flight_id
    JOIN
        airports o ON f.origin_id = o.airport_id
    JOIN
        airports d ON f.destination_id = d.airport_id
    WHERE
        b.booking_id = ?
        AND b.booking_code = ?;
");
$stmt->bind_param("is", $bookingId, $bookingCode);
$stmt->execute();
$bookingResult = $stmt->get_result();
$booking = $bookingResult->fetch_assoc();

$familyStmt = $conn->prepare("SELECT * FROM family_members WHERE booking_id = ?");
$familyStmt->bind_param("i", $bookingId);
$familyStmt->execute();
$familyResult = $familyStmt->get_result();
$familyMembers = $familyResult->fetch_all(MYSQLI_ASSOC);

$stmt->close();
$familyStmt->close();
$conn->close();

// Calculate the total fare
$totalFare = $booking['total_price_per_passenger'] * $booking['total_passengers'];
?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Add Booking Payment')); ?>
    <?php include 'layouts/head-css.php'; ?>
</head>

<body>
    <!-- Begin page -->
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Payments & Invoicing', 'title' => 'Add Booking Payment')); ?>
                    <div class="row">
                        <div class="col-xl-8">
                            <div class="card">
                                <div class="card-body checkout-tab">
                                    <form action="#">
                                        <div class="step-arrow-nav mt-n3 mx-n3 mb-3">
                                            <ul class="nav nav-pills nav-justified custom-nav" role="tablist">
                                                <li class="nav-item" role="presentation">
                                                    <button class="nav-link fs-15 p-3 active" id="pills-payment-tab" data-bs-toggle="pill" data-bs-target="#pills-payment" type="button" role="tab" aria-controls="pills-payment" aria-selected="false">
                                                        <i class="ri-bank-card-line fs-16 p-2 bg-primary-subtle text-primary rounded-circle align-middle me-2"></i> Payment Info
                                                    </button>
                                                </li>
                                                <li class="nav-item" role="presentation">
                                                    <button class="nav-link fs-15 p-3" id="pills-finish-tab" data-bs-toggle="pill" data-bs-target="#pills-finish" type="button" role="tab" aria-controls="pills-finish" aria-selected="false">
                                                        <i class="ri-checkbox-circle-line fs-16 p-2 bg-primary-subtle text-primary rounded-circle align-middle me-2"></i> Finish
                                                    </button>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="tab-content">
                                            <div class="tab-pane fade show active" id="pills-payment" role="tabpanel" aria-labelledby="pills-payment-tab">
                                                <div>
                                                    <h5 class="mb-1">Payment Selection</h5>
                                                    <p class="text-muted mb-4">Please select and enter your billing information</p>
                                                </div>
                                                <div class="row g-4">
                                                    <div class="col-lg-4 col-sm-6">
                                                        <div class="form-check card-radio">
                                                            <input id="paymentMethod02" name="paymentMethod" type="radio" class="form-check-input" checked>
                                                            <label class="form-check-label" for="paymentMethod02">
                                                                <span class="fs-16 text-muted me-2"><i class="ri-bank-card-fill align-bottom"></i></span>
                                                                <span class="fs-14 text-wrap">Credit / Debit Card</span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4 col-sm-6">
                                                        <div class="form-check card-radio">
                                                            <input id="paymentMethod03" name="paymentMethod" type="radio" class="form-check-input">
                                                            <label class="form-check-label" for="paymentMethod03">
                                                                <span class="fs-16 text-muted me-2"><i class="ri-money-dollar-box-fill align-bottom"></i></span>
                                                                <span class="fs-14 text-wrap">Cash</span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div id="creditCardContent" class="mt-4">
                                                    <div class="card p-4 border shadow-none mb-0">
                                                        <div class="row gy-3">
                                                            <div class="col-md-12">
                                                                <label for="cc-name" class="form-label">Name on card</label>
                                                                <input type="text" class="form-control" id="cc-name" placeholder="Enter name">
                                                                <small class="text-muted">Full name as displayed on card</small>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <label for="cc-number" class="form-label">Credit card number</label>
                                                                <input type="text" class="form-control" id="cc-number" placeholder="xxxx xxxx xxxx xxxx">
                                                            </div>
                                                            <div class="col-md-3">
                                                                <label for="cc-expiration" class="form-label">Expiration</label>
                                                                <input type="text" class="form-control" id="cc-expiration" placeholder="MM/YY">
                                                            </div>
                                                            <div class="col-md-3">
                                                                <label for="cc-cvv" class="form-label">CVV</label>
                                                                <input type="text" class="form-control" id="cc-cvv" placeholder="xxx">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="text-muted mt-2 fst-italic">
                                                        <i data-feather="lock" class="text-muted icon-xs"></i> Your transaction is secured with SSL encryption
                                                    </div>
                                                </div>
                                                <div id="cashContent" class="mt-4" style="display: none;">
                                                    <div class="card p-4 border shadow-none mb-0">
                                                        <div class="row gy-3">
                                                            <div class="col-md-6">
                                                                <label for="cash-amount" class="form-label">Amount</label>
                                                                <input type="number" class="form-control" id="cash-amount" placeholder="Enter amount" step="0.01" required>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <label for="cash-payment-date" class="form-label">Payment Date</label>
                                                                <input type="date" class="form-control" id="cash-payment-date" required>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <label for="cash-payment-status" class="form-label">Payment Status</label>
                                                                <select class="form-select" id="cash-payment-status" required>
                                                                    <option value="Pending">Pending</option>
                                                                    <option value="Completed">Completed</option>
                                                                    <option value="Failed">Failed</option>
                                                                </select>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <label for="cash-transaction-id" class="form-label">Transaction ID</label>
                                                                <input type="text" class="form-control" id="cash-transaction-id" placeholder="Enter transaction ID" >
                                                            </div>
                                                        </div>
                                                        <p class="mt-3 mb-0 text-muted">Please note that you will need to pay the full amount to receive your ticket(s).</p>
                                                    </div>
                                                </div>
                                                <div class="d-flex align-items-start gap-3 mt-4">
                                                    <button type="button" class="btn btn-light btn-label previestab" data-previous="pills-bill-address-tab"><i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i>Back to Shipping</button>
                                                    <button type="button" class="btn btn-primary btn-label right ms-auto nexttab" data-nexttab="pills-finish-tab"><i class="ri-shopping-basket-line label-icon align-middle fs-16 ms-2"></i>Complete Order</button>
                                                </div>
                                            </div>
                                            <div class="tab-pane fade" id="pills-finish" role="tabpanel" aria-labelledby="pills-finish-tab">
                                                <div class="text-center py-5">
                                                    <div class="mb-4">
                                                        <lord-icon src="https://cdn.lordicon.com/lupuorrc.json" trigger="loop" colors="primary:#695eef,secondary:#73dce9" style="width:120px;height:120px"></lord-icon>
                                                    </div>
                                                    <h5>Thank you ! Your Order is Completed !</h5>
                                                    <p class="text-muted">You will receive an order confirmation email with details of your order.</p>
                                                    <h3 class="fw-semibold">Order ID: <a href="apps-ecommerce-order-details.php" class="text-decoration-underline">VZ2451</a></h3>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4">
                            <div class="card">
                                <div class="card-header">
                                    <div class="d-flex">
                                        <div class="flex-grow-1">
                                            <h5 class="card-title mb-0">Booking Summary</h5>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive table-card">
                                        <table class="table table-borderless align-middle mb-0">
                                            <tbody>
                                                <tr>
                                                    <th scope="row">Booking ID:</th>
                                                    <td class="text-end"><?php echo $booking['booking_id']; ?></td>
                                                </tr>
                                                <tr>
                                                    <th scope="row">Booking Date:</th>
                                                    <td class="text-end"><?php echo date('F j, Y', strtotime($booking['booking_date'])); ?></td>
                                                </tr>
                                                <tr>
                                                    <th scope="row">Status:</th>
                                                    <td class="text-end"><?php echo $booking['status']; ?></td>
                                                </tr>
                                                <tr>
                                                    <th scope="row">Customer:</th>
                                                    <td class="text-end"><?php echo $booking['first_name'] . ' ' . $booking['last_name']; ?></td>
                                                </tr>
                                                <tr>
                                                    <th scope="row">Flight Number:</th>
                                                    <td class="text-end"><?php echo $booking['flight_number']; ?></td>
                                                </tr>
                                                <tr>
                                                    <th scope="row">Origin:</th>
                                                    <td class="text-end"><?php echo $booking['origin']; ?></td>
                                                </tr>
                                                <tr>
                                                    <th scope="row">Destination:</th>
                                                    <td class="text-end"><?php echo $booking['destination']; ?></td>
                                                </tr>
                                                <tr>
                                                    <th scope="row">Departure:</th>
                                                    <td class="text-end"><?php echo date('M j, Y g:i A', strtotime($booking['departure'])); ?></td>
                                                </tr>
                                                <tr>
                                                    <th scope="row">Arrival:</th>
                                                    <td class="text-end"><?php echo date('M j, Y g:i A', strtotime($booking['arrival'])); ?></td>
                                                </tr>
                                                <tr>
                                                    <th scope="row">Total Passengers:</th>
                                                    <td class="text-end"><?php echo $booking['total_passengers']; ?></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="mt-4">
                                        <h6 class="mb-3">Passengers:</h6>
                                        <div class="table-responsive table-card">
                                            <table class="table table-borderless align-middle mb-0">
                                                <thead class="table-light">
                                                    <tr>
                                                        <th>Name</th>
                                                        <th>Relation</th>
                                                        <th>Age</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php foreach ($familyMembers as $member) { ?>
                                                        <tr>
                                                            <td><?php echo $member['name']; ?></td>
                                                            <td><?php echo $member['relation']; ?></td>
                                                            <td><?php echo $member['age']; ?></td>
                                                        </tr>
                                                    <?php } ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="mt-4">
                                        <table class="table table-borderless align-middle mb-0">
                                            <tbody>
                                                <tr>
                                                    <th scope="row">Base Price:</th>
                                                    <td class="text-end">$<?php echo number_format($booking['base_price'], 2); ?> x <?php echo $booking['total_passengers']; ?></td>
                                                </tr>
                                                <tr>
                                                    <th scope="row">Taxes & Fees:</th>
                                                    <td class="text-end">$<?php echo number_format($booking['taxes_fees'] * $booking['total_passengers'], 2); ?></td>
                                                </tr>
                                                <tr class="table-active">
                                                    <th scope="row">Total (USD):</th>
                                                    <td class="text-end">
                                                        <span class="fw-semibold">$<?php echo number_format($totalFare, 2); ?></span>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>
    <?php include 'layouts/vendor-scripts.php'; ?>
    <!-- prismjs plugin -->
    <script src="assets/libs/prismjs/prism.js"></script>
    <script src="assets/js/app.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const creditCardContent = document.getElementById('creditCardContent');
            const cashContent = document.getElementById('cashContent');
            const paymentMethods = document.querySelectorAll('input[name="paymentMethod"]');

            paymentMethods.forEach(method => {
                method.addEventListener('change', function() {
                    if (this.id === 'paymentMethod02') {
                        creditCardContent.style.display = 'block';
                        cashContent.style.display = 'none';
                    } else if (this.id === 'paymentMethod03') {
                        creditCardContent.style.display = 'none';
                        cashContent.style.display = 'block';
                    }
                });
            });
        });
    </script>
</body>
</html>
