<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>

<?php
// Include the database connection file
include 'layouts/dbconn.php';

// Fetch airports data from the database
$query = "SELECT airport_id, airport_name FROM airports";
$result = $conn->query($query);

// Initialize an array to store airport data
$airports = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $airports[] = $row; // Store each row in the $airports array
    }
}

// Close the database connection
$conn->close();
?>


<head>

    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Add Flight Schedule')); ?>
    
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <?php include 'layouts/head-css.php'; ?>

</head>

<body>

    <!-- Begin page -->
    <div id="layout-wrapper">

        <?php include 'layouts/menu.php'; ?>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Manage Flights', 'title' => 'Add Flight Schedule')); ?>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Add Flight Schedule</h4>
                                </div><!-- end card header -->
                                <div class="card-body">
                                    <form method="POST" action="save_flight_schedule.php">
                                        <div class="live-preview">
                                            <div class="row gy-4">
                                                <!-- Flight Number -->
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="flightNumber" class="form-label">Flight Number</label>
                                                        <div class="form-icon">
                                                            <input type="text" class="form-control form-control-icon" name="flightNumber" id="flightNumber" placeholder="Enter Flight Number">
                                                            <i class="ri-flight-takeoff-line"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Origin ID Dropdown -->
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="originAirport" class="form-label">Origin Airport</label>
                                                        <div class="form-icon">
                                                            <select class="form-control form-select" name="originId" id="originAirport">
                                                                <option value="">Select Origin Airport</option>
                                                                <?php foreach ($airports as $airport): ?>
                                                                    <option value="<?php echo $airport['airport_id']; ?>">
                                                                        <?php echo $airport['airport_name']; ?>
                                                                    </option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Destination ID Dropdown -->
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="destinationAirport" class="form-label">Destination Airport</label>
                                                        <div class="form-icon">
                                                            <select class="form-control form-select" name="destinationId" id="destinationAirport">
                                                                <option value="">Select Destination Airport</option>
                                                                <?php foreach ($airports as $airport): ?>
                                                                    <option value="<?php echo $airport['airport_id']; ?>">
                                                                        <?php echo $airport['airport_name']; ?>
                                                                    </option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Days of Operation Checkboxes -->
                                                <div class="col-xxl-4 col-md-12">
                                                    <div>
                                                        <label class="form-label">Days of Operation</label>
                                                        <div class="d-flex flex-wrap gap-3">
                                                            <?php
                                                            $days_of_week = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'];
                                                            foreach ($days_of_week as $day) {
                                                                echo '
                                                                <div class="form-check form-check-inline">
                                                                    <input class="form-check-input" type="checkbox" name="daysOfWeek[]" id="day_'.$day.'" value="'.$day.'">
                                                                    <label class="form-check-label" for="day_'.$day.'">'.$day.'</label>
                                                                </div>';
                                                            }
                                                            ?>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Departure Time -->
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="departureTime" class="form-label">Departure Time</label>
                                                        <div class="form-icon">
                                                            <input type="time" class="form-control form-control-icon" name="departureTime" id="departureTime">
                                                            <i class="ri-time-line"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Arrival Time -->
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="arrivalTime" class="form-label">Arrival Time</label>
                                                        <div class="form-icon">
                                                            <input type="time" class="form-control form-control-icon" name="arrivalTime" id="arrivalTime">
                                                            <i class="ri-time-line"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Start Date -->
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="startDate" class="form-label">Start Date</label>
                                                        <div class="form-icon">
                                                            <input type="date" class="form-control form-control-icon" name="startDate" id="startDate">
                                                            <i class="ri-calendar-line"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- End Date -->
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="endDate" class="form-label">End Date</label>
                                                        <div class="form-icon">
                                                            <input type="date" class="form-control form-control-icon" name="endDate" id="endDate">
                                                            <i class="ri-calendar-line"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        
                                                    </div>
                                                </div>
                                                <!-- Save Button -->
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <button type="submit" class="btn btn-success btn-label waves-effect waves-light rounded-pill">
                                                            <i class="ri-check-double-line label-icon align-middle rounded-pill fs-16 me-2"></i> Save
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- End row -->
                                        </div>
                                    </form>


                                    
                                </div>
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->


                </div> <!-- container-fluid -->
            </div><!-- End Page-content -->

            <?php include 'layouts/footer.php'; ?>
        </div>
        <!-- end main content-->

    </div>
    <!-- END layout-wrapper -->

    <?php include 'layouts/vendor-scripts.php'; ?>

    <!-- prismjs plugin -->
    <script src="assets/libs/prismjs/prism.js"></script>

    <script src="assets/js/app.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <!--select2 cdn-->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="assets/js/pages/select2.init.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
        // Initialize Select2 on both dropdowns
        $('#originAirport').select2();
        $('#destinationAirport').select2();
    
        // Get both dropdowns
        const originSelect = document.getElementById('originAirport');
        const destinationSelect = document.getElementById('destinationAirport');
    
        // Ensure both dropdown elements are present
        if (!originSelect || !destinationSelect) return;
    
        // Helper function to disable the selected option in the opposite dropdown
        function disableSelectedOption(selectElement, valueToDisable) {
            Array.from(selectElement.options).forEach(option => {
                option.disabled = option.value === valueToDisable;
            });
    
            // Refresh Select2 to reflect changes
            $('#' + selectElement.id).select2();
        }
    
        // Function to check for duplicate selections and reset if necessary
        function checkForDuplicates() {
            const selectedOrigin = originSelect.value;
            const selectedDestination = destinationSelect.value;
    
            if (selectedOrigin === selectedDestination && selectedOrigin !== "") {
                alert("Origin and Destination cannot be the same. Please select a different option.");
                destinationSelect.value = "";
                $('#destinationAirport').val("").trigger('change');
            }
        }
    
        // Event listener for Origin dropdown changes
        $('#originAirport').on('change', function () {
            const selectedOrigin = originSelect.value;
    
            // Reset all options in the Destination dropdown
            Array.from(destinationSelect.options).forEach(option => option.disabled = false);
    
            // Disable the selected origin airport in the destination dropdown
            if (selectedOrigin) {
                disableSelectedOption(destinationSelect, selectedOrigin);
            }
    
            // Check for duplicates after processing
            checkForDuplicates();
        });
    
        // Event listener for Destination dropdown changes
        $('#destinationAirport').on('change', function () {
            const selectedDestination = destinationSelect.value;
    
            // Reset all options in the Origin dropdown
            Array.from(originSelect.options).forEach(option => option.disabled = false);
    
            // Disable the selected destination airport in the origin dropdown
            if (selectedDestination) {
                disableSelectedOption(originSelect, selectedDestination);
            }
    
            // Check for duplicates after processing
            checkForDuplicates();
        });
    });
    
    </script>


</body>

</html>