<?php
include 'layouts/session.php';
include 'layouts/main.php';
include 'layouts/dbconn.php';

$applicationId = isset($_GET['id']) ? intval($_GET['id']) : 0;

$stmt = $conn->prepare("
    SELECT v.*, u.full_name as agent_name
    FROM visa_applications v
    LEFT JOIN users u ON v.assigned_agent_id = u.user_id
    WHERE v.application_id = ?
");

$stmt->bind_param("i", $applicationId);
$stmt->execute();
$result = $stmt->get_result();
$visa = $result->fetch_assoc();

if (!$visa) {
    header('Location: all_visas.php');
    exit();
}
?>

<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg">
<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'View Visa Application')); ?>
    <?php include 'layouts/head-css.php'; ?>
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h4 class="card-title mb-0">Visa Application Details</h4>
                                    <div>
                                        <?php if ($visa['status'] === 'Submitted' || $visa['status'] === 'Under Review'): ?>
                                        <a href="edit_visa.php?id=<?php echo $applicationId; ?>" class="btn btn-primary btn-sm">
                                            Edit Application
                                        </a>
                                        <?php endif; ?>
                                        <a href="all_visas.php" class="btn btn-secondary btn-sm">Back</a>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <h5>Personal Information</h5>
                                            <table class="table table-bordered">
                                                <tr>
                                                    <th width="200">Name</th>
                                                    <td><?php echo htmlspecialchars($visa['first_name'] . ' ' . $visa['last_name']); ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Passport Number</th>
                                                    <td><?php echo htmlspecialchars($visa['passport_number']); ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Nationality</th>
                                                    <td><?php echo htmlspecialchars($visa['nationality']); ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Date of Birth</th>
                                                    <td><?php echo date('d M Y', strtotime($visa['date_of_birth'])); ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Gender</th>
                                                    <td><?php echo htmlspecialchars($visa['gender']); ?></td>
                                                </tr>
                                            </table>
                                        </div>
                                        <div class="col-md-6">
                                            <h5>Contact Information</h5>
                                            <table class="table table-bordered">
                                                <tr>
                                                    <th width="200">Email</th>
                                                    <td><?php echo htmlspecialchars($visa['email']); ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Phone Number</th>
                                                    <td><?php echo htmlspecialchars($visa['phone_number']); ?></td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>

                                    <div class="row mt-4">
                                        <div class="col-md-6">
                                            <h5>Visa Details</h5>
                                            <table class="table table-bordered">
                                                <tr>
                                                    <th width="200">Destination</th>
                                                    <td><?php echo htmlspecialchars($visa['destination_country']); ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Application Type</th>
                                                    <td><?php echo htmlspecialchars($visa['application_type']); ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Entry Type</th>
                                                    <td><?php echo htmlspecialchars($visa['entry_type']); ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Duration (Days)</th>
                                                    <td><?php echo htmlspecialchars($visa['visa_duration']); ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Travel Dates</th>
                                                    <td>
                                                        <?php echo date('d M Y', strtotime($visa['intended_arrival_date'])); ?> - 
                                                        <?php echo date('d M Y', strtotime($visa['intended_departure_date'])); ?>
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                        <div class="col-md-6">
                                            <h5>Financial Information</h5>
                                            <table class="table table-bordered">
                                                <tr>
                                                    <th width="200">Monthly Income</th>
                                                    <td>$<?php echo number_format($visa['monthly_income'], 2); ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Trip Cost</th>
                                                    <td>$<?php echo number_format($visa['total_trip_cost'], 2); ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Processing Fee</th>
                                                    <td>$<?php echo number_format($visa['processing_fee'], 2); ?></td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>

                                    <div class="row mt-4">
                                        <div class="col-md-6">
                                            <h5>Documents</h5>
                                            <table class="table table-bordered">
                                                <?php if ($visa['passport_copy_path']): ?>
                                                <tr>
                                                    <th>Passport Copy</th>
                                                    <td><a href="<?php echo htmlspecialchars($visa['passport_copy_path']); ?>" target="_blank">View</a></td>
                                                </tr>
                                                <?php endif; ?>
                                                <?php if ($visa['photo_path']): ?>
                                                <tr>
                                                    <th>Photo</th>
                                                    <td><a href="<?php echo htmlspecialchars($visa['photo_path']); ?>" target="_blank">View</a></td>
                                                </tr>
                                                <?php endif; ?>
                                                <?php if ($visa['travel_insurance_proof_path']): ?>
                                                <tr>
                                                    <th>Insurance Proof</th>
                                                    <td><a href="<?php echo htmlspecialchars($visa['travel_insurance_proof_path']); ?>" target="_blank">View</a></td>
                                                </tr>
                                                <?php endif; ?>
                                            </table>
                                        </div>
                                        <div class="col-md-6">
                                            <h5>Application Status</h5>
                                            <table class="table table-bordered">
                                                <tr>
                                                    <th width="200">Status</th>
                                                    <td>
                                                        <span class="badge bg-<?php 
                                                            echo $visa['status'] === 'Approved' ? 'success' : 
                                                                ($visa['status'] === 'Rejected' ? 'danger' : 
                                                                ($visa['status'] === 'Under Review' ? 'warning' : 'info')); 
                                                        ?>">
                                                            <?php echo htmlspecialchars($visa['status']); ?>
                                                        </span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Assigned Agent</th>
                                                    <td><?php echo $visa['agent_name'] ? htmlspecialchars($visa['agent_name']) : 'Not Assigned'; ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Submission Date</th>
                                                    <td><?php echo date('d M Y H:i', strtotime($visa['submission_date'])); ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Last Updated</th>
                                                    <td><?php echo date('d M Y H:i', strtotime($visa['last_updated_date'])); ?></td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include 'layouts/vendor-scripts.php'; ?>
</body>
</html>