<?php
include 'layouts/session.php';
include 'layouts/main.php';
include 'layouts/dbconn.php';

$ticketId = isset($_GET['id']) ? intval($_GET['id']) : 0;

$stmt = $conn->prepare("
    SELECT t.*, b.booking_code 
    FROM ticket_details t
    LEFT JOIN bookings b ON t.booking_id = b.booking_id
    WHERE t.ticket_id = ?
");

$stmt->bind_param("i", $ticketId);
$stmt->execute();
$result = $stmt->get_result();
$ticket = $result->fetch_assoc();

if (!$ticket) {
    header('Location: all_new_tickets.php');
    exit();
}
?>

<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable">

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'View Ticket')); ?>
    <?php include 'layouts/head-css.php'; ?>
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Ticket Management', 'title' => 'View Ticket')); ?>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h5 class="card-title mb-0">Ticket Details</h5>
                                    <div>
                                        <a href="edit_ticket.php?id=<?php echo $ticketId; ?>" 
                                           class="btn btn-success btn-label waves-effect waves-light rounded-pill"><i class="ri-edit-line label-icon align-middle rounded-pill fs-16 me-2"></i> Edit</a>
                                        <a href="all_new_tickets.php" class="btn btn-danger btn-label waves-effect waves-light rounded-pill">
                                            <i class="ri-arrow-left-line label-icon align-middle rounded-pill fs-16 me-2"></i> Back</a>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <table class="table table-bordered">
                                                <tr>
                                                    <th width="200">Ticket Reference</th>
                                                    <td><?php echo htmlspecialchars($ticket['ticket_ref']); ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Customer Name</th>
                                                    <td><?php echo htmlspecialchars($ticket['salutation'] . ' ' . $ticket['customer_name']); ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Booking Class</th>
                                                    <td><?php echo htmlspecialchars($ticket['booking_class']); ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Flight Route</th>
                                                    <td><?php echo htmlspecialchars($ticket['flight_route']); ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Flight Date</th>
                                                    <td><?php echo date('d M Y H:i', strtotime($ticket['flight_date'])); ?></td>
                                                </tr>
                                            </table>
                                        </div>
                                        <div class="col-md-6">
                                            <table class="table table-bordered">
                                                <tr>
                                                    <th width="200">Ticket Cost</th>
                                                    <td>$<?php echo number_format($ticket['ticket_cost'], 2); ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Agency Fee</th>
                                                    <td>$<?php echo number_format($ticket['agency_fee'], 2); ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Total Amount</th>
                                                    <td>$<?php echo number_format($ticket['total_amount'], 2); ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Related Booking</th>
                                                    <td><?php echo $ticket['booking_code'] ? htmlspecialchars($ticket['booking_code']) : 'N/A'; ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Status</th>
                                                    <td>
                                                        <span class="badge 
                                                            <?php echo $ticket['status'] === 'Active' ? 'bg-success' : 
                                                                ($ticket['status'] === 'Used' ? 'bg-info' : 'bg-danger'); ?>">
                                                            <?php echo htmlspecialchars($ticket['status']); ?>
                                                        </span>
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>

                                    <div class="row mt-4">
                                        <div class="col-12">
                                            <h5>Ticket Timeline</h5>
                                            <table class="table table-bordered">
                                                <tr>
                                                    <th width="200">Created Date</th>
                                                    <td><?php echo date('d M Y H:i', strtotime($ticket['created_date'])); ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Last Updated</th>
                                                    <td><?php echo date('d M Y H:i', strtotime($ticket['updated_date'])); ?></td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
</body>
</html>