<?php 
include 'layouts/session.php';
include 'layouts/dbconn.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Track Your Cargo</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .tracking-status {
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .status-steps {
            position: relative;
            padding-left: 30px;
        }
        .status-step {
            padding: 15px 0;
            position: relative;
        }
        .status-step::before {
            content: '';
            position: absolute;
            left: -25px;
            top: 0;
            height: 100%;
            width: 2px;
            background: #dee2e6;
        }
        .status-step::after {
            content: '';
            position: absolute;
            left: -29px;
            top: 20px;
            height: 10px;
            width: 10px;
            border-radius: 50%;
            background: #dee2e6;
        }
        .status-step.active::after {
            background: #28a745;
        }
        .status-step.active::before {
            background: #28a745;
        }
    </style>
</head>
<body>
    <div class="container my-5">
        <?php
        if (isset($_GET['booking'])) {
            $booking_number = $_GET['booking'];
            
            // Fetch booking details
            $query = "
                SELECT 
                    cb.*,
                    CONCAT(sc.first_name, ' ', sc.last_name) AS sender_name,
                    CONCAT(rc.first_name, ' ', rc.last_name) AS receiver_name
                FROM cargo_bookings cb
                LEFT JOIN customers sc ON cb.sender_customer_id = sc.customer_id
                LEFT JOIN customers rc ON cb.receiver_customer_id = rc.customer_id
                WHERE cb.booking_number = ?
            ";
            
            $stmt = $conn->prepare($query);
            $stmt->bind_param("s", $booking_number);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result->num_rows > 0) {
                $booking = $result->fetch_assoc();
                ?>
                <div class="card">
                    <div class="card-header">
                        <h4>Tracking Information - <?php echo htmlspecialchars($booking_number); ?></h4>
                    </div>
                    <div class="card-body">
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <h5>Sender</h5>
                                <p><?php echo htmlspecialchars($booking['sender_name']); ?></p>
                            </div>
                            <div class="col-md-6">
                                <h5>Receiver</h5>
                                <p><?php echo htmlspecialchars($booking['receiver_name']); ?></p>
                            </div>
                        </div>

                        <div class="tracking-status bg-light">
                            <h5>Shipment Status</h5>
                            <div class="status-steps">
                                <?php
                                $status_steps = [
                                    'Booked' => true, // Always true as booking exists
                                    'Payment' => $booking['payment_status'] == 'Paid',
                                    'Processing' => $booking['status'] == 'Processing',
                                    'In Transit' => $booking['status'] == 'In Transit',
                                    'Delivered' => $booking['status'] == 'Delivered'
                                ];

                                foreach ($status_steps as $step => $is_active) {
                                    echo '<div class="status-step ' . ($is_active ? 'active' : '') . '">';
                                    echo '<h6>' . $step . '</h6>';
                                    echo '<small class="text-muted">' . date('M d, Y') . '</small>';
                                    echo '</div>';
                                }
                                ?>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <h5>Shipment Details</h5>
                                <p>Cargo Type: <?php echo htmlspecialchars($booking['cargo_type']); ?></p>
                                <p>Weight: <?php echo htmlspecialchars($booking['weight']); ?> kg</p>
                                <p>Expected Delivery: <?php echo date('M d, Y', strtotime($booking['estimated_delivery_date'])); ?></p>
                            </div>
                            <div class="col-md-6">
                                <h5>Payment Information</h5>
                                <p>Status: <?php echo htmlspecialchars($booking['payment_status']); ?></p>
                                <p>Amount: <?php echo htmlspecialchars($booking['currency'] . ' ' . $booking['total_amount']); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
            } else {
                echo '<div class="alert alert-danger">Booking not found</div>';
            }
            $stmt->close();
        } else {
            echo '<div class="alert alert-danger">No booking number provided</div>';
        }
        ?>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>