<?php
include 'layouts/session.php';
include 'layouts/dbconn.php';

header('Content-Type: application/json');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $conn->begin_transaction();
    try {
        // Validate ID
        if (!isset($_POST['id']) || empty($_POST['id'])) {
            throw new Exception("Invalid visa application ID");
        }

        $id = intval($_POST['id']);

        // Check if visa exists and is in cancellable state
        $checkStmt = $conn->prepare("SELECT status FROM visa_applications WHERE application_id = ?");
        $checkStmt->bind_param("i", $id);
        $checkStmt->execute();
        $result = $checkStmt->get_result();

        if ($result->num_rows === 0) {
            throw new Exception("Visa application not found");
        }

        $visa = $result->fetch_assoc();
        if ($visa['status'] !== 'Pending') {
            throw new Exception("Only pending applications can be cancelled");
        }

        // Update visa status
        $updateStmt = $conn->prepare("UPDATE visa_applications 
                                    SET status = 'Cancelled', 
                                        updated_by = ?,
                                        updated_at = CURRENT_TIMESTAMP 
                                    WHERE application_id = ?");
        
        $userId = $_SESSION['user_id'];
        $updateStmt->bind_param("ii", $userId, $id);
        
        if (!$updateStmt->execute()) {
            throw new Exception("Failed to cancel visa application");
        }

        // Add audit log
        $logStmt = $conn->prepare("INSERT INTO audit_logs (user_id, action, log_details, ip_address, user_agent) 
                                  VALUES (?, 'CANCEL_VISA', ?, ?, ?)");
        $logDetails = "Cancelled visa application ID: " . $id;
        $logStmt->bind_param(
            "isss", 
            $userId,
            $logDetails,
            $_SERVER['REMOTE_ADDR'],
            $_SERVER['HTTP_USER_AGENT']
        );
        $logStmt->execute();

        $conn->commit();

        echo json_encode([
            'status' => 'success',
            'message' => 'Visa application cancelled successfully'
        ]);

    } catch (Exception $e) {
        $conn->rollback();
        echo json_encode([
            'status' => 'error',
            'message' => $e->getMessage()
        ]);
    }
}

$conn->close();
?>