<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>
<?php
// Include the database connection file
include 'layouts/dbconn.php';

// Fetch all flight schedules from the database
$sqlFlightSchedules = "SELECT fs.schedule_id, fs.flight_number, fs.departure_time, fs.arrival_time, 
                               fs.start_date, fs.end_date, fs.days_of_week,
                               o.city AS origin_city, d.city AS destination_city
                        FROM flight_schedules fs
                        JOIN airports o ON fs.origin_id = o.airport_id
                        JOIN airports d ON fs.destination_id = d.airport_id
                        WHERE fs.end_date >= CURDATE()
                        ORDER BY fs.start_date, fs.departure_time";
$result = $conn->query($sqlFlightSchedules);

// Initialize an array to store flight schedules
$flightSchedules = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $flightSchedules[] = $row;
    }
}

// Encode the flight schedules as JSON for use in JavaScript
$flightSchedulesJson = json_encode($flightSchedules);

// Close the database connection
$conn->close();
?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Flight Schedule Calendar')); ?>
    <?php include 'layouts/head-css.php'; ?>
    <!-- fullcalendar css -->
    <!--<link href="assets/libs/fullcalendar/main.min.css" rel="stylesheet" type="text/css" />-->
    <style>
        .modal-body * {
    display: block !important;
    visibility: visible !important;
    opacity: 1 !important;
}

    </style>
</head>

<body>
    <!-- Begin page -->
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Apps', 'title' => 'Flight Schedule Calendar')); ?>
                    <div class="row">
                        <div class="col-12">
                            <div class="row">
                                <div class="col-xl-3">
                                    <div class="card card-h-100">
                                        <div class="card-body">
                                            <button class="btn btn-primary w-100" id="btn-new-event"><i class="mdi mdi-plus"></i> Create New Flight</button>
                                            <div id="external-events"></div>
                                        </div>
                                    </div>
                                    <div>
                                        <h5 class="mb-1">Upcoming Flights</h5>
                                        <p class="text-muted">Don't miss scheduled flights</p>
                                        <div class="pe-2 me-n1 mb-3" data-simplebar style="height: 400px">
                                            <div id="upcoming-event-list"></div>
                                        </div>
                                    </div>
                                </div> <!-- end col-->

                                <div class="col-xl-9">
                                    <div class="card card-h-100">
                                        <div class="card-body">
                                            <div id="calendar"></div>
                                        </div>
                                    </div>
                                </div><!-- end col -->
                            </div>
                            <!--end row-->

                            <div style='clear:both'></div>

                            <!-- Add New Event MODAL -->
                            <div class="modal fade" id="event-modal" tabindex="-1" aria-labelledby="modal-title" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered">
                                    <div class="modal-content border-0">
                                        <div class="modal-header p-3 bg-info-subtle">
                                            <h5 class="modal-title" id="modal-title">Flight Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-hidden="true"></button>
                                        </div>
                                        <div class="modal-body p-4">
                                            <form class="needs-validation" name="event-form" id="form-event" novalidate>

                                                <div class="event-details">
                                                    <div class="mb-2">
                                                        <label for="event-flight-number" class="form-label">Flight Number:</label>
                                                        <div id="event-flight-number" class="fw-bold"></div>
                                                    </div>
                                                    <div class="mb-2">
                                                        <label for="event-origin" class="form-label">Origin:</label>
                                                        <div id="event-origin" class="fw-bold"></div>
                                                    </div>
                                                    <div class="mb-2">
                                                        <label for="event-destination" class="form-label">Destination:</label>
                                                        <div id="event-destination" class="fw-bold"></div>
                                                    </div>
                                                    <div class="mb-2">
                                                        <label for="event-departure-time" class="form-label">Departure Time:</label>
                                                        <div id="event-departure-time" class="fw-bold"></div>
                                                    </div>
                                                    <div class="mb-2">
                                                        <label for="event-arrival-time" class="form-label">Arrival Time:</label>
                                                        <div id="event-arrival-time" class="fw-bold"></div>
                                                    </div>
                                                    <div class="mb-2">
                                                        <label for="event-days-of-week" class="form-label">Days of Week:</label>
                                                        <div id="event-days-of-week" class="fw-bold"></div>
                                                    </div>
                                                </div>
                                                
                                            </form>
                                            <div class="row mt-4">
                                                <div class="col-12">
                                                    <div class="hstack gap-2 justify-content-end">
                                                        <!-- Rounded Buttons -->
                                                        <button type="button" class="btn rounded-pill btn-primary waves-effect waves-light" data-bs-dismiss="modal">Close</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            
 <!-- end modal-->
                        </div>
                    </div> <!-- end row-->
                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->
            <?php include 'layouts/footer.php'; ?>
        </div>
        <!-- end main content-->
    </div>
    <!-- END layout-wrapper -->

    <?php include 'layouts/vendor-scripts.php'; ?>

    <!-- calendar min js -->
    <script src="assets/libs/fullcalendar/index.global.min.js"></script>

    <!-- App js -->
    <script src="assets/js/app.js"></script>

    <script>
document.addEventListener('DOMContentLoaded', function() {
    var calendarEl = document.getElementById('calendar');
    var flightSchedules = <?php echo $flightSchedulesJson; ?>;

    console.log('Flight Schedules:', flightSchedules);

    var events = [];
    flightSchedules.forEach(function(schedule) {
        var daysOfWeek = schedule.days_of_week.split(',').map(function(day) {
            return ['sun', 'mon', 'tue', 'wed', 'thu', 'fri', 'sat'].indexOf(day.toLowerCase());
        });

        events.push({
            title: schedule.flight_number + ': ' + schedule.origin_city + ' to ' + schedule.destination_city,
            start: schedule.start_date + 'T' + schedule.departure_time,
            end: schedule.start_date + 'T' + schedule.arrival_time,
            startRecur: schedule.start_date,
            endRecur: schedule.end_date,
            daysOfWeek: daysOfWeek,
            extendedProps: {
                scheduleId: schedule.schedule_id,
                flightNumber: schedule.flight_number,
                originCity: schedule.origin_city,
                destinationCity: schedule.destination_city,
                departureTime: schedule.departure_time,
                arrivalTime: schedule.arrival_time,
                daysOfWeek: schedule.days_of_week
            }
        });
    });

    console.log('Processed Events:', events);

    var calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth',
        headerToolbar: {
            left: 'prev,next today',
            center: 'title',
            right: 'dayGridMonth,timeGridWeek,timeGridDay'
        },
        events: events,
        editable: true,
        droppable: true,
        selectable: true,
        dateClick: function(info) {
            console.log('Date clicked:', info.dateStr);
            var eventsForDay = events.filter(function(event) {
                var eventDate = new Date(event.start);
                return eventDate.toISOString().split('T')[0] === info.dateStr;
            });
            if (eventsForDay.length > 0) {
                showEventDetails(eventsForDay[0]);
            } else {
                console.log('No events for this date');
            }
        },
        eventClick: function(info) {
            console.log('Event clicked:', info.event);
            showEventDetails(info.event);
        }
    });

function showEventDetails(event) {
    console.log('Showing event details:', event);
    var extendedProps = event.extendedProps;

    // Debug: Log each property being set
    console.log('Flight Number:', extendedProps.flightNumber);
    console.log('Origin City:', extendedProps.originCity);
    console.log('Destination City:', extendedProps.destinationCity);
    console.log('Departure Time:', extendedProps.departureTime);
    console.log('Arrival Time:', extendedProps.arrivalTime);
    console.log('Days of Week:', extendedProps.daysOfWeek);

    // Populate modal with event details
    document.getElementById('event-flight-number').textContent = extendedProps.flightNumber || 'N/A';
    document.getElementById('event-origin').textContent = extendedProps.originCity || 'N/A';
    document.getElementById('event-destination').textContent = extendedProps.destinationCity || 'N/A';
    document.getElementById('event-departure-time').textContent = extendedProps.departureTime || 'N/A';
    document.getElementById('event-arrival-time').textContent = extendedProps.arrivalTime || 'N/A';
    document.getElementById('event-days-of-week').textContent = extendedProps.daysOfWeek || 'N/A';

    // Debug: Log the content of each element after setting
    console.log('Flight Number Element:', document.getElementById('event-flight-number').textContent);
    console.log('Origin Element:', document.getElementById('event-origin').textContent);
    console.log('Destination Element:', document.getElementById('event-destination').textContent);
    console.log('Departure Time Element:', document.getElementById('event-departure-time').textContent);
    console.log('Arrival Time Element:', document.getElementById('event-arrival-time').textContent);
    console.log('Days of Week Element:', document.getElementById('event-days-of-week').textContent);

    // Show the modal
    var eventModal = new bootstrap.Modal(document.getElementById('event-modal'));
    console.log('Modal object:', eventModal); // Debug: Log the modal object
    eventModal.show();
    console.log('Modal shown'); // Debug: Log after showing the modal
}


    calendar.render();

    // Populate upcoming flights list
    var upcomingEventList = document.getElementById('upcoming-event-list');
    events.slice(0, 5).forEach(function(event) {
        var eventEl = document.createElement('div');
        eventEl.className = 'card mb-3';
        eventEl.innerHTML = `
            <div class="card-body">
                <h5 class="card-title">${event.extendedProps.flightNumber}</h5>
                <p class="card-text">${event.extendedProps.originCity} to ${event.extendedProps.destinationCity}</p>
                <p class="card-text"><small class="text-muted">${event.extendedProps.departureTime} - ${event.extendedProps.arrivalTime}</small></p>
            </div>
        `;
        upcomingEventList.appendChild(eventEl);
    });

    // Add click event listener for "Create New Flight" button
    document.getElementById('btn-new-event').addEventListener('click', function() {
        window.location.href = 'add_flight_schedule.php';
    });
});

    </script>
    
</body>
</html>