<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>
<?php include 'layouts/dbconn.php'; ?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Add Role')); ?>
    <?php include 'layouts/head-css.php'; ?>
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Role Management', 'title' => 'Add Role')); ?>
                    
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Add New Role</h4>
                                </div>
                                <div class="card-body">
                                    <form id="addRoleForm" method="POST" action="save_role.php">
                                        <div class="row gy-4">
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="role_name" class="form-label">Role Name</label>
                                                    <input type="text" class="form-control" id="role_name" name="role_name" required>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <button type="submit" class="btn btn-success">Create Role</button>
                                                <a href="all_roles.php" class="btn btn-light">Cancel</a>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    
    <script>
    document.getElementById('addRoleForm').addEventListener('submit', function(e) {
        const roleName = document.getElementById('role_name').value.trim();
        
        if (roleName === '') {
            e.preventDefault();
            alert('Role name is required');
            return false;
        }
    });
    </script>
</body>
</html>