<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>
<?php include 'layouts/dbconn.php'; ?>

<head>

    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Add Expense')); ?>
    
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <?php include 'layouts/head-css.php'; ?>
     <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>

<body>

    <!-- Begin page -->
    <div id="layout-wrapper">

        <?php include 'layouts/menu.php'; ?>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Expenses Management', 'title' => 'Add Expense')); ?>
            
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Add New Expense</h4>
                                </div>
                                <div class="card-body">
                                    <form id="addExpenseForm" method="POST" action="save_expense.php">
                                        <div class="row gy-4">
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="expense_type" class="form-label">Expense Type</label>
                                                    <select class="form-select" id="expense_type" name="expense_type" required>
                                                        <option value="">Select Type</option>
                                                        <option value="fuel">Fuel</option>
                                                        <option value="maintenance">Maintenance</option>
                                                        <option value="repairs">Repairs</option>
                                                        <option value="insurance">Insurance</option>
                                                        <option value="licenses">Licenses</option>
                                                        <option value="salaries">Salaries</option>
                                                        <option value="rent">Rent</option>
                                                        <option value="utilities">Utilities</option>
                                                        <option value="office_supplies">Office Supplies</option>
                                                        <option value="travel">Travel</option>
                                                        <option value="marketing">Marketing</option>
                                                        <option value="other">Other</option>
                                                    </select>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="amount" class="form-label">Amount</label>
                                                    <input type="number" step="0.01" class="form-control" id="amount" name="amount" required>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="currency" class="form-label">Currency</label>
                                                    <select class="form-select" id="currency" name="currency" required>
                                                        <option value="KES">KES</option>
                                                        <option value="USD">USD</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="expense_date" class="form-label">Expense Date</label>
                                                    <input type="date" class="form-control" id="expense_date" name="expense_date" required>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="payment_method" class="form-label">Payment Method</label>
                                                    <select class="form-select" id="payment_method" name="payment_method" required>
                                                        <option value="cash">Cash</option>
                                                        <option value="bank_transfer">Bank Transfer</option>
                                                        <option value="mobile_money">Mobile Money</option>
                                                        <option value="credit_card">Credit Card</option>
                                                        <option value="check">Check</option>
                                                    </select>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="reference_number" class="form-label">Reference Number</label>
                                                    <input type="text" class="form-control" id="reference_number" name="reference_number">
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="mb-3">
                                                    <label for="description" class="form-label">Description</label>
                                                    <textarea class="form-control" id="description" name="description" rows="3"></textarea>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <button type="submit" class="btn btn-success">Save Expense</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            

            
            <?php include 'layouts/footer.php'; ?>
        </div>
        <!-- end main content-->

    </div>
    <!-- END layout-wrapper -->

    <?php include 'layouts/vendor-scripts.php'; ?>

    <!-- prismjs plugin -->
    <script src="assets/libs/prismjs/prism.js"></script>

    <script src="assets/js/app.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <!--select2 cdn-->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="assets/js/pages/select2.init.js"></script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
    const currencySelect = document.getElementById('currency');
    const currencySymbol = document.querySelector('.currency-symbol');

    currencySelect.addEventListener('change', function() {
        currencySymbol.textContent = this.value;
    });

    // Optional: Add input formatting for the amount
    const totalAmountInput = document.getElementById('totalAmount');
    totalAmountInput.addEventListener('input', function() {
        // Ensure only two decimal places
        if (this.value.includes('.')) {
            const parts = this.value.split('.');
            if (parts[1].length > 2) {
                this.value = parseFloat(this.value).toFixed(2);
            }
        }
    });
});
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const formConfig = {
        sender: {
            formId: 'newSenderForm',
            modalId: 'senderModal',
            selectId: 'senderCustomer',
            endpoint: 'save_customer_mod.php',
            type: 'sender'
        },
        receiver: {
            formId: 'newReceiverForm',
            modalId: 'receiverModal',
            selectId: 'receiverCustomer',
            endpoint: 'save_customer_mod.php',
            type: 'receiver'
        }
    };

    function updateCustomerSelect(selectId, newCustomer) {
        const select = document.getElementById(selectId);
        if (select) {
            const newOption = new Option(
                `${newCustomer.first_name} ${newCustomer.last_name}`,
                newCustomer.customer_id,
                true,
                true
            );
            $(`#${selectId}`).append(newOption).trigger('change');
        }
    }

    function handleFormSubmission(config) {
        const form = document.getElementById(config.formId);
        if (!form) {
            console.error(`Form with ID ${config.formId} not found`);
            return;
        }

        form.addEventListener('submit', async function(e) {
            e.preventDefault();
            console.log('Form submitted');
            
            const submitBtn = form.querySelector('button[type="submit"]');
            const originalBtnContent = submitBtn.innerHTML;
            const modal = document.getElementById(config.modalId);

            try {
                submitBtn.disabled = true;
                submitBtn.innerHTML = `
                    <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                    Saving...
                `;

                const formData = new FormData(form);
                formData.append('customer_type', config.type);
                formData.append('address_type', 'home');
                formData.append('is_default', '1');

                // Log the form data
                console.log('Sending data to:', config.endpoint);
                for (let pair of formData.entries()) {
                    console.log(pair[0] + ': ' + pair[1]);
                }

                const response = await fetch(config.endpoint, {
                    method: 'POST',
                    body: formData
                });

                console.log('Response status:', response.status);
                const data = await response.json();
                console.log('Response data:', data);

                if (data.success) {
                    updateCustomerSelect(config.selectId, data);
                    form.reset();
                    
                    // Close modal using Bootstrap modal instance
                    const modalInstance = bootstrap.Modal.getInstance(modal);
                    if (modalInstance) {
                        modalInstance.hide();
                    } else {
                        // Fallback if modal instance not found
                        $(modal).modal('hide');
                    }

                    // Show success message
                    Swal.fire({
                        title: 'Success!',
                        text: `${config.type === 'sender' ? 'Sender' : 'Receiver'} added successfully`,
                        icon: 'success',
                        confirmButtonClass: 'btn btn-primary w-xs mt-2',
                        buttonsStyling: false
                    });
                } else {
                    throw new Error(data.message || 'Failed to save customer');
                }
            } catch (error) {
                console.error('Error details:', error);
                Swal.fire({
                    title: 'Error!',
                    text: error.message || 'An error occurred while saving the customer.',
                    icon: 'error',
                    confirmButtonClass: 'btn btn-primary w-xs mt-2',
                    buttonsStyling: false
                });
            } finally {
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalBtnContent;
            }
        });
    }

    // Initialize forms
    Object.values(formConfig).forEach(config => {
        handleFormSubmission(config);
    });

    // Reset forms when modals are closed
    document.querySelectorAll('.modal').forEach(modal => {
        modal.addEventListener('hidden.bs.modal', function() {
            const form = this.querySelector('form');
            if (form) {
                form.reset();
                form.querySelectorAll('.is-invalid').forEach(field => {
                    field.classList.remove('is-invalid');
                });
            }
        });
    });
});
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    function fetchAddresses(customerId, addressDropdownId) {
        if (customerId) {
            $.ajax({
                url: 'fetch_addresses.php',
                type: 'GET',
                data: { customer_id: customerId },
                dataType: 'json',
                success: function(data) {
                    var addressDropdown = $(addressDropdownId);
                    addressDropdown.empty();
                    addressDropdown.append('<option value="">Select Address</option>');
                    $.each(data, function(index, address) {
                        var addressText = address.street_address + ', ' + address.city + ', ' + address.state + ', ' + address.postal_code + ', ' + address.country;
                        addressDropdown.append('<option value="' + address.address_id + '">' + addressText + '</option>');
                    });
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching addresses:', error);
                }
            });
        } else {
            $(addressDropdownId).empty().append('<option value="">Select Address</option>');
        }
    }

    function fetchCustomerDetails(customerId, nameFieldId, phoneFieldId, emailFieldId) {
        if (customerId) {
            $.ajax({
                url: 'fetch_customer_details.php',
                type: 'GET',
                data: { customer_id: customerId },
                dataType: 'json',
                success: function(data) {
                    $(nameFieldId).val(data.first_name + ' ' + data.last_name);
                    $(phoneFieldId).val(data.phone_number);
                    $(emailFieldId).val(data.email);
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching customer details:', error);
                }
            });
        } else {
            $(nameFieldId).val('');
            $(phoneFieldId).val('');
            $(emailFieldId).val('');
        }
    }

    $('#senderCustomer').on('change', function() {
        var customerId = $(this).val();
        fetchAddresses(customerId, '#senderAddress');
        fetchCustomerDetails(customerId, '#senderName', '#senderPhone', '#senderEmail');
    });

    $('#receiverCustomer').on('change', function() {
        var customerId = $(this).val();
        fetchAddresses(customerId, '#receiverAddress');
        fetchCustomerDetails(customerId, '#receiverName', '#receiverPhone', '#receiverEmail');
        // Remove the required attribute from receiver name and phone fields
        $('#receiverName').prop('required', false);
        $('#receiverPhone').prop('required', false);
    });

    // Initialize Select2 with search functionality including phone number
    $('.js-example-basic-single').select2({
        ajax: {
            url: 'fetch_customers.php',
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term // search term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            },
            cache: true
        },
        minimumInputLength: 1,
        templateResult: formatRepo,
        templateSelection: formatRepoSelection
    });

    function formatRepo (repo) {
        if (repo.loading) {
            return repo.text;
        }

        var markup = "<div class='select2-result-repository clearfix'>" +
            "<div class='select2-result-repository__meta'>" +
            "<div class='select2-result-repository__title'>" + repo.first_name + " " + repo.last_name + "</div>" +
            "<div class='select2-result-repository__description'>" + repo.phone_number + "</div>" +
            "</div></div>";

        return markup;
    }

    function formatRepoSelection (repo) {
        return repo.first_name + " " + repo.last_name;
    }
});
</script>

</body>

</html>