<?php
// Include database connection
include 'layouts/dbconn.php';

// Get the booking_id from the URL
$booking_id = isset($_GET['booking_id']) ? intval($_GET['booking_id']) : 0;

// Fetch booking details
$query = "
    SELECT 
        cb.*,
        sc.first_name AS sender_first_name,
        sc.last_name AS sender_last_name,
        sc.phone_number AS sender_phone,
        rc.first_name AS receiver_first_name,
        rc.last_name AS receiver_last_name,
        rc.phone_number AS receiver_phone
    FROM cargo_bookings cb
    LEFT JOIN customers sc ON cb.sender_customer_id = sc.customer_id
    LEFT JOIN customers rc ON cb.receiver_customer_id = rc.customer_id
    WHERE cb.booking_id = ?
";

$stmt = $conn->prepare($query);
$stmt->bind_param("i", $booking_id);
$stmt->execute();
$result = $stmt->get_result();
$booking = $result->fetch_assoc();
$stmt->close();

if (!$booking) {
    die("Booking not found");
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Cargo Receipt</title>
    <style type="text/css">
        body {
            margin: 0;
            padding: 0;
            background: #ffffff;
            width: 88mm;
            height: 100%;
            -webkit-font-smoothing: antialiased;
        }
        
        @media print {
            body {
                width: 88mm;
                margin: 0;
                padding: 0;
            }
            .no-print {
                display: none;
            }
        }
        
        div, p, a, li, td {
            -webkit-text-size-adjust: none;
        }
        
        p {
            padding: 0 !important;
            margin: 0 !important;
        }
        
        .visibleMobile {
            display: none;
        }
        
        .hiddenMobile {
            display: block;
        }
        
        .logo-img {
            max-width: 150px;
            margin: 10px auto;
            display: block;
        }
        
        .qr-code {
            text-align: center;
            margin: 10px 0;
        }
        
        .qr-code img {
            max-width: 100px;
        }
    </style>
</head>
<body>
    <div class="no-print">
        <button onclick="window.print()">Print Receipt</button>
        <button onclick="window.close()">Close</button>
    </div>

    <!-- Header -->
    <table width="100%" border="0" cellpadding="2" cellspacing="2" align="center" bgcolor="#ffffff" style="padding-top:4px;">
        <tbody>
            <tr>
                <td style="text-align: center;">
                    <img src="assets/images/awt_logo.png" alt="Company Logo" class="logo-img">
                </td>
            </tr>
            <tr>
                <td style="font-size: 12px; color: #5b5b5b; font-family: 'Open Sans', sans-serif; line-height: 18px; vertical-align: bottom; text-align: center;">
                    <strong style="font-size:16px;">African Wings Travel & Cargo Ltd</strong>
                    <br>Phone: +(254) 234 6789
                    <br>Nairobi, Kenya
                    <br>www.africanwingstravel.com
                </td>
            </tr>
            <tr>
                <td height="2" colspan="0" style="border-bottom:1px solid #e4e4e4"></td>
            </tr>
        </tbody>
    </table>

    <!-- Receipt Details -->
    <table width="100%" border="0" cellpadding="0" cellspacing="2" align="center">
        <tbody>
            <tr>
                <td colspan="100" style="font-size: 14px; color: #5b5b5b; font-family: 'Open Sans', sans-serif; line-height: 18px; vertical-align: bottom; text-align: center;">
                    <strong>Cargo Receipt</strong>
                </td>
            </tr>
            <tr>
                <td style="font-size: 12px; color: #5b5b5b; font-family: 'Open Sans', sans-serif; line-height: 18px; vertical-align: bottom; text-align: left;">
                    Booking #: <?php echo $booking['booking_number']; ?>
                    <br>Payment Status: <?php echo $booking['payment_status']; ?>
                </td>
                <td style="font-size: 12px; color: #5b5b5b; font-family: 'Open Sans', sans-serif; line-height:18px; vertical-align: top; text-align: right;">
                    Receipt #: VL<?php echo $booking['booking_id']; ?>
                    <br>Date: <?php echo date('M d, Y', strtotime($booking['payment_date'])); ?>
                </td>
            </tr>
            <tr>
                <td height="2" colspan="100" style="padding-top:15px;border-bottom:1px solid #e4e4e4"></td>
            </tr>
        </tbody>
    </table>

    <!-- Sender Details -->
    <table width="100%" border="0" cellpadding="0" cellspacing="2" align="center">
        <tbody>
            <tr>
                <td style="font-size: 12px; color: #5b5b5b; font-family: 'Open Sans', sans-serif; padding-top: 10px;">
                    <strong>Sender:</strong> <?php echo $booking['sender_first_name'] . ' ' . $booking['sender_last_name']; ?>
                    <br>Phone: <?php echo $booking['sender_phone']; ?>
                </td>
            </tr>
            <tr>
                <td style="font-size: 12px; color: #5b5b5b; font-family: 'Open Sans', sans-serif; padding-top: 10px;">
                    <strong>Receiver:</strong> <?php echo $booking['receiver_first_name'] . ' ' . $booking['receiver_last_name']; ?>
                    <br>Phone: <?php echo $booking['receiver_phone']; ?>
                </td>
            </tr>
        </tbody>
    </table>

    <!-- Cargo Details -->
    <table width="100%" border="0" cellpadding="0" cellspacing="2" align="center" style="padding: 12px 0px 5px 2px">
        <tbody>
            <tr>
                <td style="font-size: 12px; font-family: 'Open Sans', sans-serif; color: #646a6e;">
                    Cargo Type: <?php echo $booking['cargo_type']; ?>
                    <br>Weight: <?php echo number_format($booking['weight'], 2); ?> kg
                </td>
            </tr>
            <tr>
                <td height="2" colspan="100" style="padding-top:8px;border-bottom:1px solid #e4e4e4"></td>
            </tr>
        </tbody>
    </table>

    <!-- Amount Details -->
    <table width="100%" border="0" cellpadding="0" cellspacing="2" align="center" style="padding: 12px 0px 5px 2px">
        <tbody>
            <tr>
                <td style="font-size: 16px; font-family: 'Open Sans', sans-serif; color: #646a6e; line-height: 16px; vertical-align: top; text-align:left;">
                    Total Amount:
                </td>
                <td style="font-size: 16px; font-family: 'Open Sans', sans-serif; color: #646a6e; line-height: 16px; vertical-align: top; text-align:right; white-space:nowrap;" width="100">
                    $<?php echo number_format($booking['total_amount'], 2); ?>
                </td>
            </tr>
            <tr>
                <td height="2" colspan="100" style="padding-top:8px;border-bottom:1px solid #e4e4e4"></td>
            </tr>
        </tbody>
    </table>

    <!-- QR Code -->
    <table width="100%" border="0" cellpadding="0" cellspacing="2" align="center">
        <tbody>
            <tr>
                <td style="text-align: center; padding: 10px 0;">
                    <?php 
                    // Get the current domain and protocol
                    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://';
                    $domain = $_SERVER['HTTP_HOST'];
                    
                    // Create the complete tracking URL
                    $tracking_url = $protocol . $domain . "/tracking.php?booking=" . $booking['booking_number'];
                    ?>
                    <img src="https://api.qrserver.com/v1/create-qr-code/?size=100x100&data=<?php echo urlencode($tracking_url); ?>" alt="Tracking QR Code">
                    <br>
                    <span style="font-size: 12px; color: #5b5b5b; font-family: 'Open Sans', sans-serif;">
                        Scan to track your cargo
                    </span>
                </td>
            </tr>
        </tbody>
    </table>

    <!-- Footer -->
    <table width="100%" border="0" cellpadding="0" cellspacing="2" align="center">
        <tbody>
            <tr>
                <td style="font-size: 12px; color: #5b5b5b; font-family: 'Open Sans', sans-serif; text-align: center; padding: 10px 0;">
                    Thank you for choosing African Wings Travel & Cargo Ltd
                </td>
            </tr>
        </tbody>
    </table>

</body>
</html>