<?php
include 'layouts/session.php';
include 'layouts/dbconn.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    try {
        // Start transaction
        $conn->begin_transaction();
        
        // First insert the customer
        $stmt = $conn->prepare("INSERT INTO customers (
            user_id, 
            first_name, 
            last_name, 
            email, 
            phone_number, 
            passport,
            city,
            country
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        
        $user_id = $_SESSION['user_id']; // Get from session
        
        $stmt->bind_param("isssssss", 
            $user_id,
            $_POST['first_name'],
            $_POST['last_name'],
            $_POST['email'],
            $_POST['phone_number'],
            $_POST['passport'],
            $_POST['city'],
            $_POST['country']
        );
        
        $stmt->execute();
        $customer_id = $conn->insert_id;

        // Then insert the address
        $stmt = $conn->prepare("INSERT INTO customer_addresses (
            customer_id,
            address_type,
            street_address,
            city,
            state,
            postal_code,
            country,
            is_default
        ) VALUES (?, ?, ?, ?, ?, ?, ?, 1)");
        
        $stmt->bind_param("issssss",
            $customer_id,
            $_POST['address_type'],
            $_POST['street_address'],
            $_POST['city'],
            $_POST['state'],
            $_POST['postal_code'],
            $_POST['country']
        );
        
        $stmt->execute();

        // If we got here, commit the transaction
        $conn->commit();
        
        $_SESSION['success_msg'] = "Customer added successfully";
        header("Location: customer_view.php?id=" . $customer_id);
        exit();
        
    } catch (Exception $e) {
        // An error occurred, rollback changes
        $conn->rollback();
        
        if ($e->getCode() == 1062) { // MySQL duplicate entry error code
            $_SESSION['error_msg'] = "Email address already exists";
        } else {
            $_SESSION['error_msg'] = "Error adding customer: " . $e->getMessage();
        }
        
        // Redirect back to form with error
        header("Location: add_customer.php");
        exit();
    }
}

// If we get here, redirect to customers list
header("Location: all_customers.php");
exit();
?>