<?php
include 'layouts/session.php';
include 'layouts/dbconn.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    try {
        $conn->begin_transaction();
        
        $booking_id = $_POST['booking_id'];
        $cancellation_reason = $_POST['cancellation_reason'];
        $refund_amount = $_POST['refund_amount'];
        $refund_date = $_POST['refund_date'];
        
        // Update booking status
        $stmt = $conn->prepare("UPDATE bookings SET 
            status = 'Cancelled',
            cancellation_reason = ?,
            cancellation_date = CURRENT_TIMESTAMP,
            refund_amount = ?,
            refund_date = ?
            WHERE booking_id = ?");
            
        $stmt->bind_param("sdsi", 
            $cancellation_reason,
            $refund_amount,
            $refund_date,
            $booking_id
        );
        
        $stmt->execute();
        
        // The trigger will automatically update the flight's available seats
        
        $conn->commit();
        $_SESSION['success_msg'] = "Booking cancellation processed successfully";
        
    } catch (Exception $e) {
        $conn->rollback();
        $_SESSION['error_msg'] = "Error processing cancellation: " . $e->getMessage();
    }
    
    header("Location: all_cancellations.php");
    exit();
}

header("Location: all_cancellations.php");
exit();
?>