<?php
include 'layouts/session.php';
include 'layouts/dbconn.php';

// Get visa details
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

$sql = "SELECT v.*, 
               u_created.full_name as created_by_name,
               u_updated.full_name as updated_by_name
        FROM visa_applications v
        LEFT JOIN users u_created ON v.created_by = u_created.user_id
        LEFT JOIN users u_updated ON v.updated_by = u_updated.user_id
        WHERE v.application_id = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

if (!$result->num_rows) {
    header("Location: all_visas.php");
    exit;
}

$visa = $result->fetch_assoc();

// Get company settings
$settingsQuery = "SELECT * FROM settings 
                 WHERE setting_key IN ('system_name', 'address', 'tel_1', 'tel_2')";
$settingsResult = $conn->query($settingsQuery);
$settings = [];
while ($row = $settingsResult->fetch_assoc()) {
    $settings[$row['setting_key']] = $row['setting_value'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Visa Application Receipt - <?php echo $visa['reference_number']; ?></title>
    <link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            margin: 20px;
        }
        .receipt-container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .company-name {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        .company-details {
            margin-bottom: 20px;
        }
        .receipt-title {
            font-size: 18px;
            font-weight: bold;
            text-align: center;
            margin: 20px 0;
            text-transform: uppercase;
        }
        .section {
            margin-bottom: 20px;
        }
        .section-title {
            font-weight: bold;
            margin-bottom: 10px;
            border-bottom: 1px solid #ddd;
            padding-bottom: 5px;
        }
        .info-row {
            display: flex;
            margin-bottom: 8px;
        }
        .info-label {
            font-weight: bold;
            width: 150px;
        }
        .info-value {
            flex: 1;
        }
        .amount-section {
            border: 1px solid #ddd;
            padding: 10px;
            margin: 20px 0;
            background-color: #f9f9f9;
        }
        .footer {
            margin-top: 40px;
            text-align: center;
            font-size: 14px;
            border-top: 1px solid #ddd;
            padding-top: 20px;
        }
        @media print {
            .no-print {
                display: none;
            }
            body {
                margin: 0;
                padding: 15px;
            }
            .receipt-container {
                border: none;
            }
        }
    </style>
</head>
<body>
    <div class="receipt-container">
        <!-- Print Button -->
        <div class="no-print mb-3">
            <button onclick="window.print()" class="btn btn-primary">
                <i class="ri-printer-line align-middle me-1"></i> Print Receipt
            </button>
            <a href="view_visa.php?id=<?php echo $id; ?>" class="btn btn-secondary">
                <i class="ri-arrow-left-line align-middle me-1"></i> Back
            </a>
        </div>

        <!-- Header -->
        <div class="header">
            <div class="company-name"><?php echo htmlspecialchars($settings['system_name']); ?></div>
            <div class="company-details">
                <?php echo htmlspecialchars($settings['address']); ?><br>
                Tel: <?php echo htmlspecialchars($settings['tel_1']); ?> 
                <?php if(!empty($settings['tel_2'])): ?>
                    / <?php echo htmlspecialchars($settings['tel_2']); ?>
                <?php endif; ?>
            </div>
        </div>

        <div class="receipt-title">Visa Application Receipt</div>

        <!-- Reference Information -->
        <div class="section">
            <div class="section-title">Reference Information</div>
            <div class="info-row">
                <div class="info-label">Reference Number:</div>
                <div class="info-value"><?php echo htmlspecialchars($visa['reference_number']); ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Date:</div>
                <div class="info-value"><?php echo date('d M Y', strtotime($visa['created_at'])); ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Status:</div>
                <div class="info-value"><?php echo htmlspecialchars($visa['status']); ?></div>
            </div>
        </div>

        <!-- Client Information -->
        <div class="section">
            <div class="section-title">Client Information</div>
            <div class="info-row">
                <div class="info-label">Client Name:</div>
                <div class="info-value"><?php echo htmlspecialchars($visa['client_name']); ?></div>
            </div>
            <?php if (!empty($visa['care_of'])): ?>
            <div class="info-row">
                <div class="info-label">Care Of:</div>
                <div class="info-value"><?php echo htmlspecialchars($visa['care_of']); ?></div>
            </div>
            <?php endif; ?>
        </div>

        <!-- Payment Details -->
        <div class="section amount-section">
            <div class="section-title">Payment Details</div>
            <div class="info-row">
                <div class="info-label">Processing Amount:</div>
                <div class="info-value"><?php echo $visa['currency'] . ' ' . number_format($visa['amount'], 2); ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Payment Made:</div>
                <div class="info-value"><?php echo $visa['currency'] . ' ' . number_format($visa['payment'], 2); ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Commission:</div>
                <div class="info-value"><?php echo $visa['currency'] . ' ' . number_format($visa['commission'], 2); ?></div>
            </div>
        </div>

        <!-- Notes -->
        <?php if (!empty($visa['notes'])): ?>
        <div class="section">
            <div class="section-title">Additional Notes</div>
            <div class="info-row">
                <div class="info-value"><?php echo nl2br(htmlspecialchars($visa['notes'])); ?></div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Signature Section -->
        <div class="section" style="margin-top: 50px;">
            <div class="row">
                <div class="col-6">
                    <div style="border-top: 1px solid #000; margin-top: 25px; padding-top: 5px;">
                        Client Signature
                    </div>
                </div>
                <div class="col-6 text-end">
                    <div style="border-top: 1px solid #000; margin-top: 25px; padding-top: 5px;">
                        Official Signature & Stamp
                    </div>
                </div>
            </div>
        </div>

        <!-- Footer -->
        <div class="footer">
            <p>Receipt generated on <?php echo date('d M Y H:i'); ?><br>
            Generated by: <?php echo htmlspecialchars($visa['created_by_name']); ?></p>
            <p style="font-size: 12px; color: #666;">
                This is an official receipt. Please retain for your records.<br>
                Receipt No: <?php echo str_pad($visa['application_id'], 6, '0', STR_PAD_LEFT); ?>
            </p>
        </div>
    </div>
</body>
</html>