<?php include 'layouts/main.php'; ?>
<?php
session_start();
include 'layouts/dbconn.php';

$current_month = date('m');
$current_year = date('Y');

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Query to fetch user details
$user_id = $_SESSION['user_id'];
$sql_user_details = "SELECT username, user_role, full_name, email FROM users WHERE user_id = $user_id";
$result_user_details = $conn->query($sql_user_details);

if ($result_user_details && $row_user_details = $result_user_details->fetch_assoc()) {
    $username = $row_user_details['username'];
    $user_role = $row_user_details['user_role'];
    $full_name = $row_user_details['full_name'];
    $email = $row_user_details['email'];
}

// Initialize metrics variables
$totalBookings = $totalBookingsPrev = $upcomingFlights = $upcomingFlightsPrev = 
$totalRevenue = $totalRevenuePrev = $totalCancellations = $totalCancellationsPrev = 0;

try {
    // 1. Fetch Total Bookings (Current Month)
    $sqlTotalBookings = "SELECT COUNT(*) AS total_bookings 
                        FROM bookings 
                        WHERE status = 'Booked' 
                        AND MONTH(booking_date) = MONTH(CURDATE()) 
                        AND YEAR(booking_date) = YEAR(CURDATE())";
    $result = $conn->query($sqlTotalBookings);
    if ($result->num_rows > 0) {
        $totalBookings = $result->fetch_assoc()['total_bookings'];
    }

    // 1.1 Fetch Total Bookings (Previous Month)
    $sqlTotalBookingsPrev = "SELECT COUNT(*) AS total_bookings 
                            FROM bookings 
                            WHERE status = 'Booked' 
                            AND MONTH(booking_date) = MONTH(CURDATE()) - 1 
                            AND YEAR(booking_date) = YEAR(CURDATE())";
    $result = $conn->query($sqlTotalBookingsPrev);
    if ($result->num_rows > 0) {
        $totalBookingsPrev = $result->fetch_assoc()['total_bookings'];
    }

    // 2. Fetch Upcoming Flights
    $sqlUpcomingFlights = "SELECT COUNT(*) AS upcoming_flights 
                          FROM flight_schedules 
                          WHERE start_date <= CURDATE() 
                          AND end_date >= CURDATE()";
    $result = $conn->query($sqlUpcomingFlights);
    if ($result->num_rows > 0) {
        $upcomingFlights = $result->fetch_assoc()['upcoming_flights'];
    }

    // 2.1 Fetch Previous Week Flights
    $sqlUpcomingFlightsPrev = "SELECT COUNT(*) AS upcoming_flights 
                              FROM flight_schedules 
                              WHERE start_date <= CURDATE() - INTERVAL 7 DAY 
                              AND end_date >= CURDATE() - INTERVAL 7 DAY";
    $result = $conn->query($sqlUpcomingFlightsPrev);
    if ($result->num_rows > 0) {
        $upcomingFlightsPrev = $result->fetch_assoc()['upcoming_flights'];
    }

    // 3. Fetch Revenue Generated (Current Month)
    $sqlRevenueGenerated = "
        SELECT (
            -- Revenue from ticket details
            SELECT COALESCE(SUM(
                CASE 
                    WHEN currency = 'KES' THEN (ticket_cost + agency_fee) / 100
                    ELSE (ticket_cost + agency_fee)
                END
            ), 0)
            FROM ticket_details 
            WHERE status = 'Active'
            AND MONTH(created_date) = MONTH(CURDATE())
            AND YEAR(created_date) = YEAR(CURDATE())
        ) + (
            -- Revenue from payments
            SELECT COALESCE(SUM(amount), 0)
            FROM payments 
            WHERE payment_status = 'Completed'
            AND MONTH(payment_date) = MONTH(CURDATE())
            AND YEAR(payment_date) = YEAR(CURDATE())
        ) + (
            -- Revenue from cargo bookings
            SELECT COALESCE(SUM(
                CASE 
                    WHEN currency = 'KES' THEN paid_amount / 100
                    ELSE paid_amount
                END
            ), 0)
            FROM cargo_bookings 
            WHERE payment_status = 'paid'
            AND MONTH(payment_date) = MONTH(CURDATE())
            AND YEAR(payment_date) = YEAR(CURDATE())
        ) + (
            -- Revenue from visa applications
            SELECT COALESCE(SUM(
                CASE 
                    WHEN commission IS NOT NULL THEN commission
                    ELSE 0
                END +
                CASE 
                    WHEN payment IS NOT NULL THEN payment
                    ELSE 0
                END
            ), 0)
            FROM visa_applications
            WHERE status = 'Completed'
            AND MONTH(created_at) = MONTH(CURDATE())
            AND YEAR(create_at) = YEAR(CURDATE())
        ) AS total_revenue
    ";
    
    $result = $conn->query($sqlRevenueGenerated);
    if ($result->num_rows > 0) {
        $totalRevenue = $result->fetch_assoc()['total_revenue'];
    }

    // 3.1 Fetch Revenue Generated (Previous Month)
    $sqlRevenuePrev = "
        SELECT (
            -- Revenue from ticket details
            SELECT COALESCE(SUM(
                CASE 
                    WHEN currency = 'KES' THEN (ticket_cost + agency_fee) / 100
                    ELSE (ticket_cost + agency_fee)
                END
            ), 0)
            FROM ticket_details 
            WHERE status = 'Active'
            AND MONTH(created_date) = MONTH(CURDATE()) - 1
            AND YEAR(created_date) = YEAR(CURDATE())
        ) + (
            -- Revenue from payments
            SELECT COALESCE(SUM(amount), 0)
            FROM payments 
            WHERE payment_status = 'Completed'
            AND MONTH(payment_date) = MONTH(CURDATE()) - 1
            AND YEAR(payment_date) = YEAR(CURDATE())
        ) + (
            -- Revenue from cargo bookings
            SELECT COALESCE(SUM(
                CASE 
                    WHEN currency = 'KES' THEN paid_amount / 100
                    ELSE paid_amount
                END
            ), 0)
            FROM cargo_bookings 
            WHERE payment_status = 'paid'
            AND MONTH(payment_date) = MONTH(CURDATE()) - 1
            AND YEAR(payment_date) = YEAR(CURDATE())
        ) + (
            -- Revenue from visa applications
            SELECT COALESCE(SUM(
                CASE 
                    WHEN commission IS NOT NULL THEN commission
                    ELSE 0
                END +
                CASE 
                    WHEN payment IS NOT NULL THEN payment
                    ELSE 0
                END
            ), 0)
            FROM visa_applications
            WHERE status = 'Completed'
            AND MONTH(created_at) = MONTH(CURDATE()) - 1
            AND YEAR(created_at) = YEAR(CURDATE())
        ) AS total_revenue
    ";
    
    $result = $conn->query($sqlRevenuePrev);
    if ($result->num_rows > 0) {
        $totalRevenuePrev = $result->fetch_assoc()['total_revenue'];
    }

    // 4. Fetch Flight Cancellations
    $sqlFlightCancellations = "SELECT COUNT(*) AS cancellations 
                              FROM bookings 
                              WHERE status = 'Cancelled' 
                              AND MONTH(cancellation_date) = MONTH(CURDATE()) 
                              AND YEAR(cancellation_date) = YEAR(CURDATE())";
    $result = $conn->query($sqlFlightCancellations);
    if ($result->num_rows > 0) {
        $totalCancellations = $result->fetch_assoc()['cancellations'];
    }

    // 4.1 Fetch Previous Month Cancellations
    $sqlFlightCancellationsPrev = "SELECT COUNT(*) AS cancellations 
                                  FROM bookings 
                                  WHERE status = 'Cancelled' 
                                  AND MONTH(cancellation_date) = MONTH(CURDATE()) - 1 
                                  AND YEAR(cancellation_date) = YEAR(CURDATE())";
    $result = $conn->query($sqlFlightCancellationsPrev);
    if ($result->num_rows > 0) {
        $totalCancellationsPrev = $result->fetch_assoc()['cancellations'];
    }

    // Calculate percentage changes
    $bookingsChange = ($totalBookingsPrev > 0) ? 
        (($totalBookings - $totalBookingsPrev) / $totalBookingsPrev) * 100 : 0;
    $flightsChange = ($upcomingFlightsPrev > 0) ? 
        (($upcomingFlights - $upcomingFlightsPrev) / $upcomingFlightsPrev) * 100 : 0;
    $revenueChange = ($totalRevenuePrev > 0) ? 
        (($totalRevenue - $totalRevenuePrev) / $totalRevenuePrev) * 100 : 0;
    $cancellationsChange = ($totalCancellationsPrev > 0) ? 
        (($totalCancellations - $totalCancellationsPrev) / $totalCancellationsPrev) * 100 : 0;

    // Additional Metrics
    $sqlCargoShipments = "SELECT COUNT(*) AS total_shipments 
                         FROM cargo_bookings 
                         WHERE booking_status = 'delivered' 
                         AND MONTH(actual_delivery_date) = MONTH(CURDATE()) 
                         AND YEAR(actual_delivery_date) = YEAR(CURDATE())";
    $result = $conn->query($sqlCargoShipments);
    $totalCargoShipments = $result->num_rows > 0 ? $result->fetch_assoc()['total_shipments'] : 0;

    $sqlVisaApplications = "SELECT COUNT(*) AS total_applications 
                           FROM visa_applications 
                           WHERE status = 'Completed' 
                           AND MONTH(created_at) = MONTH(CURDATE()) 
                           AND YEAR(created_at) = YEAR(CURDATE())";
    $result = $conn->query($sqlVisaApplications);
    $totalVisaApplications = $result->num_rows > 0 ? $result->fetch_assoc()['total_applications'] : 0;

    $sqlAirTickets = "SELECT COUNT(*) AS total_tickets 
                      FROM bookings 
                      WHERE status = 'Booked' 
                      AND MONTH(booking_date) = MONTH(CURDATE()) 
                      AND YEAR(booking_date) = YEAR(CURDATE())";
    $result = $conn->query($sqlAirTickets);
    $totalAirTickets = $result->num_rows > 0 ? $result->fetch_assoc()['total_tickets'] : 0;

    // Flight Schedules for Calendar
    $sqlFlightSchedules = "SELECT fs.schedule_id, fs.flight_number, 
                                 fs.departure_time, fs.arrival_time, 
                                 fs.start_date, fs.end_date, fs.days_of_week,
                                 o.city AS origin_city, d.city AS destination_city
                          FROM flight_schedules fs
                          JOIN airports o ON fs.origin_id = o.airport_id
                          JOIN airports d ON fs.destination_id = d.airport_id
                          WHERE fs.start_date >= CURDATE()
                          ORDER BY fs.start_date, fs.departure_time
                          LIMIT 10";
    $result = $conn->query($sqlFlightSchedules);

    $flightSchedules = [];
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $row['days_of_week'] = implode(',', array_map('trim', explode(',', $row['days_of_week'])));
            $flightSchedules[] = $row;
        }
    }
    $flightSchedulesJson = json_encode($flightSchedules);

} catch (Exception $e) {
    error_log("Error in dashboard metrics calculation: " . $e->getMessage());
    // Set default values in case of error
    $totalBookings = $upcomingFlights = $totalCancellations = 0;
    $totalRevenue = $totalCargoShipments = $totalVisaApplications = $totalAirTickets = 0;
    $bookingsChange = $flightsChange = $cancellationsChange = $revenueChange = 0;
}

$sqlAgencyFees = "
    SELECT (
        -- Agency fees from ticket details
        SELECT COALESCE(SUM(
            CASE 
                WHEN currency = 'KES' THEN agency_fee / 100
                ELSE agency_fee
            END
        ), 0)
        FROM ticket_details 
        WHERE status = 'Active'
        AND MONTH(created_date) = MONTH(CURDATE())
        AND YEAR(created_date) = YEAR(CURDATE())
    ) + (
        -- Agency fees from visa applications
        SELECT COALESCE(SUM(
            CASE 
                WHEN commission IS NOT NULL THEN commission  -- Assuming 20% agency fee
                ELSE 0
            END
        ), 0)
        FROM visa_applications
        WHERE status = 'Completed'
        AND MONTH(created_at) = MONTH(CURDATE())
        AND YEAR(created_at) = YEAR(CURDATE())
    ) + (
        -- Agency fees from cargo bookings (assuming 15% of total amount)
        SELECT COALESCE(SUM(
            CASE 
                WHEN currency = 'KES' THEN (paid_amount * 0.15) / 100
                ELSE (paid_amount * 0.15)
            END
        ), 0)
        FROM cargo_bookings 
        WHERE payment_status = 'paid'
        AND MONTH(payment_date) = MONTH(CURDATE())
        AND YEAR(payment_date) = YEAR(CURDATE())
    ) + (
        -- Agency fees from passport extensions
        SELECT COALESCE(SUM(agency_fee), 0)
        FROM passport_extensions
        WHERE payment_status = 'paid'
        AND MONTH(extension_date) = MONTH(CURDATE())
        AND YEAR(extension_date) = YEAR(CURDATE())
    ) AS total_agency_fees
";

$result = $conn->query($sqlAgencyFees);
$totalAgencyFees = $result->fetch_assoc()['total_agency_fees'];

// Get previous month's agency fees for comparison
$sqlPrevAgencyFees = str_replace(
    'MONTH(CURDATE())',
    'MONTH(CURDATE()) - 1',
    $sqlAgencyFees
);
$result = $conn->query($sqlPrevAgencyFees);
$prevAgencyFees = $result->fetch_assoc()['total_agency_fees'];

// Calculate percentage change
$agencyFeesChange = ($prevAgencyFees > 0) ? 
    (($totalAgencyFees - $prevAgencyFees) / $prevAgencyFees) * 100 : 0;

// Close the database connection
$conn->close();
?>

<?php
// Add these functions to your existing PHP code or in a separate file

function getFlightStatusSummary() {
    // This should query your database to get the count of flights in each status
    // For now, we'll use dummy data
    return [
        'on_time' => 85,
        'delayed' => 12,
        'cancelled' => 3
    ];
}

function getPopularRoutes() {
    // Include your database connection file
    include('layouts/dbconn.php');

    $query = "
    SELECT 
        CONCAT(a1.city, ' - ', a2.city) AS route,
        COUNT(*) AS bookings
    FROM 
        bookings b
    JOIN 
        flights f ON b.flight_id = f.flight_id
    JOIN 
        airports a1 ON f.origin_id = a1.airport_id
    JOIN 
        airports a2 ON f.destination_id = a2.airport_id
    WHERE 
        b.status = 'Booked'
        AND b.booking_date >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)
    GROUP BY 
        f.origin_id, f.destination_id
    ORDER BY 
        bookings DESC
    LIMIT 5
    ";

    $result = $conn->query($query);

    $popularRoutes = [];
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $popularRoutes[] = [
                'route' => $row['route'],
                'bookings' => $row['bookings']
            ];
        }
    }

    $conn->close();

    return $popularRoutes;
}

function getSeatOccupancyRate() {
    // Include your database connection file
    include('layouts/dbconn.php');

    // Updated query to ensure correct calculations and comparisons
    $query = "
    SELECT 
    AVG((f.capacity - f.available_seats) / f.capacity * 100) AS avg_occupancy_rate
    FROM 
        flights f
    WHERE 
        (
            -- Flight has a future departure or is currently in progress
        f.departure_time >= CURDATE() 
        OR 
        (f.departure_time < CURDATE() AND f.arrival_time >= NOW())
    )
    AND f.departure_time < DATE_ADD(CURDATE(), INTERVAL 30 DAY)
    AND f.status IN ('scheduled', 'in progress');
    ";

    // Execute the query and handle results
    $result = $conn->query($query);

    if ($result && $row = $result->fetch_assoc()) {
        $occupancyRate = round($row['avg_occupancy_rate'], 1); // Round to 1 decimal place
    } else {
        $occupancyRate = 0; // Set occupancy rate to 0 if no results
    }

    // Close the database connection
    $conn->close();

    return $occupancyRate;
}


function getRecentCustomerInquiries() {
    // Fetch the most recent customer inquiries from your database
    // For now, we'll use dummy data
    return [
        ['id' => 1001, 'subject' => 'Baggage Claim', 'status' => 'Open'],
        ['id' => 1002, 'subject' => 'Refund Request', 'status' => 'In Progress'],
        ['id' => 1003, 'subject' => 'Seat Change', 'status' => 'Closed'],
        ['id' => 1004, 'subject' => 'Flight Delay Compensation', 'status' => 'Open'],
        ['id' => 1005, 'subject' => 'Lost Item', 'status' => 'In Progress']
    ];
}
?>
<?php
function getWeatherAlerts($cities) {
    $apiKey = '20d6ce617e2d398473d5ea30460a182f'; // Replace with your actual API key
    $alerts = [];

    foreach ($cities as $city) {
        $url = "http://api.openweathermap.org/data/2.5/weather?q={$city}&appid={$apiKey}&units=metric";
        
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);

        $data = json_decode($response, true);

        if ($data && isset($data['weather'][0]['main'])) {
            $weatherMain = $data['weather'][0]['main'];
            $temp = $data['main']['temp'];

            // Define conditions for alerts (you can customize these)
            $alert = '';
            if ($weatherMain == 'Rain' || $weatherMain == 'Thunderstorm') {
                $alert = 'Precipitation';
            } elseif ($weatherMain == 'Snow') {
                $alert = 'Snowfall';
            } elseif ($temp > 35) {
                $alert = 'Extreme Heat';
            } elseif ($temp < 0) {
                $alert = 'Freezing Conditions';
            } elseif ($data['wind']['speed'] > 20) {
                $alert = 'Strong Winds';
            }

            if ($alert) {
                $alerts[] = ['location' => $city, 'alert' => $alert];
            }
        }
    }

    return $alerts;
}

// Usage
$citiesToCheck = ['Nairobi,KE', 'Juba,SS', 'Mogadishu,SO', 'Addis Ababa,ET', 'Dubai,AE', 'Paris,FR'];
$weatherAlerts = getWeatherAlerts($citiesToCheck);

// Display the alerts
foreach ($weatherAlerts as $alert) {
    echo "{$alert['location']}: {$alert['alert']}<br>";
}
?>
<head>

    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'African Wings Travel & Cargo Agency')); ?>

    <?php include 'layouts/head-css.php'; ?>

</head>

<body>

    <!-- Begin page -->
    <div id="layout-wrapper">

        <?php include 'layouts/menu.php'; ?>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Dashboard', 'title' => 'African Wings Travel & Cargo Agency')); ?>

                    <div class="row project-wrapper">
                        <div class="col-xxl-12">
                            
                            <!-- Dashboard Cards Section -->
                            <div class="row">

                                <!-- Revenue Generated Card -->
                                <div class="col-xl-4 col-md-6">
                                    <div class="card card-animate">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center">
                                                <div class="avatar-sm flex-shrink-0">
                                                    <span class="avatar-title bg-success-subtle text-success rounded-2 fs-2">
                                                        <i data-feather="dollar-sign" class="text-success"></i>
                                                    </span>
                                                </div>
                                                <div class="flex-grow-1 overflow-hidden ms-3">
                                                    <p class="text-uppercase fw-semibold text-muted text-truncate mb-3">Revenue Generated</p>
                                                    <div class="d-flex align-items-center mb-3">
                                                        <h4 class="fs-4 flex-grow-1 mb-0">$<?php echo number_format($totalRevenue, 2); ?></h4>
                                                        <span class="badge <?php echo $revenueChange >= 0 ? 'bg-success-subtle text-success' : 'bg-danger-subtle text-danger'; ?> fs-12">
                                                            <i class="ri-arrow-<?php echo $revenueChange >= 0 ? 'up' : 'down'; ?>-s-line fs-13 align-middle me-1"></i>
                                                            <?php echo number_format(abs($revenueChange), 2); ?>%
                                                        </span>
                                                    </div>
                                                    <p class="text-muted text-truncate mb-0">Revenue this month (Tickets, Cargo, Visa)</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Total Bookings Card -->
                                
                                <!-- end col -->
                            
                            
                                <!-- Upcoming Flights Card -->
                                <div class="col-xl-4 col-md-6">
                                    <div class="card card-animate">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center">
                                                <div class="avatar-sm flex-shrink-0">
                                                    <span class="avatar-title bg-info-subtle text-info rounded-2 fs-2">
                                                        <i data-feather="clock" class="text-info"></i>
                                                    </span>
                                                </div>
                                                <div class="flex-grow-1 overflow-hidden ms-3">
                                                    <p class="text-uppercase fw-semibold text-muted text-truncate mb-3">Upcoming Flights</p>
                                                    <div class="d-flex align-items-center mb-3">
                                                        <h4 class="fs-4 flex-grow-1 mb-0"><?php echo $upcomingFlights; ?></h4>
                                                        <span class="badge <?php echo $flightsChange >= 0 ? 'bg-success-subtle text-success' : 'bg-danger-subtle text-danger'; ?> fs-12">
                                                            <i class="ri-arrow-<?php echo $flightsChange >= 0 ? 'up' : 'down'; ?>-s-line fs-13 align-middle me-1"></i>
                                                            <?php echo number_format(abs($flightsChange), 2); ?>%
                                                        </span>
                                                    </div>
                                                    <p class="text-muted text-truncate mb-0">Flights scheduled this week</p>
                                                </div>
                                            </div>
                                        </div><!-- end card body -->
                                    </div>
                                </div><!-- end col -->
                            
                                <!-- Total Agency Fee This Month Card -->
                                <div class="col-xl-4 col-md-6">
                                    <div class="card card-animate">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center">
                                                <div class="avatar-sm flex-shrink-0">
                                                    <span class="avatar-title bg-primary-subtle text-primary rounded-2 fs-2">
                                                        <i data-feather="dollar-sign" class="text-primary"></i>
                                                    </span>
                                                </div>
                                                <div class="flex-grow-1 overflow-hidden ms-3">
                                                    <p class="text-uppercase fw-semibold text-muted text-truncate mb-3">Total Agency Fees</p>
                                                    <div class="d-flex align-items-center mb-3">
                                                        <h4 class="fs-4 flex-grow-1 mb-0">$<?php echo number_format($totalAgencyFees, 2); ?></h4>
                                                        <span class="badge <?php echo $agencyFeesChange >= 0 ? 'bg-success-subtle text-success' : 'bg-danger-subtle text-danger'; ?> fs-12">
                                                            <i class="ri-arrow-<?php echo $agencyFeesChange >= 0 ? 'up' : 'down'; ?>-s-line fs-13 align-middle me-1"></i>
                                                            <?php echo number_format(abs($agencyFeesChange), 2); ?>%
                                                        </span>
                                                    </div>
                                                    <p class="text-muted text-truncate mb-0">Total agency fees (Tickets, Visa, Cargo, Extensions)</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end col -->
                                
                            </div><!-- end row -->

                            
                        </div><!-- end col -->

                        <!-- Upcoming Schedules Section -->

                    </div><!-- end row -->

                    <div class="row">
                        
                        <!-- Total Cargo Shipments This Month Card -->
                        <div class="col-xl-3 col-md-6">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-sm flex-shrink-0">
                                            <span class="avatar-title bg-primary-subtle text-primary rounded-2 fs-2">
                                                <i data-feather="truck" class="text-primary"></i>
                                            </span>
                                        </div>
                                        <div class="flex-grow-1 overflow-hidden ms-3">
                                            <p class="text-uppercase fw-semibold text-muted text-truncate mb-3">Total Cargo Shipments This Month</p>
                                            <div class="d-flex align-items-center mb-3">
                                                <h4 class="fs-4 flex-grow-1 mb-0"><?php echo $totalCargoShipments; ?></h4>
                                            </div>
                                            <p class="text-muted text-truncate mb-0">Shipments delivered this month</p>
                                        </div>
                                    </div>
                                </div><!-- end card body -->
                            </div>
                        </div><!-- end col -->
                                
                        <!-- Visa Applications Processed Card -->
                        <div class="col-xl-3 col-md-6">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-sm flex-shrink-0">
                                            <span class="avatar-title bg-success-subtle text-success rounded-2 fs-2">
                                                <i data-feather="file-text" class="text-success"></i>
                                            </span>
                                        </div>
                                        <div class="flex-grow-1 overflow-hidden ms-3">
                                            <p class="text-uppercase fw-semibold text-muted text-truncate mb-3">Visa Applications Processed</p>
                                            <div class="d-flex align-items-center mb-3">
                                                <h4 class="fs-4 flex-grow-1 mb-0"><?php echo $totalVisaApplications; ?></h4>
                                            </div>
                                            <p class="text-muted text-truncate mb-0">Applications approved this month</p>
                                        </div>
                                    </div>
                                </div><!-- end card body -->
                            </div>
                        </div><!-- end col -->
                        
                        <!-- Passport Extension Applications Processed Card -->
                        <div class="col-xl-3 col-md-6">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-sm flex-shrink-0">
                                            <span class="avatar-title bg-success-subtle text-success rounded-2 fs-2">
                                                <i data-feather="file-text" class="text-success"></i>
                                            </span>
                                        </div>
                                        <div class="flex-grow-1 overflow-hidden ms-3">
                                            <p class="text-uppercase fw-semibold text-muted text-truncate mb-3">Passport Extension Processed</p>
                                            <div class="d-flex align-items-center mb-3">
                                                <h4 class="fs-4 flex-grow-1 mb-0"><?php echo $totalVisaApplications; ?></h4>
                                            </div>
                                            <p class="text-muted text-truncate mb-0">Applications approved this month</p>
                                        </div>
                                    </div>
                                </div><!-- end card body -->
                            </div>
                        </div><!-- end col -->
                        
                        
                            <!-- Weather Alerts Card -->
                        <div class="col-xl-3 col-md-6">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-sm flex-shrink-0">
                                            <span class="avatar-title bg-danger-subtle text-danger rounded-2 fs-2">
                                                <i class="ri-cloud-line"></i>
                                            </span>
                                        </div>
                                        <div class="flex-grow-1 overflow-hidden ms-3">
                                            <p class="text-uppercase fw-semibold text-muted text-truncate mb-3">Weather Alerts</p>
                                            <div class="d-flex align-items-center mb-3">
                                                <?php
                                                $citiesToCheck = ['Nairobi', 'Juba', 'Mogadishu', 'Addis Ababa', 'Dubai'];
                                                $weatherAlerts = getWeatherAlerts($citiesToCheck);
                                                ?>
                                                <h4 class="fs-4 flex-grow-1 mb-0"><?php echo count($weatherAlerts); ?> Alerts</h4>
                                            </div>
                        
                                            <?php
                                            if (!empty($weatherAlerts)) {
                                                // Loop through the alerts and display each one
                                                echo "<ul class='list-unstyled mb-0'>";
                                                foreach ($weatherAlerts as $alert) {
                                                    echo "<li class='text-muted mb-1'>{$alert['location']}: {$alert['alert']}</li>";
                                                }
                                                echo "</ul>";
                                            } else {
                                                echo "<p class='text-muted mb-0'>No current weather alerts</p>";
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    
                    </div>

                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card card-height-100">
                                <div class="card-header d-flex align-items-center">
                                    <h4 class="card-title flex-grow-1 mb-0">Ticket Bookings</h4>
                                    <div class="flex-shrink-0">
                                        <a href="javascript:void(0);" class="btn btn-soft-info btn-sm">Export Report</a>
                                    </div>
                                </div><!-- end cardheader -->
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="buttons-datatables" class="display table table-bordered" style="width:100%">
                                        <thead>
                                            <tr>
                                                <th>Ticket ID</th>
                                                <th>Ticket Ref</th>
                                                <th>Customer Name</th>
                                                <th>Flight Route</th>
                                                <th>Date</th>
                                                <th>Ticket Cost</th>
                                                <th>Agency Fee</th>
                                                <th>Total Amount</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            // Include the database connection file
                                            include('layouts/dbconn.php');
                                            
                                            // Construct the SQL query
                                            $query = "SELECT 
                                                td.ticket_id,
                                                td.ticket_ref,
                                                td.salutation,
                                                td.customer_name,
                                                td.airline,
                                                td.flight_route,
                                                td.flight_date,
                                                td.ticket_cost,
                                                td.agency_fee,
                                                td.total_amount,
                                                td.status,
                                                td.booking_id,
                                                b.booking_code,
                                                CONCAT(c.first_name, ' ', c.last_name) as customer_fullname
                                            FROM 
                                                ticket_details td
                                            LEFT JOIN 
                                                bookings b ON td.booking_id = b.booking_id
                                            LEFT JOIN 
                                                customers c ON b.customer_id = c.customer_id
                                            ORDER BY 
                                                td.created_date DESC";
                                            
                                            // Execute the query
                                            $result = $conn->query($query);
                                            
                                            // Check if there are any results
                                            if ($result->num_rows > 0) {
                                                // Loop through the results and output each row
                                                while ($row = $result->fetch_assoc()) {
                                                    $statusClass = $row['status'] === 'Active' ? 'badge bg-success' : 
                                                                ($row['status'] === 'Cancelled' ? 'badge bg-danger' : 'badge bg-warning');
                                                    
                                                    echo "<tr>";
                                                    echo "<td>{$row['ticket_id']}</td>";
                                                    echo "<td>{$row['ticket_ref']}</td>";
                                                    echo "<td>{$row['salutation']} {$row['customer_name']}</td>";
                                                    echo "<td>{$row['flight_route']}</td>";
                                                    echo "<td>" . date('d M Y', strtotime($row['flight_date'])) . "</td>";
                                                    echo "<td>" . number_format($row['ticket_cost'], 2) . "</td>";
                                                    echo "<td>" . number_format($row['agency_fee'], 2) . "</td>";
                                                    echo "<td>" . number_format($row['total_amount'], 2) . "</td>";
                                                    echo "<td><span class='{$statusClass}'>{$row['status']}</span></td>";
                                                    echo '<td>
                                                            <ul class="list-inline hstack gap-2 mb-0">
                                                                <li class="list-inline-item edit" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="Print Ticket">
                                                                    <a href="javascript:void(0);" onclick="printTicket(' . $row['ticket_id'] . ')" class="text-muted d-inline-block">
                                                                        <i class="ri-printer-line fs-16"></i>
                                                                    </a>
                                                                </li>
                                                                <li class="list-inline-item" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="View Details">
                                                                    <a href="view_ticket.php?ticket_id=' . $row['ticket_id'] . '">
                                                                        <i class="ri-eye-fill align-bottom text-muted"></i>
                                                                    </a>
                                                                </li>';
                                                                
                                                    if ($row['booking_id']) {
                                                        echo '<li class="list-inline-item" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="View Booking">
                                                                <a href="booking_view.php?booking_id=' . $row['booking_id'] . '">
                                                                    <i class="ri-file-list-3-line align-bottom text-muted"></i>
                                                                </a>
                                                              </li>';
                                                    }
                                                                
                                                    echo    '</ul>
                                                        </td>';
                                                    echo "</tr>";
                                                }
                                            } else {
                                                // If no tickets are found, output a message
                                                echo "<tr><td colspan='10'>No tickets found</td></tr>";
                                            }
                                            
                                            // Close the database connection
                                            $conn->close();
                                            ?>
                                        </tbody>    
                                    </table>
                                    </div>
                                </div>
                            </div><!-- end card -->
                        </div><!-- end col -->

                        <div class="col-xl-12">
                            <div class="card card-height-100">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1 py-1">Payments</h4>
                                    
                                </div><!-- end card header -->
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="buttons-datatables" class="display table table-bordered" style="width:100%">
                                            <thead>
                                                <tr>
                                                    <th>Payment ID</th>
                                                    <th>Booking ID</th>
                                                    <th>Amount</th>
                                                    <th>Payment Date</th>
                                                    <th>Transaction ID</th>
                                                    <th>Payment Status</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                // Include the database connection file
                                                include('layouts/dbconn.php');
                                                
                                                $query = "SELECT *
                                                            FROM payments";
                            
                                                $result = $conn->query($query);
                                                
                                                if ($result->num_rows > 0) {
                                                    while ($row = $result->fetch_assoc()) {
                                                        echo "<tr ondblclick=\"openFileData('{$row['payment_id']}')\">"; // Added ondblclick event
                                                        echo "<td>{$row['payment_id']}</td>";
                                                        echo "<td>{$row['booking_id']}</td>";
                                                        echo "<td>{$row['amount']}</td>";
                                                        echo "<td>{$row['payment_date']}</td>"; 
                                                        echo "<td>{$row['transaction_id']}</td>";
                                                        echo "<td>{$row['payment_status']}</td>";
                                                        echo '<td>
                                                                 <ul class="list-inline hstack gap-2 mb-0">
                                                                    
                                                                    <li class="list-inline-item edit" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="Payment View">
                                                                        <a href="payment_view.php?payment_id=' . $row['payment_id'] . '" class="text-muted d-inline-block">
                                                                            <i class="ri-printer-line fs-16"></i>
                                                                        </a>
                                                                    </li>
                                                                    <li class="list-inline-item" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="View">
                                                                        <a href="booking_view.php?booking_id=' . $row['booking_id'] . '"><i class="ri-eye-fill align-bottom text-muted"></i></a>
                                                                    </li>
                                                                    
                                                                </ul>
                                                              </td>';


                                                        echo "</tr>";
                                                    }
                                                } else {
                                                    echo "<tr><td colspan='8'>No files found</td></tr>";
                                                }
                                                
                                                $conn->close(); // Close the database connection
                                                ?>
                                            </tbody>    
                                        </table>
                                    </div>
                                </div><!-- end cardbody -->
                            </div><!-- end card -->
                            
                        </div><!-- end col -->
                        <!-- New Dashboard Cards -->


                        <!-- Recent Cargo Bookings Card -->
                        <div class="row mt-4">
                            <div class="col-xl-12">
                                <div class="card">
                                    <div class="card-header align-items-center d-flex">
                                        <h4 class="card-title mb-0 flex-grow-1">Recent Cargo Bookings</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table id="buttons-datatables" class="display table table-bordered" style="width:100%">
                                                <thead>
                                                    <tr>
                                                        <th>Booking Number</th>
                                                        <th>Sender Name</th>
                                                        <th>Receiver Name</th>
                                                        <th>Cargo Type</th>
                                                        <th>Weight</th>
                                                        <th>Estimated Delivery Date</th>
                                                        <th>Total Amount</th>
                                                        <th>Payment Status</th>
                                                        <th>Package Status</th>
                                                        <th>Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php
                                                // Include the database connection file
                                                include('layouts/dbconn.php');
                                                
                                                // Modified query to include booking_status
                                                $query = "
                                                    SELECT
                                                        cb.booking_number,
                                                        CONCAT(sc.first_name, ' ', sc.last_name) AS sender_name,
                                                        CONCAT(rc.first_name, ' ', rc.last_name) AS receiver_name,
                                                        cb.cargo_type,
                                                        cb.weight,
                                                        cb.estimated_delivery_date,
                                                        cb.total_amount,
                                                        cb.currency,
                                                        cb.payment_status,
                                                        cb.booking_status,
                                                        cb.booking_id
                                                    FROM
                                                        cargo_bookings cb
                                                    LEFT JOIN
                                                        customers sc ON cb.sender_customer_id = sc.customer_id
                                                    LEFT JOIN
                                                        customers rc ON cb.receiver_customer_id = rc.customer_id
                                                ";
                                                
                                                $result = $conn->query($query);
                                                
                                                if ($result->num_rows > 0) {
                                                    while ($row = $result->fetch_assoc()) {
                                                        echo "<tr ondblclick=\"openFileData('{$row['booking_number']}')\">";
                                                        echo "<td><a href='cargo_view.php?booking_number={$row['booking_number']}'>{$row['booking_number']}</a></td>";
                                                        echo "<td>{$row['sender_name']}</td>";
                                                        echo "<td>{$row['receiver_name']}</td>";
                                                        echo "<td>{$row['cargo_type']}</td>";
                                                        echo "<td>{$row['weight']}</td>";
                                                        echo "<td>{$row['estimated_delivery_date']}</td>";
                                                        echo "<td>{$row['currency']} {$row['total_amount']}</td>";
                                                        echo "<td>{$row['payment_status']}</td>";
                                                        
                                                        // Add delivery status column with appropriate styling
                                                        $status_class = '';
                                                        $status_text = ucfirst(str_replace('_', ' ', $row['booking_status']));
                                                        
                                                        switch($row['booking_status']) {
                                                            case 'delivered':
                                                                $status_class = 'badge bg-success';
                                                                break;
                                                            case 'in_transit':
                                                                $status_class = 'badge bg-info';
                                                                break;
                                                            case 'pending':
                                                                $status_class = 'badge bg-warning';
                                                                break;
                                                            case 'cancelled':
                                                                $status_class = 'badge bg-danger';
                                                                break;
                                                            default:
                                                                $status_class = 'badge bg-secondary';
                                                        }
                                                        
                                                        echo "<td><span class='{$status_class}'>{$status_text}</span></td>";
                                                        
                                                        // Actions column with conditional buttons
                                                        echo '<td>
                                                            <ul class="list-inline hstack gap-2 mb-0">';
                                                        
                                                        // Check payment status and show appropriate button
                                                        if ($row['payment_status'] == 'paid') {
                                                            echo '<li class="list-inline-item edit" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="Print Payment">
                                                                    <a href="javascript:void(0);" onclick="openThermalReceipt(' . $row['booking_id'] . ')" class="text-muted d-inline-block">
                                                                        <i class="ri-printer-line fs-16"></i>
                                                                    </a>
                                                                  </li>';
                                                        } else {
                                                            echo '<li class="list-inline-item edit" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="Add Payment">
                                                                    <a href="add_cargo_payment.php?booking_number=' . $row['booking_number'] . '" class="text-muted d-inline-block">
                                                                        <i class="ri-refund-2-line fs-16"></i>
                                                                    </a>
                                                                  </li>';
                                                        }
                                                
                                                        // Rest of the action buttons
                                                        echo '
                                                            <li class="list-inline-item" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="View">
                                                                <a href="cargo_view.php?booking_number=' . $row['booking_number'] . '" class="text-muted d-inline-block">
                                                                    <i class="ri-eye-fill align-bottom me-2 text-muted"></i> 
                                                                </a>
                                                            </li>
                                                            <li class="list-inline-item" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="View Invoice">
                                                                <a class="edit-item-btn" href="cargo_payment_view.php?booking_id=' . $row['booking_id'] . '">
                                                                    <i class="ri-printer-line fs-16"></i>
                                                                </a>
                                                            </li>';
                                                        
                                                        // Only show status update button if not delivered
                                                        if ($row['booking_status'] !== 'delivered') {
                                                            echo '<li class="list-inline-item edit" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="Update Status">
                                                                    <a href="javascript:void(0);" onclick="showStatusModal(' . $row['booking_id'] . ', \'' . $row['booking_status'] . '\')" class="text-muted d-inline-block">
                                                                        <i class="ri-exchange-line fs-16"></i>
                                                                    </a>
                                                                  </li>';
                                                        }
                                                        
                                                        echo '<li class="list-inline-item" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="Delete">
                                                                <a class="remove-item-btn" href="javascript:void(0);" onclick="showDeleteModal(' . $row['booking_id'] . ')">
                                                                    <i class="ri-delete-bin-fill align-bottom text-muted"></i>
                                                                </a>
                                                            </li>
                                                        
                                                        </ul>
                                                        </td>';
                                                        echo "</tr>";
                                                    }
                                                } else {
                                                    echo "<tr><td colspan='10'>No cargo bookings found</td></tr>";
                                                }
                                                
                                                $conn->close();
                                                ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end row -->

                    

                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

            <?php include 'layouts/footer.php'; ?>
        </div>
        <!-- end main content-->

    </div>
    <!-- END layout-wrapper -->


    <?php include 'layouts/vendor-scripts.php'; ?>

    <!-- apexcharts -->
    <script src="assets/libs/apexcharts/apexcharts.min.js"></script>

    <!-- projects js -->
    <script src="assets/js/pages/dashboard-projects.init.js"></script>

    <!-- App js -->
    <script src="assets/js/app.js"></script>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        const allFlightSchedules = <?php echo $flightSchedulesJson; ?>;

        // Initialize Flatpickr Calendar
        flatpickr("#flight-calendar", {
            inline: true,
            dateFormat: "Y-m-d",
            defaultDate: "today",
            onChange: function(selectedDates, dateStr, instance) {
                // When the date changes, filter the flight schedules
                filterFlightSchedules(dateStr);
            }
        });

        // Initial call to populate the list with today's schedules
        filterFlightSchedules(new Date().toISOString().split('T')[0]);

        function filterFlightSchedules(selectedDate) {
            const scheduleList = document.getElementById('flight-schedule-list');
            scheduleList.innerHTML = '';

            // Convert selected date to a Date object for comparison
            const selectedDateObj = new Date(selectedDate);
            const formattedSelectedDate = selectedDateObj.toISOString().split('T')[0]; // Get YYYY-MM-DD format
            const selectedDay = selectedDateObj.toLocaleString('en-us', {weekday: 'short'});

            // Filter schedules based on selected date
            const matchingSchedules = allFlightSchedules.filter(schedule => {
                const startDate = new Date(schedule.start_date);
                const endDate = new Date(schedule.end_date);
                const daysOfWeek = schedule.days_of_week.split(',');
                
                return (startDate <= selectedDateObj && endDate >= selectedDateObj) && 
                       daysOfWeek.map(day => day.trim()).includes(selectedDay.substring(0, 3)); // Use first 3 letters of day name
            });

            if (matchingSchedules.length > 0) {
                matchingSchedules.forEach(schedule => {
                    // Create the schedule item dynamically
                    const scheduleItem = `
                        <div class="mini-stats-wid d-flex align-items-center mt-3">
                            <div class="flex-shrink-0 avatar-sm">
                                <span class="mini-stat-icon avatar-title rounded-circle text-primary bg-primary-subtle fs-4">
                                    ${selectedDateObj.getDate()}
                                </span>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <h6 class="mb-1">${schedule.flight_number}</h6>
                                <p class="text-muted mb-0">${schedule.origin_city} to ${schedule.destination_city}</p>
                            </div>
                            <div class="flex-shrink-0">
                                <p class="text-muted mb-0">${new Date('1970-01-01T' + schedule.departure_time + 'Z').toLocaleTimeString('en-US', { hour: '2-digit', minute: '2-digit' })}</p>
                            </div>
                        </div>`;
                    scheduleList.innerHTML += scheduleItem;
                });
            } else {
                // No schedules found for the selected date
                scheduleList.innerHTML = '<p class="text-muted mb-0">No upcoming schedules found for this date.</p>';
            }
        }
    });
</script>
</body>

</html>