<?php 
include 'layouts/session.php';
include 'layouts/main.php';
?>
<?php include 'layouts/dbconn.php'; ?>

<?php
$customer_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Fetch customer and default address
$query = "SELECT c.*, 
          ca.address_id, ca.address_type, ca.street_address, ca.city, ca.state, 
          ca.postal_code, ca.country
          FROM customers c
          LEFT JOIN customer_addresses ca ON c.customer_id = ca.customer_id AND ca.is_default = 1
          WHERE c.customer_id = ?";

$stmt = $conn->prepare($query);
$stmt->bind_param("i", $customer_id);
$stmt->execute();
$result = $stmt->get_result();
$customer = $result->fetch_assoc();
?>

<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable">

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Edit Customer')); ?>
    <?php include 'layouts/head-css.php'; ?>
    <link href="assets/libs/sweetalert2/sweetalert2.min.css" rel="stylesheet" type="text/css" />
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Customer Management', 'title' => 'Edit Customer')); ?>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Edit Customer Information</h4>
                                </div>
                                <div class="card-body">
                                    <form id="editCustomerForm" method="POST" action="update_customer.php">
                                        <input type="hidden" name="customer_id" value="<?php echo $customer_id; ?>">
                                        <input type="hidden" name="address_id" value="<?php echo $customer['address_id']; ?>">
                                        
                                        <div class="row">
                                            <div class="col-md-6">
                                                <h5 class="mb-4">Personal Information</h5>
                                                <div class="mb-3">
                                                    <label for="first_name" class="form-label">First Name</label>
                                                    <input type="text" class="form-control" id="first_name" name="first_name" 
                                                           value="<?php echo htmlspecialchars($customer['first_name']); ?>" required>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="last_name" class="form-label">Last Name</label>
                                                    <input type="text" class="form-control" id="last_name" name="last_name" 
                                                           value="<?php echo htmlspecialchars($customer['last_name']); ?>" required>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="email" class="form-label">Email</label>
                                                    <input type="email" class="form-control" id="email" name="email" 
                                                           value="<?php echo htmlspecialchars($customer['email']); ?>" required>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="phone_number" class="form-label">Phone Number</label>
                                                    <input type="tel" class="form-control" id="phone_number" name="phone_number" 
                                                           value="<?php echo htmlspecialchars($customer['phone_number']); ?>">
                                                </div>
                                                <div class="mb-3">
                                                    <label for="passport" class="form-label">Passport Number</label>
                                                    <input type="text" class="form-control" id="passport" name="passport" 
                                                           value="<?php echo htmlspecialchars($customer['passport']); ?>">
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <h5 class="mb-4">Default Address</h5>
                                                <div class="mb-3">
                                                    <label for="address_type" class="form-label">Address Type</label>
                                                    <select class="form-select" id="address_type" name="address_type" required>
                                                        <option value="home" <?php echo $customer['address_type'] == 'home' ? 'selected' : ''; ?>>Home</option>
                                                        <option value="office" <?php echo $customer['address_type'] == 'office' ? 'selected' : ''; ?>>Office</option>
                                                        <option value="other" <?php echo $customer['address_type'] == 'other' ? 'selected' : ''; ?>>Other</option>
                                                    </select>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="street_address" class="form-label">Street Address</label>
                                                    <textarea class="form-control" id="street_address" name="street_address" required><?php echo htmlspecialchars($customer['street_address']); ?></textarea>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="city" class="form-label">City</label>
                                                    <input type="text" class="form-control" id="city" name="city" 
                                                           value="<?php echo htmlspecialchars($customer['city']); ?>" required>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="state" class="form-label">State/Province</label>
                                                    <input type="text" class="form-control" id="state" name="state" 
                                                           value="<?php echo htmlspecialchars($customer['state']); ?>">
                                                </div>
                                                <div class="mb-3">
                                                    <label for="postal_code" class="form-label">Postal Code</label>
                                                    <input type="text" class="form-control" id="postal_code" name="postal_code" 
                                                           value="<?php echo htmlspecialchars($customer['postal_code']); ?>" required>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="country" class="form-label">Country</label>
                                                    <input type="text" class="form-control" id="country" name="country" 
                                                           value="<?php echo htmlspecialchars($customer['country']); ?>" required>
                                                </div>
                                            </div>

                                            <div class="col-12 mt-4">
                                                <button type="submit" class="btn btn-primary">Update Customer</button>
                                                <a href="customer_view.php?id=<?php echo $customer_id; ?>" class="btn btn-secondary">Cancel</a>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <!-- Additional Addresses Section -->
                        <div class="col-lg-12 mt-4">
                            <div class="card">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h4 class="card-title mb-0">Additional Addresses</h4>
                                    <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addAddressModal">
                                        Add New Address
                                    </button>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>Type</th>
                                                    <th>Address</th>
                                                    <th>City</th>
                                                    <th>State</th>
                                                    <th>Country</th>
                                                    <th>Status</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $addressQuery = "SELECT * FROM customer_addresses WHERE customer_id = ? AND is_default = 0";
                                                $stmt = $conn->prepare($addressQuery);
                                                $stmt->bind_param("i", $customer_id);
                                                $stmt->execute();
                                                $addresses = $stmt->get_result();
                                                
                                                while ($address = $addresses->fetch_assoc()) {
                                                    echo "<tr>";
                                                    echo "<td>" . ucfirst($address['address_type']) . "</td>";
                                                    echo "<td>" . htmlspecialchars($address['street_address']) . "</td>";
                                                    echo "<td>" . htmlspecialchars($address['city']) . "</td>";
                                                    echo "<td>" . htmlspecialchars($address['state']) . "</td>";
                                                    echo "<td>" . htmlspecialchars($address['country']) . "</td>";
                                                    echo "<td>" . ($address['is_default'] ? '<span class="badge bg-success">Default</span>' : '') . "</td>";
                                                    echo "<td>
                                                            <button class='btn btn-sm btn-primary me-1' onclick='editAddress(" . $address['address_id'] . ")'>Edit</button>
                                                            <button class='btn btn-sm btn-danger' onclick='deleteAddress(" . $address['address_id'] . ")'>Delete</button>
                                                          </td>";
                                                    echo "</tr>";
                                                }
                                                ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>
    
        <!-- Add Address Modal -->
    <div class="modal fade" id="addAddressModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add New Address</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="addAddressForm" method="POST" action="save_address.php">
                        <input type="hidden" name="customer_id" value="<?php echo $customer_id; ?>">
                        <div class="mb-3">
                            <label class="form-label">Address Type</label>
                            <select class="form-select" name="address_type" required>
                                <option value="home">Home</option>
                                <option value="office">Office</option>
                                <option value="other">Other</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Street Address</label>
                            <textarea class="form-control" name="street_address" required></textarea>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">City</label>
                            <input type="text" class="form-control" name="city" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">State</label>
                            <input type="text" class="form-control" name="state">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Postal Code</label>
                            <input type="text" class="form-control" name="postal_code" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Country</label>
                            <input type="text" class="form-control" name="country" required>
                        </div>
                        <div class="text-end">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-primary">Save Address</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="assets/libs/sweetalert2/sweetalert2.min.js"></script>
    <script>
    function deleteAddress(addressId) {
        if (confirm("Are you sure you want to delete this address?")) {
            window.location.href = `delete_address.php?id=${addressId}&customer_id=<?php echo $customer_id; ?>`;
        }
    }

    function editAddress(addressId) {
        window.location.href = `edit_address.php?id=${addressId}&customer_id=<?php echo $customer_id; ?>`;
    }
    </script>
</body>
</html>