<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>
<?php include 'layouts/dbconn.php'; ?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Passport Extensions')); ?>
    <?php include 'layouts/head-css.php'; ?>
    <!-- DataTables CSS -->
    <link href="assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css" rel="stylesheet">
</head>

<body>
    <!-- Begin page -->
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Extensions', 'title' => 'Passport Extensions')); ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header d-flex align-items-center">
                                    <h5 class="card-title mb-0 flex-grow-1">All Passport Extensions</h5>
                                    <a href="add_extension.php" class="btn btn-primary">
                                        <i class="ri-add-line align-middle me-1"></i> Add New Extension
                                    </a>
                                </div>
                                <div class="card-body">
                                    <table id="extensions-table" class="table table-bordered dt-responsive nowrap table-striped">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>Date</th>
                                                <th>Client Name</th>
                                                <th>Passport Number</th>
                                                <th>Service Type</th>
                                                <th>Expiry Date</th>
                                                <th>Amount</th>
                                                <th>Agency Fee</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $sql = "SELECT * FROM passport_extensions ORDER BY extension_date DESC";
                                            $result = $conn->query($sql);

                                            if ($result->num_rows > 0) {
                                                while($row = $result->fetch_assoc()) {
                                                    $statusClass = '';
                                                    switch($row['payment_status']) {
                                                        case 'paid':
                                                            $statusClass = 'badge bg-success';
                                                            break;
                                                        case 'unpaid':
                                                            $statusClass = 'badge bg-danger';
                                                            break;
                                                        case 'partial':
                                                            $statusClass = 'badge bg-warning';
                                                            break;
                                                    }

                                                    echo "<tr>";
                                                    echo "<td>{$row['extension_id']}</td>";
                                                    echo "<td>" . date('d M Y', strtotime($row['extension_date'])) . "</td>";
                                                    echo "<td>{$row['client_name']}</td>";
                                                    echo "<td>{$row['passport_number']}</td>";
                                                    echo "<td>" . ucfirst($row['service_type']) . "</td>";
                                                    echo "<td>" . date('d M Y', strtotime($row['expiry_date'])) . "</td>";
                                                    echo "<td>" . $row['currency'] . " " . number_format($row['amount_received'], 2) . "</td>";
                                                    echo "<td>" . $row['currency'] . " " . number_format($row['agency_fee'], 2) . "</td>";
                                                    echo "<td><span class='{$statusClass}'>" . ucfirst($row['payment_status']) . "</span></td>";
                                                    echo "<td>
                                                            <div class='d-flex gap-2'>
                                                                <a href='view_extension.php?id={$row['extension_id']}' 
                                                                   class='btn btn-sm btn-soft-primary'>
                                                                    <i class='ri-eye-fill'></i>
                                                                </a>
                                                                <a href='print_extension.php?id={$row['extension_id']}' 
                                                                   class='btn btn-sm btn-soft-info'>
                                                                    <i class='ri-printer-line'></i>
                                                                </a>
                                                                <button type='button' 
                                                                        class='btn btn-sm btn-soft-danger delete-extension'
                                                                        data-id='{$row['extension_id']}'>
                                                                    <i class='ri-delete-bin-line'></i>
                                                                </button>
                                                            </div>
                                                          </td>";
                                                    echo "</tr>";
                                                }
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    
    <!-- DataTables JS -->
    <script src="assets/libs/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="assets/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js"></script>
    <!-- App js -->
    <script src="assets/js/app.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <script>
    $(document).ready(function() {
        // Initialize DataTable
        $('#extensions-table').DataTable({
            order: [[1, 'desc']], // Sort by date descending
            pageLength: 25,
            language: {
                search: "_INPUT_",
                searchPlaceholder: "Search extensions..."
            }
        });

        // Handle delete button clicks
        $('.delete-extension').on('click', function() {
            const extensionId = $(this).data('id');
            
            Swal.fire({
                title: 'Are you sure?',
                text: "This action cannot be undone",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonClass: 'btn btn-primary w-xs me-2 mt-2',
                cancelButtonClass: 'btn btn-danger w-xs mt-2',
                confirmButtonText: 'Yes, delete it!',
                buttonsStyling: false,
                showCloseButton: true
            }).then((result) => {
                if (result.isConfirmed) {
                    // Send delete request
                    $.ajax({
                        url: 'delete_extension.php',
                        type: 'POST',
                        data: { extension_id: extensionId },
                        success: function(response) {
                            const data = JSON.parse(response);
                            if (data.success) {
                                Swal.fire({
                                    title: 'Deleted!',
                                    text: data.message,
                                    icon: 'success',
                                    confirmButtonClass: 'btn btn-primary w-xs mt-2',
                                    buttonsStyling: false
                                }).then(() => {
                                    location.reload();
                                });
                            } else {
                                Swal.fire({
                                    title: 'Error!',
                                    text: data.message,
                                    icon: 'error',
                                    confirmButtonClass: 'btn btn-primary w-xs mt-2',
                                    buttonsStyling: false
                                });
                            }
                        },
                        error: function() {
                            Swal.fire({
                                title: 'Error!',
                                text: 'Failed to delete extension',
                                icon: 'error',
                                confirmButtonClass: 'btn btn-primary w-xs mt-2',
                                buttonsStyling: false
                            });
                        }
                    });
                }
            });
        });
    }
    function formatMoney($amount, $currency) {
    return $currency . " " . number_format($amount, 2);
}
    );
    </script>
</body>
</html>