<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>
<?php include 'layouts/dbconn.php'; ?>

<head>

    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'All Booking Cancellations')); ?>

    <!--datatable css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />
    <!--datatable responsive css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />

    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">


    <?php include 'layouts/head-css.php'; ?>

</head>

<body>

    <!-- Begin page -->
    <div id="layout-wrapper">

        <?php include 'layouts/menu.php'; ?>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Bookings Management', 'title' => 'All Booking Cancellations')); ?>


                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h5 class="card-title mb-0">Booking Cancellations</h5>
                                </div>
                                <div class="card-body">
                                    <table id="cancellations-table" class="table table-bordered dt-responsive nowrap">
                                        <thead>
                                            <tr>
                                                <th>Booking Code</th>
                                                <th>Customer</th>
                                                <th>Booking Date</th>
                                                <th>Total Amount</th>
                                                <th>Cancellation Date</th>
                                                <th>Refund Amount</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $query = "SELECT b.*, 
                                                     CONCAT(c.first_name, ' ', c.last_name) as customer_name,
                                                     c.email as customer_email
                                                     FROM bookings b
                                                     LEFT JOIN customers c ON b.customer_id = c.customer_id
                                                     WHERE b.status = 'Cancelled'
                                                     ORDER BY b.cancellation_date DESC";
                                            
                                            $result = $conn->query($query);
                                            while($row = $result->fetch_assoc()):
                                            ?>
                                            <tr>
                                                <td><?php echo $row['booking_code']; ?></td>
                                                <td>
                                                    <div>
                                                        <h5 class="font-size-14 mb-1">
                                                            <?php echo htmlspecialchars($row['customer_name']); ?>
                                                        </h5>
                                                        <p class="text-muted mb-0"><?php echo $row['customer_email']; ?></p>
                                                    </div>
                                                </td>
                                                <td><?php echo date('d M Y', strtotime($row['booking_date'])); ?></td>
                                                <td><?php echo number_format($row['total_amount'], 2); ?></td>
                                                <td><?php echo date('d M Y', strtotime($row['cancellation_date'])); ?></td>
                                                <td>
                                                    <?php 
                                                    if ($row['refund_amount']) {
                                                        echo number_format($row['refund_amount'], 2);
                                                    } else {
                                                        echo '<span class="badge bg-warning">Pending</span>';
                                                    }
                                                    ?>
                                                </td>
                                                <td>
                                                    <?php if ($row['refund_date']): ?>
                                                        <span class="badge bg-success">Refunded</span>
                                                    <?php else: ?>
                                                        <span class="badge bg-info">Processing</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <div class="dropdown">
                                                        <button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown">
                                                            <i class="ri-more-fill align-middle"></i>
                                                        </button>
                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                            <li>
                                                                <a href="view_cancellation.php?id=<?php echo $row['booking_id']; ?>" class="dropdown-item">
                                                                    <i class="ri-eye-fill align-bottom me-2 text-muted"></i> View
                                                                </a>
                                                            </li>
                                                            <?php if (!$row['refund_date']): ?>
                                                            <li>
                                                                <a href="process_refund.php?id=<?php echo $row['booking_id']; ?>" class="dropdown-item">
                                                                    <i class="ri-money-dollar-circle-fill align-bottom me-2 text-muted"></i> Process Refund
                                                                </a>
                                                            </li>
                                                            <?php endif; ?>
                                                            <li>
                                                                <a href="edit_cancellation.php?id=<?php echo $row['booking_id']; ?>" class="dropdown-item">
                                                                    <i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Edit
                                                                </a>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php endwhile; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

            <?php include 'layouts/footer.php'; ?>
        </div>
        <!-- end main content-->

    </div>
    <!-- END layout-wrapper -->


    <?php include 'layouts/vendor-scripts.php'; ?>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

    <script src="assets/js/pages/datatables.init.js"></script>
    <!-- App js -->
    <script src="assets/js/app.js"></script>
    <script>
    $(document).ready(function() {
        $('#cancellations-table').DataTable({
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],
            order: [[4, 'desc']],
            pageLength: 10
        });
    });
    </script>
</body>

</html>