<?php
include 'layouts/session.php';
include 'layouts/dbconn.php';

// Get the booking number from the URL
$booking_number = isset($_GET['booking_number']) ? $_GET['booking_number'] : '';

// Fetch cargo details
$query = "
    SELECT
        cb.*,
        CONCAT(sc.first_name, ' ', sc.last_name) AS sender_name,
        sc.phone_number AS sender_phone,
        sca.street_address AS sender_street_address,
        sca.city AS sender_city,
        sca.state AS sender_state,
        sca.postal_code AS sender_postal_code,
        sca.country AS sender_country,
        CONCAT(rc.first_name, ' ', rc.last_name) AS receiver_name,
        rc.phone_number AS receiver_phone,
        rca.street_address AS receiver_street_address,
        rca.city AS receiver_city,
        rca.state AS receiver_state,
        rca.postal_code AS receiver_postal_code,
        rca.country AS receiver_country
    FROM
        cargo_bookings cb
    LEFT JOIN
        customers sc ON cb.sender_customer_id = sc.customer_id
    LEFT JOIN
        customer_addresses sca ON cb.sender_address_id = sca.address_id
    LEFT JOIN
        customers rc ON cb.receiver_customer_id = rc.customer_id
    LEFT JOIN
        customer_addresses rca ON cb.receiver_address_id = rca.address_id
    WHERE
        cb.booking_number = ?
";

$stmt = $conn->prepare($query);
$stmt->bind_param("s", $booking_number);
$stmt->execute();
$result = $stmt->get_result();
$cargoDetails = $result->fetch_assoc();

if (!$cargoDetails) {
    $_SESSION['error_message'] = 'Cargo details not found.';
    header("Location: all_cargo.php");
    exit();
}

// Get the current domain and protocol for QR code
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://';
$domain = $_SERVER['HTTP_HOST'];
$tracking_url = $protocol . $domain . "/tracking.php?booking=" . $cargoDetails['booking_number'];
?>

<!DOCTYPE html>
<html>
<head>
    <title>Cargo Shipping Label - <?php echo htmlspecialchars($booking_number); ?></title>
    <style>
        @page {
            size: A5;
            margin: 0;
        }
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            -webkit-print-color-adjust: exact;
        }
        .shipping-label {
            width: 148mm;
            min-height: 210mm;
            margin: 0 auto;
            border: 2px solid #000;
            padding: 20px;
            box-sizing: border-box;
        }
        .header {
            text-align: center;
            border-bottom: 2px solid #000;
            padding-bottom: 15px;
            margin-bottom: 15px;
        }
        .company-logo {
            max-width: 150px;
            margin: 0 auto 10px;
        }
        .company-name {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        .tracking-number {
            font-size: 18px;
            font-weight: bold;
            margin: 10px 0;
        }
        .address-block {
            margin: 15px 0;
        }
        .address-title {
            font-weight: bold;
            font-size: 18px;
            margin-bottom: 5px;
        }
        .package-details {
            border-top: 2px solid #000;
            border-bottom: 2px solid #000;
            padding: 15px 0;
            margin: 15px 0;
        }
        .details-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        .qr-container {
            text-align: center;
            margin: 20px 0;
        }
        .qr-code {
            width: 100px;
            height: 100px;
            margin: 0 auto;
        }
        .scan-text {
            font-size: 12px;
            color: #5b5b5b;
            margin-top: 5px;
        }
        .print-button {
            text-align: center;
            margin-top: 20px;
        }
        .print-button button {
            padding: 10px 20px;
            background: #4CAF50;
            color: white;
            border: none;
            cursor: pointer;
            font-size: 16px;
        }
        @media print {
            .print-button {
                display: none;
            }
            body {
                padding: 0;
            }
            .shipping-label {
                border: 2px solid #000;
            }
        }
    </style>
</head>
<body>
    <div class="shipping-label">
        <!-- Header -->
        <div class="header">
            <img src="assets/images/awt_logo.png" alt="Company Logo" class="company-logo">
            <div class="company-name">African Wings Travel & Cargo Agency</div>
            <div>Phone: +(254) 234 6789</div>
            <div>Nairobi, Kenya</div>
        </div>

        <!-- Tracking Number -->
        <div class="tracking-number">
            Tracking Number: <?php echo htmlspecialchars($cargoDetails['booking_number']); ?>
        </div>

        <!-- From Address -->
        <div class="address-block">
            <div class="address-title">FROM:</div>
            <div><?php echo htmlspecialchars($cargoDetails['sender_name']); ?></div>
            <div><?php echo htmlspecialchars($cargoDetails['sender_street_address']); ?></div>
            <div>
                <?php echo htmlspecialchars($cargoDetails['sender_city']); ?>, 
                <?php echo htmlspecialchars($cargoDetails['sender_state']); ?>
            </div>
            <div><?php echo htmlspecialchars($cargoDetails['sender_postal_code']); ?></div>
            <div><?php echo htmlspecialchars($cargoDetails['sender_country']); ?></div>
            <div>Phone: <?php echo htmlspecialchars($cargoDetails['sender_phone']); ?></div>
        </div>

        <!-- To Address -->
        <div class="address-block">
            <div class="address-title">TO:</div>
            <div><?php echo htmlspecialchars($cargoDetails['receiver_name']); ?></div>
            <div><?php echo htmlspecialchars($cargoDetails['receiver_street_address']); ?></div>
            <div>
                <?php echo htmlspecialchars($cargoDetails['receiver_city']); ?>, 
                <?php echo htmlspecialchars($cargoDetails['receiver_state']); ?>
            </div>
            <div><?php echo htmlspecialchars($cargoDetails['receiver_postal_code']); ?></div>
            <div><?php echo htmlspecialchars($cargoDetails['receiver_country']); ?></div>
            <div>Phone: <?php echo htmlspecialchars($cargoDetails['receiver_phone']); ?></div>
        </div>

        <!-- Package Details -->
        <div class="package-details">
            <div class="details-row">
                <div><strong>Weight:</strong> <?php echo htmlspecialchars($cargoDetails['weight']); ?> kg</div>
                <div><strong>Dimensions:</strong> <?php echo htmlspecialchars($cargoDetails['dimensions']); ?></div>
            </div>
            <div class="details-row">
                <div><strong>Cargo Type:</strong> <?php echo htmlspecialchars($cargoDetails['cargo_type']); ?></div>
            </div>
            <?php if (!empty($cargoDetails['special_instructions'])): ?>
            <div>
                <strong>Special Instructions:</strong>
                <div><?php echo htmlspecialchars($cargoDetails['special_instructions']); ?></div>
            </div>
            <?php endif; ?>
        </div>

        <!-- QR Code -->
        <div class="qr-container">
            <img src="https://api.qrserver.com/v1/create-qr-code/?size=100x100&data=<?php echo urlencode($tracking_url); ?>" 
                 alt="Tracking QR Code" 
                 class="qr-code">
            <div class="scan-text">
                Scan to track your cargo
            </div>
        </div>
    </div>

    <!-- Print Button -->
    <div class="print-button">
        <button onclick="window.print()">Print Label</button>
    </div>
</body>
</html>