<?php
session_start();
include 'layouts/dbconn.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    exit(json_encode(['status' => 'error', 'message' => 'Not authenticated']));
}

// Get parameters
$action = $_POST['action'] ?? '';
$file_id = $_POST['file_id'] ?? '';
$file_number = $_POST['file_number'] ?? '';
$user_id = $_SESSION['user_id'];
$ip_address = $_SERVER['REMOTE_ADDR'];

// Log the action
$sql = "INSERT INTO admin_logs (user_id, action, details, ip_address, created_at) 
        VALUES (?, ?, ?, ?, NOW())";
$stmt = $conn->prepare($sql);

$details = '';
if ($action === 'delete_button_click') {
    $details = "User clicked delete button for file ID: $file_id, File Number: $file_number";
} elseif ($action === 'delete_cancelled') {
    $details = "User cancelled deletion for file ID: $file_id, File Number: $file_number";
}

$stmt->bind_param('isss', $user_id, $action, $details, $ip_address);
$stmt->execute();

// Return success
echo json_encode(['status' => 'success']);
exit();
?>