<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>
<?php include 'layouts/dbconn.php'; ?>

<?php
$booking_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

$query = "SELECT b.*, 
          CONCAT(c.first_name, ' ', c.last_name) as customer_name,
          f.flight_number
          FROM bookings b
          LEFT JOIN customers c ON b.customer_id = c.customer_id
          LEFT JOIN flights f ON b.flight_id = f.flight_id
          WHERE b.booking_id = ? AND b.status = 'Cancelled'";

$stmt = $conn->prepare($query);
$stmt->bind_param("i", $booking_id);
$stmt->execute();
$booking = $stmt->get_result()->fetch_assoc();

if (!$booking) {
    $_SESSION['error_msg'] = "Invalid booking or not cancelled";
    header("Location: cancellations.php");
    exit();
}
?>

<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable">

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Edit Customer')); ?>
    <?php include 'layouts/head-css.php'; ?>
    <link href="assets/libs/sweetalert2/sweetalert2.min.css" rel="stylesheet" type="text/css" />
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Customer Management', 'title' => 'Edit Customer')); ?>

                    <div class="row justify-content-center">
                        <div class="col-lg-8">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Edit Cancellation Details</h4>
                                </div>
                                <div class="card-body">
                                    <form action="update_cancellation.php" method="post">
                                        <input type="hidden" name="booking_id" value="<?php echo $booking_id; ?>">
                                        
                                        <div class="mb-3">
                                            <label class="form-label">Booking Reference</label>
                                            <input type="text" class="form-control" value="<?php echo $booking['booking_code']; ?>" readonly>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Customer</label>
                                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($booking['customer_name']); ?>" readonly>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Cancellation Reason</label>
                                            <textarea class="form-control" name="cancellation_reason" rows="4" required><?php echo htmlspecialchars($booking['cancellation_reason']); ?></textarea>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Refund Amount</label>
                                                    <input type="number" step="0.01" class="form-control" name="refund_amount" 
                                                           value="<?php echo $booking['refund_amount']; ?>" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Refund Date</label>
                                                    <input type="date" class="form-control" name="refund_date" 
                                                           value="<?php echo $booking['refund_date'] ? date('Y-m-d', strtotime($booking['refund_date'])) : ''; ?>">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row mt-4">
                                            <div class="col-12 text-end">
                                                <a href="cancellations.php" class="btn btn-secondary me-2">Cancel</a>
                                                <button type="submit" class="btn btn-primary">Update Cancellation</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>


    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="assets/libs/sweetalert2/sweetalert2.min.js"></script>

</body>
</html>