<?php
include 'layouts/session.php';
include 'layouts/main.php';
include 'layouts/dbconn.php';

// Get the payment_id from the URL
$payment_id = isset($_GET['booking_id']) ? intval($_GET['booking_id']) : 0;

// Fetch payment details from the database
$stmt = $conn->prepare("SELECT * FROM cargo_bookings WHERE booking_id = ?");
$stmt->bind_param("i", $payment_id);
$stmt->execute();
$result = $stmt->get_result();
$payment = $result->fetch_assoc();
$stmt->close();

// Fetch booking and customer details related to the payment
if ($payment) {
    $booking_id = $payment['booking_id'];
    $query = "
        SELECT
            cb.*,
            sc.first_name AS sender_first_name,
            sc.last_name AS sender_last_name,
            sc.email AS sender_email,
            sc.phone_number AS sender_phone,
            sca.street_address AS sender_street_address,
            sca.city AS sender_city,
            sca.state AS sender_state,
            sca.postal_code AS sender_postal_code,
            sca.country AS sender_country,
            rc.first_name AS receiver_first_name,
            rc.last_name AS receiver_last_name,
            rc.email AS receiver_email,
            rc.phone_number AS receiver_phone,
            rca.street_address AS receiver_street_address,
            rca.city AS receiver_city,
            rca.state AS receiver_state,
            rca.postal_code AS receiver_postal_code,
            rca.country AS receiver_country
        FROM
            cargo_bookings cb
        LEFT JOIN
            customers sc ON cb.sender_customer_id = sc.customer_id
        LEFT JOIN
            customer_addresses sca ON cb.sender_address_id = sca.address_id
        LEFT JOIN
            customers rc ON cb.receiver_customer_id = rc.customer_id
        LEFT JOIN
            customer_addresses rca ON cb.receiver_address_id = rca.address_id
        WHERE
            cb.booking_id = ?
    ";
    $bookingStmt = $conn->prepare($query);
    $bookingStmt->bind_param("i", $booking_id);
    $bookingStmt->execute();
    $bookingResult = $bookingStmt->get_result();
    $booking = $bookingResult->fetch_assoc();
    $bookingStmt->close();
}
?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Payment View')); ?>
    <!--datatable css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />
    <!--datatable responsive css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
    <?php include 'layouts/head-css.php'; ?>
</head>

<body>
    <!-- Begin page -->
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Payments & Invoicing', 'title' => 'Payment View')); ?>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">Payment Details</h5>
                                </div>
                                <div class="card" id="demo">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="card-header border-bottom-dashed p-4">
                                                <div class="d-flex">
                                                    <div class="flex-grow-1">
                                                        <img src="assets/images/awt_logo.png" class="card-logo card-logo-dark" alt="logo dark" height="40">
                                                        <img src="assets/images/awt_logo.png" class="card-logo card-logo-light" alt="logo light" height="40">
                                                        <div class="mt-sm-5 mt-4">
                                                            <h6 class="text-muted text-uppercase fw-semibold">Address</h6>
                                                            <p class="text-muted mb-1" id="address-details">Nairobi, Kenya</p>
                                                            <p class="text-muted mb-0" id="zip-code"><span>Zip-code:</span> 00100</p>
                                                        </div>
                                                    </div>
                                                    <div class="flex-shrink-0 mt-sm-0 mt-3">
                                                        <h6><span class="text-muted fw-normal">Legal Registration No:</span><span id="legal-register-no">987654</span></h6>
                                                        <h6><span class="text-muted fw-normal">Email:</span><span id="email">info@africanwingstravel.com</span></h6>
                                                        <h6><span class="text-muted fw-normal">Website:</span> <a href="https://africanwingstravel.com/" class="link-primary" target="_blank" id="website">www.africanwingstravel.com</a></h6>
                                                        <h6 class="mb-0"><span class="text-muted fw-normal">Contact No: </span><span id="contact-no"> +(254) 234 6789</span></h6>
                                                    </div>
                                                </div>
                                            </div>
                                            <!--end card-header-->
                                        </div><!--end col-->
                                        <div class="col-lg-12">
                                            <div class="card-body p-4">
                                                <div class="row g-3">
                                                    <div class="col-lg-3 col-6">
                                                        <p class="text-muted mb-2 text-uppercase fw-semibold">Invoice No</p>
                                                        <h5 class="fs-15 mb-0">#VL<span id="invoice-no"><?php echo $payment['booking_id']; ?></span></h5>
                                                    </div>
                                                    <!--end col-->
                                                    <div class="col-lg-3 col-6">
                                                        <p class="text-muted mb-2 text-uppercase fw-semibold">Date</p>
                                                        <h5 class="fs-15 mb-0"><span id="invoice-date"><?php echo date('d M, Y', strtotime($payment['payment_date'])); ?></span> <small class="text-muted" id="invoice-time"><?php echo date('h:i A', strtotime($payment['payment_date'])); ?></small></h5>
                                                    </div>
                                                    <!--end col-->
                                                    <div class="col-lg-3 col-6">
                                                        <p class="text-muted mb-2 text-uppercase fw-semibold">Payment Status</p>
                                                        <span class="badge bg-success-subtle text-success fs-11" id="payment-status"><?php echo $payment['payment_status']; ?></span>
                                                    </div>
                                                    <!--end col-->
                                                    <div class="col-lg-3 col-6">
                                                        <p class="text-muted mb-2 text-uppercase fw-semibold">Total Amount</p>
                                                        <h5 class="fs-15 mb-0">$<span id="total-amount"><?php echo number_format($payment['total_amount'], 2); ?></span></h5>
                                                    </div>
                                                    <!--end col-->
                                                </div>
                                                <!--end row-->
                                            </div>
                                            <!--end card-body-->
                                        </div><!--end col-->
                                        <div class="col-lg-12">
                                            <div class="card-body p-4 border-top border-top-dashed">
                                                <div class="row g-3">
                                                    <div class="col-6">
                                                        <h6 class="text-muted text-uppercase fw-semibold mb-3">Billing Address</h6>
                                                        <p class="fw-medium mb-2" id="billing-name"><?php echo $booking['sender_first_name'] . ' ' . $booking['sender_last_name']; ?></p>
                                                        <p class="text-muted mb-1" id="billing-address-line-1"><?php echo $booking['sender_street_address'] . ', ' . $booking['sender_city'] . ', ' . $booking['sender_state'] . ', ' . $booking['sender_postal_code'] . ', ' . $booking['sender_country']; ?></p>
                                                        <p class="text-muted mb-1"><span>Phone: </span><span id="billing-phone-no"><?php echo $booking['sender_phone']; ?></span></p>
                                                    </div>
                                                    <!--end col-->
                                                    <div class="col-6">
                                                        <h6 class="text-muted text-uppercase fw-semibold mb-3">Shipping Address</h6>
                                                        <p class="fw-medium mb-2" id="shipping-name"><?php echo $booking['receiver_first_name'] . ' ' . $booking['receiver_last_name']; ?></p>
                                                        <p class="text-muted mb-1" id="shipping-address-line-1"><?php echo $booking['receiver_street_address'] . ', ' . $booking['receiver_city'] . ', ' . $booking['receiver_state'] . ', ' . $booking['receiver_postal_code'] . ', ' . $booking['receiver_country']; ?></p>
                                                        <p class="text-muted mb-1"><span>Phone: </span><span id="shipping-phone-no"><?php echo $booking['receiver_phone']; ?></span></p>
                                                    </div>
                                                    <!--end col-->
                                                </div>
                                                <!--end row-->
                                            </div>
                                            <!--end card-body-->
                                        </div><!--end col-->
                                        <div class="col-lg-12">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table class="table table-borderless text-center table-nowrap align-middle mb-0">
                                                        <thead>
                                                            <tr class="table-active">
                                                                <th scope="col" style="width: 50px;">#</th>
                                                                <th scope="col">Booking Number</th>
                                                                <th scope="col">Weight</th>
                                                                <th scope="col">Cargo Type</th>
                                                                <th scope="col">Special Instructions</th>
                                                                <th scope="col" class="text-end">Amount</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="products-list">
                                                            <!-- Main customer details -->
                                                            <tr>
                                                                <th scope="row">1</th>
                                                                <td class="text-start"><?php echo $booking['booking_number']; ?></td>
                                                                <td><?php echo number_format($payment['weight'], 2); ?></td>
                                                                <td><?php echo $booking['cargo_type']; ?></td>
                                                                <td><?php echo $booking['special_instructions']; ?></td>
                                                                <td class="text-end"><?php echo number_format($payment['total_amount'], 2); ?></td>
                                                            </tr>
                                                        </tbody>
                                                    </table><!--end table-->
                                                </div>
                                                <div class="border-top border-top-dashed mt-2">
                                                    <table class="table table-borderless table-nowrap align-middle mb-0 ms-auto" style="width:250px">
                                                        <tbody>
                                                            <tr>
                                                                <td>Sub Total</td>
                                                                <td class="text-end">$<?php echo number_format($payment['total_amount'], 2); ?></td>
                                                            </tr>
                                                            <tr class="border-top border-top-dashed fs-15">
                                                                <th scope="row">Total Amount</th>
                                                                <th class="text-end">$<?php echo number_format($payment['total_amount'], 2); ?></th>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                    <!--end table-->
                                                </div>
                                                <div class="mt-3">
                                                    <h6 class="text-muted text-uppercase fw-semibold mb-3">Payment Details:</h6>
                                                    <p class="text-muted mb-1">Payment Method: <span class="fw-medium" id="payment-method"><?php echo $payment['payment_method']; ?></span></p>
                                                    <p class="text-muted mb-1">Card Holder: <span class="fw-medium" id="card-holder-name"><?php echo $booking['sender_first_name'] . ' ' . $booking['sender_last_name']; ?></span></p>
                                                    <p class="text-muted">Total Amount: <span class="fw-medium">$</span><span id="card-total-amount"><?php echo number_format($payment['total_amount'], 2); ?></span></p>
                                                </div>
                                                <div class="mt-4">
                                                    <div class="alert alert-info">
                                                        <p class="mb-0"><span class="fw-semibold">NOTES:</span>
                                                            <span id="note">All accounts are to be paid within 2 days from receipt of invoice. To be paid by direct payment. If account is not paid within 2
                                                                days the tickets will not be issued.
                                                            </span>
                                                        </p>
                                                    </div>
                                                </div>
                                                <div class="hstack gap-2 justify-content-end d-print-none mt-4">
                                                    <a href="javascript:window.print()" class="btn btn-info"><i class="ri-printer-line align-bottom me-1"></i> Print</a>
                                                    <a href="javascript:void(0);" onclick="openThermalReceipt()" class="btn btn-secondary">
                                                        <i class="ri-printer-line align-bottom me-1"></i> Thermal Receipt
                                                    </a>
                                                    <a href="javascript:void(0);" class="btn btn-primary"><i class="ri-download-2-line align-bottom me-1"></i> Download</a>
                                                </div>
                                            </div>
                                            <!--end card-body-->
                                        </div><!--end col-->
                                    </div><!--end row-->
                                </div>
                            </div>
                        </div>
                    </div><!--end row-->
                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->
            <?php include 'layouts/footer.php'; ?>
        </div>
        <!-- end main content-->
    </div>
    <!-- END layout-wrapper -->
    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="assets/js/pages/datatables.init.js"></script>
    <!-- App js -->
    <script src="assets/js/app.js"></script>
    <script>
function openThermalReceipt() {
    var booking_id = <?php echo json_encode($payment['booking_id']); ?>;
    var receiptWindow = window.open('thermal_receipt.php?booking_id=' + booking_id, 'thermalReceipt', 'width=400,height=800');
}
</script>
</body>
</html>
