<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>
<?php include 'layouts/dbconn.php'; ?>

<head>

    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'All Payments')); ?>

    <!--datatable css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />
    <!--datatable responsive css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />

    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">


    <?php include 'layouts/head-css.php'; ?>

</head>

<body>

    <!-- Begin page -->
    <div id="layout-wrapper">

        <?php include 'layouts/menu.php'; ?>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Payments & Invoicing', 'title' => 'All Payments')); ?>


                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">All Payments</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="buttons-datatables" class="display table table-bordered" style="width:100%">
                                            <thead>
                                                <tr>
                                                    <th>Payment ID</th>
                                                    <th>Booking ID</th>
                                                    <th>Amount</th>
                                                    <th>Payment Date</th>
                                                    <th>Transaction ID</th>
                                                    <th>Payment Method</th>
                                                    <th>Payment Status</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                               <?php
                                                // Include the database connection file
                                                include('layouts/dbconn.php');
                                                
                                                $query = "SELECT * FROM payments";
                                                $result = $conn->query($query);
                                                
                                                if ($result->num_rows > 0) {
                                                    while ($row = $result->fetch_assoc()) {
                                                        echo "<tr ondblclick=\"openFileData('{$row['payment_id']}')\">"; // Added ondblclick event
                                                        echo "<td>{$row['payment_id']}</td>";
                                                        echo "<td>{$row['booking_id']}</td>";
                                                        echo "<td>{$row['amount']}</td>";
                                                        echo "<td>{$row['payment_date']}</td>"; 
                                                        echo "<td>{$row['transaction_id']}</td>";
                                                        echo "<td>{$row['payment_gateway']}</td>";
                                                        echo "<td>{$row['payment_status']}</td>";
                                                        echo '<td>
                                                                <ul class="list-inline hstack gap-2 mb-0">';
                                                                
                                                                // Show the "Add Payment" button only if the payment status is NOT "Completed"
                                                                if ($row['payment_status'] != 'Completed') {
                                                                    echo '<li class="list-inline-item edit" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="Add Payment">
                                                                            <a href="add_pay.php?booking_id=' . $row['booking_id'] . '" class="text-muted d-inline-block">
                                                                                <i class="ri-refund-2-line fs-16"></i>
                                                                            </a>
                                                                          </li>';
                                                                }
                                                
                                                        echo    '<li class="list-inline-item edit" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="Print Booking Pass(es)">
                                                                    <a href="print_tickets.php?booking_id=' . $row['booking_id'] . '" class="text-muted d-inline-block">
                                                                        <i class="ri-printer-line fs-16"></i>
                                                                    </a>
                                                                 </li>
                                                                 <li class="list-inline-item" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="View">
                                                                    <a href="payment_view.php?payment_id=' . $row['payment_id'] . '"><i class="ri-refund-2-fill align-bottom text-muted"></i></a>
                                                                 </li>
                                                                 <li class="list-inline-item" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="Edit">
                                                                    <a class="edit-item-btn" href="#showModal" data-bs-toggle="modal"><i class="ri-pencil-fill align-bottom text-muted"></i></a>
                                                                 </li>
                                                                 <li class="list-inline-item" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="Delete">
                                                                    <a class="remove-item-btn" data-bs-toggle="modal" href="#deleteRecordModal">
                                                                        <i class="ri-delete-bin-fill align-bottom text-muted"></i>
                                                                    </a>
                                                                 </li>
                                                                </ul>
                                                              </td>';
                                                        echo "</tr>";
                                                    }
                                                } else {
                                                    echo "<tr><td colspan='8'>No files found</td></tr>";
                                                }
                                                
                                                $conn->close(); // Close the database connection
                                                ?>

                                            </tbody>    
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!--end row-->


                    

                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

            <?php include 'layouts/footer.php'; ?>
        </div>
        <!-- end main content-->

    </div>
    <!-- END layout-wrapper -->

    <?php include 'layouts/vendor-scripts.php'; ?>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

    <script src="assets/js/pages/datatables.init.js"></script>
    <!-- App js -->
    <script src="assets/js/app.js"></script>
</body>

</html>