<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>
<?php
// Include the database connection file
include('layouts/dbconn.php');

?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Add Support Ticket')); ?>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <?php include 'layouts/head-css.php'; ?>
</head>

<body>
    <!-- Begin page -->
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Ticket Management', 'title' => 'Add Support Ticket')); ?>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Add Support Ticket</h4>
                                    <div class="flex-shrink-0">
                                    </div>
                                </div><!-- end card header -->
                                <div class="card-body">
                                    <div class="live-preview">
                                        <form id="ticketForm" method="POST" action="save_ticket.php">
                                            <div class="row gy-4">
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="customer_id" class="form-label">Customer</label>
                                                        <select class="js-example-basic-single" id="customer_id" name="customer_id">
                                                            <option value="">Select Customer</option>
                                                            <?php
                                                            // Fetch customers from the database
                                                            $customers = $conn->query("SELECT customer_id, CONCAT(first_name, ' ', last_name) AS full_name FROM customers");
                                                            while ($customer = $customers->fetch_assoc()) {
                                                                echo "<option value='{$customer['customer_id']}'>{$customer['full_name']}</option>";
                                                            }
                                                            ?>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="subject" class="form-label">Subject</label>
                                                        <input type="text" class="form-control form-control-icon" id="subject" name="subject" placeholder="Enter ticket subject">
                                                    </div>
                                                </div>
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="description" class="form-label">Description</label>
                                                        <textarea class="form-control form-control-icon" id="description" name="description" placeholder="Enter ticket description"></textarea>
                                                    </div>
                                                </div>
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="priority" class="form-label">Priority</label>
                                                        <select class="form-select" id="priority" name="priority">
                                                            <option value="Low">Low</option>
                                                            <option value="Medium">Medium</option>
                                                            <option value="High">High</option>
                                                            <option value="Urgent">Urgent</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="status" class="form-label">Status</label>
                                                        <select class="form-select mb-3" name="status" aria-label="Default select example">
                                                            <option selected>Select A Status</option>
                                                            <option value="Open">Open</option>
                                                            <option value="In_progress">In Progress</option>
                                                            <option value="Closed">Closed</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <button type="submit" class="btn btn-success btn-label waves-effect waves-light rounded-pill">
                                                            <i class="ri-check-double-line label-icon align-middle rounded-pill fs-16 me-2"></i> Save Ticket
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> <!-- container-fluid -->
            </div><!-- End Page-content -->
            <?php include 'layouts/footer.php'; ?>
        </div>
        <!-- end main content-->
    </div>
    <!-- END layout-wrapper -->

    <?php include 'layouts/vendor-scripts.php'; ?>

    <!-- prismjs plugin -->
    <script src="assets/libs/prismjs/prism.js"></script>
    <script src="assets/js/app.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- Add these CDN links in your <head> section -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="assets/js/pages/select2.init.js"></script>

<script>
$(document).ready(function() {
    // Initialize Select2 on the customer select element
    $('#customer_id').select2({
        placeholder: "Select a customer",
        allowClear: true
    });
});
</script>

    
    <script>
$(document).ready(function() {
    $('#ticketForm').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
            type: 'POST',
            url: $(this).attr('action'),
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: response.message + ' Ticket number: ' + response.ticket_number,
                        confirmButtonColor: '#28a745'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // Redirect to the all_support_tickets.php page after clicking "Okay"
                            window.location.href = "all_support_tickets.php?status=success&ticket_number=" + response.ticket_number;
                        }
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: response.message,
                        confirmButtonColor: '#dc3545'
                    });
                }
            },
            error: function(xhr, status, error) {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'An error occurred: ' + error,
                    confirmButtonColor: '#dc3545'
                });
            }
        });
    });
});

    </script>
</body>
</html>
