<?php
// view_deposit.php
session_start();
include 'layouts/dbconn.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Get user details for permission checks
$user_id = $_SESSION['user_id'];
$sql_user_details = "SELECT username, user_role, full_name, email, role_id FROM users WHERE user_id = $user_id";
$result_user_details = $conn->query($sql_user_details);

if ($result_user_details && $row_user_details = $result_user_details->fetch_assoc()) {
    $username = $row_user_details['username'];
    $user_role = $row_user_details['user_role'];
    $full_name = $row_user_details['full_name'];
    $email = $row_user_details['email'];
    $role_id = $row_user_details['role_id'];
}

// Check if user has access (admin or operations roles)
if ($role_id != 1 && $role_id != 3) {
    $_SESSION['error_message'] = "You don't have permission to access this page.";
    header('Location: index.php');
    exit();
}

// Check if deposit ID is provided
if (!isset($_GET['id']) || empty($_GET['id'])) {
    $_SESSION['error_message'] = "No deposit ID provided.";
    header('Location: deposit_list.php');
    exit();
}

$deposit_id = intval($_GET['id']);

// Get deposit details
$sql = "SELECT 
            d.*,
            u1.full_name as created_by_name,
            u2.full_name as deposit_user_name,
            u3.full_name as approval_user_name
        FROM 
            deposits d
        LEFT JOIN 
            users u1 ON d.created_by = u1.user_id
        LEFT JOIN 
            users u2 ON d.deposit_user_id = u2.user_id
        LEFT JOIN 
            users u3 ON d.approval_user_id = u3.user_id
        WHERE 
            d.id = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param('i', $deposit_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    $_SESSION['error_message'] = "Deposit not found.";
    header('Location: deposit_list.php');
    exit();
}

$deposit = $result->fetch_assoc();

// Format date helper function
function formatDate($date) {
    return date('Y-m-d', strtotime($date));
}

// Get system name from settings
$sql_settings = "SELECT setting_value FROM settings WHERE setting_key = 'system_name'";
$result_settings = $conn->query($sql_settings);
if ($result_settings && $result_settings->num_rows > 0) {
    $row_settings = $result_settings->fetch_assoc();
    $system_name = $row_settings['setting_value'];
} else {
    $system_name = "Royal Freight Management System";
}
?>

<?php include 'layouts/main.php'; ?>
<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Deposit Details')); ?>
    <?php include 'layouts/head-css.php'; ?>
    
    <!-- Sweet Alert css -->
    <link href="assets/libs/sweetalert2/sweetalert2.min.css" rel="stylesheet" type="text/css" />
    
    <style>
        .deposit-details-card {
            margin-bottom: 1.5rem;
        }
        .deposit-header {
            padding: 1rem;
            border-bottom: 1px solid #e9e9ef;
            background-color: #f8f9fa;
        }
        .detail-label {
            font-weight: 600;
            color: #495057;
            margin-bottom: 0.25rem;
        }
        .detail-value {
            margin-bottom: 1rem;
        }
        .badge-status {
            font-size: 0.75rem;
            padding: 0.3rem 0.5rem;
        }
        .print-section {
            text-align: right;
            margin-bottom: 1rem;
        }
        @media print {
            .no-print {
                display: none !important;
            }
            .container-fluid {
                width: 100% !important;
                padding: 0 !important;
                margin: 0 !important;
            }
            .card {
                border: none !important;
                box-shadow: none !important;
            }
        }
    </style>
</head>

<body>
    <!-- Begin page -->
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Finance Management', 'title' => 'Deposit Details')); ?>

                    <div class="print-section no-print">
                        <button type="button" class="btn btn-success" onclick="window.print()">
                            <i class="ri-printer-line align-bottom me-1"></i> Print Details
                        </button>
                        <a href="deposit_list.php" class="btn btn-primary">
                            <i class="ri-arrow-left-line align-bottom me-1"></i> Back to List
                        </a>
                        <?php if ($deposit['status'] == 'pending' && ($role_id == 1 || $role_id == 3)): ?>
                        <!--<a href="edit_deposit.php?id=<?php echo $deposit_id; ?>" class="btn btn-info">
                            <i class="ri-edit-box-line align-bottom me-1"></i> Edit Deposit
                        </a> -->
                        <?php endif; ?>
                        <?php if ($deposit['status'] == 'pending' && $role_id == 1): ?>
                        <a href="approve_deposit.php?id=<?php echo $deposit_id; ?>" class="btn btn-warning">
                            <i class="ri-check-double-line align-bottom me-1"></i> Approve/Reject
                        </a>
                        <?php endif; ?>
                    </div>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card deposit-details-card">
                                <div class="card-header deposit-header d-flex justify-content-between align-items-center">
                                    <h5 class="card-title mb-0">
                                        Deposit #<?php echo $deposit_id; ?>
                                        <?php
                                        $status_badge_class = 'bg-warning';
                                        if ($deposit['status'] == 'approved') {
                                            $status_badge_class = 'bg-success';
                                        } elseif ($deposit['status'] == 'rejected') {
                                            $status_badge_class = 'bg-danger';
                                        }
                                        ?>
                                        <span class="badge <?php echo $status_badge_class; ?> badge-status ms-2">
                                            <?php echo ucfirst($deposit['status']); ?>
                                        </span>
                                    </h5>
                                    <span>Created: <?php echo formatDate($deposit['created_at']); ?></span>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="detail-label">Deposit Date</div>
                                            <div class="detail-value"><?php echo formatDate($deposit['deposit_date']); ?></div>
                                            
                                            <div class="detail-label">Bank</div>
                                            <div class="detail-value"><?php echo $deposit['bank']; ?></div>
                                            
                                            <div class="detail-label">Currency</div>
                                            <div class="detail-value"><?php echo $deposit['currency']; ?></div>
                                            
                                            <div class="detail-label">Amount</div>
                                            <div class="detail-value"><?php echo number_format($deposit['amount'], 2); ?></div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="detail-label">Created By</div>
                                            <div class="detail-value"><?php echo $deposit['created_by_name']; ?></div>
                                            
                                            <div class="detail-label">Deposit User</div>
                                            <div class="detail-value"><?php echo $deposit['deposit_user_name']; ?></div>
                                            
                                            <div class="detail-label">Approval User</div>
                                            <div class="detail-value"><?php echo $deposit['approval_user_name']; ?></div>
                                        </div>
                                    </div>
                                    
                                    <div class="row mt-3">
                                        <div class="col-12">
                                            <div class="detail-label">Purpose</div>
                                            <div class="detail-value">
                                                <?php echo nl2br(htmlspecialchars($deposit['purpose'])); ?>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <?php if (!empty($deposit['comments'])): ?>
                                    <div class="row mt-3">
                                        <div class="col-12">
                                            <div class="detail-label">Comments</div>
                                            <div class="detail-value">
                                                <?php echo nl2br(htmlspecialchars($deposit['comments'])); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

            <?php include 'layouts/footer.php'; ?>
        </div>
        <!-- end main content-->
    </div>
    <!-- END layout-wrapper -->

    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="assets/js/app.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link href="assets/libs/sweetalert2/sweetalert2.min.css" rel="stylesheet">
<script src="assets/libs/sweetalert2/sweetalert2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    
    <script>
        $(document).ready(function() {
            // Show success message with SweetAlert if present
            <?php if (isset($_SESSION['swal_success'])): ?>
            Swal.fire({
                icon: 'success',
                title: 'Success!',
                text: '<?php echo $_SESSION['swal_success']; ?>',
                confirmButtonColor: '#3085d6'
            });
            <?php unset($_SESSION['swal_success']); endif; ?>
            
            // Show error message with SweetAlert if present
            <?php if (isset($_SESSION['swal_error'])): ?>
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: '<?php echo $_SESSION['swal_error']; ?>',
                confirmButtonColor: '#3085d6'
            });
            <?php unset($_SESSION['swal_error']); endif; ?>
        });
    </script>

    <!-- App js -->
    <script src="assets/js/app.js"></script>
</body>
</html>