-- Database Backup
-- Generated: 2025-03-07 19:09:54

SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS `admin_logs`;
CREATE TABLE `admin_logs` (
  `log_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `action` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `details` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`log_id`),
  KEY `user_id` (`user_id`),
  KEY `action` (`action`),
  KEY `created_at` (`created_at`),
  CONSTRAINT `admin_logs_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `backup_settings`;
CREATE TABLE `backup_settings` (
  `setting_id` int NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `setting_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`setting_id`),
  UNIQUE KEY `setting_key` (`setting_key`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `banks`;
CREATE TABLE `banks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `bank_name` varchar(100) NOT NULL,
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `charges`;
CREATE TABLE `charges` (
  `id` int NOT NULL AUTO_INCREMENT,
  `file_number` varchar(30) NOT NULL,
  `port_charge` decimal(10,2) DEFAULT NULL,
  `wharfage_charge` decimal(10,2) DEFAULT NULL,
  `port_charges_paid_date` datetime DEFAULT NULL,
  `whafage_paid_date` datetime DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_user_id` (`user_id`),
  CONSTRAINT `fk_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=163 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `chat_notifs`;
CREATE TABLE `chat_notifs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `message` varchar(255) NOT NULL,
  `link` varchar(255) DEFAULT NULL,
  `is_read` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `chat_notifs_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `cheque_withdrawals`;
CREATE TABLE `cheque_withdrawals` (
  `id` int NOT NULL AUTO_INCREMENT,
  `withdrawal_date` date NOT NULL,
  `currency` enum('USD','Tsh') NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `purpose` text NOT NULL,
  `bank` varchar(100) NOT NULL,
  `bank_branch` varchar(100) DEFAULT NULL,
  `cheque_number` varchar(50) DEFAULT NULL,
  `withdrawal_user_id` int NOT NULL,
  `approval_user_id` int DEFAULT NULL,
  `status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  `rejection_reason` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `approved_at` timestamp NULL DEFAULT NULL,
  `rejected_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `withdrawal_user_id` (`withdrawal_user_id`),
  KEY `approval_user_id` (`approval_user_id`),
  CONSTRAINT `fk_approval_user` FOREIGN KEY (`approval_user_id`) REFERENCES `users` (`user_id`) ON DELETE SET NULL,
  CONSTRAINT `fk_withdrawal_user` FOREIGN KEY (`withdrawal_user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `client_debts`;
CREATE TABLE `client_debts` (
  `debt_id` int NOT NULL AUTO_INCREMENT,
  `customer_id` int NOT NULL,
  `currency` varchar(10) NOT NULL DEFAULT '$',
  `total_debt` decimal(15,2) NOT NULL DEFAULT '0.00',
  `credit_limit` decimal(15,2) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`debt_id`),
  UNIQUE KEY `customer_currency` (`customer_id`,`currency`),
  KEY `customer_id` (`customer_id`),
  CONSTRAINT `fk_client_debts_customer` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`customer_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `container_deposit`;
CREATE TABLE `container_deposit` (
  `id` int NOT NULL AUTO_INCREMENT,
  `shipping_line` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `type` enum('normal','fixed','additional') CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `bl` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `container` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `fixed_amount` decimal(10,2) DEFAULT NULL,
  `deposit` decimal(10,2) DEFAULT NULL,
  `date_deposited` datetime DEFAULT NULL,
  `refund_amount` decimal(10,2) DEFAULT NULL,
  `balance` int DEFAULT NULL,
  `refund_date` datetime DEFAULT NULL,
  `remarks` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `deposit_roll_over` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `payment_status` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `additional_info` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `user_id` int NOT NULL,
  `created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `container_deposit_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `container_details`;
CREATE TABLE `container_details` (
  `id` int NOT NULL AUTO_INCREMENT,
  `file_number` varchar(20) NOT NULL,
  `container_code` varchar(20) NOT NULL,
  `container_size` varchar(25) DEFAULT NULL,
  `way_bill` varchar(50) DEFAULT NULL,
  `delivery_order_apply_date` date DEFAULT NULL,
  `delivery_order_received_date` date DEFAULT NULL,
  `obr_sct_received_date` date DEFAULT NULL,
  `obr_ti_validation_date` date DEFAULT NULL,
  `t1_c2_approval_date` date DEFAULT NULL,
  `port_charges_paid_date` date DEFAULT NULL,
  `whafage_paid_date` date DEFAULT NULL,
  `transporter_name` varchar(50) DEFAULT NULL,
  `driver_name` varchar(50) DEFAULT NULL,
  `driver_phone_number` varchar(15) DEFAULT NULL,
  `driver_license` varchar(50) DEFAULT NULL,
  `loading_permit_apply_date` date DEFAULT NULL,
  `truck_exit_date` date DEFAULT NULL,
  `truck_at_border_date` date DEFAULT NULL,
  `border_crossing_date` date DEFAULT NULL,
  `delivery_date` date DEFAULT NULL,
  `discharge_date` date DEFAULT NULL,
  `empty_return_date` date DEFAULT NULL,
  `remarks` text,
  PRIMARY KEY (`id`),
  KEY `file_number` (`file_number`),
  CONSTRAINT `container_details_ibfk_1` FOREIGN KEY (`file_number`) REFERENCES `files` (`file_number`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=632 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `container_inspections`;
CREATE TABLE `container_inspections` (
  `id` int NOT NULL AUTO_INCREMENT,
  `container_id` varchar(50) DEFAULT NULL,
  `inspection_date` datetime DEFAULT NULL,
  `inspector_id` int DEFAULT NULL,
  `condition_status` enum('Excellent','Good','Fair','Poor','Damaged') DEFAULT NULL,
  `temperature_reading` decimal(5,2) DEFAULT NULL,
  `humidity_reading` decimal(5,2) DEFAULT NULL,
  `damage_details` text,
  `photos_url` text,
  `action_required` text,
  PRIMARY KEY (`id`),
  KEY `inspector_id` (`inspector_id`),
  CONSTRAINT `container_inspections_ibfk_1` FOREIGN KEY (`inspector_id`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `container_maintenance`;
CREATE TABLE `container_maintenance` (
  `id` int NOT NULL AUTO_INCREMENT,
  `container_id` varchar(50) DEFAULT NULL,
  `maintenance_type` varchar(100) DEFAULT NULL,
  `maintenance_date` datetime DEFAULT NULL,
  `cost` decimal(10,2) DEFAULT NULL,
  `provider` varchar(100) DEFAULT NULL,
  `description` text,
  `next_maintenance_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `container_temperature_logs`;
CREATE TABLE `container_temperature_logs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `container_id` varchar(50) DEFAULT NULL,
  `temperature` decimal(5,2) DEFAULT NULL,
  `humidity` decimal(5,2) DEFAULT NULL,
  `timestamp` datetime DEFAULT NULL,
  `alert_triggered` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `containers`;
CREATE TABLE `containers` (
  `container_id` int NOT NULL AUTO_INCREMENT,
  `container_reference` varchar(50) DEFAULT NULL,
  `container_type` varchar(50) DEFAULT NULL,
  `capacity` int DEFAULT NULL,
  `status` enum('available','in_transit','delivered') NOT NULL,
  `location` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`container_id`),
  UNIQUE KEY `container_reference` (`container_reference`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `cost_reference`;
CREATE TABLE `cost_reference` (
  `id` int NOT NULL AUTO_INCREMENT,
  `category` varchar(255) NOT NULL,
  `code` varchar(20) NOT NULL,
  `description` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `customer_interactions`;
CREATE TABLE `customer_interactions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `customer_id` int DEFAULT NULL,
  `interaction_date` datetime DEFAULT NULL,
  `interaction_type` enum('Complaint','Inquiry','Feedback','Support') DEFAULT NULL,
  `description` text,
  `resolution` text,
  `resolution_date` datetime DEFAULT NULL,
  `satisfaction_rating` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  CONSTRAINT `customer_interactions_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `customer_preferences`;
CREATE TABLE `customer_preferences` (
  `id` int NOT NULL AUTO_INCREMENT,
  `customer_id` int DEFAULT NULL,
  `preferred_transport_mode` varchar(50) DEFAULT NULL,
  `preferred_payment_terms` varchar(50) DEFAULT NULL,
  `special_handling_requirements` text,
  `notification_preferences` json DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  CONSTRAINT `customer_preferences_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `customers`;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `first_name` varchar(50) NOT NULL,
  `last_name` varchar(50) NOT NULL,
  `phone_number` varchar(15) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `postal_code` varchar(10) DEFAULT NULL,
  `country` varchar(50) DEFAULT NULL,
  `invoices_count` int DEFAULT '0',
  `status` int NOT NULL DEFAULT '1',
  `email` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `customs_clearance`;
CREATE TABLE `customs_clearance` (
  `id` int NOT NULL AUTO_INCREMENT,
  `shipment_id` varchar(50) DEFAULT NULL,
  `clearance_date` datetime DEFAULT NULL,
  `customs_office` varchar(100) DEFAULT NULL,
  `broker_id` int DEFAULT NULL,
  `clearance_status` enum('Pending','In Progress','Cleared','Held') DEFAULT NULL,
  `inspection_required` tinyint(1) DEFAULT NULL,
  `inspection_date` datetime DEFAULT NULL,
  `duties_amount` decimal(10,2) DEFAULT NULL,
  `taxes_amount` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `customs_documents`;
CREATE TABLE `customs_documents` (
  `id` int NOT NULL AUTO_INCREMENT,
  `shipment_id` varchar(50) DEFAULT NULL,
  `document_type` varchar(100) DEFAULT NULL,
  `document_number` varchar(100) DEFAULT NULL,
  `issue_date` datetime DEFAULT NULL,
  `expiry_date` datetime DEFAULT NULL,
  `status` enum('Pending','Approved','Rejected','Expired') DEFAULT NULL,
  `issuing_authority` varchar(100) DEFAULT NULL,
  `digital_copy_url` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `debt_transactions`;
CREATE TABLE `debt_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `customer_id` int NOT NULL,
  `transaction_date` date NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `currency` varchar(10) NOT NULL DEFAULT '$',
  `transaction_type` enum('invoice','payment','debit_note','credit_note','adjustment') NOT NULL,
  `reference_id` varchar(50) DEFAULT NULL,
  `notes` text,
  `user_id` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`transaction_id`),
  KEY `customer_id` (`customer_id`),
  KEY `user_id` (`user_id`),
  KEY `transaction_date` (`transaction_date`),
  CONSTRAINT `fk_debt_transactions_customer` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`customer_id`),
  CONSTRAINT `fk_debt_transactions_user` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `deleted_records`;
CREATE TABLE `deleted_records` (
  `id` int NOT NULL AUTO_INCREMENT,
  `file_number` varchar(20) NOT NULL,
  `date_deleted` datetime NOT NULL,
  `deleted_by` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `delivery_returns`;
CREATE TABLE `delivery_returns` (
  `id` int NOT NULL AUTO_INCREMENT,
  `file_number` varchar(50) DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `bl` varchar(50) DEFAULT NULL,
  `container_no` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `load_date` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `file_number` (`file_number`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `delivery_returns_ibfk_1` FOREIGN KEY (`file_number`) REFERENCES `files` (`file_number`),
  CONSTRAINT `delivery_returns_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `deposits`;
CREATE TABLE `deposits` (
  `id` int NOT NULL AUTO_INCREMENT,
  `deposit_date` date NOT NULL,
  `currency` varchar(10) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `purpose` text NOT NULL,
  `source` varchar(20) NOT NULL,
  `bank` varchar(50) NOT NULL,
  `deposit_user_id` int NOT NULL,
  `approval_user_id` int NOT NULL,
  `status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  `comments` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `deposit_user_id` (`deposit_user_id`),
  KEY `approval_user_id` (`approval_user_id`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `deposits_ibfk_1` FOREIGN KEY (`deposit_user_id`) REFERENCES `users` (`user_id`),
  CONSTRAINT `deposits_ibfk_2` FOREIGN KEY (`approval_user_id`) REFERENCES `users` (`user_id`),
  CONSTRAINT `deposits_ibfk_3` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `destinations`;
CREATE TABLE `destinations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `country` varchar(100) NOT NULL,
  `city` varchar(100) NOT NULL,
  `prefix` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `prefix` (`prefix`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `email_attachments`;
CREATE TABLE `email_attachments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `email_id` int NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `file_path` varchar(255) NOT NULL,
  `file_type` varchar(100) NOT NULL,
  `file_size` int NOT NULL,
  `uploaded_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `email_id` (`email_id`),
  CONSTRAINT `email_attachments_ibfk_1` FOREIGN KEY (`email_id`) REFERENCES `emails` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `emails`;
CREATE TABLE `emails` (
  `id` int NOT NULL AUTO_INCREMENT,
  `sender` varchar(255) NOT NULL,
  `recipient` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `message` text NOT NULL,
  `status` enum('draft','sent','trash') DEFAULT 'draft',
  `is_read` tinyint(1) DEFAULT '0',
  `starred` tinyint(1) DEFAULT '0',
  `timestamp` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_sender` (`sender`),
  KEY `idx_recipient` (`recipient`),
  KEY `idx_status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `expense_categories`;
CREATE TABLE `expense_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text,
  `type` enum('Office','File','Other') NOT NULL DEFAULT 'Office',
  `status` enum('Active','Inactive') NOT NULL DEFAULT 'Active',
  `created_by` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`category_id`),
  KEY `fk_expense_cat_created_by` (`created_by`),
  CONSTRAINT `fk_expense_cat_created_by` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`) ON DELETE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `expense_ref`;
CREATE TABLE `expense_ref` (
  `idx` int NOT NULL AUTO_INCREMENT,
  `category` varchar(255) DEFAULT NULL,
  `code` varchar(50) DEFAULT NULL,
  `description` text,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`idx`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `expenses`;
CREATE TABLE `expenses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `exp_no` varchar(255) NOT NULL,
  `status` varchar(20) DEFAULT 'Pending',
  `currency` varchar(3) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `office_cost` varchar(30) DEFAULT NULL,
  `user_id` int NOT NULL,
  `created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `pay_mode` varchar(10) NOT NULL,
  `file_number` varchar(50) DEFAULT NULL,
  `amount` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `file_access_logs`;
CREATE TABLE `file_access_logs` (
  `log_id` int NOT NULL AUTO_INCREMENT,
  `file_id` int DEFAULT NULL,
  `folder_id` int DEFAULT NULL,
  `user_id` int NOT NULL,
  `access_type` enum('view','download','edit','share','delete') NOT NULL,
  `access_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ip_address` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `fk_log_file` (`file_id`),
  KEY `fk_log_folder` (`folder_id`),
  KEY `fk_log_user` (`user_id`),
  CONSTRAINT `fk_log_file` FOREIGN KEY (`file_id`) REFERENCES `file_manager` (`file_id`) ON DELETE CASCADE,
  CONSTRAINT `fk_log_folder` FOREIGN KEY (`folder_id`) REFERENCES `file_folders` (`folder_id`) ON DELETE CASCADE,
  CONSTRAINT `fk_log_user` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `file_folders`;
CREATE TABLE `file_folders` (
  `folder_id` int NOT NULL AUTO_INCREMENT,
  `folder_name` varchar(255) NOT NULL,
  `parent_folder_id` int DEFAULT NULL,
  `created_by` int NOT NULL,
  `created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `related_file_number` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`folder_id`),
  KEY `fk_folder_user` (`created_by`),
  KEY `fk_parent_folder` (`parent_folder_id`),
  KEY `idx_folder_file_number` (`related_file_number`),
  CONSTRAINT `fk_folder_user` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  CONSTRAINT `fk_parent_folder` FOREIGN KEY (`parent_folder_id`) REFERENCES `file_folders` (`folder_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `file_manager`;
CREATE TABLE `file_manager` (
  `file_id` int NOT NULL AUTO_INCREMENT,
  `file_name` varchar(255) NOT NULL,
  `file_path` varchar(255) NOT NULL,
  `file_type` varchar(100) NOT NULL,
  `file_size` int NOT NULL,
  `file_extension` varchar(10) NOT NULL,
  `folder_id` int DEFAULT NULL,
  `uploaded_by` int NOT NULL,
  `upload_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `related_file_number` varchar(50) DEFAULT NULL,
  `description` text,
  `is_public` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`file_id`),
  KEY `fk_file_user` (`uploaded_by`),
  KEY `fk_file_folder` (`folder_id`),
  KEY `idx_file_file_number` (`related_file_number`),
  CONSTRAINT `fk_file_folder` FOREIGN KEY (`folder_id`) REFERENCES `file_folders` (`folder_id`) ON DELETE SET NULL,
  CONSTRAINT `fk_file_user` FOREIGN KEY (`uploaded_by`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `file_shares`;
CREATE TABLE `file_shares` (
  `share_id` int NOT NULL AUTO_INCREMENT,
  `file_id` int DEFAULT NULL,
  `folder_id` int DEFAULT NULL,
  `shared_with` int NOT NULL,
  `shared_by` int NOT NULL,
  `permission_level` enum('read','edit','delete') NOT NULL DEFAULT 'read',
  `share_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expire_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`share_id`),
  KEY `fk_share_file` (`file_id`),
  KEY `fk_share_folder` (`folder_id`),
  KEY `fk_share_by` (`shared_by`),
  KEY `fk_share_with` (`shared_with`),
  CONSTRAINT `fk_share_by` FOREIGN KEY (`shared_by`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  CONSTRAINT `fk_share_file` FOREIGN KEY (`file_id`) REFERENCES `file_manager` (`file_id`) ON DELETE CASCADE,
  CONSTRAINT `fk_share_folder` FOREIGN KEY (`folder_id`) REFERENCES `file_folders` (`folder_id`) ON DELETE CASCADE,
  CONSTRAINT `fk_share_with` FOREIGN KEY (`shared_with`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `files`;
CREATE TABLE `files` (
  `id` int NOT NULL AUTO_INCREMENT,
  `file_number` varchar(20) DEFAULT NULL,
  `customer` int DEFAULT NULL,
  `trans_type` varchar(50) DEFAULT NULL,
  `transporter` varchar(50) DEFAULT NULL,
  `created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `currency` varchar(10) DEFAULT NULL,
  `charge` varchar(50) DEFAULT NULL,
  `consignee_name` varchar(50) DEFAULT NULL,
  `container_code` varchar(255) DEFAULT NULL,
  `container_size` varchar(25) DEFAULT NULL,
  `vno` varchar(255) DEFAULT NULL,
  `obl_no` varchar(50) DEFAULT NULL,
  `eta` datetime DEFAULT NULL,
  `initial_eta` datetime DEFAULT NULL,
  `destination` varchar(50) DEFAULT NULL,
  `pre_alert_received_date` datetime DEFAULT NULL,
  `discharge_date` datetime DEFAULT NULL,
  `way_bill` varchar(50) DEFAULT NULL,
  `delivery_order_apply_date` datetime DEFAULT NULL,
  `delivery_order_received_date` datetime DEFAULT NULL,
  `obr_sct_received_date` datetime DEFAULT NULL,
  `obr_ti_validation_date` datetime DEFAULT NULL,
  `t1_c2_approval_date` datetime DEFAULT NULL,
  `port_charges_paid_date` datetime DEFAULT NULL,
  `whafage_paid_date` datetime DEFAULT NULL,
  `transporter_name` varchar(50) DEFAULT NULL,
  `port` varchar(255) DEFAULT NULL,
  `truck_trailer_no` varchar(50) DEFAULT NULL,
  `driver_name` varchar(50) DEFAULT NULL,
  `driver_phone_number` varchar(15) DEFAULT NULL,
  `driver_license` varchar(50) DEFAULT NULL,
  `loading_permit_apply_date` datetime DEFAULT NULL,
  `truck_exit_date` datetime DEFAULT NULL,
  `truck_at_border_date` datetime DEFAULT NULL,
  `border_crossing_date` datetime DEFAULT NULL,
  `delivery_date` datetime DEFAULT NULL,
  `empty_return_date` datetime DEFAULT NULL,
  `load_date` date DEFAULT NULL,
  `offload_date` date DEFAULT NULL,
  `remarks` text,
  `local/transit` int DEFAULT NULL,
  `free_detention` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `invoice` int DEFAULT NULL,
  `close_file` varchar(5) DEFAULT NULL,
  `c_type` varchar(50) DEFAULT 'Container',
  `bulk_item_count` int DEFAULT NULL,
  `bulk_cbm` decimal(10,2) DEFAULT NULL,
  `loose_item_count` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_file_number` (`file_number`)
) ENGINE=InnoDB AUTO_INCREMENT=291 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `flagged_messages`;
CREATE TABLE `flagged_messages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `word` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `fund_request_attachments`;
CREATE TABLE `fund_request_attachments` (
  `attachment_id` int NOT NULL AUTO_INCREMENT,
  `request_id` int NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `file_path` varchar(255) NOT NULL,
  `file_type` varchar(100) NOT NULL,
  `file_size` int NOT NULL,
  `uploaded_by` int NOT NULL,
  `upload_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`attachment_id`),
  KEY `fk_attachment_request` (`request_id`),
  KEY `fk_attachment_user` (`uploaded_by`),
  CONSTRAINT `fk_attachment_request` FOREIGN KEY (`request_id`) REFERENCES `fund_requests` (`request_id`) ON DELETE CASCADE,
  CONSTRAINT `fk_attachment_user` FOREIGN KEY (`uploaded_by`) REFERENCES `users` (`user_id`) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `fund_request_logs`;
CREATE TABLE `fund_request_logs` (
  `log_id` int NOT NULL AUTO_INCREMENT,
  `request_id` int NOT NULL,
  `action` varchar(50) NOT NULL,
  `status_from` varchar(20) DEFAULT NULL,
  `status_to` varchar(20) DEFAULT NULL,
  `amount_before` decimal(10,2) DEFAULT NULL,
  `amount_after` decimal(10,2) DEFAULT NULL,
  `performed_by` int NOT NULL,
  `remarks` text,
  `log_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`log_id`),
  KEY `fk_fund_log_request` (`request_id`),
  KEY `fk_fund_log_user` (`performed_by`),
  CONSTRAINT `fk_fund_log_request` FOREIGN KEY (`request_id`) REFERENCES `fund_requests` (`request_id`) ON DELETE CASCADE,
  CONSTRAINT `fk_fund_log_user` FOREIGN KEY (`performed_by`) REFERENCES `users` (`user_id`) ON DELETE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `fund_requests`;
CREATE TABLE `fund_requests` (
  `request_id` int NOT NULL AUTO_INCREMENT,
  `request_number` varchar(20) NOT NULL,
  `category_id` int NOT NULL,
  `file_number` varchar(50) DEFAULT NULL,
  `amount` decimal(10,2) NOT NULL,
  `currency` enum('USD','TSH') NOT NULL DEFAULT 'USD',
  `description` text NOT NULL,
  `status` enum('Pending','Approved','Rejected','Released','Cancelled') NOT NULL DEFAULT 'Pending',
  `request_date` datetime NOT NULL,
  `approval_date` datetime DEFAULT NULL,
  `release_date` datetime DEFAULT NULL,
  `requested_by` int NOT NULL,
  `approved_by` int DEFAULT NULL,
  `released_by` int DEFAULT NULL,
  `received_by` int DEFAULT NULL,
  `rejection_reason` text,
  `attachments` text,
  `remarks` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`request_id`),
  UNIQUE KEY `request_number` (`request_number`),
  KEY `fk_fund_category` (`category_id`),
  KEY `fk_fund_requested_by` (`requested_by`),
  KEY `fk_fund_approved_by` (`approved_by`),
  KEY `fk_fund_released_by` (`released_by`),
  KEY `fk_fund_received_by` (`received_by`),
  KEY `idx_file_number` (`file_number`),
  CONSTRAINT `fk_fund_approved_by` FOREIGN KEY (`approved_by`) REFERENCES `users` (`user_id`) ON DELETE RESTRICT,
  CONSTRAINT `fk_fund_category` FOREIGN KEY (`category_id`) REFERENCES `expense_categories` (`category_id`) ON DELETE RESTRICT,
  CONSTRAINT `fk_fund_received_by` FOREIGN KEY (`received_by`) REFERENCES `users` (`user_id`) ON DELETE RESTRICT,
  CONSTRAINT `fk_fund_released_by` FOREIGN KEY (`released_by`) REFERENCES `users` (`user_id`) ON DELETE RESTRICT,
  CONSTRAINT `fk_fund_requested_by` FOREIGN KEY (`requested_by`) REFERENCES `users` (`user_id`) ON DELETE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `import_batches`;
CREATE TABLE `import_batches` (
  `batch_id` int NOT NULL AUTO_INCREMENT,
  `filename` varchar(255) NOT NULL,
  `import_type` varchar(50) NOT NULL COMMENT 'Type of import (e.g., transit_shipment, local_shipment)',
  `status` enum('pending','approved','rejected','processed','failed') NOT NULL DEFAULT 'pending',
  `total_records` int NOT NULL DEFAULT '0',
  `processed_records` int NOT NULL DEFAULT '0',
  `created_by` int NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `processed_at` datetime DEFAULT NULL,
  `processed_by` int DEFAULT NULL,
  `notes` text,
  PRIMARY KEY (`batch_id`),
  KEY `fk_import_user` (`created_by`),
  KEY `fk_import_processor` (`processed_by`),
  CONSTRAINT `fk_import_processor` FOREIGN KEY (`processed_by`) REFERENCES `users` (`user_id`) ON DELETE SET NULL,
  CONSTRAINT `fk_import_user` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `import_config`;
CREATE TABLE `import_config` (
  `config_id` int NOT NULL AUTO_INCREMENT,
  `import_type` varchar(50) NOT NULL,
  `field_name` varchar(100) NOT NULL,
  `display_name` varchar(100) NOT NULL,
  `is_required` tinyint(1) NOT NULL DEFAULT '0',
  `field_type` varchar(50) NOT NULL DEFAULT 'text',
  `validation_rules` text COMMENT 'JSON rules for validation',
  `column_mapping` varchar(10) DEFAULT NULL COMMENT 'Excel column letter or CSV column index',
  `ordinal_position` int NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`config_id`),
  UNIQUE KEY `uk_import_field` (`import_type`,`field_name`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `import_records`;
CREATE TABLE `import_records` (
  `record_id` int NOT NULL AUTO_INCREMENT,
  `batch_id` int NOT NULL,
  `row_index` int NOT NULL,
  `record_data` text NOT NULL COMMENT 'JSON data of the record',
  `validation_errors` text COMMENT 'JSON array of validation errors if any',
  `status` enum('pending','valid','invalid','processed','skipped') NOT NULL DEFAULT 'pending',
  `generated_file_number` varchar(50) DEFAULT NULL COMMENT 'Generated file number if applicable',
  `processed_at` datetime DEFAULT NULL,
  `notes` text,
  PRIMARY KEY (`record_id`),
  KEY `fk_record_batch` (`batch_id`),
  CONSTRAINT `fk_record_batch` FOREIGN KEY (`batch_id`) REFERENCES `import_batches` (`batch_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=221 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `import_templates`;
CREATE TABLE `import_templates` (
  `template_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text,
  `file_path` varchar(255) NOT NULL,
  `import_type` varchar(50) NOT NULL,
  `created_by` int NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`template_id`),
  KEY `fk_template_user` (`created_by`),
  CONSTRAINT `fk_template_user` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `incidents`;
CREATE TABLE `incidents` (
  `id` int NOT NULL AUTO_INCREMENT,
  `shipment_id` varchar(50) DEFAULT NULL,
  `incident_date` datetime DEFAULT NULL,
  `incident_type` varchar(100) DEFAULT NULL,
  `severity` enum('Low','Medium','High','Critical') DEFAULT NULL,
  `description` text,
  `action_taken` text,
  `claim_filed` tinyint(1) DEFAULT NULL,
  `claim_amount` decimal(10,2) DEFAULT NULL,
  `resolution_status` enum('Pending','In Progress','Resolved','Closed') DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `insurance_policies`;
CREATE TABLE `insurance_policies` (
  `id` int NOT NULL AUTO_INCREMENT,
  `shipment_id` varchar(50) DEFAULT NULL,
  `policy_number` varchar(100) DEFAULT NULL,
  `insurance_provider` varchar(100) DEFAULT NULL,
  `coverage_type` varchar(100) DEFAULT NULL,
  `coverage_amount` decimal(10,2) DEFAULT NULL,
  `premium_amount` decimal(10,2) DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `status` enum('Active','Expired','Cancelled') DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `invoice_emails`;
CREATE TABLE `invoice_emails` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` int NOT NULL,
  `sent_date` datetime NOT NULL,
  `recipient_email` varchar(255) NOT NULL,
  `cc_email` varchar(255) DEFAULT NULL,
  `subject` varchar(255) NOT NULL,
  `message` text NOT NULL,
  `attachment` varchar(255) DEFAULT NULL,
  `sent_by` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `invoice_id` (`invoice_id`),
  KEY `sent_by` (`sent_by`),
  CONSTRAINT `invoice_emails_ibfk_1` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`invoice_id`),
  CONSTRAINT `invoice_emails_ibfk_2` FOREIGN KEY (`sent_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `invoices`;
CREATE TABLE `invoices` (
  `invoice_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `invoice_number` varchar(20) DEFAULT NULL,
  `file_number` varchar(50) NOT NULL,
  `total_amount` decimal(10,2) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `quantity` int NOT NULL,
  `price` int NOT NULL,
  `issue_date` date NOT NULL,
  `due_date` date NOT NULL,
  `notes` varchar(200) DEFAULT NULL,
  `status` enum('pending','paid','cancelled') NOT NULL,
  PRIMARY KEY (`invoice_id`),
  UNIQUE KEY `invoice_number` (`invoice_number`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `login_activity_log`;
CREATE TABLE `login_activity_log` (
  `idx` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `company_name` varchar(255) DEFAULT NULL,
  `last_login_attempts` int DEFAULT NULL,
  `session_duration` time DEFAULT NULL,
  `login_date` datetime DEFAULT NULL,
  `created_date` datetime DEFAULT NULL,
  PRIMARY KEY (`idx`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `login_activity_log_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `loose_cargo_items`;
CREATE TABLE `loose_cargo_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `file_number` varchar(20) NOT NULL,
  `chassis_number` varchar(50) NOT NULL,
  `car_model` varchar(50) NOT NULL,
  `cbm` decimal(10,2) DEFAULT NULL,
  `transporter` varchar(100) DEFAULT NULL,
  `driver_name` varchar(100) DEFAULT NULL,
  `driver_phone` varchar(50) DEFAULT NULL,
  `driver_license` varchar(50) DEFAULT NULL,
  `remarks` text,
  `created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `file_number` (`file_number`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `menu_roles`;
CREATE TABLE `menu_roles` (
  `id` int NOT NULL AUTO_INCREMENT,
  `menu_item` varchar(255) NOT NULL,
  `role_id` int NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_menu_role` (`menu_item`,`role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `messages`;
CREATE TABLE `messages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `sender_id` int NOT NULL,
  `receiver_id` int NOT NULL,
  `message` text NOT NULL,
  `is_read` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `is_file` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `sender_id` (`sender_id`),
  KEY `receiver_id` (`receiver_id`),
  CONSTRAINT `messages_ibfk_1` FOREIGN KEY (`sender_id`) REFERENCES `users` (`user_id`),
  CONSTRAINT `messages_ibfk_2` FOREIGN KEY (`receiver_id`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `note_items`;
CREATE TABLE `note_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `note_id` int NOT NULL,
  `description` varchar(255) NOT NULL,
  `quantity` decimal(10,2) NOT NULL DEFAULT '1.00',
  `unit_price` decimal(10,2) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `vat_included` tinyint(1) NOT NULL DEFAULT '0',
  `vat_amount` decimal(10,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`item_id`),
  KEY `note_id` (`note_id`),
  CONSTRAINT `fk_note_items_note` FOREIGN KEY (`note_id`) REFERENCES `notes` (`note_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `notes`;
CREATE TABLE `notes` (
  `note_id` int NOT NULL AUTO_INCREMENT,
  `note_number` varchar(20) NOT NULL,
  `note_type` enum('debit','credit') NOT NULL,
  `file_number` varchar(50) DEFAULT NULL,
  `invoice_id` int DEFAULT NULL,
  `customer_id` int NOT NULL,
  `user_id` int NOT NULL,
  `total_amount` decimal(10,2) NOT NULL,
  `currency` varchar(10) NOT NULL DEFAULT '$',
  `issue_date` date NOT NULL,
  `due_date` date DEFAULT NULL,
  `status` enum('draft','issued','cancelled','approved','denied') NOT NULL DEFAULT 'draft',
  `reference` varchar(255) DEFAULT NULL,
  `notes` text,
  `reason` varchar(255) NOT NULL,
  `approved_by` int DEFAULT NULL,
  `approval_date` datetime DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`note_id`),
  UNIQUE KEY `note_number` (`note_number`),
  KEY `invoice_id` (`invoice_id`),
  KEY `customer_id` (`customer_id`),
  KEY `user_id` (`user_id`),
  KEY `approved_by` (`approved_by`),
  CONSTRAINT `fk_notes_approver` FOREIGN KEY (`approved_by`) REFERENCES `users` (`user_id`) ON DELETE SET NULL,
  CONSTRAINT `fk_notes_customer` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`customer_id`),
  CONSTRAINT `fk_notes_invoice` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`invoice_id`) ON DELETE SET NULL,
  CONSTRAINT `fk_notes_user` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `notif_messages`;
CREATE TABLE `notif_messages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `message` varchar(255) NOT NULL,
  `type` varchar(50) NOT NULL,
  `icon` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `notifications`;
CREATE TABLE `notifications` (
  `id` int NOT NULL AUTO_INCREMENT,
  `file_id` int NOT NULL,
  `notif_message_id` int NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `file_number` varchar(255) NOT NULL,
  `notif_message` varchar(200) NOT NULL,
  `is_read` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `file_id` (`file_id`),
  CONSTRAINT `notifications_ibfk_1` FOREIGN KEY (`file_id`) REFERENCES `files` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=152 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `password_resets`;
CREATE TABLE `password_resets` (
  `id` int NOT NULL AUTO_INCREMENT,
  `email` varchar(100) NOT NULL,
  `token` varchar(255) NOT NULL,
  `expires_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `pending_approvals`;
CREATE TABLE `pending_approvals` (
  `id` int NOT NULL AUTO_INCREMENT,
  `file_number` varchar(20) NOT NULL,
  `new_all_in_amount` int NOT NULL,
  `proposed_by` varchar(50) NOT NULL,
  `proposed_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `approver` varchar(50) DEFAULT NULL,
  `approved` enum('Pending','Approved','Rejected') DEFAULT 'Pending',
  `approved_date` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `pre_proforma`;
CREATE TABLE `pre_proforma` (
  `id` int NOT NULL AUTO_INCREMENT,
  `file_number` varchar(20) NOT NULL,
  `all_in` enum('Yes','No') DEFAULT NULL,
  `all_in_amount` int DEFAULT NULL,
  `category` varchar(20) NOT NULL,
  `cost_code` varchar(20) NOT NULL,
  `cost_description` varchar(255) NOT NULL,
  `charge` decimal(10,2) NOT NULL,
  `vatable` enum('Yes','No') NOT NULL,
  `vat_amount` decimal(10,2) NOT NULL,
  `currency` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `approver` varchar(50) DEFAULT NULL,
  `updated_date` timestamp NULL DEFAULT NULL,
  `update_count` int DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=438 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `proforma`;
CREATE TABLE `proforma` (
  `id` int NOT NULL AUTO_INCREMENT,
  `file_number` varchar(20) NOT NULL,
  `all_in` enum('Yes','No') DEFAULT NULL,
  `all_in_amount` int DEFAULT NULL,
  `category` varchar(20) NOT NULL,
  `cost_code` varchar(20) NOT NULL,
  `cost_description` varchar(255) NOT NULL,
  `charge` decimal(10,2) NOT NULL,
  `vatable` enum('Yes','No') NOT NULL,
  `vat_amount` decimal(10,2) NOT NULL,
  `currency` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `restricted_words`;
CREATE TABLE `restricted_words` (
  `id` int NOT NULL AUTO_INCREMENT,
  `word` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `word` (`word`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `route_tracking`;
CREATE TABLE `route_tracking` (
  `id` int NOT NULL AUTO_INCREMENT,
  `shipment_id` varchar(50) DEFAULT NULL,
  `planned_route_id` int DEFAULT NULL,
  `actual_route` text,
  `deviation_reason` text,
  `additional_cost` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `planned_route_id` (`planned_route_id`),
  CONSTRAINT `route_tracking_ibfk_1` FOREIGN KEY (`planned_route_id`) REFERENCES `routes` (`route_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `routes`;
CREATE TABLE `routes` (
  `route_id` int NOT NULL AUTO_INCREMENT,
  `origin_port` varchar(100) DEFAULT NULL,
  `destination_port` varchar(100) DEFAULT NULL,
  `transit_points` text,
  `estimated_duration` int DEFAULT NULL,
  `distance` decimal(10,2) DEFAULT NULL,
  `base_cost` decimal(10,2) DEFAULT NULL,
  `risk_level` enum('Low','Medium','High') DEFAULT NULL,
  `active` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`route_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(255) NOT NULL,
  `setting_value` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `shipment_data`;
CREATE TABLE `shipment_data` (
  `id` int NOT NULL AUTO_INCREMENT,
  `file_no` varchar(255) NOT NULL,
  `transporter_name` varchar(255) NOT NULL,
  `truck_trailer_no` varchar(50) DEFAULT NULL,
  `driver_name` varchar(50) DEFAULT NULL,
  `driver_phone_number` varchar(20) DEFAULT NULL,
  `driver_license` varchar(50) DEFAULT NULL,
  `load_date` date NOT NULL,
  `port_date` date NOT NULL,
  `border_date` date NOT NULL,
  `border_crossing_date` date DEFAULT NULL,
  `dest_date` date NOT NULL,
  `offload_date` date NOT NULL,
  `empty_return_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `shipment_files`;
CREATE TABLE `shipment_files` (
  `file_id` int NOT NULL AUTO_INCREMENT,
  `creation_date` date NOT NULL,
  `port_date` date DEFAULT NULL,
  `transit_date` date DEFAULT NULL,
  `expected_delivery_date` date DEFAULT NULL,
  `delivery_date` date DEFAULT NULL,
  `customer_reference` int DEFAULT NULL,
  `container_reference` varchar(50) DEFAULT NULL,
  `assigned_truck` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `shipping_line`;
CREATE TABLE `shipping_line` (
  `id` int NOT NULL AUTO_INCREMENT,
  `file_no` varchar(255) NOT NULL,
  `delivery_order_apply_date` date NOT NULL,
  `delivery_order_received_date` date NOT NULL,
  `empty_return_date` date DEFAULT NULL,
  `actual_return_date` date DEFAULT NULL,
  `remarks` text,
  `container_deposit` enum('Yes','No') NOT NULL,
  `refund` int DEFAULT NULL,
  `damages` int DEFAULT NULL,
  `damage_hold` int DEFAULT NULL,
  `user_id` int NOT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `shipping_line_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `support_tickets`;
CREATE TABLE `support_tickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `reference_number` varchar(20) NOT NULL,
  `user_id` int NOT NULL,
  `subject` varchar(255) NOT NULL,
  `priority` enum('low','medium','high','critical') NOT NULL DEFAULT 'medium',
  `status` enum('open','in_progress','waiting','resolved','closed') NOT NULL DEFAULT 'open',
  `category` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `assigned_to` int DEFAULT NULL,
  PRIMARY KEY (`ticket_id`),
  UNIQUE KEY `reference_number` (`reference_number`),
  KEY `user_id` (`user_id`),
  KEY `assigned_to` (`assigned_to`),
  CONSTRAINT `support_tickets_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  CONSTRAINT `support_tickets_ibfk_2` FOREIGN KEY (`assigned_to`) REFERENCES `users` (`user_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `ticket_attachments`;
CREATE TABLE `ticket_attachments` (
  `attachment_id` int NOT NULL AUTO_INCREMENT,
  `message_id` int NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `file_path` varchar(255) NOT NULL,
  `file_type` varchar(100) NOT NULL,
  `file_size` int NOT NULL,
  `uploaded_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`attachment_id`),
  KEY `message_id` (`message_id`),
  CONSTRAINT `ticket_attachments_ibfk_1` FOREIGN KEY (`message_id`) REFERENCES `ticket_messages` (`message_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `ticket_categories`;
CREATE TABLE `ticket_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `ticket_messages`;
CREATE TABLE `ticket_messages` (
  `message_id` int NOT NULL AUTO_INCREMENT,
  `ticket_id` int NOT NULL,
  `user_id` int NOT NULL,
  `message` text NOT NULL,
  `is_internal` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`message_id`),
  KEY `ticket_id` (`ticket_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `ticket_messages_ibfk_1` FOREIGN KEY (`ticket_id`) REFERENCES `support_tickets` (`ticket_id`) ON DELETE CASCADE,
  CONSTRAINT `ticket_messages_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `trans_charges`;
CREATE TABLE `trans_charges` (
  `id` int NOT NULL AUTO_INCREMENT,
  `description` varchar(50) DEFAULT NULL,
  `status` enum('Active','Inactive') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `trans_cost_ref`;
CREATE TABLE `trans_cost_ref` (
  `id` int NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL,
  `status` enum('Active','Inactive') NOT NULL DEFAULT 'Active',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `trans_fees`;
CREATE TABLE `trans_fees` (
  `id` int NOT NULL AUTO_INCREMENT,
  `trans_id` int DEFAULT NULL,
  `file_number` varchar(20) NOT NULL,
  `all_in` enum('Yes','No') DEFAULT NULL,
  `agreed_amount` int DEFAULT NULL,
  `description` varchar(255) NOT NULL,
  `charge` decimal(10,2) NOT NULL,
  `balance` decimal(10,2) NOT NULL,
  `initial_date` date DEFAULT NULL,
  `final_date` date DEFAULT NULL,
  `other_date` date DEFAULT NULL,
  `currency` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `trans_id` (`trans_id`),
  CONSTRAINT `trans_fees_ibfk_1` FOREIGN KEY (`trans_id`) REFERENCES `transporter_info` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `transporter_info`;
CREATE TABLE `transporter_info` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `contact` varchar(50) NOT NULL,
  `country` varchar(10) NOT NULL,
  `status` int NOT NULL DEFAULT '2',
  `balance` decimal(10,2) DEFAULT '0.00',
  `balance_brought_forward` decimal(10,2) DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `transporters`;
CREATE TABLE `transporters` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `file_number` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `truck_details`;
CREATE TABLE `truck_details` (
  `id` int NOT NULL AUTO_INCREMENT,
  `file_no` varchar(50) NOT NULL,
  `container_code` varchar(50) NOT NULL,
  `transporter_name` varchar(100) DEFAULT NULL,
  `load_date` date DEFAULT NULL,
  `truck_trailer_no` varchar(50) DEFAULT NULL,
  `driver_name` varchar(100) DEFAULT NULL,
  `driver_phone_number` varchar(50) DEFAULT NULL,
  `driver_license` varchar(50) DEFAULT NULL,
  `port_date` date DEFAULT NULL,
  `border_date` date DEFAULT NULL,
  `dest_date` date DEFAULT NULL,
  `offload_date` date DEFAULT NULL,
  `empty_return_date` date DEFAULT NULL,
  `border_crossing_date` date DEFAULT NULL,
  `user_id` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `file_no` (`file_no`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `truck_details_ibfk_1` FOREIGN KEY (`file_no`) REFERENCES `files` (`file_number`),
  CONSTRAINT `truck_details_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `truck_reassignment_logs`;
CREATE TABLE `truck_reassignment_logs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `file_number` varchar(50) NOT NULL,
  `container_code` varchar(50) NOT NULL,
  `old_transporter` varchar(100) NOT NULL,
  `new_transporter` varchar(100) NOT NULL,
  `old_driver_name` varchar(100) DEFAULT NULL,
  `new_driver_name` varchar(100) NOT NULL,
  `reason` text NOT NULL,
  `reassigned_by` int NOT NULL,
  `reassignment_date` datetime NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_file_number` (`file_number`),
  KEY `idx_container_code` (`container_code`),
  KEY `idx_reassigned_by` (`reassigned_by`),
  CONSTRAINT `fk_reassignment_user` FOREIGN KEY (`reassigned_by`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `truck_reassignments`;
CREATE TABLE `truck_reassignments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `file_number` varchar(50) NOT NULL,
  `container_code` varchar(50) NOT NULL,
  `old_transporter` varchar(100) NOT NULL,
  `new_transporter` varchar(100) NOT NULL,
  `reassigned_by` int NOT NULL,
  `reason` text NOT NULL,
  `reassignment_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `file_number` (`file_number`),
  KEY `reassigned_by` (`reassigned_by`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `user_role`;
CREATE TABLE `user_role` (
  `role_id` int NOT NULL AUTO_INCREMENT,
  `role_name` varchar(50) NOT NULL,
  PRIMARY KEY (`role_id`),
  UNIQUE KEY `role_name` (`role_name`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `user_roles`;
CREATE TABLE `user_roles` (
  `user_id` int NOT NULL,
  `role_id` int NOT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `user_roles_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  CONSTRAINT `user_roles_ibfk_2` FOREIGN KEY (`role_id`) REFERENCES `user_role` (`role_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `user_id` int NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `full_name` varchar(100) NOT NULL,
  `password` varchar(255) NOT NULL,
  `user_role` enum('admin','general_manager','operations','finance','declaration_officer','shipping_line_clerk','transport_supervisor') DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `verified` tinyint DEFAULT '1',
  `failed_attempts` int NOT NULL DEFAULT '0',
  `last_attempt_time` timestamp NULL DEFAULT NULL,
  `last_password_change` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `role_id` int DEFAULT NULL,
  `last_active` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `email` (`email`),
  KEY `fk_user_role` (`role_id`),
  CONSTRAINT `fk_user_role` FOREIGN KEY (`role_id`) REFERENCES `user_role` (`role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;

INSERT INTO `admin_logs` VALUES
('1', '1', 'config_change', 'Component: backup\nCreated manual backup: backup_2025-02-21_03-45-39.sql', '102.140.245.174', '2025-02-21 06:45:39'),
('2', '1', 'config_change', 'Component: backup_settings\nUpdated backup schedule settings', '102.140.245.174', '2025-02-21 06:45:49'),
('3', '1', 'config_change', 'Component: backup\nCreated manual backup: backup_2025-03-01_04-33-58.sql', '102.140.245.174', '2025-03-01 07:33:58'),
('4', '1', 'config_change', 'Component: backup_download\nDownloaded backup file: backup_2025-03-01_04-33-58.sql', '102.140.245.174', '2025-03-01 07:34:03');

INSERT INTO `backup_settings` VALUES
('1', 'backup_frequency', 'weekly', '2024-12-29 16:35:13', '2025-02-21 06:45:49'),
('2', 'retention_days', '30', '2024-12-29 16:35:13', '2024-12-29 16:35:13'),
('3', 'notify_email', 'hi@myne.co.ke', '2024-12-29 16:35:13', '2024-12-29 16:50:53'),
('4', 'last_backup_time', '', '2024-12-29 16:35:13', '2024-12-29 16:35:13'),
('5', 'backup_enabled', '1', '2024-12-29 16:35:13', '2024-12-29 16:35:13');

INSERT INTO `banks` VALUES
('1', 'Ecobank', 'active'),
('2', 'I & M Bank', 'active');

INSERT INTO `charges` VALUES
('1', 'RFT/RW/KI/002/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-10 13:51:03'),
('2', 'RFT/RW/KI/003/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-10 17:00:45'),
('3', 'RFT/RW/KI/004/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-11 06:51:30'),
('4', 'RFT/RW/KI/005/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-11 06:57:25'),
('5', 'RFT/RW/KI/006/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-11 07:02:21'),
('6', 'RFT/RW/KI/007/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 06:06:02'),
('7', 'RFT/RW/KI/008/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 06:07:57'),
('8', 'RFT/RW/KI/009/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 06:10:20'),
('9', 'RFT/RW/KI/010/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 06:16:04'),
('10', 'RFT/RW/KI/011/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 06:21:44'),
('11', 'RFT/RW/KI/012/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 06:24:35'),
('12', 'RFT/RW/KI/013/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 06:28:18'),
('13', 'RFT/RW/KI/014/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 06:33:59'),
('14', 'RFT/RW/KI/015/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 06:36:30'),
('15', 'RFT/RW/KI/016/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 06:40:18'),
('16', 'RFT/RW/KI/017/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 06:44:07'),
('17', 'RFT/RW/KI/018/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 06:52:56'),
('18', 'RFT/RW/KI/017/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 08:37:34'),
('19', 'RFT/BU/BU/018/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 08:41:59'),
('20', 'RFT/RW/KI/019/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 08:51:47'),
('21', 'RFT/RW/KI/020/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 09:15:00'),
('22', 'RFT/BU/BU/021/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 09:19:15'),
('23', 'RFT/BU/BU/022/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 09:21:19'),
('24', 'RFT/RW/KI/023/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 09:26:13'),
('25', 'RFT/RW/KI/024/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 09:36:22'),
('26', 'RFT/RW/KI/025/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 09:41:42'),
('27', 'RFT/RW/KI/026/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 09:45:56'),
('28', 'RFT/RW/KI/027/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 09:49:08'),
('29', 'RFT/RW/KI/024/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 13:50:22'),
('30', 'RFT/RW/KI/025/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 13:55:22'),
('31', 'RFT/RW/KI/026/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 13:57:59'),
('32', 'RFT/RW/KI/027/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 14:02:54'),
('33', 'RFT/RW/KI/028/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 14:06:49'),
('34', 'RFT/RW/KI/029/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 14:17:38'),
('35', 'RFT/RW/KI/030/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 14:20:40'),
('36', 'RFT/BU/BU/031/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 14:22:28'),
('37', 'RFT/RW/KI/032/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 14:30:53'),
('38', 'RFT/RW/KI/033/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 14:33:56'),
('39', 'RFT/DR/KAL/034/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 14:46:48'),
('40', 'RFT/RW/KI/035/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 14:57:35'),
('41', 'RFT/RW/KI/036/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 15:00:33'),
('42', 'RFT/RW/KI/037/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 15:08:23'),
('43', 'RFT/DR/GOM/038/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 15:10:24'),
('44', 'RFT/RW/KI/039/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 15:35:44'),
('45', 'RFT/DR/LUB/040/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-12 16:00:18'),
('46', 'RFT/RW/KI/041/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 09:51:32'),
('47', 'RFT/RW/KI/042/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 09:54:47'),
('48', 'RFT/DR/LUB/043/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 09:57:22'),
('49', 'RFT/RW/KI/044/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 09:59:59'),
('50', 'RFT/RW/KI/045/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 10:14:09'),
('51', 'RFT/ZM/LU/046/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 10:17:09'),
('52', 'RFT/ZM/LU/047/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 10:22:06'),
('53', 'RFT/DR/LUB/048/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 10:25:35'),
('54', 'RFT/DR/GOM/049/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 10:29:43'),
('55', 'Connection failed: Too many co', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 10:33:23'),
('56', 'RFT/DR/LUB/050/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 10:42:17'),
('57', 'RFT/BU/BU/051/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 10:46:07'),
('58', 'RFT/ZM/LU/052/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 10:50:16'),
('59', 'RFT/RW/KI/053/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 10:54:19'),
('60', 'RFT/DR/GOM/054/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 10:58:15'),
('61', 'RFT/DR/LUB/055/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 11:01:36'),
('62', 'RFT/DR/GOM/056/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 11:04:23'),
('63', 'RFT/DR/GOM/057/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 11:06:59'),
('64', 'RFT/DR/LUB/058/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 11:10:02'),
('65', 'RFT/RW/KI/059/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 11:19:55'),
('66', 'RFT/BU/BU/060/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 11:26:02'),
('67', 'RFT/DR/LUB/061/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 11:29:35'),
('68', 'RFT/ZM/KI/062/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 11:34:14'),
('69', 'RFT/BU/BU/063/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 11:47:00'),
('70', 'RFT/BU/BU/064/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 11:48:28'),
('71', 'RFT/RW/KI/065/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 12:01:23'),
('72', 'RFT/BU/BU/066/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 12:05:36'),
('73', 'RFT/DR/GOM/067/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 12:10:42'),
('74', 'RFT/DR/LUB/068/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 13:37:37'),
('75', 'RFT/DR/LUB/069/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 13:40:02'),
('76', 'RFT/DR/LUB/070/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 13:44:19'),
('77', 'RFT/DR/GOM/071/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 13:46:12'),
('78', 'RFT/DR/LUB/072/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 13:48:15'),
('79', 'RFT/DR/LUB/073/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 13:52:44'),
('80', 'RFT/RW/KI/074/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 13:57:30'),
('81', 'RFT/DR/GOM/075/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 13:59:26'),
('82', 'RFT/RW/KI/076/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 14:03:59'),
('83', 'RFT/BU/BU/077/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 14:19:03'),
('84', 'RFT/RW/KI/078/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 14:22:06'),
('85', 'RFT/DR/GOM/079/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 14:24:32'),
('86', 'RFT/DR/LUB/080/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 14:27:06'),
('87', 'RFT/RW/KI/081/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 14:45:25'),
('88', 'RFT/RW/KI/082/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 15:03:26'),
('89', 'RFT/BU/BU/083/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 15:08:12'),
('90', 'RFT/DR/LUB/084/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 15:10:40'),
('91', 'RFT/RW/KI/085/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 15:15:38'),
('92', 'RFT/RW/KI/086/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 15:17:56'),
('93', 'RFT/BU/BU/087/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 15:22:42'),
('94', 'RFT/RW/KI/088/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 15:24:24'),
('95', 'RFT/DR/LUB/089/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 15:26:33'),
('96', 'RFT/BU/BU/090/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 15:29:26'),
('97', 'RFT/BU/BU/091/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 15:35:12'),
('98', 'RFT/RW/KI/092/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 15:43:20'),
('99', 'RFT/RW/KI/093/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 15:47:47'),
('100', 'RFT/RW/KI/094/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 15:55:33'),
('101', 'RFT/DR/LUB/095/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 16:00:35'),
('102', 'RFT/RW/KI/096/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 16:03:41'),
('103', 'RFT/RW/KI/097/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 16:07:18'),
('104', 'RFT/RW/KI/098/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 16:09:19'),
('105', 'RFT/RW/KI/099/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 16:10:56'),
('106', 'RFT/RW/KI/100/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 16:15:19'),
('107', 'RFT/RW/KI/101/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 16:20:15'),
('108', 'RFT/RW/KI/102/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-13 16:21:59'),
('109', 'RFT/RW/KI/103/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-15 14:09:50'),
('110', 'RFT/DR/GOM/104/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-15 14:12:24'),
('111', 'RFT/RW/KI/105/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-15 14:14:28'),
('112', 'RFT/DR/GOM/106/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-15 14:36:52'),
('113', 'RFT/DR/LUB/107/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-15 17:34:38'),
('114', 'RFT/DR/SOL/107/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-15 17:38:20'),
('115', 'RFT/DR/BUK/107/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-21 07:39:01'),
('116', 'RFT/DR/BUK/107/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-21 07:48:52'),
('117', 'RFT/BU/BU/107/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-21 08:12:17'),
('118', 'RFT/BU/BU/107/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-06-21 08:15:10'),
('119', 'RFT/107/KI/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-07-04 15:15:06'),
('120', 'RFT/107/BU/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-07-04 15:17:30'),
('121', 'RFT/108/BU/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-07-04 15:57:02'),
('122', 'RFT/109/KI/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-07-04 16:06:12'),
('123', 'RFT/110/KI/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-07-04 16:10:23'),
('124', 'RFT/111/LU/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-07-04 16:12:36'),
('125', 'RFT/112/LU/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-07-04 16:17:02'),
('126', 'RFT/113/LU/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-07-04 16:22:33'),
('127', 'RFT/114/LU/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-07-04 16:24:25'),
('128', 'RFT/115/KAL/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-07-05 07:38:04'),
('129', 'RFT/115/LUB/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-07-05 07:54:46'),
('130', 'RFT/115/LUB/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-07-05 08:01:21'),
('131', 'RFT/115/LUB/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-07-05 08:10:59'),
('132', 'RFT/115/LUB/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-07-05 08:13:06'),
('133', 'RFT/115/LUB/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-07-05 08:17:46'),
('134', 'RFT/115/LUB/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-07-25 09:43:39'),
('135', 'RFT/116/BUK/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-07-25 09:47:23'),
('136', 'RFT/117/LUB/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-07-25 10:00:41'),
('137', 'RFT/118/LUB/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-07-29 09:44:31'),
('138', 'RFT/119/LUB/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-08-07 16:01:17'),
('139', 'RFT/120/KI/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-08-07 16:26:06'),
('140', 'RFT/121/KI/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-08-16 07:11:03'),
('141', 'RFT/122/KI/24', NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', NULL, '2024-08-16 07:14:00'),
('143', 'RFT/LOC/001/25', NULL, NULL, NULL, NULL, NULL, '2025-02-18 14:03:00'),
('146', 'RFT/DR/KAL/001/25', NULL, NULL, NULL, NULL, NULL, '2025-03-01 08:26:55'),
('149', 'RFT/RW/KI/001/25', NULL, NULL, NULL, NULL, NULL, '2025-03-04 08:26:46'),
('150', 'RFT/RW/KI/002/25', NULL, NULL, NULL, NULL, NULL, '2025-03-04 08:39:51'),
('151', 'RFT/RW/KI/003/25', NULL, NULL, NULL, NULL, NULL, '2025-03-04 08:49:41'),
('152', 'RFT/RW/KI/004/25', NULL, NULL, NULL, NULL, NULL, '2025-03-04 10:16:52'),
('153', 'RFT/RW/KI/005/25', NULL, NULL, NULL, NULL, NULL, '2025-03-04 10:22:52'),
('154', 'RFT/RW/KI/006/25', NULL, NULL, NULL, NULL, NULL, '2025-03-04 10:43:09'),
('155', 'RFT/DR/GOM/001/25', NULL, NULL, NULL, NULL, NULL, '2025-03-06 13:04:35'),
('161', 'RFT/DR/SOL/008/25', NULL, NULL, NULL, NULL, NULL, '2025-03-07 15:05:55'),
('162', 'RFT/DR/BUK/009/25', NULL, NULL, NULL, NULL, NULL, '2025-03-07 15:10:24');




INSERT INTO `container_deposit` VALUES
('6', 'INCHCAPE SHIPPING SERVICES', 'normal', 'MOLU18006052265', '0000-00-00 00:00:00', '1 UNIT TOYOTA VOXY', NULL, '0.00', NULL, NULL, NULL, NULL, ' - salman on 2024-09-17', NULL, NULL, NULL, '14', '2024-09-17 11:43:04'),
('7', 'SEAFRONT', 'fixed', '10TT501TJ039', '0000-00-00 00:00:00', '', NULL, '0.00', NULL, NULL, NULL, NULL, ' - karim on 2024-10-01', NULL, NULL, NULL, '12', '2024-10-01 16:15:03'),
('8', 'CMA ', 'fixed', 'COP0275380', '0000-00-00 00:00:00', '', NULL, '0.00', NULL, NULL, NULL, NULL, ' - hafsa on 2024-10-01', NULL, NULL, NULL, '20', '2024-10-01 16:38:15'),
('9', 'CMA ', 'fixed', 'CHN1494703', '0000-00-00 00:00:00', '', NULL, '0.00', NULL, NULL, NULL, NULL, ' - karim on 2024-10-01', NULL, NULL, NULL, '12', '2024-10-01 16:55:21'),
('10', 'maersk', 'fixed', '242326140', '0000-00-00 00:00:00', '', NULL, '0.00', NULL, NULL, NULL, NULL, ' - karim on 2024-10-02', NULL, NULL, NULL, '12', '2024-10-02 10:53:30'),
('12', 'MAERSK', 'fixed', '242372021', '0000-00-00 00:00:00', '', NULL, '0.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '20', '2024-10-25 11:55:28'),
('13', 'CMA-CGM', 'fixed', 'USG0285219', '0000-00-00 00:00:00', '', NULL, '0.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '20', '2024-10-25 12:32:36'),
('14', 'CMA-CGM', 'fixed', 'USG0285219', '0000-00-00 00:00:00', '', NULL, '0.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '20', '2024-10-25 18:50:31'),
('15', 'MAERSK', 'normal', 'RW485X', '2025-02-10 00:00:00', '', '0.00', '5000.00', NULL, NULL, NULL, NULL, ' - Admin on 2025-02-22', NULL, NULL, NULL, '1', '2025-02-22 19:42:36'),
('16', 'MAERSK', 'normal', 'TSTE001', '2025-02-28 00:00:00', '', '0.00', '2000.00', NULL, NULL, NULL, NULL, 'Deposited by client - Admin on 2025-02-28', NULL, NULL, NULL, '1', '2025-02-28 08:01:11'),
('17', 'MAERSK', 'normal', 'TSTE003', '2025-02-28 00:00:00', '', '0.00', '5000.00', NULL, NULL, NULL, NULL, ' - Admin on 2025-03-01', NULL, NULL, NULL, '1', '2025-03-01 08:28:03'),
('18', 'MAERSK', 'normal', 'TSTEX001', '2025-03-01 00:00:00', '', '0.00', '4000.00', NULL, NULL, NULL, NULL, ' - Admin on 2025-03-02', NULL, NULL, NULL, '1', '2025-03-02 07:34:45'),
('19', 'Gold Star (Diamond shipping)', 'normal', 'GOSUSNH8489959', '2025-01-03 00:00:00', '', '0.00', '3000.00', NULL, NULL, NULL, NULL, 'paid by royal - hafsa on 2025-03-04', NULL, NULL, NULL, '20', '2025-03-04 08:29:50');

INSERT INTO `container_details` VALUES
('623', 'RFT/RW/KI/001/25', 'DRYU2132035', '20', NULL, NULL, NULL, NULL, NULL, '2025-01-07', NULL, NULL, 'KAMURU TRADING COMPANY', 'Bakari Mayala', '', '', '2025-01-08', '2025-01-08', '2025-01-12', '2025-01-12', '2025-01-13', NULL, '2025-01-18', ''),
('624', 'RFT/RW/KI/001/25', 'GOSU1020794', '40', NULL, NULL, NULL, NULL, NULL, '2025-01-07', NULL, NULL, 'KAMURU TRADING COMPANY', 'Juma Kayiranga', '', '', '2025-01-08', '2025-01-08', '2025-01-12', '2025-01-12', '2025-01-13', NULL, '2025-01-18', ''),
('625', 'RFT/RW/KI/006/25', 'TCLU7884236', '40', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'OTHERS', 'LESTER GRIGIS', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, ''),
('626', 'RFT/RW/KI/006/25', 'BMOU6872682', '40', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'OTHERS', 'ADAMU NTAHORUTABA', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, ''),
('627', 'RFT/RW/KI/006/25', 'MEDU8763362', '40', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'OTHERS', 'RAMADHAN MSUHERO', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, ''),
('628', 'RFT/DR/GOM/007/25', 'SEKU9063451', '40HC', NULL, NULL, NULL, NULL, NULL, '2025-01-20', '2025-02-21', '2025-02-20', 'POWA BUSINESS ', 'RAJABU SAIDI MGANGA', '0693803902', '', '2025-03-21', '2025-02-21', '2025-02-28', '2025-02-28', '2025-03-03', NULL, NULL, 'Driver alichelewa kufika rusumo hii ni reefer'),
('629', 'RFT/DR/SOL/008/25', 'AMCU9330182', '40', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'OTHERS', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, ''),
('630', 'RFT/DR/BUK/009/25', 'FBIU5221825', '40', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'OTHERS', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, ''),
('631', 'RFT/DR/BUK/009/25', 'OTPU6320240', '40', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'OTHERS', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '');





INSERT INTO `cost_reference` VALUES
('1', 'Operational', '1-101', 'Agency Fee'),
('2', 'Operational', '1-102', 'Commission on Disbursement'),
('3', 'Non-Operational', '3-101', 'Delivery Order'),
('4', 'Non-Operational', '3-102', 'Port Charges'),
('5', 'Non-Operational', '3-103', 'Handover Fee'),
('6', 'Non-Operational', '3-104', 'Consolidation Fee'),
('7', 'Non-Operational', '3-105', 'Container Deposit Fee'),
('8', 'Non-Operational', '3-106', 'Wharfage'),
('9', 'Non-Operational', '3-107', 'Port Handling'),
('10', 'Non-Operational', '3-108', 'Physical Verification'),
('11', 'Non-Operational', '3-109', 'Storage'),
('12', 'Non-Operational', '3-110', 'Removal Fee'),
('13', 'Non-Operational', '3-111', 'Additional Storage'),
('14', 'Non-Operational', '3-112', 'Customs Rent'),
('15', 'Non-Operational', '3-113', 'Verification Misc.'),
('16', 'Non-Operational', '3-114', 'Permit Charges'),
('17', 'Non-Operational', '3-115', 'TBS Fee'),
('18', 'Non-Operational', '3-116', 'TFDA Fee'),
('19', 'Non-Operational', '3-117', 'Chemical Permit Fee'),
('20', 'Non-Operational', '3-118', 'Livestock P Fee'),
('21', 'Non-Operational', '3-119', 'Dairy Board Permit'),
('22', 'Non-Operational', '3-120', 'Atomic Permit'),
('23', 'Non-Operational', '3-121', 'Weight & Measure'),
('24', 'Non-Operational', '3-122', 'Customs Alteration'),
('25', 'Non-Operational', '3-123', 'Number Plate'),
('26', 'Non-Operational', '3-124', 'Temporary Insurance'),
('27', 'Non-Operational', '3-125', 'Transportation Charges'),
('28', 'Non-Operational', '3-126', 'Transport Additional'),
('29', 'Non-Operational', '3-127', 'Load Off Load'),
('30', 'Non-Operational', '3-128', 'Lift on Lift Off'),
('31', 'Non-Operational', '3-129', 'Demurrages'),
('32', 'Non-Operational', '3-130', 'Demurrages Additional'),
('33', 'Non-Operational', '3-131', 'Documentation Fees'),
('34', 'Non-Operational', '3-132', 'Total Non Operational Costs'),
('35', 'Non-Operational', '3-133', 'Reefer Charges'),
('36', 'Non-Operational', '3-134', 'Miscellaneous'),
('37', 'Non-Operational', '3-135', 'Drop-Off Charges'),
('38', 'Non-Operational', 'Corridor Levy', ''),
('39', 'Non-Operational', '3-137', 'DG'),
('40', 'Non-Operational', '3-136', 'Corridor Levy'),
('41', 'Non-Operational', '3-138', 'OGFREM ');



INSERT INTO `customers` VALUES
('9', NULL, 'Kamuru Trading', '', '', 'Kigali City, Nyarugenge\r\nKigali, Rwanda.', 'Kigali', NULL, 'Rwanda', '0', '1', NULL),
('11', NULL, 'Shipping GL', '', '727724169', 'Kanyanuhanga 23 Blvd,\r\nQuartier Les Volcans \r\nGoma, DRC\r\n', 'Goma', NULL, 'DRC', '0', '1', NULL),
('12', NULL, 'Dylan', '', '727724169', 'Bujumbura\r\n', 'Bujumbura', NULL, 'Burundi', '0', '1', NULL),
('13', NULL, 'Powa Business', '', '727724169', 'Kigali, Rwanda\r\n', 'Kigali', NULL, 'Rwanda', '0', '1', NULL),
('14', NULL, 'Denholm Global Logistics Ltd', '', '727724169', 'Unit D1 Dolphine Ind Estate\r\n Windmill Road\r\nSunbury on Thames, TW167HE\r\n\r\n', 'London', NULL, 'UK', '0', '1', NULL),
('15', NULL, 'KASCCO LTD', '', '727724169', 'P.O.BOX 110340\r\nSolwezi, Zambia\r\n\r\n\r\n', 'Solwezi', NULL, 'Zambia', '0', '1', NULL),
('16', NULL, 'METRO WATERS', '', '', 'DAR', '', NULL, NULL, '0', '1', ''),
('18', NULL, 'OCEAN ALLUMINIUM 7HILLS', '', '+255693686910', 'DAR KIGAL', 'DAR KIGAL', NULL, NULL, '0', '1', ''),
('21', NULL, 'MBARUSHA TRADING (SHABADEUX)', '', '+250 788 560 76', 'KIGALI', 'RWANDA', NULL, NULL, '0', '1', ''),
('22', NULL, 'KASCCO ZAMBIA', '', '+260 973691058', 'ZAMBIA', 'KITWE', NULL, NULL, '0', '1', ''),
('23', NULL, 'RAD METALS', '', '+255 779631814', '', 'BURUNDI', NULL, NULL, '0', '1', ''),
('25', NULL, 'KASERKANDIS CONSTRUCTION ', '', '0754309666', 'MWANZA', 'TANZANIA', NULL, NULL, '0', '1', ''),
('27', NULL, 'GULLE INDUSTRY', '', '0692108114', 'DAR ES SALAAM', 'TANZANIA', NULL, NULL, '0', '1', ''),
('28', NULL, 'GULED WHOLESALERS', '', '0745793079', 'MWANZA', 'TANZANIA', NULL, NULL, '0', '1', ''),
('29', NULL, 'MS DUMA TANZGRAPHITE', '', '0716176688', 'MOROGORO', 'TANZANIA', NULL, NULL, '0', '1', ''),
('30', NULL, 'GWAMAKA TM', '', '255 762 692 639', 'TUNDUMA', 'TUNDUMA', NULL, NULL, '0', '1', ''),
('31', NULL, 'CONGO (other clients)', '', '', 'CONGO', 'GOMA & LUBUMBASHI', NULL, NULL, '0', '1', ''),
('32', NULL, 'RWANDA (Other Clients)', '', '', 'Rwanda, kigali', 'kigali', NULL, NULL, '0', '1', ''),
('33', NULL, 'BURUNDI (Other clients)', '', '', 'Burundi', 'Bujumbura', NULL, NULL, '0', '1', ''),
('34', NULL, 'ZAMBIA (Other Client)', '', '', 'LUSAKA', 'LUSAKA, KITWE, NDOLA', NULL, NULL, '0', '1', ''),
('35', NULL, 'RIFT VALLEY', '', '27791984435', 'DAR', 'DAR TZ', NULL, NULL, '0', '1', ''),
('37', NULL, 'OTHER (Local) ', '', '27791984435', 'DAR', 'DAR TZ', NULL, NULL, '0', '1', ''),
('38', NULL, 'HK INTERNATIONAL', '', '255 755 003 004', 'DAR ', 'DAR TZ', NULL, NULL, '0', '1', ''),
('39', NULL, 'TANZGRAPHITE', '', ' ', 'DAR ', 'DAR TZ', NULL, NULL, '0', '1', ''),
('40', NULL, 'Amuges ', '', '+250 788 409 60', 'Kigali Rwanda', 'Kigali', NULL, NULL, '0', '1', 'amugesnew@gmail.com'),
('41', NULL, 'HIGHLAND ESTATES LIMITED', '', '0713200979', 'P.O. Box 7173\r\n', 'Dar es salaam, Tanzania', NULL, NULL, '0', '1', 'royalfreight@royalfreight.co.tz'),
('42', NULL, 'BOUTIQUE AMARE LTD', '', '', '', '', NULL, NULL, '0', '1', ''),
('43', NULL, 'DOMUS (ALINE)', '', '+250 788 539 95', 'KIGAL RWANDA', 'Kigali', NULL, NULL, '0', '1', ' ');




INSERT INTO `deleted_records` VALUES
('2', 'RFT/BU/BU/107/24', '2024-06-21 08:15:45', 'RF Admin'),
('3', 'RFT/107/BU/24', '2024-07-04 15:53:02', 'hafsa'),
('4', 'RFT/115/KAL/24', '2024-07-05 07:39:05', 'Admin'),
('5', 'RFT/115/LUB/24', '2024-07-05 07:57:23', 'Admin'),
('6', 'RFT/115/LUB/24', '2024-07-05 08:07:01', 'Admin'),
('7', 'RFT/115/LUB/24', '2024-07-05 08:11:54', 'Admin'),
('8', 'RFT/115/LUB/24', '2024-07-05 08:13:37', 'Admin'),
('9', 'RFT/115/LUB/24', '2024-07-05 08:18:28', 'Admin'),
('10', 'RFT/123/BUK/24', '2024-08-26 11:54:28', 'Admin'),
('11', 'RFT/144/GOM/24', '2024-09-15 09:25:23', 'Admin'),
('12', 'RFT/144/GOM/24', '2024-09-15 09:41:52', 'Admin'),
('13', 'RFT/151/GOM/24', '2024-10-01 08:40:20', 'Admin'),
('14', 'RFT/152/GOM/24', '2024-10-02 19:09:49', 'Admin'),
('15', 'RFT/152/GOM/24', '2024-10-02 19:19:49', 'Admin'),
('16', 'RFT/152/KI/24', '2024-10-25 11:28:45', 'hafsa'),
('17', 'RFT/153/LUB/24', '2024-10-25 12:33:58', 'hafsa'),
('18', 'RFT/144/BUK/24', '2025-03-02 13:50:07', 'RF Admin'),
('19', 'RFT/DR/BUK/001/25', '2025-03-02 22:21:47', 'RF Admin'),
('20', 'RFT/DR/LUB/001/25', '2025-03-02 22:21:52', 'RF Admin'),
('21', 'RFT/LOC/005/25', '2025-03-02 22:21:57', 'RF Admin'),
('22', 'RFT/LOC/008/25', '2025-03-02 22:22:03', 'RF Admin'),
('23', 'RFT/RW/KI/001/25', '2025-03-02 22:22:08', 'RF Admin'),
('24', 'RFL/001/03/25', '2025-03-06 19:10:02', 'RF Admin'),
('25', 'RFT/ZM/LU/008/25', '2025-03-06 23:29:00', 'RF Admin'),
('26', 'RFL/002/03/25', '2025-03-07 06:58:29', 'RF Admin'),
('27', 'RFL/001/03/25', '2025-03-07 14:24:05', 'RF Admin'),
('28', 'RFT/DR/SOL/008/25', '2025-03-07 14:24:28', 'RF Admin');



INSERT INTO `destinations` VALUES
('1', 'Zambia', 'Lusaka', 'RFT-ZM-LU'),
('2', 'Zambia', 'Ndola', 'RFT-ZM-ND');

INSERT INTO `email_attachments` VALUES
('1', '4', 'Sam Nujoma - Biz Card.pdf', 'uploads/attachments/67554effe6b7b_Sam Nujoma - Biz Card.pdf', 'application/pdf', '100077', '2024-12-08 10:47:11'),
('2', '1', 'Sam Nujoma - Biz Card.pdf', 'uploads/attachments/6755526889d34_Sam Nujoma - Biz Card.pdf', 'application/pdf', '100077', '2024-12-08 11:01:44'),
('3', '1', 'Sam Nujoma - Biz Card.pdf', 'uploads/attachments/6755527011273_Sam Nujoma - Biz Card.pdf', 'application/pdf', '100077', '2024-12-08 11:01:52');

INSERT INTO `emails` VALUES
('1', 'hi@myne.co.ke', 'hafsa@royalfreight.co.tz', 'Testing', '<p>Testing</p>', 'draft', '0', '0', '2024-12-08 11:01:52'),
('2', 'hi@myne.co.ke', 'nujoma@mynecoke', 'Quotation for Internet Supply', '<p>Please provide the quotation</p>', 'draft', '0', '0', '2024-12-08 11:03:12');

INSERT INTO `expense_categories` VALUES
('2', 'Operating - ', 'Operating Expenses', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('3', 'Administration - ', 'Administration Expenses', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('4', 'Administration - ', 'Other Administration Expenses', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('5', 'Employment - 2-101', '2-101 - Salary & Wages', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('6', 'Employment - 2-102', '2-102 - Transport Allowance', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('7', 'Employment - 2-103', '2-103 - House Allowance', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('8', 'Employment - 2-104', '2-104 - Payment in Lieu of Leave', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('9', 'Employment - 2-105', '2-105 - Notice Pay', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('10', 'Employment - 2-106', '2-106 - Bonus Expenses', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('11', 'Employment - 2-107', '2-107 - Social Security Fund Employer\'s Expenses', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('12', 'Employment - 2-108', '2-108 - SDL Expenses', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('13', 'Employment - 2-109', '2-109 - WCF Expenses', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('14', 'Insurance - 2-319', '2-319 - Insurance - Motor Vehicles', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('15', 'Insurance - 2-320', '2-320 - Insurance-Motor Cycles', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('16', 'Insurance - 2-321', '2-321 - Custom Bond (Insurance on Bond) - CB8', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('17', 'Repairs & Maintenance - 2-306', '2-306 - Motor Vehicle Repairs and Maintenance', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('18', 'Repairs & Maintenance - 2-307', '2-307 - Motor Cycle Repairs and Maintenance', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('19', 'Repairs & Maintenance - 2-308', '2-308 - Furniture & Equipment Repairs and Maintenance', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('20', 'Repairs & Maintenance - 2-305', '2-305 - Depreciation Expenses', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('21', 'Repairs & Maintenance - 2-309', '2-309 - Business License', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('22', 'Repairs & Maintenance - 2-310', '2-310 - Sumatra Fee', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('23', 'Repairs & Maintenance - 2-311', '2-311 - TAFFA Subscription Fee', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('24', 'Repairs & Maintenance - 2-312', '2-312 - Customs License', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('25', 'Repairs & Maintenance - 2-313', '2-313 - IDF Fees', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('26', 'Repairs & Maintenance - 2-314', '2-314 - Staff Uniforms', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('27', 'Repairs & Maintenance - 2-315', '2-315 - Printing and Stationery', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('28', 'Repairs & Maintenance - 2-316', '2-316 - Fuel', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('29', 'Repairs & Maintenance - 2-317', '2-317 - Condelence', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('30', 'Repairs & Maintenance - 2-318', '2-318 - Legal Fees', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('31', 'Repairs & Maintenance - 2-319', '2-319 - Office Expenses', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('32', 'Utility - 2-201', '2-201 - Electricity Expenses', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('33', 'Utility - 2-202', '2-202 - Water & Sewage Expenses', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('34', 'Utility - 2-203', '2-203 - Cleaning & Sanitation Expenses', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('35', 'Finance - 2-501', '2-501 - Bank Charges', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('36', 'Finance - 2-502', '2-502 - Bank Commission', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('37', 'Finance - 2-503', '2-503 - Forex Gain / Loss', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('38', 'Selling & Distribution - 2-401', '2-401 - Travelling Expenses', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('39', 'Selling & Distribution - 2-402', '2-402 - Marketing & Advertisement', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('40', 'Selling & Distribution - 2-403', '2-403 - Bad Debts', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('41', 'Selling & Distribution - 2-404', '2-404 - Provision for Bad Debts', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57'),
('42', 'Selling & Distribution - 2-405', '2-405 - Tender Documents & Fees', 'Office', 'Active', '1', '2025-03-03 08:20:57', '2025-03-03 08:20:57');

INSERT INTO `expense_ref` VALUES
('1', 'Operating', '', 'Operating Expenses', '2024-04-18 08:28:49'),
('2', 'Administration', '', 'Administration Expenses', '2024-04-18 08:28:49'),
('3', 'Administration', '', 'Other Administration Expenses', '2024-04-18 08:28:49'),
('4', 'Employment', '2-101', 'Salary & Wages', '2024-04-18 08:28:49'),
('5', 'Employment', '2-102', 'Transport Allowance', '2024-04-18 08:28:49'),
('6', 'Employment', '2-103', 'House Allowance', '2024-04-18 08:28:49'),
('7', 'Employment', '2-104', 'Payment in Lieu of Leave', '2024-04-18 08:28:49'),
('8', 'Employment', '2-105', 'Notice Pay', '2024-04-18 08:28:49'),
('9', 'Employment', '2-106', 'Bonus Expenses', '2024-04-18 08:28:49'),
('10', 'Employment', '2-107', 'Social Security Fund Employer\'s Expenses', '2024-04-18 08:28:49'),
('11', 'Employment', '2-108', 'SDL Expenses', '2024-04-18 08:28:49'),
('12', 'Employment', '2-109', 'WCF Expenses', '2024-04-18 08:28:49'),
('14', 'Insurance', '2-319', 'Insurance - Motor Vehicles', '2024-04-18 08:28:49'),
('15', 'Insurance', '2-320', 'Insurance-Motor Cycles', '2024-04-18 08:28:49'),
('16', 'Insurance', '2-321', 'Custom Bond (Insurance on Bond) - CB8', '2024-04-18 08:28:49'),
('18', 'Repairs & Maintenance', '2-306', 'Motor Vehicle Repairs and Maintenance', '2024-04-18 08:28:49'),
('19', 'Repairs & Maintenance', '2-307', 'Motor Cycle Repairs and Maintenance', '2024-04-18 08:28:49'),
('20', 'Repairs & Maintenance', '2-308', 'Furniture & Equipment Repairs and Maintenance', '2024-04-18 08:28:49'),
('21', 'Repairs & Maintenance', '2-305', 'Depreciation Expenses', '2024-04-18 08:28:49'),
('22', 'Repairs & Maintenance', '2-309', 'Business License', '2024-04-18 08:28:49'),
('23', 'Repairs & Maintenance', '2-310', 'Sumatra Fee', '2024-04-18 08:28:49'),
('24', 'Repairs & Maintenance', '2-311', 'TAFFA Subscription Fee', '2024-04-18 08:28:49'),
('25', 'Repairs & Maintenance', '2-312', 'Customs License', '2024-04-18 08:28:49'),
('26', 'Repairs & Maintenance', '2-313', 'IDF Fees', '2024-04-18 08:28:49'),
('27', 'Repairs & Maintenance', '2-314', 'Staff Uniforms', '2024-04-18 08:28:49'),
('28', 'Repairs & Maintenance', '2-315', 'Printing and Stationery', '2024-04-18 08:28:49'),
('29', 'Repairs & Maintenance', '2-316', 'Fuel', '2024-04-18 08:28:49'),
('30', 'Repairs & Maintenance', '2-317', 'Condelence', '2024-04-18 08:28:49'),
('31', 'Repairs & Maintenance', '2-318', 'Legal Fees', '2024-04-18 08:28:49'),
('32', 'Repairs & Maintenance', '2-319', 'Office Expenses', '2024-04-18 08:28:49'),
('34', 'Utility', '2-201', 'Electricity Expenses', '2024-04-18 08:28:49'),
('35', 'Utility', '2-202', 'Water & Sewage Expenses', '2024-04-18 08:28:49'),
('36', 'Utility', '2-203', 'Cleaning & Sanitation Expenses', '2024-04-18 08:28:49'),
('38', 'Finance', '2-501', 'Bank Charges', '2024-04-18 08:28:49'),
('39', 'Finance', '2-502', 'Bank Commission', '2024-04-18 08:28:49'),
('40', 'Finance', '2-503', 'Forex Gain / Loss', '2024-04-18 08:28:49'),
('42', 'Selling & Distribution', '2-401', 'Travelling Expenses', '2024-04-18 08:28:49'),
('43', 'Selling & Distribution', '2-402', 'Marketing & Advertisement', '2024-04-18 08:28:49'),
('44', 'Selling & Distribution', '2-403', 'Bad Debts', '2024-04-18 08:28:49'),
('45', 'Selling & Distribution', '2-404', 'Provision for Bad Debts', '2024-04-18 08:28:49'),
('46', 'Selling & Distribution', '2-405', 'Tender Documents & Fees', '2024-04-18 08:28:49');

INSERT INTO `expenses` VALUES
('1', 'EXP-20250221042921-915', 'Approved', 'Tsh', 'Testing', 'fuel', '1', '2025-02-21 00:00:00', 'cash', 'RFF001', '1500.00'),
('2', 'EXP/2025/02/0001', 'Approved', 'Tsh', 'Office function', 'Administration', '1', '2025-02-23 08:26:30', 'Cash', '', '50000.00'),
('3', 'EXP/2025/03/0001', 'Approved', 'Tsh', 'Salaries', 'Utility', '1', '2025-03-01 07:46:40', 'Cash', '', '1000000.00');

INSERT INTO `file_access_logs` VALUES
('1', NULL, '1', '1', 'edit', '2025-02-22 07:30:20', '102.140.245.174'),
('2', '1', NULL, '1', '', '2025-02-22 08:07:59', '102.140.245.174'),
('3', '1', NULL, '1', 'view', '2025-02-22 08:08:14', '102.140.245.174'),
('4', '1', NULL, '1', 'share', '2025-02-22 08:08:27', '102.140.245.174'),
('5', '2', NULL, '1', '', '2025-02-22 08:08:54', '102.140.245.174'),
('6', '2', NULL, '1', 'view', '2025-02-22 08:09:00', '102.140.245.174'),
('7', '2', NULL, '1', 'view', '2025-02-22 08:09:02', '102.140.245.174'),
('8', '2', NULL, '1', 'download', '2025-02-22 08:09:06', '102.140.245.174'),
('9', '2', NULL, '1', 'download', '2025-02-22 08:09:08', '102.140.245.174'),
('10', NULL, '2', '1', 'edit', '2025-03-01 07:28:59', '102.140.245.174'),
('11', '3', NULL, '1', '', '2025-03-01 07:30:02', '102.140.245.174'),
('12', '3', NULL, '1', 'view', '2025-03-01 07:30:09', '102.140.245.174'),
('13', '3', NULL, '1', 'view', '2025-03-01 07:30:12', '102.140.245.174'),
('14', '3', NULL, '1', 'share', '2025-03-01 07:30:28', '102.140.245.174');

INSERT INTO `file_folders` VALUES
('1', 'Test', NULL, '1', '2025-02-22 07:30:20', '2025-02-22 07:30:20', '0', ''),
('2', 'Local Files', NULL, '1', '2025-03-01 07:28:59', '2025-03-01 07:28:59', '0', '');

INSERT INTO `file_manager` VALUES
('1', 'T03.png', 'uploads/files/file_67b95bafc4f4c_1740200879.png', 'image/png', '57961', 'png', '1', '1', '2025-02-22 08:07:59', '2025-02-22 08:07:59', '0', '', '', '0'),
('2', 'MediSure360 Medical System.pdf', 'uploads/files/file_67b95be695637_1740200934.pdf', 'application/pdf', '94123', 'pdf', '1', '1', '2025-02-22 08:08:54', '2025-02-22 08:08:54', '0', '', '', '0'),
('3', 'RASMS System Proposal.pdf', 'uploads/files/file_67c28d4a43aa5_1740803402.pdf', 'application/pdf', '87373', 'pdf', '2', '1', '2025-03-01 07:30:02', '2025-03-01 07:30:02', '0', 'RFT/LOC/001/25', '', '0');

INSERT INTO `file_shares` VALUES
('1', '1', NULL, '20', '1', 'read', '2025-02-22 08:08:27', NULL, '1'),
('2', '3', NULL, '20', '1', 'read', '2025-03-01 07:30:28', NULL, '1');

INSERT INTO `files` VALUES
('277', 'RFT/RW/KI/001/25', '9', NULL, NULL, '2025-03-04 08:26:46', '$', NULL, 'AFRICAN GREEN MOBILITY ', NULL, NULL, 'ANGELIKI', 'GOSUSNH8489959', '2025-01-02 00:00:00', '2024-12-29 00:00:00', 'RW-KI', '2024-12-28 00:00:00', '2025-01-02 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'HESU', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Array', '2', '21', NULL, NULL, 'Container', NULL, NULL, NULL),
('278', 'RFT/RW/KI/002/25', '40', NULL, NULL, '2025-03-04 08:39:51', '$', NULL, 'AMUGES', NULL, NULL, 'DEVBULK CANSEN', '105364TJ073', '2025-01-04 00:00:00', '2025-01-04 00:00:00', 'RW-KI', '2024-12-30 00:00:00', '2025-01-04 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DP WORLD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'COIL 462', '2', '21', NULL, NULL, 'Container', NULL, NULL, NULL),
('279', 'RFT/RW/KI/003/25', '40', NULL, NULL, '2025-03-04 08:49:41', '$', NULL, 'AMUGES', NULL, NULL, 'DEVBULK CANSEN', '105364TJ020A', '2025-01-04 00:00:00', '2025-01-04 00:00:00', 'RW-KI', '2024-12-30 00:00:00', '2025-01-04 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'BLOOMER TZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'HOSE 10UNTES ', '2', '21', NULL, NULL, 'Container', NULL, NULL, NULL),
('280', 'RFT/RW/KI/004/25', '40', NULL, NULL, '2025-03-04 10:16:52', '$', NULL, 'AMUGES', NULL, NULL, 'NANBEIHU', 'NB24S53XGGTAN017', '2024-12-30 00:00:00', '2024-12-30 00:00:00', 'RW-KI', '2024-12-29 00:00:00', '2025-01-02 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'TPA TERMINAL TANGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '74 COILS LOADED FROM TANGA PORT', '2', '21', NULL, NULL, 'Container', NULL, NULL, NULL),
('281', 'RFT/RW/KI/005/25', '40', NULL, NULL, '2025-03-04 10:22:52', '$', NULL, 'AMUGES', NULL, NULL, 'NANBEIHU', 'NB24S53XGGTAN025', '2024-12-30 00:00:00', '2024-12-30 00:00:00', 'RW-KI', '2024-12-29 00:00:00', '2025-01-02 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'TPA TERMINAL TANGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '287 COILS LOADED FROM TANGA PORT', '2', '21', NULL, NULL, 'Container', NULL, NULL, NULL),
('282', 'RFT/RW/KI/006/25', '32', 'ROAD', '15', '2025-03-04 10:43:09', '$', NULL, 'RWANDA MEDICAL SUPPLY', NULL, NULL, 'MSC LANGSAR', 'MEDUYP023987', '2025-01-17 00:00:00', '2025-01-02 00:00:00', 'RW-KI', '2025-01-10 00:00:00', '2025-01-17 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DP WORLD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '2', '21', NULL, NULL, 'Container', NULL, NULL, NULL),
('283', 'RFT/DR/GOM/007/25', '11', NULL, NULL, '2025-03-06 13:04:35', '$', NULL, 'MSFOCB', NULL, NULL, '', 'COP0280035', '2025-01-28 00:00:00', '2025-01-08 00:00:00', 'DR-GOM', '2025-01-08 00:00:00', '2025-02-01 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'SALISLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Array', '2', '40', NULL, NULL, 'Container', NULL, NULL, NULL),
('289', 'RFT/DR/SOL/008/25', '11', NULL, NULL, '2025-03-07 15:05:55', '$', NULL, 'US EMBASSY KINSHASA USAID/GHSC-TA', NULL, NULL, 'DERBY D', 'USG0291942', '2025-02-12 00:00:00', '2025-02-12 00:00:00', 'DR-SOL', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'SALISA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Array', '2', '21', NULL, NULL, 'Container', NULL, NULL, NULL),
('290', 'RFT/DR/BUK/009/25', '11', NULL, NULL, '2025-03-07 15:10:24', '$', NULL, 'US EMBASSY', NULL, NULL, 'YOKOHAMA STAR', 'USG0287504', '2025-02-24 00:00:00', '2025-02-20 00:00:00', 'DR-BUK', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'TEAGTL', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Array', '2', '21', NULL, NULL, 'Container', NULL, NULL, NULL);

INSERT INTO `flagged_messages` VALUES
('20', '1', 'Naked', '2024-10-02 13:57:27');





INSERT INTO `import_config` VALUES
('1', 'transit', 'customer', 'Customer', '1', 'select', '{\"source\": \"customers\", \"key\": \"customer_id\", \"display\": \"first_name\"}', 'A', '1', '2025-02-22 10:48:17', '2025-02-24 18:42:37'),
('2', 'transit', 'consignee_name', 'Consignee Name', '1', 'text', '{\"min_length\": 3, \"max_length\": 50}', 'B', '2', '2025-02-22 10:48:17', '2025-02-24 18:42:37'),
('3', 'transit', 'destination', 'Destination', '1', 'select', '{\"values\": [\"BU-BU\", \"DR-LUB\", \"DR-GOM\", \"DR-BUK\", \"DR-KAL\", \"DR-SOL\", \"RW-KI\", \"ZM-LU\", \"ZM-ND\", \"ZM-KI\"]}', 'C', '3', '2025-02-22 10:48:17', '2025-02-24 18:42:37'),
('4', 'transit', 'obl_no', 'OBL Number', '1', 'text', '{\"min_length\": 3, \"max_length\": 50}', 'D', '4', '2025-02-22 10:48:17', '2025-02-24 18:42:37'),
('5', 'transit', 'eta', 'ETA Date', '0', 'date', NULL, 'E', '5', '2025-02-22 10:48:17', '2025-02-24 18:42:37'),
('6', 'transit', 'container_code', 'Container Number', '1', 'text', '{\"min_length\": 5, \"max_length\": 20}', 'F', '6', '2025-02-22 10:48:17', '2025-02-24 18:42:37'),
('7', 'transit', 'container_size', 'Container Size', '1', 'select', '{\"values\": [\"20\", \"40\", \"40HC\"]}', 'G', '7', '2025-02-22 10:48:17', '2025-02-24 18:42:37'),
('8', 'transit', 'transporter', 'Transporter', '0', 'select', '{\"source\": \"transporter_info\", \"key\": \"id\", \"display\": \"name\"}', 'H', '8', '2025-02-22 10:48:17', '2025-02-24 18:42:37'),
('9', 'transit', 'remarks', 'Remarks', '0', 'textarea', NULL, 'I', '9', '2025-02-22 10:48:17', '2025-02-24 18:42:37'),
('10', 'transit', 'free_detention', 'Free Detention Days', '0', 'number', '{\"min\": 0, \"max\": 60}', 'J', '10', '2025-02-22 10:48:17', '2025-02-24 18:42:37'),
('11', 'local', 'customer', 'Customer', '1', 'select', '{\"source\": \"customers\", \"key\": \"customer_id\", \"display\": \"first_name\"}', 'A', '1', '2025-02-22 10:48:17', '2025-02-24 18:42:48'),
('12', 'local', 'consignee_name', 'Consignee Name', '1', 'text', '{\"min_length\": 3, \"max_length\": 50}', 'B', '2', '2025-02-22 10:48:17', '2025-02-24 18:42:48'),
('13', 'local', 'obl_no', 'OBL Number', '1', 'text', '{\"min_length\": 3, \"max_length\": 50}', 'C', '3', '2025-02-22 10:48:17', '2025-02-24 18:42:48'),
('14', 'local', 'eta', 'ETA Date', '0', 'date', NULL, 'D', '4', '2025-02-22 10:48:17', '2025-02-24 18:42:48'),
('15', 'local', 'container_code', 'Container Number', '1', 'text', '{\"min_length\": 5, \"max_length\": 20}', 'E', '5', '2025-02-22 10:48:17', '2025-02-24 18:42:48'),
('16', 'local', 'container_size', 'Container Size', '1', 'select', '{\"values\": [\"20\", \"40\", \"40HC\"]}', 'F', '6', '2025-02-22 10:48:17', '2025-02-24 18:42:48'),
('17', 'local', 'transporter', 'Transporter', '0', 'select', '{\"source\": \"transporter_info\", \"key\": \"id\", \"display\": \"name\"}', 'G', '7', '2025-02-22 10:48:17', '2025-02-24 18:42:48'),
('18', 'local', 'load_date', 'Load Date', '0', 'date', NULL, 'H', '8', '2025-02-22 10:48:17', '2025-02-24 18:42:48'),
('19', 'local', 'offload_date', 'Offload Date', '0', 'date', NULL, 'I', '9', '2025-02-22 10:48:17', '2025-02-24 18:42:48'),
('20', 'local', 'remarks', 'Remarks', '0', 'textarea', NULL, 'J', '10', '2025-02-22 10:48:17', '2025-02-24 18:42:48');

INSERT INTO `import_records` VALUES
('55', '10', '1', '', NULL, 'pending', NULL, NULL, NULL),
('56', '10', '2', '', NULL, 'pending', NULL, NULL, NULL),
('57', '10', '3', '', NULL, 'pending', NULL, NULL, NULL),
('58', '10', '4', '', NULL, 'pending', NULL, NULL, NULL),
('59', '10', '5', '', NULL, 'pending', NULL, NULL, NULL),
('60', '10', '6', '', NULL, 'pending', NULL, NULL, NULL),
('61', '10', '7', '', NULL, 'pending', NULL, NULL, NULL),
('62', '10', '8', '', NULL, 'pending', NULL, NULL, NULL),
('63', '10', '9', '', NULL, 'pending', NULL, NULL, NULL),
('64', '10', '10', '', NULL, 'pending', NULL, NULL, NULL),
('65', '10', '11', '', NULL, 'pending', NULL, NULL, NULL),
('66', '10', '12', '', NULL, 'pending', NULL, NULL, NULL),
('67', '10', '13', '', NULL, 'pending', NULL, NULL, NULL),
('68', '10', '14', '', NULL, 'pending', NULL, NULL, NULL),
('69', '10', '15', '', NULL, 'pending', NULL, NULL, NULL),
('70', '10', '16', '', NULL, 'pending', NULL, NULL, NULL),
('71', '10', '17', '', NULL, 'pending', NULL, NULL, NULL),
('72', '10', '18', '', NULL, 'pending', NULL, NULL, NULL),
('73', '10', '19', '', NULL, 'pending', NULL, NULL, NULL),
('74', '10', '20', '', NULL, 'pending', NULL, NULL, NULL),
('75', '10', '21', '', NULL, 'pending', NULL, NULL, NULL),
('76', '10', '22', '', NULL, 'pending', NULL, NULL, NULL),
('77', '10', '23', '', NULL, 'pending', NULL, NULL, NULL),
('78', '10', '24', '', NULL, 'pending', NULL, NULL, NULL),
('79', '10', '25', '', NULL, 'pending', NULL, NULL, NULL),
('80', '10', '26', '', NULL, 'pending', NULL, NULL, NULL),
('81', '10', '27', '', NULL, 'pending', NULL, NULL, NULL),
('82', '11', '1', '', NULL, 'pending', NULL, NULL, NULL),
('83', '11', '2', '', NULL, 'pending', NULL, NULL, NULL),
('84', '11', '3', '', NULL, 'pending', NULL, NULL, NULL),
('85', '11', '4', '', NULL, 'pending', NULL, NULL, NULL),
('86', '11', '5', '', NULL, 'pending', NULL, NULL, NULL),
('87', '11', '6', '', NULL, 'pending', NULL, NULL, NULL),
('88', '11', '7', '', NULL, 'pending', NULL, NULL, NULL),
('89', '11', '8', '', NULL, 'pending', NULL, NULL, NULL),
('90', '11', '9', '', NULL, 'pending', NULL, NULL, NULL),
('91', '11', '10', '', NULL, 'pending', NULL, NULL, NULL),
('92', '11', '11', '', NULL, 'pending', NULL, NULL, NULL),
('93', '11', '12', '', NULL, 'pending', NULL, NULL, NULL),
('94', '11', '13', '', NULL, 'pending', NULL, NULL, NULL),
('95', '11', '14', '', NULL, 'pending', NULL, NULL, NULL),
('96', '11', '15', '', NULL, 'pending', NULL, NULL, NULL),
('97', '11', '16', '', NULL, 'pending', NULL, NULL, NULL),
('98', '11', '17', '', NULL, 'pending', NULL, NULL, NULL),
('99', '11', '18', '', NULL, 'pending', NULL, NULL, NULL),
('100', '11', '19', '', NULL, 'pending', NULL, NULL, NULL),
('101', '11', '20', '', NULL, 'pending', NULL, NULL, NULL),
('102', '11', '21', '', NULL, 'pending', NULL, NULL, NULL),
('103', '11', '22', '', NULL, 'pending', NULL, NULL, NULL),
('104', '11', '23', '', NULL, 'pending', NULL, NULL, NULL),
('105', '11', '24', '', NULL, 'pending', NULL, NULL, NULL),
('106', '11', '25', '', NULL, 'pending', NULL, NULL, NULL),
('107', '11', '26', '', NULL, 'pending', NULL, NULL, NULL),
('108', '11', '27', '', NULL, 'pending', NULL, NULL, NULL),
('109', '12', '1', '', NULL, 'pending', NULL, NULL, NULL),
('110', '12', '2', '', NULL, 'pending', NULL, NULL, NULL),
('111', '12', '3', '', NULL, 'pending', NULL, NULL, NULL),
('112', '12', '4', '', NULL, 'pending', NULL, NULL, NULL),
('113', '12', '5', '', NULL, 'pending', NULL, NULL, NULL),
('114', '12', '6', '', NULL, 'pending', NULL, NULL, NULL),
('115', '12', '7', '', NULL, 'pending', NULL, NULL, NULL),
('116', '12', '8', '', NULL, 'pending', NULL, NULL, NULL),
('117', '12', '9', '', NULL, 'pending', NULL, NULL, NULL),
('118', '12', '10', '', NULL, 'pending', NULL, NULL, NULL),
('119', '12', '11', '', NULL, 'pending', NULL, NULL, NULL),
('120', '12', '12', '', NULL, 'pending', NULL, NULL, NULL),
('121', '12', '13', '', NULL, 'pending', NULL, NULL, NULL),
('122', '12', '14', '', NULL, 'pending', NULL, NULL, NULL),
('123', '12', '15', '', NULL, 'pending', NULL, NULL, NULL),
('124', '12', '16', '', NULL, 'pending', NULL, NULL, NULL),
('125', '12', '17', '', NULL, 'pending', NULL, NULL, NULL),
('126', '12', '18', '', NULL, 'pending', NULL, NULL, NULL),
('127', '12', '19', '', NULL, 'pending', NULL, NULL, NULL),
('128', '12', '20', '', NULL, 'pending', NULL, NULL, NULL),
('129', '12', '21', '', NULL, 'pending', NULL, NULL, NULL),
('130', '12', '22', '', NULL, 'pending', NULL, NULL, NULL),
('131', '12', '23', '', NULL, 'pending', NULL, NULL, NULL),
('132', '12', '24', '', NULL, 'pending', NULL, NULL, NULL),
('133', '12', '25', '', NULL, 'pending', NULL, NULL, NULL),
('134', '12', '26', '', NULL, 'pending', NULL, NULL, NULL),
('135', '12', '27', '', NULL, 'pending', NULL, NULL, NULL),
('136', '13', '1', '', NULL, 'pending', NULL, NULL, NULL),
('137', '13', '2', '', NULL, 'pending', NULL, NULL, NULL),
('138', '13', '3', '', NULL, 'pending', NULL, NULL, NULL),
('139', '13', '4', '', NULL, 'pending', NULL, NULL, NULL),
('140', '13', '5', '', NULL, 'pending', NULL, NULL, NULL),
('141', '13', '6', '', NULL, 'pending', NULL, NULL, NULL),
('142', '13', '7', '', NULL, 'pending', NULL, NULL, NULL),
('143', '13', '8', '', NULL, 'pending', NULL, NULL, NULL),
('144', '13', '9', '', NULL, 'pending', NULL, NULL, NULL),
('145', '13', '10', '', NULL, 'pending', NULL, NULL, NULL),
('146', '13', '11', '', NULL, 'pending', NULL, NULL, NULL),
('147', '13', '12', '', NULL, 'pending', NULL, NULL, NULL),
('148', '13', '13', '', NULL, 'pending', NULL, NULL, NULL),
('149', '13', '14', '', NULL, 'pending', NULL, NULL, NULL),
('150', '13', '15', '', NULL, 'pending', NULL, NULL, NULL),
('151', '13', '16', '', NULL, 'pending', NULL, NULL, NULL),
('152', '13', '17', '', NULL, 'pending', NULL, NULL, NULL),
('153', '13', '18', '', NULL, 'pending', NULL, NULL, NULL),
('154', '13', '19', '', NULL, 'pending', NULL, NULL, NULL),
('155', '13', '20', '', NULL, 'pending', NULL, NULL, NULL),
('156', '13', '21', '', NULL, 'pending', NULL, NULL, NULL),
('157', '13', '22', '', NULL, 'pending', NULL, NULL, NULL),
('158', '13', '23', '', NULL, 'pending', NULL, NULL, NULL),
('159', '13', '24', '', NULL, 'pending', NULL, NULL, NULL),
('160', '13', '25', '', NULL, 'pending', NULL, NULL, NULL),
('161', '13', '26', '', NULL, 'pending', NULL, NULL, NULL),
('162', '13', '27', '', NULL, 'pending', NULL, NULL, NULL);







INSERT INTO `loose_cargo_items` VALUES
('1', 'RFL/002/03/25', 'X001', 'Sedan', '15000.00', '16', '', '', '', '', '2025-03-07 06:46:32'),
('2', 'RFL/001/03/25', 'X001', 'Sedan', '15000.00', '16', '', '', '', '', '2025-03-07 13:38:19');

INSERT INTO `menu_roles` VALUES
('30', '#', '1'),
('28', 'allin_list.php', '1'),
('29', 'approved_expenses.php', '1'),
('22', 'assign_trucks.php', '1'),
('21', 'delete_record.php', '1'),
('19', 'gen_settings.php', '1'),
('20', 'index.php', '1'),
('23', 'truck_list.php', '1');

INSERT INTO `messages` VALUES
('24', '1', '20', 'Test', '1', '2024-09-24 20:18:03', '0'),
('25', '1', '20', 'Sent', '1', '2024-09-24 20:31:43', '0');



INSERT INTO `notif_messages` VALUES
('1', 'New file with file number {file_number} has been created.', 'success', 'mdi-file'),
('2', 'File {file_number} has been updated.', 'info', 'mdi-update'),
('3', 'File {file_number} has been deleted.', 'danger', 'mdi-delete');

INSERT INTO `notifications` VALUES
('133', '277', '1', '2025-03-04 08:26:46', 'RFT/RW/KI/001/25', 'New transit file with file number RFT/RW/KI/001/25 has been created.', '0'),
('134', '278', '1', '2025-03-04 08:39:51', 'RFT/RW/KI/002/25', 'New transit file with file number RFT/RW/KI/002/25 has been created.', '0'),
('135', '279', '1', '2025-03-04 08:49:41', 'RFT/RW/KI/003/25', 'New transit file with file number RFT/RW/KI/003/25 has been created.', '0'),
('136', '280', '1', '2025-03-04 10:16:52', 'RFT/RW/KI/004/25', 'New transit file with file number RFT/RW/KI/004/25 has been created.', '0'),
('137', '281', '1', '2025-03-04 10:22:52', 'RFT/RW/KI/005/25', 'New transit file with file number RFT/RW/KI/005/25 has been created.', '0'),
('138', '282', '1', '2025-03-04 10:43:09', 'RFT/RW/KI/006/25', 'New transit file with file number RFT/RW/KI/006/25 has been created.', '0'),
('139', '282', '2', '2025-03-04 10:44:56', 'RFT/RW/KI/006/25', 'File RFT/RW/KI/006/25 has been updated by salman.', '0'),
('140', '282', '2', '2025-03-04 10:45:09', 'RFT/RW/KI/006/25', 'File RFT/RW/KI/006/25 has been updated by salman.', '0'),
('141', '282', '2', '2025-03-04 10:54:08', 'RFT/RW/KI/006/25', 'File RFT/RW/KI/006/25 has been updated by salman.', '0'),
('142', '282', '2', '2025-03-04 10:54:29', 'RFT/RW/KI/006/25', 'File RFT/RW/KI/006/25 has been updated by salman.', '0'),
('144', '283', '1', '2025-03-06 13:04:35', 'RFT/DR/GOM/001/25', 'New transit file with file number RFT/DR/GOM/001/25 has been created.', '0'),
('150', '289', '1', '2025-03-07 15:05:55', 'RFT/DR/SOL/008/25', 'New transit file with file number RFT/DR/SOL/008/25 has been created.', '0'),
('151', '290', '1', '2025-03-07 15:10:24', 'RFT/DR/BUK/009/25', 'New transit file with file number RFT/DR/BUK/009/25 has been created.', '0');



INSERT INTO `pre_proforma` VALUES
('1', 'RFT/RW/KI/007/24', 'Yes', '1750', 'Operational', '1-101', 'Agency Fee', '905.00', 'No', '0.00', '$', '2024-06-14 08:05:14', NULL, NULL, NULL),
('3', 'RFT/RW/KI/007/24', NULL, '1750', 'Non-Operational', '3-106', 'Wharfage', '450.00', 'No', '0.00', '$', '2024-06-14 08:05:14', NULL, NULL, NULL),
('4', 'RFT/RW/KI/007/24', NULL, '1750', 'Non-Operational', '3-102', 'Port Charges', '350.00', 'No', '0.00', '$', '2024-06-14 08:05:14', NULL, NULL, NULL),
('5', 'RFT/RW/KI/007/24', NULL, '1750', 'Non-Operational', '3-134', 'Miscellaneous', '30.00', 'No', '0.00', '$', '2024-06-14 08:05:15', NULL, NULL, NULL),
('6', 'RFT/RW/KI/004/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-1375.00', 'No', '0.00', '$', '2024-06-14 08:14:47', NULL, NULL, '0'),
('8', 'RFT/RW/KI/004/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '900.00', 'No', '0.00', '$', '2024-06-14 08:14:47', NULL, NULL, '0'),
('9', 'RFT/RW/KI/004/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '700.00', 'No', '0.00', '$', '2024-06-14 08:14:47', NULL, NULL, '0'),
('10', 'RFT/RW/KI/004/24', NULL, NULL, 'Non-Operational', '3-134', 'Miscellaneous', '60.00', 'No', '0.00', '$', '2024-06-14 08:14:47', NULL, NULL, '0'),
('11', 'RFT/RW/KI/037/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-2950.00', 'No', '0.00', '$', '2024-06-15 07:23:24', NULL, NULL, '0'),
('13', 'RFT/RW/KI/037/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '1800.00', 'No', '0.00', '$', '2024-06-15 07:23:24', NULL, NULL, '0'),
('14', 'RFT/RW/KI/037/24', NULL, NULL, 'Non-Operational', '3-107', 'Port Handling', '1400.00', 'No', '0.00', '$', '2024-06-15 07:23:24', NULL, NULL, '0'),
('15', 'RFT/RW/KI/037/24', NULL, NULL, 'Non-Operational', '3-135', 'Drop-Off Charges', '35.00', 'No', '0.00', '$', '2024-06-15 07:23:24', NULL, NULL, '0'),
('16', 'RFT/RW/KI/042/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-27.00', 'No', '0.00', '$', '2024-06-15 07:27:45', NULL, NULL, '0'),
('18', 'RFT/RW/KI/042/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '180.00', 'No', '0.00', '$', '2024-06-15 07:27:45', NULL, NULL, '0'),
('19', 'RFT/RW/KI/042/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '120.00', 'No', '0.00', '$', '2024-06-15 07:27:45', NULL, NULL, '0'),
('20', 'RFT/RW/KI/042/24', NULL, NULL, 'Non-Operational', '3-134', 'Miscellaneous', '12.00', 'No', '0.00', '$', '2024-06-15 07:27:45', NULL, NULL, '0'),
('21', 'RFT/RW/KI/032/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-1375.00', 'No', '0.00', '$', '2024-06-15 07:29:49', NULL, NULL, '0'),
('22', 'RFT/RW/KI/030/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-877.00', 'No', '0.00', '$', '2024-06-15 07:34:34', NULL, NULL, '0'),
('24', 'RFT/RW/KI/030/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '630.00', 'No', '0.00', '$', '2024-06-15 07:34:34', NULL, NULL, '0'),
('25', 'RFT/RW/KI/030/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '490.00', 'No', '0.00', '$', '2024-06-15 07:34:34', NULL, NULL, '0'),
('26', 'RFT/RW/KI/030/24', NULL, NULL, 'Non-Operational', '3-134', 'Miscellaneous', '42.00', 'No', '0.00', '$', '2024-06-15 07:34:34', NULL, NULL, '0'),
('27', 'RFT/RW/KI/013/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-1375.00', 'No', '0.00', '$', '2024-06-15 07:39:53', NULL, NULL, '0'),
('29', 'RFT/RW/KI/013/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '700.00', 'No', '0.00', '$', '2024-06-15 07:39:53', NULL, NULL, '0'),
('30', 'RFT/RW/KI/013/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '900.00', 'No', '0.00', '$', '2024-06-15 07:39:53', NULL, NULL, '0'),
('31', 'RFT/RW/KI/013/24', NULL, NULL, 'Non-Operational', 'Corridor Levy', '', '60.00', 'No', '0.00', '$', '2024-06-15 07:39:53', NULL, NULL, '0'),
('32', 'RFT/RW/KI/026/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-545.00', 'No', '0.00', '$', '2024-06-15 07:41:44', NULL, NULL, '0'),
('34', 'RFT/RW/KI/026/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '450.00', 'No', '0.00', '$', '2024-06-15 07:41:44', NULL, NULL, '0'),
('35', 'RFT/RW/KI/026/24', NULL, NULL, 'Non-Operational', '3-107', 'Port Handling', '350.00', 'No', '0.00', '$', '2024-06-15 07:41:44', NULL, NULL, '0'),
('36', 'RFT/RW/KI/026/24', NULL, NULL, 'Non-Operational', 'Corridor Levy', '', '30.00', 'No', '0.00', '$', '2024-06-15 07:41:44', NULL, NULL, '0'),
('37', 'RFT/RW/KI/029/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-1375.00', 'No', '0.00', '$', '2024-06-15 07:43:18', NULL, NULL, '0'),
('39', 'RFT/RW/KI/029/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '900.00', 'No', '0.00', '$', '2024-06-15 07:43:18', NULL, NULL, '0'),
('40', 'RFT/RW/KI/029/24', NULL, NULL, 'Non-Operational', '3-107', 'Port Handling', '700.00', 'No', '0.00', '$', '2024-06-15 07:43:18', NULL, NULL, '0'),
('41', 'RFT/RW/KI/029/24', NULL, NULL, 'Non-Operational', 'Corridor Levy', '', '60.00', 'No', '0.00', '$', '2024-06-15 07:43:18', NULL, NULL, '0'),
('42', 'RFT/RW/KI/023/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-1675.00', 'No', '0.00', '$', '2024-06-15 07:46:16', NULL, NULL, '0'),
('44', 'RFT/RW/KI/023/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '900.00', 'No', '0.00', '$', '2024-06-15 07:46:16', NULL, NULL, '0'),
('45', 'RFT/RW/KI/023/24', NULL, NULL, 'Non-Operational', '3-107', 'Port Handling', '700.00', 'No', '0.00', '$', '2024-06-15 07:46:16', NULL, NULL, '0'),
('46', 'RFT/RW/KI/023/24', NULL, NULL, 'Non-Operational', '3-135', 'Drop-Off Charges', '300.00', 'No', '0.00', '$', '2024-06-15 07:46:16', NULL, NULL, '0'),
('47', 'RFT/RW/KI/023/24', NULL, NULL, 'Non-Operational', 'Corridor Levy', '', '60.00', 'No', '0.00', '$', '2024-06-15 07:46:16', NULL, NULL, '0'),
('48', 'RFT/RW/KI/028/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-27.00', 'No', '0.00', '$', '2024-06-15 07:48:59', NULL, NULL, '0'),
('50', 'RFT/RW/KI/028/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '180.00', 'No', '0.00', '$', '2024-06-15 07:48:59', NULL, NULL, '0'),
('51', 'RFT/RW/KI/028/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '120.00', 'No', '0.00', '$', '2024-06-15 07:48:59', NULL, NULL, '0'),
('52', 'RFT/RW/KI/028/24', NULL, NULL, 'Non-Operational', 'Corridor Levy', '', '12.00', 'No', '0.00', '$', '2024-06-15 07:48:59', NULL, NULL, '0'),
('53', 'RFT/RW/KI/035/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-1675.00', 'No', '0.00', '$', '2024-06-15 07:50:57', NULL, NULL, '0'),
('55', 'RFT/RW/KI/035/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '900.00', 'No', '0.00', '$', '2024-06-15 07:50:57', NULL, NULL, '0'),
('56', 'RFT/RW/KI/035/24', NULL, NULL, 'Non-Operational', '3-107', 'Port Handling', '700.00', 'No', '0.00', '$', '2024-06-15 07:50:57', NULL, NULL, '0'),
('57', 'RFT/RW/KI/035/24', NULL, NULL, 'Non-Operational', 'Corridor Levy', '', '60.00', 'No', '0.00', '$', '2024-06-15 07:50:57', NULL, NULL, '0'),
('58', 'RFT/RW/KI/035/24', NULL, NULL, 'Non-Operational', '3-135', 'Drop-Off Charges', '300.00', 'No', '0.00', '$', '2024-06-15 07:50:57', NULL, NULL, '0'),
('59', 'RFT/RW/KI/005/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-1375.00', 'No', '0.00', '$', '2024-06-15 07:52:58', NULL, NULL, '0'),
('61', 'RFT/RW/KI/005/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '900.00', 'No', '0.00', '$', '2024-06-15 07:52:58', NULL, NULL, '0'),
('62', 'RFT/RW/KI/005/24', NULL, NULL, 'Non-Operational', '3-107', 'Port Handling', '700.00', 'No', '0.00', '$', '2024-06-15 07:52:58', NULL, NULL, '0'),
('63', 'RFT/RW/KI/005/24', NULL, NULL, 'Non-Operational', 'Corridor Levy', '', '60.00', 'No', '0.00', '$', '2024-06-15 07:52:58', NULL, NULL, '0'),
('64', 'RFT/RW/KI/016/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-1375.00', 'No', '0.00', '$', '2024-06-15 07:54:36', NULL, NULL, '0'),
('66', 'RFT/RW/KI/016/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '900.00', 'No', '0.00', '$', '2024-06-15 07:54:36', NULL, NULL, '0'),
('67', 'RFT/RW/KI/016/24', NULL, NULL, 'Non-Operational', '3-107', 'Port Handling', '700.00', 'No', '0.00', '$', '2024-06-15 07:54:36', NULL, NULL, '0'),
('68', 'RFT/RW/KI/016/24', NULL, NULL, 'Non-Operational', 'Corridor Levy', '', '60.00', 'No', '0.00', '$', '2024-06-15 07:54:36', NULL, NULL, '0'),
('69', 'RFT/RW/KI/010/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-27.00', 'No', '0.00', '$', '2024-06-15 07:55:56', NULL, NULL, '0'),
('71', 'RFT/RW/KI/010/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '180.00', 'No', '0.00', '$', '2024-06-15 07:55:56', NULL, NULL, '0'),
('72', 'RFT/RW/KI/010/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '120.00', 'No', '0.00', '$', '2024-06-15 07:55:56', NULL, NULL, '0'),
('73', 'RFT/RW/KI/010/24', NULL, NULL, 'Non-Operational', 'Corridor Levy', '', '12.00', 'No', '0.00', '$', '2024-06-15 07:55:56', NULL, NULL, '0'),
('74', 'RFT/RW/KI/059/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '113.00', 'No', '0.00', '$', '2024-06-15 07:57:46', NULL, NULL, '0'),
('76', 'RFT/RW/KI/059/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '90.00', 'No', '0.00', '$', '2024-06-15 07:57:46', NULL, NULL, '0'),
('77', 'RFT/RW/KI/059/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '70.00', 'No', '0.00', '$', '2024-06-15 07:57:46', NULL, NULL, '0'),
('78', 'RFT/RW/KI/059/24', NULL, NULL, 'Non-Operational', 'Corridor Levy', '', '12.00', 'No', '0.00', '$', '2024-06-15 07:57:46', NULL, NULL, '0'),
('79', 'RFT/RW/KI/096/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '119.00', 'No', '0.00', '$', '2024-06-15 08:04:09', NULL, NULL, '0'),
('81', 'RFT/RW/KI/096/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '90.00', 'No', '0.00', '$', '2024-06-15 08:04:09', NULL, NULL, '0'),
('82', 'RFT/RW/KI/096/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '70.00', 'No', '0.00', '$', '2024-06-15 08:04:09', NULL, NULL, '0'),
('83', 'RFT/RW/KI/096/24', NULL, NULL, 'Non-Operational', 'Corridor Levy', '', '6.00', 'No', '0.00', '$', '2024-06-15 08:04:09', NULL, NULL, '0'),
('84', 'RFT/DR/GOM/057/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-171.00', 'No', '0.00', '$', '2024-06-15 08:12:34', NULL, NULL, '0'),
('86', 'RFT/DR/GOM/057/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '180.00', 'No', '0.00', '$', '2024-06-15 08:12:34', NULL, NULL, '0'),
('87', 'RFT/DR/GOM/057/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '134.00', 'No', '0.00', '$', '2024-06-15 08:12:34', NULL, NULL, '0'),
('88', 'RFT/DR/GOM/057/24', NULL, NULL, 'Non-Operational', '3-133', 'Reefer Charges', '90.00', 'No', '0.00', '$', '2024-06-15 08:12:34', NULL, NULL, '0'),
('90', 'RFT/DR/GOM/057/24', NULL, NULL, 'Non-Operational', 'Corridor Levy', '', '12.00', 'No', '0.00', '$', '2024-06-15 08:12:34', NULL, NULL, '0'),
('91', 'RFT/RW/KI/093/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-189.00', 'No', '0.00', '$', '2024-06-15 08:15:51', NULL, NULL, '0'),
('93', 'RFT/RW/KI/093/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '180.00', 'No', '0.00', '$', '2024-06-15 08:15:51', NULL, NULL, '0'),
('94', 'RFT/RW/KI/093/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '134.00', 'No', '0.00', '$', '2024-06-15 08:15:51', NULL, NULL, '0'),
('95', 'RFT/RW/KI/093/24', NULL, NULL, 'Non-Operational', '3-134', 'Miscellaneous', '68.00', 'No', '0.00', '$', '2024-06-15 08:15:51', NULL, NULL, '0'),
('96', 'RFT/RW/KI/093/24', NULL, NULL, 'Non-Operational', 'Corridor Levy', '', '12.00', 'No', '0.00', '$', '2024-06-15 08:15:51', NULL, NULL, '0'),
('97', 'RFT/RW/KI/093/24', NULL, NULL, 'Non-Operational', '3-135', 'Drop-Off Charges', '80.00', 'No', '0.00', '$', '2024-06-15 08:15:51', NULL, NULL, '0'),
('98', 'RFT/RW/KI/074/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-27.00', 'No', '0.00', '$', '2024-06-15 08:22:17', NULL, NULL, NULL),
('100', 'RFT/RW/KI/074/24', NULL, '0', 'Non-Operational', '3-106', 'Wharfage', '180.00', 'No', '0.00', '$', '2024-06-15 08:22:17', NULL, NULL, NULL),
('101', 'RFT/RW/KI/074/24', NULL, '0', 'Non-Operational', '3-102', 'Port Charges', '120.00', 'No', '0.00', '$', '2024-06-15 08:22:17', NULL, NULL, NULL),
('102', 'RFT/RW/KI/074/24', NULL, '0', 'Non-Operational', '3-136', 'Corridor Levy', '12.00', 'No', '0.00', '$', '2024-06-15 08:22:17', NULL, NULL, NULL),
('103', 'RFT/RW/KI/017/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '84.00', 'No', '0.00', '$', '2024-06-15 08:26:25', NULL, NULL, '0'),
('105', 'RFT/RW/KI/017/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '90.00', 'No', '0.00', '$', '2024-06-15 08:26:25', NULL, NULL, '0'),
('106', 'RFT/RW/KI/017/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '70.00', 'No', '0.00', '$', '2024-06-15 08:26:25', NULL, NULL, '0'),
('107', 'RFT/RW/KI/017/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '6.00', 'No', '0.00', '$', '2024-06-15 08:26:25', NULL, NULL, '0'),
('108', 'RFT/RW/KI/017/24', NULL, NULL, 'Non-Operational', '3-135', 'Drop-Off Charges', '35.00', 'No', '0.00', '$', '2024-06-15 08:26:25', NULL, NULL, '0'),
('109', 'RFT/RW/KI/088/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '119.00', 'No', '0.00', '$', '2024-06-15 08:29:57', NULL, NULL, '0'),
('111', 'RFT/RW/KI/088/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '90.00', 'No', '0.00', '$', '2024-06-15 08:29:57', NULL, NULL, '0'),
('112', 'RFT/RW/KI/088/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '70.00', 'No', '0.00', '$', '2024-06-15 08:29:57', NULL, NULL, '0'),
('113', 'RFT/RW/KI/088/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '6.00', 'No', '0.00', '$', '2024-06-15 08:29:57', NULL, NULL, '0'),
('114', 'RFT/RW/KI/025/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-1725.00', 'Yes', '0.00', '$', '2024-06-15 08:37:47', NULL, NULL, '0'),
('116', 'RFT/RW/KI/025/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '900.00', 'No', '0.00', '$', '2024-06-15 08:37:48', NULL, NULL, '0'),
('117', 'RFT/RW/KI/025/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '700.00', 'No', '0.00', '$', '2024-06-15 08:37:48', NULL, NULL, '0'),
('118', 'RFT/RW/KI/025/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '60.00', 'No', '0.00', '$', '2024-06-15 08:37:48', NULL, NULL, '0'),
('119', 'RFT/RW/KI/025/24', NULL, NULL, 'Non-Operational', '3-135', 'Drop-Off Charges', '350.00', 'No', '0.00', '$', '2024-06-15 08:37:48', NULL, NULL, '0'),
('120', 'RFT/RW/KI/044/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-67.00', 'No', '0.00', '$', '2024-06-15 08:48:48', NULL, NULL, '0'),
('122', 'RFT/RW/KI/044/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '180.00', 'No', '0.00', '$', '2024-06-15 08:48:48', NULL, NULL, '0'),
('123', 'RFT/RW/KI/044/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '160.00', 'No', '0.00', '$', '2024-06-15 08:48:48', NULL, NULL, '0'),
('124', 'RFT/RW/KI/044/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '12.00', 'No', '0.00', '$', '2024-06-15 08:48:48', NULL, NULL, '0'),
('125', 'RFT/RW/KI/041/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '60.00', 'Yes', '0.00', '$', '2024-06-15 09:34:49', NULL, NULL, '0'),
('127', 'RFT/RW/KI/041/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '700.00', 'No', '0.00', '$', '2024-06-15 09:34:49', NULL, NULL, '0'),
('128', 'RFT/RW/KI/041/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '900.00', 'No', '0.00', '$', '2024-06-15 09:34:50', NULL, NULL, '0'),
('129', 'RFT/RW/KI/041/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '60.00', 'No', '0.00', '$', '2024-06-15 09:34:50', NULL, NULL, '0'),
('130', 'RFT/RW/KI/041/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '60.00', 'Yes', '0.00', '$', '2024-06-15 09:37:55', NULL, NULL, '0'),
('132', 'RFT/RW/KI/041/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '700.00', 'No', '0.00', '$', '2024-06-15 09:37:55', NULL, NULL, '0'),
('133', 'RFT/RW/KI/041/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '900.00', 'No', '0.00', '$', '2024-06-15 09:37:55', NULL, NULL, '0'),
('134', 'RFT/RW/KI/041/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '60.00', 'No', '0.00', '$', '2024-06-15 09:37:55', NULL, NULL, '0'),
('135', 'RFT/ZM/LU/047/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-930.00', 'No', '0.00', '$', '2024-06-15 09:55:48', NULL, NULL, '0'),
('137', 'RFT/ZM/LU/047/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '180.00', 'No', '0.00', '$', '2024-06-15 09:55:48', NULL, NULL, '0'),
('138', 'RFT/ZM/LU/047/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '105.00', 'No', '0.00', '$', '2024-06-15 09:55:48', NULL, NULL, '0'),
('139', 'RFT/ZM/LU/047/24', NULL, NULL, 'Non-Operational', '3-110', 'Removal Fee', '150.00', 'No', '0.00', '$', '2024-06-15 09:55:48', NULL, NULL, '0'),
('141', 'RFT/ZM/LU/047/24', NULL, NULL, 'Non-Operational', '3-111', 'Additional Storage', '80.00', 'No', '0.00', '$', '2024-06-15 09:55:48', NULL, NULL, '0'),
('142', 'RFT/ZM/LU/047/24', NULL, NULL, 'Non-Operational', '3-112', 'Customs Rent', '100.00', 'No', '0.00', '$', '2024-06-15 09:55:48', NULL, NULL, '0'),
('143', 'RFT/ZM/LU/047/24', NULL, NULL, 'Non-Operational', '3-129', 'Demurrages', '200.00', 'No', '0.00', '$', '2024-06-15 09:55:48', NULL, NULL, '0'),
('144', 'RFT/RW/KI/076/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-2459.00', 'No', '0.00', '$', '2024-06-15 10:06:27', NULL, NULL, '0'),
('146', 'RFT/RW/KI/076/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '1260.00', 'No', '0.00', '$', '2024-06-15 10:06:27', NULL, NULL, '0'),
('147', 'RFT/RW/KI/076/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '840.00', 'No', '0.00', '$', '2024-06-15 10:06:27', NULL, NULL, '0'),
('148', 'RFT/RW/KI/076/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '84.00', 'No', '0.00', '$', '2024-06-15 10:06:27', NULL, NULL, '0'),
('149', 'RFT/RW/KI/076/24', NULL, NULL, 'Non-Operational', '3-135', 'Drop-Off Charges', '560.00', 'No', '0.00', '$', '2024-06-15 10:06:27', NULL, NULL, '0'),
('150', 'RFT/BU/BU/063/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-3109.00', 'No', '0.00', '$', '2024-06-15 10:12:26', NULL, NULL, '0'),
('152', 'RFT/BU/BU/063/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '180.00', 'No', '0.00', '$', '2024-06-15 10:12:26', NULL, NULL, '0'),
('153', 'RFT/BU/BU/063/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '140.00', 'No', '0.00', '$', '2024-06-15 10:12:26', NULL, NULL, '0'),
('154', 'RFT/BU/BU/063/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '12.00', 'No', '0.00', '$', '2024-06-15 10:12:26', NULL, NULL, '0'),
('156', 'RFT/BU/BU/063/24', NULL, NULL, 'Non-Operational', '3-110', 'Removal Fee', '200.00', 'No', '0.00', '$', '2024-06-15 10:12:26', NULL, NULL, '0'),
('157', 'RFT/BU/BU/063/24', NULL, NULL, 'Non-Operational', '3-112', 'Customs Rent', '351.00', 'No', '0.00', '$', '2024-06-15 10:12:26', NULL, NULL, '0'),
('158', 'RFT/BU/BU/063/24', NULL, NULL, 'Non-Operational', '3-129', 'Demurrages', '890.00', 'No', '0.00', '$', '2024-06-15 10:12:26', NULL, NULL, '0'),
('159', 'RFT/RW/KI/012/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-545.00', 'No', '0.00', '$', '2024-06-15 10:38:27', NULL, NULL, '0'),
('161', 'RFT/RW/KI/012/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '350.00', 'No', '0.00', '$', '2024-06-15 10:38:27', NULL, NULL, '0'),
('162', 'RFT/RW/KI/012/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '450.00', 'No', '0.00', '$', '2024-06-15 10:38:27', NULL, NULL, '0'),
('163', 'RFT/RW/KI/012/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '30.00', 'No', '0.00', '$', '2024-06-15 10:38:27', NULL, NULL, '0'),
('164', 'RFT/ZM/LU/052/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-15.00', 'No', '0.00', '$', '2024-06-15 10:44:39', NULL, NULL, '0'),
('166', 'RFT/ZM/LU/052/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '180.00', 'No', '0.00', '$', '2024-06-15 10:44:40', NULL, NULL, '0'),
('167', 'RFT/ZM/LU/052/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '120.00', 'No', '0.00', '$', '2024-06-15 10:44:40', NULL, NULL, '0'),
('168', 'RFT/RW/KI/009/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-28514.00', 'No', '0.00', '$', '2024-06-15 11:01:07', NULL, NULL, '0'),
('170', 'RFT/RW/KI/009/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '6222.00', 'No', '0.00', '$', '2024-06-15 11:01:08', NULL, NULL, '0'),
('171', 'RFT/RW/KI/009/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '3111.00', 'No', '0.00', '$', '2024-06-15 11:01:08', NULL, NULL, '0'),
('172', 'RFT/RW/KI/009/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '311.00', 'No', '0.00', '$', '2024-06-15 11:01:08', NULL, NULL, '0'),
('173', 'RFT/RW/KI/009/24', NULL, NULL, 'Non-Operational', '3-112', 'Customs Rent', '600.00', 'No', '0.00', '$', '2024-06-15 11:01:08', NULL, NULL, '0'),
('174', 'RFT/RW/KI/009/24', NULL, NULL, 'Non-Operational', '3-134', 'Miscellaneous', '3000.00', 'No', '0.00', '$', '2024-06-15 11:01:08', NULL, NULL, '0'),
('176', 'RFT/RW/KI/009/24', NULL, NULL, 'Non-Operational', '3-110', 'Removal Fee', '2074.00', 'No', '0.00', '$', '2024-06-15 11:01:08', NULL, NULL, '0'),
('177', 'RFT/RW/KI/039/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-1368.00', 'No', '0.00', '$', '2024-06-15 11:03:17', NULL, NULL, '0'),
('179', 'RFT/RW/KI/039/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '501.00', 'No', '0.00', '$', '2024-06-15 11:03:17', NULL, NULL, '0'),
('180', 'RFT/RW/KI/039/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '1002.00', 'No', '0.00', '$', '2024-06-15 11:03:17', NULL, NULL, '0'),
('181', 'RFT/RW/KI/039/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '50.00', 'No', '0.00', '$', '2024-06-15 11:03:17', NULL, NULL, '0'),
('182', 'RFT/RW/KI/039/24', NULL, NULL, 'Non-Operational', '3-134', 'Miscellaneous', '100.00', 'No', '0.00', '$', '2024-06-15 11:03:17', NULL, NULL, '0'),
('183', 'RFT/RW/KI/008/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '85.50', 'No', '0.00', '$', '2024-06-15 11:06:52', NULL, NULL, '0'),
('185', 'RFT/RW/KI/008/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '45.00', 'No', '0.00', '$', '2024-06-15 11:06:54', NULL, NULL, '0'),
('186', 'RFT/RW/KI/008/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '90.00', 'No', '0.00', '$', '2024-06-15 11:06:54', NULL, NULL, '0'),
('187', 'RFT/RW/KI/008/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '4.50', 'No', '0.00', '$', '2024-06-15 11:06:54', NULL, NULL, '0'),
('189', 'RFT/RW/KI/008/24', NULL, NULL, 'Non-Operational', '3-110', 'Removal Fee', '30.00', 'No', '0.00', '$', '2024-06-15 11:06:54', NULL, NULL, '0'),
('190', 'RFT/RW/KI/002/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-197.00', 'Yes', '0.00', '$', '2024-06-15 11:10:21', NULL, NULL, '0'),
('192', 'RFT/RW/KI/002/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '180.00', 'No', '0.00', '$', '2024-06-15 11:10:21', NULL, NULL, '0'),
('193', 'RFT/RW/KI/002/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '120.00', 'No', '0.00', '$', '2024-06-15 11:10:21', NULL, NULL, '0'),
('194', 'RFT/RW/KI/002/24', NULL, NULL, 'Non-Operational', '3-135', 'Drop-Off Charges', '50.00', 'No', '0.00', '$', '2024-06-15 11:10:21', NULL, NULL, '0'),
('195', 'RFT/RW/KI/002/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '12.00', 'No', '0.00', '$', '2024-06-15 11:10:21', NULL, NULL, '0'),
('196', 'RFT/RW/KI/002/24', NULL, NULL, 'Non-Operational', '3-129', 'Demurrages', '120.00', 'No', '0.00', '$', '2024-06-15 11:10:21', NULL, NULL, '0'),
('197', 'RFT/RW/KI/033/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-387.00', 'No', '0.00', '$', '2024-06-15 11:10:23', NULL, NULL, '0'),
('199', 'RFT/RW/KI/033/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '180.00', 'No', '0.00', '$', '2024-06-15 11:10:23', NULL, NULL, '0'),
('200', 'RFT/RW/KI/033/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '140.00', 'No', '0.00', '$', '2024-06-15 11:10:23', NULL, NULL, '0'),
('201', 'RFT/RW/KI/033/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '12.00', 'No', '0.00', '$', '2024-06-15 11:10:23', NULL, NULL, '0'),
('203', 'RFT/RW/KI/033/24', NULL, NULL, 'Non-Operational', '3-110', 'Removal Fee', '200.00', 'No', '0.00', '$', '2024-06-15 11:10:23', NULL, NULL, '0'),
('204', 'RFT/RW/KI/033/24', NULL, NULL, 'Non-Operational', '3-129', 'Demurrages', '60.00', 'No', '0.00', '$', '2024-06-15 11:10:23', NULL, NULL, '0'),
('205', 'RFT/RW/KI/011/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-1909.00', 'No', '0.00', '$', '2024-06-15 11:13:50', NULL, NULL, '0'),
('207', 'RFT/RW/KI/011/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '900.00', 'No', '0.00', '$', '2024-06-15 11:13:51', NULL, NULL, '0'),
('208', 'RFT/RW/KI/011/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '700.00', 'No', '0.00', '$', '2024-06-15 11:13:51', NULL, NULL, '0'),
('209', 'RFT/RW/KI/011/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '60.00', 'No', '0.00', '$', '2024-06-15 11:13:51', NULL, NULL, '0'),
('210', 'RFT/RW/KI/011/24', NULL, NULL, 'Non-Operational', '3-135', 'Drop-Off Charges', '534.00', 'No', '0.00', '$', '2024-06-15 11:13:51', NULL, NULL, '0'),
('211', 'RFT/RW/KI/053/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-1117.00', 'No', '0.00', '$', '2024-06-15 11:17:43', NULL, NULL, '0'),
('213', 'RFT/RW/KI/053/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '840.00', 'No', '0.00', '$', '2024-06-15 11:17:44', NULL, NULL, '0'),
('214', 'RFT/RW/KI/053/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '420.00', 'No', '0.00', '$', '2024-06-15 11:17:44', NULL, NULL, '0'),
('215', 'RFT/RW/KI/053/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '42.00', 'No', '0.00', '$', '2024-06-15 11:17:45', NULL, NULL, '0'),
('216', 'RFT/RW/KI/053/24', NULL, NULL, 'Non-Operational', '3-134', 'Miscellaneous', '100.00', 'No', '0.00', '$', '2024-06-15 11:17:45', NULL, NULL, '0'),
('217', 'RFT/RW/KI/027/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-1375.00', 'No', '0.00', '$', '2024-06-15 11:19:34', NULL, NULL, '0'),
('219', 'RFT/RW/KI/027/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '900.00', 'No', '0.00', '$', '2024-06-15 11:19:35', NULL, NULL, '0'),
('220', 'RFT/RW/KI/027/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '700.00', 'No', '0.00', '$', '2024-06-15 11:19:35', NULL, NULL, '0'),
('221', 'RFT/RW/KI/027/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '60.00', 'No', '0.00', '$', '2024-06-15 11:19:35', NULL, NULL, '0'),
('222', 'RFT/BU/BU/060/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-27.00', 'No', '0.00', '$', '2024-06-15 11:20:39', NULL, NULL, '0'),
('224', 'RFT/BU/BU/060/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '180.00', 'No', '0.00', '$', '2024-06-15 11:20:41', NULL, NULL, '0'),
('225', 'RFT/BU/BU/060/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '120.00', 'No', '0.00', '$', '2024-06-15 11:20:41', NULL, NULL, '0'),
('226', 'RFT/BU/BU/060/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '12.00', 'No', '0.00', '$', '2024-06-15 11:20:41', NULL, NULL, '0'),
('227', 'RFT/RW/KI/014/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-1625.00', 'No', '0.00', '$', '2024-06-15 11:21:14', NULL, NULL, '0'),
('229', 'RFT/RW/KI/014/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '900.00', 'No', '0.00', '$', '2024-06-15 11:21:14', NULL, NULL, '0'),
('230', 'RFT/RW/KI/014/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '700.00', 'No', '0.00', '$', '2024-06-15 11:21:14', NULL, NULL, '0'),
('231', 'RFT/RW/KI/014/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '60.00', 'No', '0.00', '$', '2024-06-15 11:21:14', NULL, NULL, '0'),
('232', 'RFT/RW/KI/014/24', NULL, NULL, 'Non-Operational', '3-135', 'Drop-Off Charges', '250.00', 'No', '0.00', '$', '2024-06-15 11:21:15', NULL, NULL, '0'),
('233', 'RFT/BU/BU/064/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-246.00', 'No', '0.00', '$', '2024-06-15 11:34:56', NULL, NULL, '0'),
('235', 'RFT/BU/BU/064/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '90.00', 'No', '0.00', '$', '2024-06-15 11:34:56', NULL, NULL, '0'),
('236', 'RFT/BU/BU/064/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '70.00', 'No', '0.00', '$', '2024-06-15 11:34:56', NULL, NULL, '0'),
('237', 'RFT/BU/BU/064/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '6.00', 'No', '0.00', '$', '2024-06-15 11:34:56', NULL, NULL, '0'),
('238', 'RFT/BU/BU/064/24', NULL, NULL, 'Non-Operational', '3-110', 'Removal Fee', '100.00', 'No', '0.00', '$', '2024-06-15 11:34:56', NULL, NULL, '0'),
('240', 'RFT/BU/BU/064/24', NULL, NULL, 'Non-Operational', '3-129', 'Demurrages', '85.00', 'No', '0.00', '$', '2024-06-15 11:34:56', NULL, NULL, '0'),
('241', 'RFT/BU/BU/064/24', NULL, NULL, 'Non-Operational', '3-112', 'Customs Rent', '60.00', 'No', '0.00', '$', '2024-06-15 11:34:56', NULL, NULL, '0'),
('242', 'RFT/DR/GOM/049/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-4627.00', 'No', '0.00', '$', '2024-06-15 11:36:12', NULL, NULL, '0'),
('244', 'RFT/DR/GOM/049/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '180.00', 'No', '0.00', '$', '2024-06-15 11:36:12', NULL, NULL, '0'),
('245', 'RFT/DR/GOM/049/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '120.00', 'No', '0.00', '$', '2024-06-15 11:36:12', NULL, NULL, '0'),
('246', 'RFT/DR/GOM/049/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '12.00', 'No', '0.00', '$', '2024-06-15 11:36:12', NULL, NULL, '0'),
('247', 'RFT/DR/GOM/049/24', NULL, NULL, 'Non-Operational', '3-129', 'Demurrages', '4600.00', 'No', '0.00', '$', '2024-06-15 11:36:13', NULL, NULL, '0'),
('248', 'RFT/DR/GOM/038/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-339.00', 'No', '0.00', '$', '2024-06-15 11:38:13', NULL, NULL, '0'),
('250', 'RFT/DR/GOM/038/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '360.00', 'No', '0.00', '$', '2024-06-15 11:38:13', NULL, NULL, '0'),
('251', 'RFT/DR/GOM/038/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '240.00', 'No', '0.00', '$', '2024-06-15 11:38:13', NULL, NULL, '0'),
('252', 'RFT/DR/GOM/038/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '24.00', 'No', '0.00', '$', '2024-06-15 11:38:14', NULL, NULL, '0'),
('253', 'RFT/DR/LUB/040/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-941.00', 'No', '0.00', '$', '2024-06-15 11:38:52', NULL, NULL, '0'),
('255', 'RFT/DR/LUB/040/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '504.00', 'No', '0.00', '$', '2024-06-15 11:38:52', NULL, NULL, '0'),
('256', 'RFT/DR/LUB/040/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '540.00', 'No', '0.00', '$', '2024-06-15 11:38:52', NULL, NULL, '0'),
('257', 'RFT/DR/LUB/040/24', NULL, NULL, 'Non-Operational', '3-133', 'Reefer Charges', '96.00', 'No', '0.00', '$', '2024-06-15 11:38:52', NULL, NULL, '0'),
('258', 'RFT/DR/LUB/040/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '36.00', 'No', '0.00', '$', '2024-06-15 11:38:52', NULL, NULL, '0'),
('259', 'RFT/DR/LUB/040/24', NULL, NULL, 'Non-Operational', '3-134', 'Miscellaneous', '50.00', 'No', '0.00', '$', '2024-06-15 11:38:52', NULL, NULL, '0'),
('267', 'RFT/DR/KAL/034/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-997.00', 'No', '0.00', '$', '2024-06-15 11:44:09', NULL, NULL, '0'),
('269', 'RFT/DR/KAL/034/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '236.00', 'No', '0.00', '$', '2024-06-15 11:44:09', NULL, NULL, '0'),
('270', 'RFT/DR/KAL/034/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '270.00', 'No', '0.00', '$', '2024-06-15 11:44:09', NULL, NULL, '0'),
('271', 'RFT/DR/KAL/034/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '18.00', 'No', '0.00', '$', '2024-06-15 11:44:09', NULL, NULL, '0'),
('272', 'RFT/DR/KAL/034/24', NULL, NULL, 'Non-Operational', '3-134', 'Miscellaneous', '758.00', 'No', '0.00', '$', '2024-06-15 11:44:09', NULL, NULL, '0'),
('273', 'RFT/BU/BU/031/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-183.00', 'No', '0.00', '$', '2024-06-15 11:44:36', NULL, NULL, '0'),
('275', 'RFT/BU/BU/031/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '180.00', 'No', '0.00', '$', '2024-06-15 11:44:36', NULL, NULL, '0'),
('276', 'RFT/BU/BU/031/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '120.00', 'No', '0.00', '$', '2024-06-15 11:44:36', NULL, NULL, '0'),
('277', 'RFT/BU/BU/031/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '12.00', 'No', '0.00', '$', '2024-06-15 11:44:36', NULL, NULL, '0'),
('278', 'RFT/BU/BU/031/24', NULL, NULL, 'Non-Operational', '3-107', 'Port Handling', '156.00', 'No', '0.00', '$', '2024-06-15 11:44:36', NULL, NULL, '0'),
('279', 'RFT/BU/BU/051/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-2048.00', 'No', '0.00', '$', '2024-06-15 11:52:20', NULL, NULL, '0'),
('281', 'RFT/BU/BU/051/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '540.00', 'No', '0.00', '$', '2024-06-15 11:52:20', NULL, NULL, '0'),
('282', 'RFT/BU/BU/051/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '360.00', 'No', '0.00', '$', '2024-06-15 11:52:20', NULL, NULL, '0'),
('283', 'RFT/BU/BU/051/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '18.00', 'No', '0.00', '$', '2024-06-15 11:52:20', NULL, NULL, '0'),
('285', 'RFT/BU/BU/051/24', NULL, NULL, 'Non-Operational', '3-110', 'Removal Fee', '300.00', 'No', '0.00', '$', '2024-06-15 11:52:20', NULL, NULL, '0'),
('286', 'RFT/BU/BU/051/24', NULL, NULL, 'Non-Operational', '3-112', 'Customs Rent', '125.00', 'No', '0.00', '$', '2024-06-15 11:52:20', NULL, NULL, '0'),
('287', 'RFT/BU/BU/021/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-489.00', 'No', '0.00', '$', '2024-06-15 11:54:56', NULL, NULL, '0'),
('289', 'RFT/BU/BU/021/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '360.00', 'No', '0.00', '$', '2024-06-15 11:54:56', NULL, NULL, '0'),
('290', 'RFT/BU/BU/021/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '280.00', 'No', '0.00', '$', '2024-06-15 11:54:56', NULL, NULL, '0'),
('291', 'RFT/BU/BU/021/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '24.00', 'No', '0.00', '$', '2024-06-15 11:54:56', NULL, NULL, '0'),
('292', 'RFT/BU/BU/021/24', NULL, NULL, 'Non-Operational', '3-129', 'Demurrages', '110.00', 'No', '0.00', '$', '2024-06-15 11:54:56', NULL, NULL, '0'),
('293', 'RFT/BU/BU/022/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '119.00', 'No', '0.00', '$', '2024-06-15 11:57:14', NULL, NULL, '0'),
('295', 'RFT/BU/BU/022/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '90.00', 'No', '0.00', '$', '2024-06-15 11:57:14', NULL, NULL, '0'),
('296', 'RFT/BU/BU/022/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '70.00', 'No', '0.00', '$', '2024-06-15 11:57:14', NULL, NULL, '0'),
('297', 'RFT/BU/BU/022/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '6.00', 'No', '0.00', '$', '2024-06-15 11:57:15', NULL, NULL, '0'),
('298', 'RFT/BU/BU/018/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '49.00', 'No', '0.00', '$', '2024-06-15 12:00:14', NULL, NULL, '0'),
('300', 'RFT/BU/BU/018/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '90.00', 'No', '0.00', '$', '2024-06-15 12:00:14', NULL, NULL, '0'),
('301', 'RFT/BU/BU/018/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '70.00', 'No', '0.00', '$', '2024-06-15 12:00:14', NULL, NULL, '0'),
('302', 'RFT/BU/BU/018/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '6.00', 'No', '0.00', '$', '2024-06-15 12:00:14', NULL, NULL, '0'),
('303', 'RFT/BU/BU/018/24', NULL, NULL, 'Non-Operational', '3-129', 'Demurrages', '70.00', 'No', '0.00', '$', '2024-06-15 12:00:14', NULL, NULL, '0'),
('304', 'RFT/RW/KI/101/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-339.00', 'No', '0.00', '$', '2024-06-15 13:01:39', NULL, NULL, '0'),
('306', 'RFT/RW/KI/101/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '360.00', 'No', '0.00', '$', '2024-06-15 13:01:39', NULL, NULL, '0'),
('307', 'RFT/RW/KI/101/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '240.00', 'No', '0.00', '$', '2024-06-15 13:01:39', NULL, NULL, '0'),
('308', 'RFT/RW/KI/101/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '24.00', 'No', '0.00', '$', '2024-06-15 13:01:39', NULL, NULL, '0'),
('309', 'RFT/RW/KI/097/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-47.00', 'No', '0.00', '$', '2024-06-15 13:09:05', NULL, NULL, '0'),
('311', 'RFT/RW/KI/097/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '180.00', 'No', '0.00', '$', '2024-06-15 13:09:05', NULL, NULL, '0'),
('312', 'RFT/RW/KI/097/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '140.00', 'No', '0.00', '$', '2024-06-15 13:09:05', NULL, NULL, '0'),
('313', 'RFT/RW/KI/097/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '12.00', 'No', '0.00', '$', '2024-06-15 13:09:05', NULL, NULL, '0'),
('314', 'RFT/DR/LUB/072/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-62.00', 'No', '0.00', '$', '2024-06-15 13:21:35', NULL, NULL, '0'),
('316', 'RFT/DR/LUB/072/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '180.00', 'No', '0.00', '$', '2024-06-15 13:21:35', NULL, NULL, '0'),
('317', 'RFT/DR/LUB/072/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '120.00', 'No', '0.00', '$', '2024-06-15 13:21:35', NULL, NULL, '0'),
('318', 'RFT/DR/LUB/072/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '12.00', 'No', '0.00', '$', '2024-06-15 13:21:35', NULL, NULL, '0'),
('319', 'RFT/DR/LUB/072/24', NULL, NULL, 'Non-Operational', '3-133', 'Reefer Charges', '35.00', 'No', '0.00', '$', '2024-06-15 13:21:35', NULL, NULL, '0'),
('320', 'RFT/DR/LUB/058/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-279.00', 'No', '0.00', '$', '2024-06-15 13:22:19', NULL, NULL, '0'),
('322', 'RFT/DR/LUB/058/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '180.00', 'No', '0.00', '$', '2024-06-15 13:22:19', NULL, NULL, '0'),
('323', 'RFT/DR/LUB/058/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '105.00', 'No', '0.00', '$', '2024-06-15 13:22:19', NULL, NULL, '0'),
('324', 'RFT/DR/LUB/058/24', NULL, NULL, 'Non-Operational', '3-138', 'OGFREM ', '137.00', 'No', '0.00', '$', '2024-06-15 13:22:19', NULL, NULL, '0'),
('325', 'RFT/DR/LUB/058/24', NULL, NULL, 'Non-Operational', '3-133', 'Reefer Charges', '90.00', 'No', '0.00', '$', '2024-06-15 13:22:19', NULL, NULL, '0'),
('327', 'RFT/DR/LUB/058/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '12.00', 'No', '0.00', '$', '2024-06-15 13:22:19', NULL, NULL, '0'),
('328', 'RFT/RW/KI/078/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-16079.00', 'No', '0.00', '$', '2024-06-15 13:28:14', NULL, NULL, '0'),
('330', 'RFT/RW/KI/078/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '360.00', 'No', '0.00', '$', '2024-06-15 13:28:14', NULL, NULL, '0'),
('331', 'RFT/RW/KI/078/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '280.00', 'No', '0.00', '$', '2024-06-15 13:28:14', NULL, NULL, '0'),
('332', 'RFT/RW/KI/078/24', NULL, NULL, 'Non-Operational', '3-110', 'Removal Fee', '400.00', 'No', '0.00', '$', '2024-06-15 13:28:14', NULL, NULL, '0'),
('334', 'RFT/RW/KI/078/24', NULL, NULL, 'Non-Operational', '3-111', 'Additional Storage', '8960.00', 'No', '0.00', '$', '2024-06-15 13:28:14', NULL, NULL, '0'),
('335', 'RFT/RW/KI/078/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '24.00', 'No', '0.00', '$', '2024-06-15 13:28:14', NULL, NULL, '0'),
('336', 'RFT/RW/KI/078/24', NULL, NULL, 'Non-Operational', '3-129', 'Demurrages', '5860.00', 'No', '0.00', '$', '2024-06-15 13:28:14', NULL, NULL, '0'),
('337', 'RFT/RW/KI/065/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-3187.00', 'No', '0.00', '$', '2024-06-15 13:37:28', NULL, NULL, '0'),
('339', 'RFT/RW/KI/065/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '360.00', 'No', '0.00', '$', '2024-06-15 13:37:28', NULL, NULL, '0'),
('340', 'RFT/RW/KI/065/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '280.00', 'No', '0.00', '$', '2024-06-15 13:37:28', NULL, NULL, '0'),
('341', 'RFT/RW/KI/065/24', NULL, NULL, 'Non-Operational', '3-129', 'Demurrages', '2380.00', 'No', '0.00', '$', '2024-06-15 13:37:28', NULL, NULL, '0'),
('342', 'RFT/RW/KI/065/24', NULL, NULL, 'Non-Operational', '3-123', 'Number Plate', '52.00', 'No', '0.00', '$', '2024-06-15 13:37:28', NULL, NULL, '0'),
('343', 'RFT/RW/KI/065/24', NULL, NULL, 'Non-Operational', '3-112', 'Customs Rent', '400.00', 'No', '0.00', '$', '2024-06-15 13:37:28', NULL, NULL, '0'),
('344', 'RFT/DR/LUB/061/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-1631.00', 'No', '0.00', '$', '2024-06-15 13:45:46', NULL, NULL, '0'),
('346', 'RFT/DR/LUB/061/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '720.00', 'No', '0.00', '$', '2024-06-15 13:45:46', NULL, NULL, '0'),
('347', 'RFT/DR/LUB/061/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '480.00', 'No', '0.00', '$', '2024-06-15 13:45:46', NULL, NULL, '0'),
('348', 'RFT/DR/LUB/061/24', NULL, NULL, 'Non-Operational', '3-138', 'OGFREM ', '548.00', 'No', '0.00', '$', '2024-06-15 13:45:46', NULL, NULL, '0'),
('349', 'RFT/DR/LUB/061/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '48.00', 'No', '0.00', '$', '2024-06-15 13:45:46', NULL, NULL, '0'),
('350', 'RFT/DR/LUB/061/24', NULL, NULL, 'Non-Operational', '3-133', 'Reefer Charges', '120.00', 'No', '0.00', '$', '2024-06-15 13:45:46', NULL, NULL, '0'),
('351', 'RFT/DR/LUB/070/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-1152.00', 'No', '0.00', '$', '2024-06-15 13:50:26', NULL, NULL, '0'),
('353', 'RFT/DR/LUB/070/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '540.00', 'No', '0.00', '$', '2024-06-15 13:50:26', NULL, NULL, '0'),
('354', 'RFT/DR/LUB/070/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '360.00', 'No', '0.00', '$', '2024-06-15 13:50:26', NULL, NULL, '0'),
('355', 'RFT/DR/LUB/070/24', NULL, NULL, 'Non-Operational', '3-138', 'OGFREM ', '411.00', 'No', '0.00', '$', '2024-06-15 13:50:26', NULL, NULL, '0'),
('356', 'RFT/DR/LUB/070/24', NULL, NULL, 'Non-Operational', '3-133', 'Reefer Charges', '90.00', 'No', '0.00', '$', '2024-06-15 13:50:26', NULL, NULL, '0'),
('357', 'RFT/DR/LUB/070/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '36.00', 'No', '0.00', '$', '2024-06-15 13:50:26', NULL, NULL, '0'),
('358', 'RFT/DR/LUB/068/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-3260.00', 'No', '0.00', '$', '2024-06-15 13:55:08', NULL, NULL, '0'),
('360', 'RFT/DR/LUB/068/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '900.00', 'No', '0.00', '$', '2024-06-15 13:55:08', NULL, NULL, '0'),
('361', 'RFT/DR/LUB/068/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '600.00', 'No', '0.00', '$', '2024-06-15 13:55:08', NULL, NULL, '0'),
('362', 'RFT/DR/LUB/068/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '60.00', 'No', '0.00', '$', '2024-06-15 13:55:08', NULL, NULL, '0'),
('363', 'RFT/DR/LUB/068/24', NULL, NULL, 'Non-Operational', '3-138', 'OGFREM ', '585.00', 'No', '0.00', '$', '2024-06-15 13:55:08', NULL, NULL, '0'),
('364', 'RFT/DR/LUB/068/24', NULL, NULL, 'Non-Operational', '3-110', 'Removal Fee', '750.00', 'No', '0.00', '$', '2024-06-15 13:55:08', NULL, NULL, '0'),
('366', 'RFT/DR/LUB/068/24', NULL, NULL, 'Non-Operational', '3-133', 'Reefer Charges', '450.00', 'No', '0.00', '$', '2024-06-15 13:55:08', NULL, NULL, '0'),
('367', 'RFT/DR/LUB/073/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-1768.00', 'No', '0.00', '$', '2024-06-15 13:59:44', NULL, NULL, '0'),
('369', 'RFT/DR/LUB/073/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '720.00', 'No', '0.00', '$', '2024-06-15 13:59:44', NULL, NULL, '0'),
('370', 'RFT/DR/LUB/073/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '480.00', 'No', '0.00', '$', '2024-06-15 13:59:44', NULL, NULL, '0'),
('371', 'RFT/DR/LUB/073/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '48.00', 'No', '0.00', '$', '2024-06-15 13:59:44', NULL, NULL, '0'),
('372', 'RFT/DR/LUB/073/24', NULL, NULL, 'Non-Operational', '3-138', 'OGFREM ', '685.00', 'No', '0.00', '$', '2024-06-15 13:59:44', NULL, NULL, '0'),
('373', 'RFT/DR/LUB/073/24', NULL, NULL, 'Non-Operational', '3-133', 'Reefer Charges', '120.00', 'No', '0.00', '$', '2024-06-15 13:59:44', NULL, NULL, '0'),
('374', 'RFT/BU/BU/083/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-2952.00', 'No', '0.00', '$', '2024-06-15 14:05:04', NULL, NULL, '0'),
('376', 'RFT/BU/BU/083/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '720.00', 'No', '0.00', '$', '2024-06-15 14:05:04', NULL, NULL, '0'),
('377', 'RFT/BU/BU/083/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '560.00', 'No', '0.00', '$', '2024-06-15 14:05:04', NULL, NULL, '0'),
('378', 'RFT/BU/BU/083/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '48.00', 'No', '0.00', '$', '2024-06-15 14:05:04', NULL, NULL, '0'),
('379', 'RFT/BU/BU/083/24', NULL, NULL, 'Non-Operational', '3-111', 'Additional Storage', '40.00', 'No', '0.00', '$', '2024-06-15 14:05:04', NULL, NULL, '0'),
('380', 'RFT/BU/BU/083/24', NULL, NULL, 'Non-Operational', '3-111', 'Additional Storage', '189.00', 'No', '0.00', '$', '2024-06-15 14:05:04', NULL, NULL, '0'),
('381', 'RFT/BU/BU/083/24', NULL, NULL, 'Non-Operational', '3-129', 'Demurrages', '1680.00', 'No', '0.00', '$', '2024-06-15 14:05:04', NULL, NULL, '0'),
('382', 'RFT/BU/BU/090/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-339.00', 'No', '0.00', '$', '2024-06-15 14:11:34', NULL, NULL, '0'),
('384', 'RFT/BU/BU/090/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '360.00', 'No', '0.00', '$', '2024-06-15 14:11:34', NULL, NULL, '0'),
('385', 'RFT/BU/BU/090/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '240.00', 'No', '0.00', '$', '2024-06-15 14:11:34', NULL, NULL, '0'),
('386', 'RFT/BU/BU/090/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '24.00', 'No', '0.00', '$', '2024-06-15 14:11:34', NULL, NULL, '0'),
('387', 'RFT/RW/KI/005/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-389.00', 'No', '0.00', '$', '2024-06-15 14:30:43', NULL, NULL, '0'),
('389', 'RFT/RW/KI/005/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '270.00', 'No', '0.00', '$', '2024-06-15 14:30:43', NULL, NULL, '0'),
('390', 'RFT/RW/KI/005/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '210.00', 'No', '0.00', '$', '2024-06-15 14:30:43', NULL, NULL, '0'),
('391', 'RFT/RW/KI/005/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '18.00', 'No', '0.00', '$', '2024-06-15 14:30:43', NULL, NULL, '0'),
('392', 'RFT/RW/KI/005/24', NULL, NULL, 'Non-Operational', '3-134', 'Miscellaneous', '176.00', 'No', '0.00', '$', '2024-06-15 14:30:43', NULL, NULL, '0'),
('393', 'RFT/RW/KI/027/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-1375.00', 'No', '0.00', '$', '2024-06-15 14:33:05', NULL, NULL, '0'),
('395', 'RFT/RW/KI/027/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '900.00', 'No', '0.00', '$', '2024-06-15 14:33:05', NULL, NULL, '0'),
('396', 'RFT/RW/KI/027/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '700.00', 'No', '0.00', '$', '2024-06-15 14:33:05', NULL, NULL, '0'),
('397', 'RFT/RW/KI/027/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '60.00', 'No', '0.00', '$', '2024-06-15 14:33:05', NULL, NULL, '0'),
('398', 'RFT/RW/KI/006/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-1057.33', 'No', '0.00', '$', '2024-06-15 14:41:53', NULL, NULL, '0'),
('400', 'RFT/RW/KI/006/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '866.22', 'No', '0.00', '$', '2024-06-15 14:41:53', NULL, NULL, '0'),
('401', 'RFT/RW/KI/006/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '433.11', 'No', '0.00', '$', '2024-06-15 14:41:53', NULL, NULL, '0'),
('402', 'RFT/RW/KI/006/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '43.00', 'No', '0.00', '$', '2024-06-15 14:41:53', NULL, NULL, '0'),
('404', 'RFT/RW/KI/002/24', NULL, NULL, 'Non-Operational', '3-101', 'Delivery Order', '15.00', 'No', '0.00', NULL, '2024-06-18 13:13:52', NULL, NULL, '0'),
('405', 'RFT/RW/KI/003/24', 'Yes', '300', 'Operational', '1-101', 'Agency Fee', '-213.00', 'No', '0.00', '$', '2024-06-19 16:12:37', '', NULL, '0'),
('406', 'RFT/RW/KI/003/24', NULL, NULL, 'Non-Operational', '3-101', 'Delivery Order', '15.00', 'No', '0.00', '$', '2024-06-19 16:12:37', NULL, NULL, '0'),
('407', 'RFT/RW/KI/003/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '270.00', 'No', '0.00', '$', '2024-06-19 16:12:37', NULL, NULL, '0'),
('408', 'RFT/RW/KI/003/24', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '210.00', 'No', '0.00', '$', '2024-06-19 16:12:37', NULL, NULL, '0'),
('409', 'RFT/RW/KI/003/24', NULL, NULL, 'Non-Operational', '3-136', 'Corridor Levy', '18.00', 'No', '0.00', '$', '2024-06-19 16:12:37', NULL, NULL, '0'),
('410', 'RFT/148/KI/24', 'Yes', '6831', 'Operational', '1-101', 'Agency Fee', '5313.00', 'No', '0.00', '$', '2024-10-01 16:23:30', NULL, NULL, '0'),
('411', 'RFT/148/KI/24', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '1518.00', 'No', '0.00', '$', '2024-10-01 16:23:30', NULL, NULL, '0'),
('412', 'RFT/151/KI/24', 'Yes', '1075', 'Operational', '1-101', 'Agency Fee', '300.00', 'Yes', '0.00', '$', '2024-10-25 11:38:29', NULL, NULL, '0'),
('413', 'RFT/153/LUB/24', 'Yes', '19400', 'Operational', '1-101', 'Agency Fee', '19385.00', 'No', '0.00', '$', '2024-10-25 19:04:00', NULL, NULL, '0'),
('414', 'RFT/153/LUB/24', NULL, NULL, 'Non-Operational', '3-101', 'Delivery Order', '15.00', 'No', '0.00', '$', '2024-10-25 19:04:00', NULL, NULL, '0'),
('434', 'RFT/RW/KI/001/25', 'Yes', '750', 'Operational', '1-101', 'Agency Fee', '272.00', 'No', '0.00', '$', '2025-03-04 08:32:41', NULL, NULL, '0'),
('435', 'RFT/RW/KI/001/25', NULL, NULL, 'Non-Operational', '3-102', 'Port Charges', '193.00', 'No', '0.00', '$', '2025-03-04 08:32:41', NULL, NULL, '0'),
('436', 'RFT/RW/KI/001/25', NULL, NULL, 'Non-Operational', '3-106', 'Wharfage', '270.00', 'No', '0.00', '$', '2025-03-04 08:32:41', NULL, NULL, '0'),
('437', 'RFT/RW/KI/001/25', NULL, NULL, 'Non-Operational', '3-101', 'Delivery Order', '15.00', 'No', '0.00', '$', '2025-03-04 08:32:41', NULL, NULL, '0');


INSERT INTO `restricted_words` VALUES
('1', 'Fuck'),
('2', 'Naked');



INSERT INTO `settings` VALUES
('1', 'system_name', 'Royal Freight  Ltd'),
('2', 'email_host', 'mail.myne.co.ke'),
('3', 'email_port', '587'),
('4', 'email_username', 'mailer@myne.co.ke'),
('5', 'email_password', '#@#2025Wemadeit'),
('6', 'email_sender', 'no-reply@myne.co.ke'),
('7', 'default_currency', 'USD'),
('8', 'address', 'Plot No: 995/149 Off, P.o.Box 4040 Uhuru Street, Dar es Salaam, Tanzania'),
('9', 'tel_1', '+255 757 200 797'),
('10', 'tel_2', ''),
('11', 'local_file_counter', '0');

INSERT INTO `shipment_data` VALUES
('5', 'RFT/DR/GOM/001/24', 'MOHAMMED ABUBAKAR ALBEITY', 'T256DKK/T239DKK', 'FAHAD ABU', '', '', '2024-05-01', '2024-05-01', '2024-05-04', NULL, '2024-05-06', '2024-05-09', '2024-05-11'),
('6', 'RFT/DR/LUB/058/24', 'SULEIMANI AMUR', 'T625DML/T228DYZ', 'SELEMANI OMARY JUMA', '4003137767', '', '2024-05-28', '2024-05-29', '2024-06-05', '2024-06-05', '2024-06-05', '2024-06-19', '2024-06-19'),
('7', 'RFT/DR/LUB/073/24', 'SULEIMAN AMUR SULEIMAN', 'T508DXQ/T726DUV', 'MEHBOOB KHAMISI MAHAMUDU', '0715172539', '4003152188', '2024-06-07', '2024-06-07', '2024-06-11', '2024-06-11', '2024-06-11', '2024-06-11', '2024-06-11'),
('8', 'RFT/BU/BU/018/24', 'ETEX CONSTRUCTION', 'H9903A/T1110A', 'ALIMACHUSI JAMES MATHIAS', '0746071153', '4002994520', '2024-02-20', '2024-02-20', '2024-02-27', '2024-02-27', '2024-02-27', '2024-02-27', '2024-03-18'),
('9', 'RFT/DR/GOM/057/24', 'DALASHO', 'T542DZM/T527DZM', 'NOEL EMANUEL SAIMON', '0713200797', '4002315273', '2024-05-30', '2024-05-30', '2024-06-05', '2024-06-05', '2024-06-05', '2024-06-05', '2024-06-12'),
('10', 'RFT/RW/KI/002/24', 'MURADO', 'RAG357F/RL4748', 'NSENGIYUMVA ABDOUL', '0746071153', '11111', '2024-01-25', '2024-01-27', '2024-01-30', '2024-02-01', '2024-02-01', '2024-02-01', '2024-02-16'),
('11', 'RFT/BU/BU/060/24', 'SOCIETE KURUGERO SOFT', 'J3843A/T1290A', 'NOHA NZOHABONAYO', '0767487153', 'PNC0022011', '2024-03-30', '2024-03-30', '2024-04-10', '2024-04-13', '2024-04-11', '2024-04-11', '2024-04-12'),
('12', 'RFT/ZM/LU/047/24', 'GREENWOOD', 'T500CKP/T193DPP', 'MATEI DONATH FIDELIS', '0685709410', '0', '2024-03-15', '2024-03-15', '2024-03-21', '2024-03-23', '2024-03-22', '2024-03-22', '2024-03-22'),
('13', 'RFT/ZM/LU/052/24', 'GREENWOOD', 'T678DPG/T286DJF', 'IBRAHIMU SHAIBU IDDY', '0676109993', '4006127580', '2024-03-27', '2024-03-27', '2024-04-06', '2024-04-08', '2024-04-06', '2024-04-07', '2024-04-08'),
('14', 'RFT/DR/GOM/038/24', 'MOHAMED ABOUBAKAR', NULL, NULL, NULL, NULL, '2024-05-26', '2024-05-26', '2024-05-30', '2024-04-30', '0000-00-00', '0000-00-00', '0000-00-00'),
('15', 'RFT/BU/BU/031/24', 'RUGAGAMIZA', NULL, NULL, NULL, NULL, '2024-03-05', '2024-03-05', '2024-03-09', '2024-03-09', '2024-03-10', '2024-03-10', '2024-03-16'),
('16', 'RFT/DR/GOM/049/24', '', NULL, NULL, NULL, NULL, '2024-03-20', '2024-03-20', '2024-03-26', '2024-03-26', '2024-03-22', '2024-03-22', '2024-03-30'),
('17', 'RFT/BU/BU/064/24', 'NIYONZIMA DYLAN', NULL, NULL, NULL, NULL, '2024-04-09', '2024-04-09', '2024-04-12', '2024-04-12', '0000-00-00', '0000-00-00', '0000-00-00'),
('18', 'RFT/DR/LUB/040/24', 'KHAMIS', NULL, NULL, NULL, NULL, '2024-03-20', '2024-03-20', '2024-03-24', '2024-03-24', '0000-00-00', '0000-00-00', '0000-00-00'),
('19', 'RFT/DR/KAL/034/24', 'NDIPA', NULL, NULL, NULL, NULL, '2024-03-11', '2024-03-11', '2024-03-18', '2024-03-18', '0000-00-00', '0000-00-00', '0000-00-00'),
('20', 'RFT/BU/BU/063/24', 'KURUGERO', NULL, NULL, NULL, NULL, '2024-04-23', '2024-04-23', '2024-04-28', '2024-04-28', '0000-00-00', '0000-00-00', '0000-00-00'),
('21', 'RFT/RW/KI/033/24', 'HABAKURAMA ORESTE', NULL, NULL, NULL, NULL, '2024-02-12', '2024-02-12', '2024-02-17', '2024-02-17', '0000-00-00', '0000-00-00', '0000-00-00'),
('22', 'RFT/DR/GOM/106/24', 'ABDIKADAR YUSUF', NULL, NULL, NULL, NULL, '2024-06-20', '2024-06-20', '2024-06-25', '2024-02-25', '0000-00-00', '0000-00-00', '0000-00-00'),
('23', 'RFT/107/KI/24', 'SEBAGABO THEOGENE', NULL, NULL, NULL, NULL, '2024-07-04', '2024-07-04', '2024-08-08', '2024-08-08', '2024-08-08', '0000-00-00', '2024-08-19'),
('24', 'RFT/DR/GOM/075/24', 'GUARANTY TRUST BANK', NULL, NULL, NULL, NULL, '2024-08-05', '2024-08-02', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00'),
('25', 'RFT/DR/GOM/071/24', 'FRANCIS BUKUZAGARA', NULL, NULL, NULL, NULL, '2024-08-05', '2024-08-02', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00'),
('26', 'RFT/119/LUB/24', 'ABOUBAKAR MOHAMED ALBAITY', NULL, NULL, NULL, NULL, '2024-08-14', '2024-08-14', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00'),
('27', 'RFT/116/BUK/24', 'GREENWOOD LOGISTICS', NULL, NULL, NULL, NULL, '2024-08-12', '2024-08-12', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00'),
('28', 'RFT/115/LUB/24', 'SULEIMAN AMUR SULEIMAN', NULL, NULL, NULL, NULL, '2024-08-13', '2024-08-13', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00'),
('29', 'RFT/112/LU/24', 'M.A.ISMAN LIMITED', NULL, NULL, NULL, NULL, '2024-08-19', '2024-08-19', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00'),
('30', 'RFT/114/LU/24', 'M.A.ISMAN LIMITED', NULL, NULL, NULL, NULL, '2024-08-19', '2024-08-19', '2024-08-19', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00'),
('31', 'RFT/113/LU/24', 'M.A.ISMAN LIMITED', NULL, NULL, NULL, NULL, '2024-08-19', '2024-08-19', '2024-08-19', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00'),
('32', 'RFT/111/LU/24', 'M.A.ISMAN LIMITED', NULL, NULL, NULL, NULL, '2024-08-19', '2024-08-19', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00'),
('33', 'RFT/BU/BU/087/24', 'SOCIATE KURUGERO SOFT', NULL, NULL, NULL, NULL, '2024-08-19', '2024-08-19', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00'),
('34', 'RFT/129/KI/24', 'MAKAB', NULL, NULL, NULL, NULL, '2024-08-27', '2024-08-26', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00'),
('35', 'RFT/128/KI/24', 'KAMURU', NULL, NULL, NULL, NULL, '2024-08-17', '2024-08-17', '2024-08-21', '2024-08-21', '0000-00-00', '0000-00-00', '0000-00-00'),
('36', 'RFT/121/KI/24', 'KAMURU', NULL, NULL, NULL, NULL, '2024-08-28', '2024-08-28', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00'),
('37', 'RFT/136/KI/24', 'DN-C SUPPLY', NULL, NULL, NULL, NULL, '2024-08-31', '2024-08-31', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00'),
('38', 'RFT/138/KI/24', 'MURADO', NULL, NULL, NULL, NULL, '2024-09-06', '2024-09-06', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00'),
('39', 'RFT/132/KI/24', 'TANGANYIKA LOGISTICS', NULL, NULL, NULL, NULL, '2024-10-15', '2024-10-15', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00'),
('40', 'RFT/117/LUB/24', 'ABOUBAKAR MOHAMED ALBAITY', NULL, NULL, NULL, NULL, '2024-10-05', '2024-10-05', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00'),
('41', 'RFT/148/KI/24', 'KAMURU', NULL, NULL, NULL, NULL, '2024-10-15', '2024-10-15', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00'),
('42', 'RFT/149/KI/24', 'GREENWOOD LOGISTICS', NULL, NULL, NULL, NULL, '2024-10-21', '2024-10-21', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00'),
('43', 'RFT/150/KI/24', 'ALL WAYS LOGISTICS', NULL, NULL, NULL, NULL, '2024-10-18', '2024-10-18', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00'),
('44', 'RFT/152/BUK/24', 'Tanganyika logistics ', NULL, NULL, NULL, NULL, '2024-10-15', '2024-10-15', '2024-10-19', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00');


INSERT INTO `shipping_line` VALUES
('1', 'RFT/DR/LUB/058/24', '2024-05-20', '2024-05-22', '2024-06-19', '2024-06-19', '', '', '0', '0', '0', '1', '2024-07-05 15:26:54'),
('2', 'RFT/BU/BU/018/24', '2024-02-14', '2024-02-14', '2024-03-18', '2024-03-18', '', '', '0', '0', '0', '1', '2024-07-05 16:06:38'),
('3', 'RFT/DR/LUB/073/24', '2024-06-03', '2024-06-03', '0000-00-00', '0000-00-00', '', '', '0', '0', '0', '1', '2024-07-05 16:11:41'),
('4', 'RFT/DR/GOM/057/24', '2024-05-29', '2024-05-30', '2024-06-12', '2024-06-12', '', '', '0', '0', '0', '1', '2024-07-05 16:47:35'),
('5', 'RFT/BU/BU/060/24', '2024-03-28', '2024-03-28', '2024-04-17', '0000-00-00', '', '', '0', '0', '0', '1', '2024-07-06 11:47:22'),
('6', 'RFT/BU/BU/022/24', '2024-02-29', '2024-03-01', '2024-03-18', '2024-03-19', '', '', '0', '0', '0', '1', '2024-07-06 11:57:36'),
('7', 'RFT/ZM/LU/052/24', '2024-03-25', '2024-02-25', '2024-04-20', '2024-04-20', '', '', '0', '0', '0', '1', '2024-07-06 12:12:10'),
('8', 'RFT/ZM/LU/052/24', '2024-03-25', '2024-02-25', '2024-04-20', '2024-04-20', '', '', '0', '0', '0', '1', '2024-07-06 12:12:30'),
('9', 'RFT/ZM/LU/052/24', '2024-03-25', '2024-02-25', '2024-04-20', '2024-04-20', '', '', '0', '0', '0', '1', '2024-07-06 12:12:50'),
('10', 'RFT/ZM/LU/052/24', '2024-03-25', '2024-02-25', '2024-04-20', '2024-04-20', '', '', '0', '0', '0', '1', '2024-07-06 12:13:03'),
('11', 'RFT/ZM/LU/052/24', '2024-03-25', '2024-02-25', '2024-04-20', '2024-04-20', '', '', '0', '0', '0', '15', '2024-07-06 12:13:35'),
('12', 'RFT/ZM/LU/052/24', '2024-03-25', '2024-02-25', '2024-04-20', '2024-04-20', '', '', '0', '0', '0', '15', '2024-07-06 12:15:16'),
('13', 'RFT/RW/KI/093/24', '2024-06-01', '2024-06-06', '2024-06-13', '2024-06-14', '', '', '0', '0', '0', '15', '2024-07-06 12:26:55'),
('14', 'RFT/ZM/LU/047/24', '2024-03-09', '2024-03-14', '2024-04-02', '2024-04-09', '', '', '0', '0', '0', '15', '2024-07-06 13:05:13'),
('15', 'RFT/RW/KI/004/24', '2024-01-23', '2024-01-23', '2024-02-16', '2024-02-17', '', '', '0', '0', '0', '15', '2024-07-06 13:35:44'),
('16', 'RFT/RW/KI/039/24', '2024-02-20', '2024-02-20', '2024-02-26', '0000-00-00', '', '', '0', '0', '0', '15', '2024-07-06 14:01:29');

INSERT INTO `support_tickets` VALUES
('3', 'TKT-41A6ADD0', '1', 'PhpMyAdmin Error', 'medium', 'open', 'General', '2025-03-04 22:26:56', '2025-03-04 22:26:56', NULL);


INSERT INTO `ticket_categories` VALUES
('1', 'General', 'General Enquiries', '1');

INSERT INTO `ticket_messages` VALUES
('3', '3', '1', 'PhpMyAdmin Error', '0', '2025-03-04 22:26:56');

INSERT INTO `trans_charges` VALUES
('1', 'Advance', 'Active'),
('2', 'Balance', 'Active'),
('3', 'Demurrages', 'Active'),
('4', 'Trucks Detentions', 'Active'),
('5', ' Truck Cancellation', 'Active'),
('6', 'Misc.', 'Active');

INSERT INTO `trans_cost_ref` VALUES
('1', 'Advance', 'Active'),
('2', 'Balance', 'Active'),
('3', 'Demurrages', 'Active'),
('4', 'Misc.', 'Active'),
('5', 'Truck Cancellation', 'Active'),
('6', 'Trucks Detention', 'Active');

INSERT INTO `trans_fees` VALUES
('1', '3', 'RFT/DR/GOM/001/24', 'Yes', '4800', '', '4800.00', '0.00', NULL, NULL, NULL, '$', '2024-08-08 08:38:52'),
('2', '3', 'RFT/DR/GOM/001/24', NULL, NULL, 'Advance', '3000.00', '0.00', NULL, NULL, NULL, '$', '2024-08-08 08:38:53'),
('3', '3', 'RFT/DR/GOM/001/24', NULL, NULL, 'Balance', '1800.00', '0.00', NULL, NULL, NULL, '$', '2024-08-08 08:38:54');

INSERT INTO `transporter_info` VALUES
('3', 'MOHAMMED ABUBAKAR ALBEITY', '0700999888', 'TANZANIA', '1', '0.00', '0.00'),
('4', 'KAMURU TRADING COMPANY', '0757172539', 'RWANDA', '1', '0.00', '0.00'),
('5', 'OCEAN ALLUMINIUM', '+255 693 686 910', 'TZ', '1', '0.00', '0.00'),
('6', 'DYLAN', '+257 796 31814', 'BURUNDI', '1', '0.00', '0.00'),
('7', 'POWA BUSINESS ', '+250 788 758 590', 'RWANDA', '1', '0.00', '0.00'),
('8', 'NSENGIYUMVA FRANCOIS', '+250 788 758', 'RWANDA', '1', '0.00', '0.00'),
('9', 'BURUNDI SHIMO', 'shimo burundi', 'BURUNDI', '1', '0.00', '0.00'),
('10', 'MBARUSHA TRADING ', 'MBARUSHA', 'RWANDA', '1', '0.00', '0.00'),
('11', 'SULEIMAN TRANSPORT', '+255 684 222 243', 'TZ', '1', '0.00', '0.00'),
('12', 'GREENWOOD- HASSAN', '+255 678259624 OR 255766797945', 'TANZANIA', '1', '0.00', '0.00'),
('13', 'DALASHO', '+255 785 999 989', 'TANZANIA', '1', '0.00', '0.00'),
('14', 'RAD METALS', '+255779631814', 'BURUNDI', '1', '0.00', '0.00'),
('15', 'OTHERS', '', 'TZ ', '1', '0.00', '0.00'),
('16', 'Amuges transport', '+250 788 661 298', 'RWANDA', '1', '0.00', '0.00'),
('17', 'ROYAL FREIGHT ', '255 713 200 797', 'TZ', '1', '0.00', '0.00');

INSERT INTO `transporters` VALUES
('2', 'MOHAMMED ABUBAKAR ALBEITY', 'RFT/DR/GOM/001/24');

INSERT INTO `truck_details` VALUES
('1', 'RFT/DR/GOM/038/24', 'CMAU6391503', 'MOHAMED ABOUBAKAR', '2024-05-26', 'T618DGD/T262DDA', 'TEOFIL SABAS TEMBO', '0746784977', '4002401941', '2024-05-26', '2024-05-30', '0000-00-00', '0000-00-00', '0000-00-00', '2024-04-30', '13', '2024-07-11 12:19:11', '2024-07-11 12:19:11'),
('2', 'RFT/DR/GOM/038/24', 'CAAU6289292', 'MOHAMED ABOUBAKAR', '2024-05-26', 'T256DKK/T239DKK', 'FAHED ABUBAKARI SHARIFF', '0763595057', '4000297123', '2024-05-26', '2024-05-31', '0000-00-00', '0000-00-00', '0000-00-00', '2024-05-31', '13', '2024-07-11 12:19:11', '2024-07-11 12:19:11'),
('3', 'RFT/BU/BU/031/24', 'TGHU6307250', 'RUGAGAMIZA', '2024-03-05', 'J0484A/T0756A', 'OMARY HAKIRI', '0766411101', 'PNC0074218', '2024-03-05', '2024-03-09', '2024-03-10', '2024-03-10', '2024-03-16', '2024-03-09', '13', '2024-07-11 15:26:05', '2024-07-11 15:26:05'),
('4', 'RFT/DR/GOM/049/24', 'UACU4793070', '', '2024-03-20', 'T500DNK/T588CLS', 'MZAMILU IBRAHIM MNYOTI', '0786577529', '4004547155', '2024-03-20', '2024-03-26', '2024-03-22', '2024-03-22', '2024-03-30', '2024-03-26', '13', '2024-07-11 15:35:44', '2024-07-11 15:35:44'),
('5', 'RFT/BU/BU/064/24', 'CBHU5879888', 'NIYONZIMA DYLAN', '2024-04-09', 'J7833A/T0521A', 'MOHAMED MANENO', '0763771479', 'PNC0020983', '2024-04-09', '2024-04-12', '0000-00-00', '0000-00-00', '0000-00-00', '2024-04-12', '14', '2024-07-11 16:49:44', '2024-07-11 16:49:44'),
('6', 'RFT/DR/LUB/040/24', 'TTNU8776160', 'KHAMIS', '2024-03-20', 'T633DWD/T866BTB', 'HAMIS ABDALLAH', '0763771479', '4000130791', '2024-03-20', '2024-03-24', '0000-00-00', '0000-00-00', '0000-00-00', '2024-03-24', '14', '2024-07-11 17:01:30', '2024-07-11 17:01:30'),
('7', 'RFT/DR/LUB/040/24', 'AMCU9315676', 'KHAMIS', '2024-03-20', 'T618DGD/T262DDA', 'ALLY HABIBU', '0763771479', '4002401941', '2024-03-20', '2024-03-24', '0000-00-00', '0000-00-00', '0000-00-00', '2024-03-24', '14', '2024-07-11 17:01:30', '2024-07-11 17:01:30'),
('8', 'RFT/DR/LUB/040/24', 'SEKU9123843', 'KHAMIS', '2024-03-20', 'T256DKK/T239/DKK', 'FAHAD MOHAMED', '0763771479', '4000297123', '2024-03-20', '2024-03-24', '0000-00-00', '0000-00-00', '0000-00-00', '2024-03-24', '14', '2024-07-11 17:01:30', '2024-07-11 17:01:30'),
('9', 'RFT/DR/KAL/034/24', 'TRHU2126492', 'NDIPA', '2024-03-11', 'E7891A/T2626A', 'MOHAMED NTARUBUZA', '0763771479', '4003332790', '2024-03-11', '2024-03-18', '0000-00-00', '0000-00-00', '0000-00-00', '2024-03-18', '14', '2024-07-13 11:35:41', '2024-07-13 11:35:41'),
('10', 'RFT/DR/KAL/034/24', 'SEGU4999130', 'NDIPA', '2024-03-11', 'L1592A/T2626A', 'BABU HAKIZIMANA', '0763771479', 'PNC0062660', '2024-03-11', '2024-03-18', '0000-00-00', '0000-00-00', '0000-00-00', '2024-03-18', '14', '2024-07-13 11:35:41', '2024-07-13 11:35:41'),
('11', 'RFT/BU/BU/063/24', 'FCIU5485326', 'KURUGERO', '2024-04-23', 'J0484A/T0756A', 'HAKIRI OMARY', '0763771479', 'PNC0074218', '2024-04-23', '2024-04-28', '0000-00-00', '0000-00-00', '0000-00-00', '2024-04-28', '14', '2024-07-13 13:09:28', '2024-07-13 13:09:28'),
('12', 'RFT/BU/BU/063/24', 'DFSU1104174', 'KURUGERO', '2024-04-23', 'J7833A/T0521A', 'MOHAMED MANENO', '0763771479', 'PNC0020983', '2024-04-23', '2024-04-28', '0000-00-00', '0000-00-00', '0000-00-00', '2024-04-28', '14', '2024-07-13 13:09:28', '2024-07-13 13:09:28'),
('13', 'RFT/RW/KI/033/24', 'TRHU1420943', 'HABAKURAMA ORESTE', '2024-02-12', 'RAF017C/RL3775', 'RWEMA THEOGENE', '0763771479', '1199480192002303', '2024-02-12', '2024-02-17', '0000-00-00', '0000-00-00', '0000-00-00', '2024-02-17', '14', '2024-07-13 13:21:16', '2024-07-13 13:21:16'),
('14', 'RFT/RW/KI/033/24', 'MRKU675812', 'HABAKURAMA ORESTE', '2024-02-12', 'RAH313C/RL5867', 'SEBAKARA INNOCENT', '0763771479', '1197980001361221', '2024-02-12', '2024-02-17', '0000-00-00', '0000-00-00', '0000-00-00', '2024-02-17', '14', '2024-07-13 13:21:16', '2024-07-13 13:21:16'),
('15', 'RFT/DR/GOM/106/24', 'CMAU1013590', 'ABDIKADAR YUSUF', '2024-06-20', 'T760CZT/T897CDJ', 'SALIM ABDALLAH HASSANI', '0763771479', '4000177092', '2024-06-20', '2024-06-25', '0000-00-00', '0000-00-00', '0000-00-00', '2024-02-25', '14', '2024-07-13 13:25:03', '2024-07-13 13:25:03'),
('16', 'RFT/107/KI/24', 'TGBU8547509', 'SEBAGABO THEOGENE', '2024-07-04', 'RAE094Q/RL1922', 'INNOCENT MBARUSHIMANA', '0769116126', '1443712VVY040', '2024-07-04', '2024-08-08', '2024-08-08', '0000-00-00', '2024-08-19', '2024-08-08', '14', '2024-08-05 12:00:09', '2024-08-05 12:00:09'),
('17', 'RFT/DR/GOM/075/24', 'TEMU4376922', 'GUARANTY TRUST BANK', '2024-08-05', 'UBH365M/RL0682', 'ABOUBAKAR HUSEIN', '0766411101', '4001703054', '2024-08-02', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '13', '2024-08-06 12:29:41', '2024-08-06 12:29:41'),
('18', 'RFT/DR/GOM/071/24', 'MSDU2879521', 'FRANCIS BUKUZAGARA', '2024-08-05', 'RAE328D/RL3303', 'ABDALLAH SAID MKAS', '0766411101', '4006390971', '2024-08-02', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '13', '2024-08-06 12:31:26', '2024-08-06 12:31:26'),
('19', 'RFT/119/LUB/24', 'DRYU9627458', 'ABOUBAKAR MOHAMED ALBAITY', '2024-08-14', 'T618DGD/T262DDA', 'TEOFIL SABAS', '0763771479', '4002401941', '2024-08-14', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-08-14 09:07:51', '2024-08-14 09:07:51'),
('20', 'RFT/119/LUB/24', 'TCNU3026473', 'ABOUBAKAR MOHAMED ALBAITY', '2024-08-14', 'T256DKK/T239DKK', 'FAHAD ABOUBAKAR', '0763771479', '4000297123', '2024-08-14', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-08-14 09:07:51', '2024-08-14 09:07:51'),
('21', 'RFT/116/BUK/24', 'MNBU4064413', 'GREENWOOD LOGISTICS', '2024-08-12', 'T680DPG/T193DPP', 'MATEI DONATH FIDELISI', '0763771479', '4005363082', '2024-08-12', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-08-14 09:12:33', '2024-08-14 09:12:33'),
('22', 'RFT/115/LUB/24', 'MNBU4159740', 'SULEIMAN AMUR SULEIMAN', '2024-08-13', 'T624DML/T473DQB', 'HUSENI HAMISI MTEE', '0769116126', '4000220209', '2024-08-13', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-08-14 09:33:20', '2024-08-14 09:33:20'),
('23', 'RFT/115/LUB/24', 'MNBU9169891', 'SULEIMAN AMUR SULEIMAN', '2024-08-13', 'T936EAN/T147EAP', 'AHMED MOHAMED OMARY', '0763771479', '4000276788', '2024-08-13', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-08-14 09:33:20', '2024-08-14 09:33:20'),
('24', 'RFT/115/LUB/24', 'MNBU0272933', 'SULEIMAN AMUR SULEIMAN', '2024-08-13', 'T165EAG/T145CUA', 'OMARY MASOUD MIRAJI', '0769116126', '4000064822', '2024-08-13', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-08-14 09:33:20', '2024-08-14 09:33:20'),
('25', 'RFT/115/LUB/24', 'MNBU0563203', 'SULEIMAN AMUR SULEIMAN', '2024-08-13', 'T366ECX/TE368ECT', 'LISTON GABRIEL RWECHUNGURA', '0763771479', '4000344511', '2024-08-13', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-08-14 09:33:20', '2024-08-14 09:33:20'),
('26', 'RFT/115/LUB/24', 'MNBU3790704', 'SULEIMAN AMUR SULEIMAN', '2024-08-13', 'T500DRT/T201EEM', 'ANDREW SAIMON KABEGERE', '0763771479', '4001867326', '2024-08-13', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-08-14 09:33:20', '2024-08-14 09:33:20'),
('27', 'RFT/115/LUB/24', 'MNBU0613942', 'SULEIMAN AMUR SULEIMAN', '2024-08-13', 'T451DTH/T102AYZ', 'GODFREY WILLIAM GOTRIBE', '0763771479', '4005963278', '2024-08-13', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-08-14 09:33:20', '2024-08-14 09:33:20'),
('28', 'RFT/115/LUB/24', 'MNBU4265423', 'SULEIMAN AMUR SULEIMAN', '2024-08-13', 'T648EAN/T147ADN', 'JUMA RAJABU MBELWA', '0763771479', '4000081360', '2024-08-13', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-08-14 09:33:20', '2024-08-14 09:33:20'),
('29', 'RFT/115/LUB/24', 'DAYU6720407', 'SULEIMAN AMUR SULEIMAN', '2024-08-13', 'T119ECX/T372ECT', 'HEMEDI SALEHE MTAULA', '0763771479', '4001867326', '2024-08-13', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-08-14 09:33:20', '2024-08-14 09:33:20'),
('30', 'RFT/112/LU/24', 'VOLU2122424 20\"', 'M.A.ISMAN LIMITED', '2024-08-19', 'T892APQ/T859ARM', 'ADAM ALLY MOHAMED', '0769116126', '4005641057', '2024-08-19', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-08-19 11:58:10', '2024-08-19 11:58:10'),
('31', 'RFT/114/LU/24', 'TGCU0182970 20\"', 'M.A.ISMAN LIMITED', '2024-08-19', 'T287AZL/T763BBP', 'YUSUPH HASSAN SIKILIZA', '0769116126', '4000099473', '2024-08-19', '2024-08-19', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-08-19 12:00:00', '2024-08-19 12:00:00'),
('32', 'RFT/113/LU/24', 'VOLU2354311 20\"', 'M.A.ISMAN LIMITED', '2024-08-19', 'T788BNV/T589AVH', 'MASHAKA GABRIER MAKORO', '0769116126', '400073402', '2024-08-19', '2024-08-19', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-08-19 12:22:44', '2024-08-19 12:22:44'),
('33', 'RFT/111/LU/24', 'HPCU2457814 20\"', 'M.A.ISMAN LIMITED', '2024-08-19', 'T558ADX/T756AGD', 'ALLY SHARIFU MHONJE', '0769116126', '4000633908', '2024-08-19', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-08-19 12:28:34', '2024-08-19 12:28:34'),
('34', 'RFT/BU/BU/087/24', 'HLBU9461498', 'SOCIATE KURUGERO SOFT', '2024-08-19', 'H9903A/T1188A', 'ERIC NCUTTINAMAGARA', '0763228788', 'PNC0019924', '2024-08-19', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-08-20 09:16:40', '2024-08-20 09:16:40'),
('35', 'RFT/129/KI/24', 'TRHU8178240', 'MAKAB', '2024-08-27', 'RAG/629S/RL5858', 'TURINUMUKIZA SAMUEL', '0769116126', '1199080016022337', '2024-08-26', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-08-27 10:11:32', '2024-08-27 10:11:32'),
('36', 'RFT/129/KI/24', 'TRHU8684526', 'MAKAB', '2024-08-27', 'RAD/960W/RL2209', 'RWABYUMA JACQUES', '0769116126', '1198480002475215', '2024-08-26', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-08-27 10:11:32', '2024-08-27 10:11:32'),
('37', 'RFT/128/KI/24', 'GESU1085748', 'KAMURU', '2024-08-17', 'RAH185C/RL5726', 'UWIHANGANYE OMAR', '0763228788', '1197280010809220', '2024-08-17', '2024-08-21', '0000-00-00', '0000-00-00', '0000-00-00', '2024-08-21', '14', '2024-08-27 10:15:24', '2024-08-27 10:15:24'),
('38', 'RFT/136/KI/24', '1', 'DN-C SUPPLY', '2024-08-31', 'RAG632W/RL5799', 'JEAN UKURIKIYIMFIRA', '0769422592', 'AA009878483KN', '2024-08-31', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-08-31 10:52:38', '2024-08-31 10:52:38'),
('39', 'RFT/136/KI/24', '1', 'DN-C SUPPLY', '2024-08-31', 'RAE613Z/RL3495', 'VENANT AYINKAMIYE', '0763228788', '1197680084391244', '2024-08-31', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-08-31 10:52:38', '2024-08-31 10:52:38'),
('40', 'RFT/136/KI/24', '1', 'DN-C SUPPLY', '2024-08-31', 'RAD839X/RL4245', 'EMMANUEL DUFATANYE', '0763228788', '1197980077288322', '2024-08-31', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-08-31 10:52:38', '2024-08-31 10:52:38'),
('41', 'RFT/136/KI/24', '1', 'DN-C SUPPLY', '2024-08-31', 'RAG651M/RL5042', 'TUYISENGE VECANCE ', '0763228788', '1200080085679208', '2024-08-31', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-08-31 10:52:38', '2024-08-31 10:52:38'),
('42', 'RFT/138/KI/24', 'MRKU8641318', 'MURADO', '2024-09-06', 'RAD342U/RL1963', 'KABARIRA GERARD', '0763771479', '1196880062901202', '2024-09-06', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-09-06 09:40:22', '2024-09-06 09:40:22'),
('43', 'RFT/132/KI/24', 'TEMU7782838', 'TANGANYIKA LOGISTICS', '2024-10-15', 'H8959A/T1198A', 'AYUBU SURWANONE', '0769116126', 'PNC0055947', '2024-10-15', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-10-17 08:45:38', '2024-10-17 08:45:38'),
('44', 'RFT/117/LUB/24', 'SEGU6317692', 'ABOUBAKAR MOHAMED ALBAITY', '2024-10-05', 'T271ECX/ / T267ECA', 'CHARLES RAFAEL LUNKIDO', '0763228788', '4005849685', '2024-10-05', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-10-17 09:05:51', '2024-10-17 09:05:51'),
('45', 'RFT/117/LUB/24', 'CMAU7165603', 'ABOUBAKAR MOHAMED ALBAITY', '2024-10-05', 'T186EGY/ / T278ACX', 'SHABANI DODO MALOLE', '0763228788', '4001328443', '2024-10-05', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-10-17 09:05:51', '2024-10-17 09:05:51'),
('46', 'RFT/117/LUB/24', 'SEGU4617509', 'ABOUBAKAR MOHAMED ALBAITY', '2024-10-05', 'T271ECX/ / T267ECA', 'CHARLES RAFAEL LUNKIDO', '0769422592', '4005849685', '2024-10-05', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-10-17 09:05:51', '2024-10-17 09:05:51'),
('47', 'RFT/117/LUB/24', 'CAIU9275422', 'ABOUBAKAR MOHAMED ALBAITY', '2024-10-05', 'T256DKK/ / T239DKK', 'FAHED ABUBAKARI SHARIF', '0763228788', '4000297123', '2024-10-05', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-10-17 09:05:51', '2024-10-17 09:05:51'),
('48', 'RFT/117/LUB/24', 'TCNU5119467', 'ABOUBAKAR MOHAMED ALBAITY', '2024-10-05', 'T678DPG/ / T286DJF', 'IJOLO PASKAS MWINYI', '0769422592', '4003715119', '2024-10-05', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-10-17 09:05:51', '2024-10-17 09:05:51'),
('49', 'RFT/117/LUB/24', 'CAIU9706690', 'ABOUBAKAR MOHAMED ALBAITY', '2024-10-05', 'T618DGD/T262DDA', 'TEOFIL SABAS', '0769422592', '4002401941', '2024-10-05', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-10-17 09:05:51', '2024-10-17 09:05:51'),
('50', 'RFT/148/KI/24', 'COIL 101', 'KAMURU', '2024-10-15', '17 TRUCKS', 'KAMURU TRADING', '0763771479', '0', '2024-10-15', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-10-17 09:10:41', '2024-10-17 09:10:41'),
('51', 'RFT/149/KI/24', 'APZU3392943', 'GREENWOOD LOGISTICS', '2024-10-21', 'T680DPG/T588CLS', 'MATEI DONATH FIDELISI', '0769422592', '4005363082', '2024-10-21', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-10-18 11:06:56', '2024-10-18 11:06:56'),
('52', 'RFT/150/KI/24', 'TCNU3565618', 'ALL WAYS LOGISTICS', '2024-10-18', 'RAE606Y/RL3486', 'MUNYEMANZI NEHEMIE', '0763228788', '1196880000219149', '2024-10-18', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-10-18 11:15:29', '2024-10-18 11:15:29'),
('53', 'RFT/150/KI/24', 'UETU7157570', 'ALL WAYS LOGISTICS', '2024-10-18', 'RAE602Y/RL3479', 'NIYIBIZI JEAN D\'AMOUR', '0763228788', '1199280084113432', '2024-10-18', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-10-18 11:15:29', '2024-10-18 11:15:29'),
('54', 'RFT/150/KI/24', 'UETU7158788', 'ALL WAYS LOGISTICS', '2024-10-18', 'RAF864U/RL4292', 'MUSONI JEAN PIEERE', '0769422592', '1197980108656247', '2024-10-18', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-10-18 11:15:29', '2024-10-18 11:15:29'),
('55', 'RFT/150/KI/24', 'UETU7158788', 'ALL WAYS LOGISTICS', '2024-10-18', 'RAF270F/RL3890', 'TWAGIRIMANA JEAN DE DIEU', '0769116126', '1198280020488320', '2024-10-18', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-10-18 11:15:29', '2024-10-18 11:15:29'),
('56', 'RFT/150/KI/24', 'UETU7174829', 'ALL WAYS LOGISTICS', '2024-10-18', 'RAF863U/RL4293', 'FURAHA JOSEPH', '0763228788', '119758009562339', '2024-10-18', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-10-18 11:15:29', '2024-10-18 11:15:29'),
('57', 'RFT/152/BUK/24', 'BEAU6383136', 'Tanganyika logistics ', '2024-10-15', 'H8959A/T1198A', 'AYUB SURWANONE', '', 'PNC0055947', '2024-10-15', '2024-10-19', '0000-00-00', '0000-00-00', '0000-00-00', '0000-00-00', '14', '2024-10-25 12:08:35', '2024-10-25 12:08:35');


INSERT INTO `truck_reassignments` VALUES
('1', 'RFT/RW/KI/001/25', 'MRSK0912', 'ROYAL FREIGHT ', 'GREENWOOD- HASSAN', '1', 'Trucks failed to show up', '2025-02-28 10:14:47'),
('2', 'RFT/DR/LUB/001/25', 'MRSK0915', 'ROYAL FREIGHT ', 'BURUNDI SHIMO', '1', 'Truck breakdown', '2025-03-01 07:24:57');

INSERT INTO `user_role` VALUES
('1', 'Administrator'),
('5', 'Declaration Officer'),
('4', 'Finance'),
('2', 'General Manager'),
('3', 'Operations'),
('6', 'Shipping Line Clerk'),
('7', 'Transport Supervisor');

INSERT INTO `user_roles` VALUES
('1', '1'),
('20', '1');

INSERT INTO `users` VALUES
('1', 'Admin', 'hi@myne.co.ke', 'RF Admin', '$2y$10$Y.5OCS473Vc4NjnwwvU//eLkhc4LP2rBy/2Y9Qqjf0Ai1TB7ItWzi', 'admin', '2023-09-17 10:48:54', '1', '3', '2024-02-11 13:07:14', '2024-07-12 10:15:55', '1', '2025-03-07 22:06:18'),
('11', 'ismail', 'ismail@royalfreight.co.tz', 'Ismail', '$2y$10$3jU0BFOtCP423Pq6MJ0xvO.P8zfiEYBRL0JvRxPybtxSiTgniuIJm', 'operations', '2024-03-28 08:59:27', '1', '0', NULL, '2024-03-28 08:59:27', '3', '2025-02-28 20:22:03'),
('12', 'karim', 'royalfreight@royalfreight.co.tz', 'Karim', '$2y$10$R3f0nfzhxu1PYMj/KykAsuJxF88v4HZAgoAXQrQKJosd.UKiOaNgW', 'general_manager', '2024-03-28 08:59:56', '1', '0', NULL, '2024-03-28 08:59:56', '2', '2025-02-28 20:14:47'),
('13', 'ashura', 'ashura@royalfreight.co.tz', 'Ashura', '$2y$10$tv.6pR5ozSmWvQguPWdpJuLrfgdt2K5gPbJQc4rQjCJVkJcCL//HC', 'declaration_officer', '2024-03-28 09:01:08', '1', '0', NULL, '2024-03-28 09:01:08', '5', '2025-03-07 15:07:48'),
('14', 'salman', 'salman@royalfreight.co.tz', 'Salman', '$2y$10$oP7HalxZw/ntKscIaR6.jeR5k6vDkrF4G40xT7cTerCpbubUzm1oK', 'declaration_officer', '2024-03-28 09:01:38', '1', '0', NULL, '2024-08-27 10:01:59', '5', '2025-03-07 15:02:24'),
('15', 'stella', 'stella@royalfreight.co.tz', 'Stella', '$2y$10$gNTdyB/QFu8yiASoyapBWerLKRE1zxTvVO3SMI.KdWmoK8OvitTOu', 'shipping_line_clerk', '2024-03-28 09:02:36', '1', '0', NULL, '2024-03-28 09:02:36', '6', NULL),
('16', 'faraji', 'faraj@royalfreight.co.tz', 'Faraji', '$2y$10$5kKCSoP8fwNkl9x5kSGP8e59CWk9MeBvP5xGdyLBIM4t1yWX8/tBa', 'shipping_line_clerk', '2024-03-28 09:03:08', '1', '0', NULL, '2024-03-28 09:03:08', '6', NULL),
('17', 'ally', 'ally@royafreight.co.tz', 'Ally', '$2y$10$fmuhKDruV47bgwCR.0G9hOejU3.LVZitXvN4lXWrFwOASbLXSyRCC', 'transport_supervisor', '2024-03-28 09:03:37', '1', '0', NULL, '2024-03-28 09:03:37', '7', NULL),
('19', 'Sam', 'sharcyville@gmail.com', 'Sam', '$2y$10$btFXXBZIpNzW9I3JVTDhtu.9nQZVDiPVP4vs6vRwoBXuc6LWy0HT.', 'admin', '2024-03-28 10:14:59', '1', '6', '2024-03-28 12:26:35', '2024-03-28 10:14:59', '1', NULL),
('20', 'hafsa', 'hafsa@royalfreight.co.tz', 'Hafsa', '$2y$10$xrGUMXg2lpUOy2Pp5LQxjerP4aLiyyCVkTWmgOwAMubwa.FDGqqqS', 'admin', '2024-06-29 11:38:47', '1', '0', NULL, '2024-06-29 11:38:47', '1', '2025-03-07 06:59:54');


SET FOREIGN_KEY_CHECKS=1;
