<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>
<?php include 'layouts/dbconn.php'; ?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'All Customers')); ?>

    <!--datatable css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
    
    <!-- Sweet Alert css-->
    <link href="assets/libs/sweetalert2/sweetalert2.min.css" rel="stylesheet" type="text/css" />

    <?php include 'layouts/head-css.php'; ?>
</head>

<body>
    <!-- Begin page -->
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        
        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Customers Management', 'title' => 'All Customers')); ?>

                    <!-- Display success/error messages if they exist -->
                    <?php if(isset($_SESSION['success_message'])): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo $_SESSION['success_message']; unset($_SESSION['success_message']); ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endif; ?>
                    
                    <?php if(isset($_SESSION['error_message'])): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <?php echo $_SESSION['error_message']; unset($_SESSION['error_message']); ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endif; ?>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header d-flex align-items-center justify-content-between">
                                    <h5 class="card-title mb-0">All Customers</h5>
                                    <a href="add_customer.php" class="btn btn-primary">
                                        <i class="ri-add-line align-bottom me-1"></i> Add New Customer
                                    </a>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="buttons-datatables" class="display table table-bordered" style="width:100%">
                                            <thead>
                                                <tr>
                                                    <th>Customer ID</th>
                                                    <th>Customer Name</th>
                                                    <th>Contact Details</th>
                                                    <th>Location</th>
                                                    <th>Status</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $query = "SELECT * FROM customers ORDER BY customer_id DESC";
                                                
                                                $result = $conn->query($query);
                                                
                                                if ($result && $result->num_rows > 0) {
                                                    while ($row = $result->fetch_assoc()) {
                                                        // Set status text and class
                                                        $statusText = ($row['status'] == 1) ? 'Active' : 'Inactive';
                                                        $statusClass = ($row['status'] == 1) ? 'badge bg-success' : 'badge bg-danger';
                                                        
                                                        echo "<tr>";
                                                        echo "<td>{$row['customer_id']}</td>";
                                                        echo "<td>
                                                                <div class='d-flex align-items-center'>
                                                                    <div class='flex-grow-1'>
                                                                        {$row['first_name']} {$row['last_name']}
                                                                    </div>
                                                                </div>
                                                              </td>";
                                                        echo "<td>
                                                                <div class='d-flex flex-column'>
                                                                    <span><i class='ri-mail-line me-1'></i>" . ($row['email'] ?: 'N/A') . "</span>
                                                                    <span><i class='ri-phone-line me-1'></i>" . ($row['phone_number'] ?: 'N/A') . "</span>
                                                                </div>
                                                              </td>";
                                                        echo "<td>
                                                                <div class='d-flex flex-column'>
                                                                    <span>" . ($row['address'] ?: 'N/A') . "</span>
                                                                    <small class='text-muted'>" . ($row['city'] ? $row['city'] . ', ' : '') . ($row['country'] ?: 'N/A') . "</small>
                                                                </div>
                                                              </td>";
                                                        echo "<td><span class='{$statusClass}'>{$statusText}</span></td>";
                                                        echo '<td>
                                                                <div class="hstack gap-3 flex-wrap">
                                                                    <a href="customer_view.php?id=' . $row['customer_id'] . '" class="link-success fs-15">
                                                                        <i class="ri-eye-line"></i>
                                                                    </a>
                                                                    <a href="edit_customer.php?id=' . $row['customer_id'] . '" class="link-primary fs-15">
                                                                        <i class="ri-edit-2-line"></i>
                                                                    </a>
                                                                    <a href="javascript:void(0);" class="link-danger fs-15 delete-customer" data-id="' . $row['customer_id'] . '">
                                                                        <i class="ri-delete-bin-line"></i>
                                                                    </a>
                                                                </div>
                                                              </td>';
                                                        echo "</tr>";
                                                    }
                                                } else {
                                                    echo "<tr><td colspan='6' class='text-center'>No customers found</td></tr>";
                                                }
                                                ?>
                                            </tbody>    
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
        <!-- end main content-->
    </div>
    <!-- END layout-wrapper -->

    <?php include 'layouts/vendor-scripts.php'; ?>
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Sweet Alerts js -->
    <script src="assets/libs/sweetalert2/sweetalert2.min.js"></script>
    
    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

    <script>
    $(document).ready(function() {
        // Initialize DataTable
        var dataTable = $('#buttons-datatables').DataTable({
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],
            responsive: true,
            lengthMenu: [
                [10, 25, 50, -1],
                [10, 25, 50, 'All']
            ],
            pageLength: 10
        });
        
        // Handle delete customer action
        $('.delete-customer').on('click', function() {
            var customerId = $(this).data('id');
            
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonClass: 'btn btn-primary w-xs me-2 mt-2',
                cancelButtonClass: 'btn btn-danger w-xs mt-2',
                confirmButtonText: 'Yes, delete it!',
                buttonsStyling: false,
                showCloseButton: true
            }).then(function(result) {
                if (result.value) {
                    // Send AJAX request or redirect to delete page
                    window.location.href = "delete_customer.php?id=" + customerId;
                }
            });
        });
    });
    </script>

    <script src="assets/js/app.js"></script>
</body>
</html>