<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>
<?php include 'layouts/dbconn.php'; ?>

<head>

    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Add Expense')); ?>
    
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <?php include 'layouts/head-css.php'; ?>
     <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>

<body>

    <!-- Begin page -->
    <div id="layout-wrapper">

        <?php include 'layouts/menu.php'; ?>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Expenses Management', 'title' => 'Add Expense')); ?>
            
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Add New Expense</h4>
                                </div>
                                <div class="card-body">
                                    <form id="addExpenseForm" method="POST" action="save_expense.php">
                                        <div class="row gy-4">
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="expense_type" class="form-label">Expense Type</label>
                                                    <select class="form-select" id="expense_type" name="expense_type" required>
                                                        <option value="">Select Type</option>
                                                        <option value="fuel">Fuel</option>
                                                        <option value="maintenance">Maintenance</option>
                                                        <option value="repairs">Repairs</option>
                                                        <option value="insurance">Insurance</option>
                                                        <option value="licenses">Licenses</option>
                                                        <option value="salaries">Salaries</option>
                                                        <option value="rent">Rent</option>
                                                        <option value="utilities">Utilities</option>
                                                        <option value="office_supplies">Office Supplies</option>
                                                        <option value="travel">Travel</option>
                                                        <option value="marketing">Marketing</option>
                                                        <option value="other">Other</option>
                                                    </select>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="amount" class="form-label">Amount</label>
                                                    <input type="number" step="0.01" class="form-control" id="amount" name="amount" required>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="currency" class="form-label">Currency</label>
                                                    <select class="form-select" id="currency" name="currency" required>
                                                        <option value="TZS">TZS</option>
                                                        <option value="USD">USD</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="expense_date" class="form-label">Expense Date</label>
                                                    <input type="date" class="form-control" id="expense_date" name="expense_date" required value="<?php echo date('Y-m-d'); ?>">
                                                </div>
                                                <div class="mb-3">
                                                    <label for="payment_method" class="form-label">Payment Method</label>
                                                    <select class="form-select" id="payment_method" name="payment_method" required>
                                                        <option value="cash">Cash</option>
                                                        <option value="bank_transfer">Bank Transfer</option>
                                                        <option value="mobile_money">Mobile Money</option>
                                                        <option value="credit_card">Credit Card</option>
                                                        <option value="check">Check</option>
                                                    </select>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="reference_number" class="form-label">Reference Number</label>
                                                    <input type="text" class="form-control" id="reference_number" name="reference_number">
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="mb-3">
                                                    <label for="description" class="form-label">Description</label>
                                                    <textarea class="form-control" id="description" name="description" rows="3"></textarea>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <button type="submit" class="btn btn-success">Save Expense</button>
                                                <a href="all_expenses.php" class="btn btn-secondary">Cancel</a>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            

            
            <?php include 'layouts/footer.php'; ?>
        </div>
        <!-- end main content-->

    </div>
    <!-- END layout-wrapper -->

    <?php include 'layouts/vendor-scripts.php'; ?>

    <!-- prismjs plugin -->
    <script src="assets/libs/prismjs/prism.js"></script>

    <script src="assets/js/app.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <!--select2 cdn-->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="assets/js/pages/select2.init.js"></script>
<!-- SweetAlert script for notifications -->
<?php if (isset($_SESSION['sweet_alert'])): ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        Swal.fire({
            title: "<?php echo $_SESSION['sweet_alert']['title']; ?>",
            text: "<?php echo $_SESSION['sweet_alert']['text']; ?>",
            icon: "<?php echo $_SESSION['sweet_alert']['icon']; ?>",
            confirmButtonText: 'OK',
            confirmButtonClass: 'btn btn-primary'
        });
    });
</script>
<?php unset($_SESSION['sweet_alert']); endif; ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
    const currencySelect = document.getElementById('currency');
    const currencySymbol = document.querySelector('.currency-symbol');

    currencySelect.addEventListener('change', function() {
        currencySymbol.textContent = this.value;
    });

    // Optional: Add input formatting for the amount
    const totalAmountInput = document.getElementById('totalAmount');
    totalAmountInput.addEventListener('input', function() {
        // Ensure only two decimal places
        if (this.value.includes('.')) {
            const parts = this.value.split('.');
            if (parts[1].length > 2) {
                this.value = parseFloat(this.value).toFixed(2);
            }
        }
    });
});
</script>

</body>

</html>